/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.util.Hashtable;

public class MtTaskSecurity {
    static final String EDIT = "edit";
    static final String DELETE = "delete";
    static final String EXECUTE = "execute";
    private static final String ANYUSER = "ANYUSER";
    private static final String ANYGROUP = "ANYGROUP";
    private static final String DENY_USER = ".denyUser";
    private static final String DENY_GROUP = ".denyGroup";
    private static final String ALLOW_USER = ".allowUser";
    private static final String ALLOW_GROUP = ".allowGroup";
    private static MtTaskSecurity instance_;
    private Hashtable acl_ = new Hashtable();
    static /* synthetic */ Class class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity;

    private MtTaskSecurity() throws SMSecurityException {
        MSLogPrintWriter.getDebugWriter().println("Task Security: initialized");
    }

    void checkAccess(int n, String string, ScSecurityCredential scSecurityCredential) throws SMSecurityException {
        this.checkValidOperation(string);
        String string2 = String.valueOf(n) + "." + string;
        String string3 = "," + scSecurityCredential.getUser() + ",";
        String string4 = String.valueOf(string2) + DENY_USER;
        String string5 = (String)this.acl_.get(string4);
        if (string5 != null) {
            if (string5.equals(ANYUSER)) {
                throw new SMSecurityException("All users denied access");
            }
            if (string5.indexOf(string3) >= 0) {
                throw new SMSecurityException("User denied access");
            }
        }
        if ((string5 = (String)this.acl_.get(string4 = String.valueOf(string2) + DENY_GROUP)) != null) {
            if (string5.equals(ANYGROUP)) {
                throw new SMSecurityException("All groups denied access");
            }
            if (MSSecurity.areGroupsInList((String[])scSecurityCredential.getGroupArray(), (String)string5)) {
                throw new SMSecurityException("Group access denied");
            }
        }
        if ((string5 = (String)this.acl_.get(string4 = String.valueOf(string2) + ALLOW_USER)) != null) {
            if (string5.equals(ANYUSER)) {
                return;
            }
            if (string5.indexOf(string3) >= 0) {
                return;
            }
        }
        if ((string5 = (String)this.acl_.get(string4 = String.valueOf(string2) + ALLOW_GROUP)) != null) {
            if (string5.equals(ANYGROUP)) {
                return;
            }
            if (MSSecurity.areGroupsInList((String[])scSecurityCredential.getGroupArray(), (String)string5)) {
                return;
            }
        }
        throw new SMSecurityException("User denied access");
    }

    private void checkValidOperation(String string) throws SMSecurityException {
        if (!(string.equals(EDIT) || string.equals(DELETE) || string.equals(EXECUTE))) {
            throw new SMSecurityException("Invalid operation: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void defineAccess(int n, String string, String string2, String string3) throws SMSecurityException {
        this.checkValidOperation(string);
        String string4 = String.valueOf(n) + "." + string + string2;
        if (this.acl_.containsKey(string4)) {
            throw new SMSecurityException("Duplicate ACL: " + string4);
        }
        if (!(string3 = string3.trim()).equals(ANYUSER) && !string3.equals(ANYGROUP)) {
            string3 = "," + string3 + ",";
        }
        this.acl_.put(string4, string3);
    }

    void defineAllowGroup(int n, String string, String string2) throws SMSecurityException {
        this.defineAccess(n, string, ALLOW_GROUP, string2);
    }

    void defineAllowUser(int n, String string, String string2) throws SMSecurityException {
        this.defineAccess(n, string, ALLOW_USER, string2);
    }

    void defineDenyGroup(int n, String string, String string2) throws SMSecurityException {
        this.defineAccess(n, string, DENY_GROUP, string2);
    }

    void defineDenyUser(int n, String string, String string2) throws SMSecurityException {
        this.defineAccess(n, string, DENY_USER, string2);
    }

    static MtTaskSecurity getInstance() throws SMSecurityException {
        if (instance_ == null) {
            Class clazz = class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity != null ? class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity : (class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity = MtTaskSecurity.class$("com.sun.symon.base.mgmtservice.task.MtTaskSecurity"));
            synchronized (clazz) {
                if (instance_ == null) {
                    instance_ = new MtTaskSecurity();
                }
            }
        }
        return instance_;
    }
}

