/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.dr.console.presentation;

import com.sun.symon.apps.dr.console.presentation.DrException;
import com.sun.symon.apps.dr.console.presentation.SymonDrTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class DrStateDialog
extends JDialog {
    SymonDrTable parent;
    String newState;
    String apId;
    JButton okbut;
    JButton cancelbut;
    JRadioButton quickTestButton;
    JRadioButton normalTestButton;
    JRadioButton extendedTestButton;

    public DrStateDialog(SymonDrTable symonDrTable, Frame frame, String string, String string2) {
        super(frame);
        this.parent = symonDrTable;
        this.setModal(true);
        this.apId = string;
        this.newState = string2;
        this.okbut = new JButton(this.parent.getI18NString("OK"));
        this.cancelbut = new JButton(this.parent.getI18NString("Cancel"));
        this.okbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrStateDialog.this.OKPressed();
            }
        });
        this.cancelbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrStateDialog.this.CancelPressed();
            }
        });
        if (this.newState.equals("test")) {
            this.setTitle(this.parent.getI18NString("Test_Memory"));
            JPanel jPanel = new JPanel();
            String string3 = this.parent.getI18NString("Select_test_type");
            JLabel jLabel = new JLabel(string3);
            jLabel.setHorizontalAlignment(2);
            jPanel.add(jLabel);
            Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            jPanel.setBorder(border);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(border);
            this.quickTestButton = new JRadioButton(this.parent.getI18NString("Quick"));
            this.normalTestButton = new JRadioButton(this.parent.getI18NString("Normal"));
            this.extendedTestButton = new JRadioButton(this.parent.getI18NString("Extended"));
            this.quickTestButton.setSelected(true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.quickTestButton);
            buttonGroup.add(this.normalTestButton);
            buttonGroup.add(this.extendedTestButton);
            jPanel2.setLayout(new GridLayout(3, 1, 0, 0));
            jPanel2.add(this.quickTestButton);
            jPanel2.add(this.normalTestButton);
            jPanel2.add(this.extendedTestButton);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.okbut);
            jPanel3.add(this.cancelbut);
            JPanel jPanel4 = new JPanel();
            Border border2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            jPanel4.setBorder(border2);
            jPanel4.setLayout(new BorderLayout(0, 0));
            jPanel4.add("North", jPanel);
            jPanel4.add("Center", jPanel2);
            jPanel4.add("South", jPanel3);
            this.getContentPane().add(jPanel4);
        } else if (this.newState.equals("security_error")) {
            this.setTitle(this.parent.getI18NString("Error"));
            JPanel jPanel = new JPanel();
            Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            jPanel.setBorder(border);
            JLabel jLabel = new JLabel(this.parent.getI18NString("DR_Security_Error"));
            jPanel.add(jLabel);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(this.okbut);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout(0, 0));
            jPanel6.add("North", jPanel);
            jPanel6.add("South", jPanel5);
            this.getContentPane().add(jPanel6);
        } else {
            this.setTitle(this.parent.getI18NString("Confirm"));
            JPanel jPanel = new JPanel();
            String string4 = String.valueOf(this.parent.getI18NString("Do_you_want_to_")) + this.parent.getI18NString(this.newState) + " " + this.apId + this.parent.getI18NString("Key_questionmark") + this.parent.getI18NString("newline");
            JLabel jLabel = new JLabel(string4);
            jPanel.add(jLabel);
            Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            jPanel.setBorder(border);
            JPanel jPanel7 = new JPanel();
            jPanel7.add(this.okbut);
            jPanel7.add(this.cancelbut);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BorderLayout(0, 0));
            jPanel8.add("North", jPanel);
            jPanel8.add("South", jPanel7);
            this.getContentPane().add(jPanel8);
        }
        this.setLocationRelativeTo(this.parent);
        this.pack();
    }

    public void CancelPressed() {
        ((Component)this).setVisible(false);
        this.parent.cancelDROperation();
    }

    public void OKPressed() {
        ((Component)this).setVisible(false);
        try {
            if (this.newState.equals("test")) {
                if (this.quickTestButton.isSelected()) {
                    this.parent.doDROperation(this.apId, "quick");
                } else if (this.normalTestButton.isSelected()) {
                    this.parent.doDROperation(this.apId, "normal");
                } else {
                    this.parent.doDROperation(this.apId, "extended");
                }
            } else if (this.newState.equals("security_error")) {
                this.parent.cancelDROperation();
            } else {
                this.parent.doDROperation(this.apId, this.newState);
            }
        }
        catch (DrException drException) {
            drException.print();
        }
    }
}

