/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.awx;

import com.sun.symon.base.console.awx.AwxTreeNodeInfo;
import com.sun.symon.base.console.awx.AwxTreeSelector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class AwxTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private AwxTreeSelector ParentTree = null;
    protected int guessedIconWidth = 16;
    protected int guessedIconHeight = 16;

    AwxTreeCellRenderer(AwxTreeSelector awxTreeSelector) {
        this.setOpaque(true);
        this.ParentTree = awxTreeSelector;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            String string = this.getText();
            Icon icon = this.getIcon();
            if (string != null && icon != null) {
                Font font = this.getFont();
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                int n = fontMetrics.stringWidth(string);
                int n2 = fontMetrics.getHeight();
                int n3 = icon.getIconWidth();
                int n4 = icon.getIconHeight();
                int n5 = n3 + this.getIconTextGap() + n;
                int n6 = Math.max(n4, n2);
                dimension = new Dimension(n5 + 3, n6);
                this.guessedIconWidth = Math.max(this.guessedIconWidth, n3);
                this.guessedIconHeight = Math.max(this.guessedIconHeight, n4);
            } else if (string != null && icon == null) {
                Font font = this.getFont();
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                int n = fontMetrics.stringWidth(string);
                int n7 = fontMetrics.getHeight();
                int n8 = this.guessedIconWidth + 2 + n;
                int n9 = Math.max(this.guessedIconHeight, n7);
                dimension = new Dimension(n8 + 3, n9);
            } else {
                dimension = new Dimension(dimension.width + 3, dimension.height);
            }
        }
        return dimension;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        AwxTreeNodeInfo awxTreeNodeInfo = (AwxTreeNodeInfo)defaultMutableTreeNode.getUserObject();
        this.setText(awxTreeNodeInfo.LabelStr);
        this.setToolTipText(awxTreeNodeInfo.ToolTipStr);
        boolean bl5 = defaultMutableTreeNode.getAllowsChildren();
        if (awxTreeNodeInfo.LabelFont != null) {
            this.setFont(awxTreeNodeInfo.LabelFont);
        } else {
            this.setFont(this.ParentTree.getDisplayFont(bl5));
        }
        if (bl) {
            if (awxTreeNodeInfo.LabelSelectColour != null) {
                this.setForeground(awxTreeNodeInfo.LabelSelectColour);
            } else {
                this.setForeground(this.ParentTree.getDisplayColour(bl5, bl));
            }
            if (this.ParentTree.getSelectBackground() != null) {
                this.setBackground(this.ParentTree.getSelectBackground());
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
            }
        } else {
            if (awxTreeNodeInfo.LabelColour != null) {
                this.setForeground(awxTreeNodeInfo.LabelColour);
            } else {
                this.setForeground(this.ParentTree.getDisplayColour(bl5, bl));
            }
            this.setOpaque(false);
        }
        if (bl2) {
            if (awxTreeNodeInfo.OpenIcon != null) {
                this.setIcon(awxTreeNodeInfo.OpenIcon);
            } else {
                this.setIcon(awxTreeNodeInfo.BaseIcon);
            }
        } else if (awxTreeNodeInfo.ClosedIcon != null) {
            this.setIcon(awxTreeNodeInfo.ClosedIcon);
        } else {
            this.setIcon(awxTreeNodeInfo.BaseIcon);
        }
        return this;
    }
}

