/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.console.SMTblSelectionInfo;
import com.sun.symon.base.client.table.SMTablePageRequest;
import com.sun.symon.base.client.table.SMTablePageResponse;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTblFilterEvent;
import com.sun.symon.base.console.views.table.CvTblFilterListener;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CvTblSlider
extends JPanel
implements ActionListener,
Runnable {
    private JLabel pageLabel;
    private JComboBox pageBox;
    private int currentPage = 1;
    private int previousPage = 1;
    private int currentRow;
    private int lastPage;
    private Hashtable buttons = new Hashtable();
    private static final String FIRST = "first";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private CvTblTable table = null;
    private CvTblTableModel model = null;
    private CvTable ownTable;
    public SMTableRequest tabObj = null;
    private SMTablePageRequest tabreq = null;
    private SMRawDataRequest origDataSource = null;
    private CvTblPageResponser responser = null;
    private static final int PAGE = 50;
    private boolean continueGet = true;
    private Vector filterListeners = new Vector();
    boolean firstTime = true;
    private Object[] pageRequests = null;
    private Object[] pageStatusRequests = null;
    String refInterval;
    private boolean initialized = false;
    private Object tableDepthRequest = null;
    String[] dataUrls = null;
    String[] statusUrls = null;
    String alarmFilter = null;
    DataLoader dataLoader;
    Thread requester;
    private int tableDepth = 0;

    public CvTblSlider(CvTable cvTable, CvTblTable cvTblTable, SMRawDataRequest sMRawDataRequest, SMTableRequest sMTableRequest, int n) {
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        this.ownTable = cvTable;
        this.tabObj = sMTableRequest;
        this.origDataSource = sMRawDataRequest;
        this.tableDepth = n;
        this.setBackground(Color.white);
        this.currentPage = 1;
        this.lastPage = this.depth2Page(n);
        this.table = cvTblTable;
        this.model = (CvTblTableModel)cvTblTable.getModel();
        this.dataUrls = CvTable.removeBlankURLs(this.model.getDataURLs());
        this.statusUrls = CvTable.removeBlankURLs(this.model.getStatusURLs());
        this.createUI();
        this.updateUIStatus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.previousPage = this.currentPage;
        if (actionEvent.getSource() == this.pageBox) {
            if (this.pageBox.getItemCount() == 0) {
                return;
            }
            int n = this.pageBox.getSelectedIndex() + 1;
            if (n == 0 && this.pageBox.getItemCount() >= this.currentPage) {
                this.pageBox.setSelectedIndex(this.currentPage - 1);
                return;
            }
            if (n == this.currentPage) {
                return;
            }
            this.currentPage = n;
        } else {
            String string = actionEvent.getActionCommand();
            String string2 = UcInternationalizer.translateKey((String)"com.sun.symon.base.console.alarms.AlarmBundle:thisIsLast");
            String string3 = UcInternationalizer.translateKey((String)"com.sun.symon.base.console.alarms.AlarmBundle:thisIsFirst");
            if (string.compareTo(FIRST) == 0) {
                if (this.currentPage <= 1) {
                    this.currentPage = 1;
                    UcDialog.showOk((String)string3);
                    return;
                }
                this.currentPage = 1;
            } else if (string.compareTo(PREVIOUS) == 0) {
                if (this.currentPage <= 1) {
                    UcDialog.showOk((String)string3);
                    return;
                }
                --this.currentPage;
            } else if (string.compareTo(NEXT) == 0) {
                if (this.currentPage >= this.lastPage) {
                    UcDialog.showOk((String)string2);
                    return;
                }
                ++this.currentPage;
            } else if (string.compareTo(LAST) == 0) {
                if (this.currentPage >= this.lastPage) {
                    this.currentPage = this.lastPage;
                    UcDialog.showOk((String)string2);
                    return;
                }
                this.currentPage = this.lastPage;
            }
        }
        this.updateUIStatus();
        this.getPageData((this.currentPage - 1) * 50);
    }

    public void addFilterListener(CvTblFilterListener cvTblFilterListener) {
        this.filterListeners.add(cvTblFilterListener);
    }

    public void createUI() {
        Accessible accessible;
        String[] stringArray = new String[]{"stdimages/First-16x16.gif", "stdimages/Previous-16x16.gif", "stdimages/Next-16x16.gif", "stdimages/Last-16x16.gif"};
        String[] stringArray2 = new String[]{FIRST, PREVIOUS, NEXT, LAST};
        String string = String.valueOf(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.page")) + ": ";
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentY(0.0f);
        this.add(jLabel);
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.origDataSource);
        int n = 0;
        while (n < 4) {
            accessible = new ImageIcon(sMResourceAccess.getImage(stringArray[n]));
            string = UcInternationalizer.translateKey((String)("base.console.alarms.AlarmBundle:" + stringArray2[n]));
            JButton jButton = new JButton((Icon)((Object)accessible));
            jButton.setToolTipText(string);
            jButton.setActionCommand(stringArray2[n]);
            jButton.setPreferredSize(new Dimension(18, 20));
            jButton.setMaximumSize(new Dimension(20, 20));
            jButton.setAlignmentY(0.0f);
            jButton.addActionListener(this);
            this.buttons.put(stringArray2[n], jButton);
            this.add(jButton);
            this.add(new JLabel(" "));
            ++n;
        }
        this.add(new JLabel("  "));
        this.pageBox = new JComboBox();
        this.pageBox.setPreferredSize(new Dimension(55, 20));
        this.pageBox.setMaximumSize(new Dimension(70, 20));
        this.pageBox.setEditable(true);
        this.pageBox.addActionListener(this);
        this.pageBox.setAlignmentY(0.0f);
        this.add(this.pageBox);
        accessible = new JLabel(" of ");
        ((JComponent)((Object)accessible)).setAlignmentY(0.0f);
        this.add((Component)((Object)accessible));
        string = " " + this.tableDepth;
        this.pageLabel = new JLabel(string);
        this.pageLabel.setAlignmentY(0.0f);
        this.add(this.pageLabel);
        this.add(Box.createHorizontalGlue());
        this.updatePageUI();
    }

    private int depth2Page(int n) {
        int n2 = n % 50 > 0 ? n / 50 + 1 : n / 50;
        if (n / 50 == 0) {
            n2 = 1;
        }
        return n2;
    }

    public void fireFilterChange(String[] stringArray) {
        CvTblFilterEvent cvTblFilterEvent = new CvTblFilterEvent(this, stringArray);
        int n = 0;
        while (n < this.filterListeners.size()) {
            ((CvTblFilterListener)this.filterListeners.get(n)).labelsChanged(cvTblFilterEvent);
            ++n;
        }
    }

    public void getData() {
        this.getPageData((this.currentPage - 1) * 50);
    }

    public void getPageData(int n) {
        this.currentRow = n;
        CvTblPageResponser cvTblPageResponser = this.responser;
        synchronized (cvTblPageResponser) {
            this.responser.notify();
        }
        if (this.dataLoader != null) {
            this.dataLoader.stop();
        }
        this.dataLoader = new DataLoader(this.tableDepth, this.currentRow);
        this.dataLoader.start();
    }

    public void initTablePageRequest(String string) {
        this.pageRequests = new Object[1];
        this.pageStatusRequests = new Object[1];
        this.refInterval = string;
        if (this.tabObj == null) {
            UcDDL.logErrorMessage((String)" data source is null");
            return;
        }
        if (this.dataUrls == null) {
            UcDDL.logErrorMessage((String)" CvTblSlider: Data Urls is null");
            return;
        }
        RowNumberUpdator rowNumberUpdator = new RowNumberUpdator(this, this.dataUrls[0], this.tabObj);
        rowNumberUpdator.start();
        this.requester = new Thread(this);
        this.requester.start();
        this.initialized = true;
    }

    public void removeFilterListener(CvTblFilterListener cvTblFilterListener) {
        this.filterListeners.removeElement(cvTblFilterListener);
    }

    public void run() {
        this.ownTable.displayFootMessage();
        this.ownTable.busyStart();
        this.shutdownAllRequest();
        this.pageRequests = new Object[1];
        this.pageStatusRequests = new Object[1];
        try {
            this.tabreq = this.alarmFilter == null ? this.tabObj.getTablePageRequest(this.dataUrls, this.statusUrls, 50) : this.tabObj.getTablePageRequest(this.dataUrls, this.statusUrls, 50, this.alarmFilter);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)"CvTblSlider:getTableRequest  received exception", (Throwable)sMAPIException);
        }
        this.responser = new CvTblPageResponser(this, this.model);
        try {
            this.tableDepthRequest = this.alarmFilter == null ? this.tabreq.getTableDepth(this.dataUrls[0], this.refInterval, (SMTablePageResponse)this.responser, null) : this.tabreq.getTableDepth(this.dataUrls[0], this.alarmFilter, this.refInterval, (SMTablePageResponse)this.responser, null);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)" CvTblSlider: get table depth received exception", (Throwable)sMAPIException);
        }
        this.getData();
        this.ownTable.busyStop();
    }

    public void setAlarmFilter(String string) {
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (string == null || string.equals("")) {
            string2 = null;
        } else {
            if (string.indexOf("ERR") >= 0) {
                bl = true;
            }
            if (string.indexOf("WRN") >= 0) {
                bl2 = true;
            }
            if (string.indexOf("INF") >= 0) {
                bl3 = true;
            }
            if (string.indexOf("DWN") >= 0) {
                bl5 = true;
            }
            string2 = SMTableRequest.createFilter((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4, (boolean)bl5, (boolean)bl6);
        }
        if (string2 != null && this.alarmFilter != null && string2.equals(this.alarmFilter)) {
            return;
        }
        if (string2 == null && this.alarmFilter == null) {
            return;
        }
        this.alarmFilter = string2;
        if (this.initialized) {
            this.requester = new Thread(this);
            this.requester.start();
        }
    }

    public void shutdown() {
        this.continueGet = false;
        this.shutdownAllRequest();
    }

    public void shutdownAllRequest() {
        this.shutdownPageRequests();
        CvTblSlider cvTblSlider = this;
        synchronized (cvTblSlider) {
            if (this.tableDepthRequest != null) {
                try {
                    this.origDataSource.removeURLRequest(this.tableDepthRequest);
                }
                catch (Exception exception) {}
                this.tableDepthRequest = null;
            }
        }
    }

    public void shutdownPageRequests() {
        CvTblSlider cvTblSlider = this;
        synchronized (cvTblSlider) {
            try {
                int n = 0;
                while (n < this.pageRequests.length) {
                    if (this.pageRequests[n] != null) {
                        this.origDataSource.removeURLRequest(this.pageRequests[n]);
                        this.pageRequests[n] = null;
                    }
                    if (this.pageStatusRequests[n] != null) {
                        this.origDataSource.removeURLRequest(this.pageStatusRequests[n]);
                        this.pageStatusRequests[n] = null;
                    }
                    ++n;
                }
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logWarningMessage((String)("CvTblSlider: error to remove old request" + (Object)((Object)sMAPIException)));
            }
        }
    }

    private void updatePageUI() {
        String string = " " + this.lastPage;
        this.pageLabel.setText(string);
        this.pageBox.removeAllItems();
        int n = 0;
        while (n < this.lastPage) {
            this.pageBox.addItem(new String(" " + (n + 1)));
            ++n;
        }
        this.pageBox.setSelectedIndex(this.currentPage - 1);
    }

    public void updateTableDepth(int n) {
        int n2 = this.tableDepth;
        int n3 = this.lastPage;
        this.tableDepth = n;
        if (this.tableDepth == n2) {
            return;
        }
        if (n <= 50) {
            ((JButton)this.buttons.get(FIRST)).setEnabled(false);
            ((JButton)this.buttons.get(PREVIOUS)).setEnabled(false);
            ((JButton)this.buttons.get(NEXT)).setEnabled(false);
            ((JButton)this.buttons.get(LAST)).setEnabled(false);
        } else {
            ((JButton)this.buttons.get(FIRST)).setEnabled(true);
            ((JButton)this.buttons.get(PREVIOUS)).setEnabled(true);
            ((JButton)this.buttons.get(NEXT)).setEnabled(true);
            ((JButton)this.buttons.get(LAST)).setEnabled(true);
        }
        this.lastPage = this.depth2Page(n);
        if (this.currentPage > this.lastPage) {
            this.currentPage = this.lastPage;
        }
        if (n3 != this.lastPage) {
            this.updatePageUI();
            this.updateUIStatus();
        }
        this.getPageData((this.currentPage - 1) * 50);
    }

    private void updateUIStatus() {
        if (this.pageBox != null) {
            this.pageBox.setSelectedIndex(this.currentPage - 1);
        }
        if (this.table != null) {
            SMTblSelectionInfo sMTblSelectionInfo = this.table.getContextSelection();
            if (sMTblSelectionInfo != null && sMTblSelectionInfo.getSelectionType() == 2) {
                this.table.clearSelection();
            }
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
        }
    }

    class DataLoader
    extends Thread {
        int tableDepth;
        int currentRow;

        public DataLoader(int n, int n2) {
            this.tableDepth = n;
            this.currentRow = n2;
        }

        public void run() {
            CvTblSlider.this.shutdownPageRequests();
            if (this.tableDepth == 0 || this.currentRow > this.tableDepth) {
                return;
            }
            CvTblSlider.this.ownTable.displayFootMessage();
            CvTblSlider.this.model.shrinkSize(0);
            int n = Math.min(this.tableDepth - this.currentRow, 50);
            Vector vector = new Vector(this.currentRow);
            String[] stringArray = this;
            synchronized (stringArray) {
                if (CvTblSlider.this.dataUrls != null) {
                    try {
                        ((CvTblSlider)CvTblSlider.this).pageRequests[0] = CvTblSlider.this.tabreq.getTablePageFieldRequest(this.currentRow, n, CvTblSlider.this.refInterval, (SMTablePageResponse)CvTblSlider.this.responser, vector);
                    }
                    catch (Exception exception) {
                        UcDDL.logWarningMessage((String)"CvTblSlider:getPageData - received exception getting table data", (Throwable)exception);
                        exception.printStackTrace();
                        CvTblSlider.this.ownTable.cleanFootMessage();
                        Object var4_5 = null;
                        return;
                    }
                }
            }
            try {
                CvTblSlider.this.responser.waitRowIndex();
            }
            catch (Exception exception) {}
            stringArray = CvTblSlider.this.responser.getRowIndex();
            String[] stringArray2 = this;
            synchronized (stringArray2) {
                if (CvTblSlider.this.statusUrls != null) {
                    try {
                        ((CvTblSlider)CvTblSlider.this).pageStatusRequests[0] = CvTblSlider.this.tabreq.getTablePageAlarmStatusRequest(stringArray, CvTblSlider.this.refInterval, (SMTablePageResponse)CvTblSlider.this.responser, vector);
                    }
                    catch (Exception exception) {
                        UcDDL.logWarningMessage((String)"CvTblSlider:getPageData - received exception getting table data", (Throwable)exception);
                    }
                }
            }
            CvTblSlider.this.ownTable.cleanFootMessage();
        }
    }

    class CvTblPageResponser
    implements SMTablePageResponse {
        String[] rowindex = null;
        CvTblTableModel tmodel = null;
        CvTblSlider pageSource = null;

        public CvTblPageResponser(CvTblSlider cvTblSlider2, CvTblTableModel cvTblTableModel) {
            this.pageSource = cvTblSlider2;
            this.tmodel = cvTblTableModel;
        }

        public String[] getRowIndex() {
            return this.rowindex;
        }

        public void getTableDepthResponse(SMRequestStatus sMRequestStatus, int n, Object object) {
            if (sMRequestStatus.getReturnCode() == 0) {
                this.pageSource.updateTableDepth(n);
            } else {
                UcDDL.logErrorMessage((String)" get table depth error ");
                sMRequestStatus.getException().printStackTrace();
            }
        }

        public void getTablePageAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
            if (sMRequestStatus.getReturnCode() != 0) {
                if (sMRequestStatus.getReturnCode() == 1) {
                    UcDDL.logErrorMessage((String)"Security Error receiving page alarm status data for table ");
                } else if (sMRequestStatus.getReturnCode() == 2) {
                    UcDDL.logErrorMessage((String)"Invalid Url Error receiving page alarm status data for table ");
                } else {
                    UcDDL.logErrorMessage((String)"Data Request Error receiving page alarm status data for table ");
                }
                return;
            }
            if (sMRequestStatus == null || sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
                if (sMRequestStatus == null) {
                    UcDDL.logErrorMessage((String)"Null status received while retrieving page alarm status data for table ");
                }
                if (sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
                    UcDDL.logErrorMessage((String)"Null data received while retrieving page alarm status data for table ");
                }
                return;
            }
            this.tmodel.setStatusValues(sMAlarmStatusDataArray);
        }

        public void getTablePageFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, String[][] stringArray2, String[] stringArray3, Object object) {
            if (sMRequestStatus.getReturnCode() != 0) {
                if (sMRequestStatus.getReturnCode() == 1) {
                    UcDDL.logErrorMessage((String)"Security Error receiving page field data for table ");
                } else if (sMRequestStatus.getReturnCode() == 2) {
                    UcDDL.logErrorMessage((String)"Invalid Url Error receiving page field  data for table ");
                } else {
                    UcDDL.logErrorMessage((String)"Data Request Error receiving page field data for table ");
                }
                CvTblSlider.this.ownTable.displayFootMessage("base.console.ConsoleMessages:console.tableLoadError");
                return;
            }
            if (sMRequestStatus == null || stringArray == null || stringArray.length == 0) {
                if (sMRequestStatus == null) {
                    UcDDL.logErrorMessage((String)"Null status received while retrieving page field data for table ");
                }
                if (stringArray == null || stringArray.length == 0) {
                    UcDDL.logErrorMessage((String)"Null data received while retrieving page field data for table ");
                }
                return;
            }
            CvTblPageResponser cvTblPageResponser = this;
            synchronized (cvTblPageResponser) {
                try {
                    this.rowindex = stringArray3;
                    this.notify();
                }
                catch (Exception exception) {
                    UcDDL.logErrorMessage((String)("CvTblSlider: notify exception :" + exception.getMessage()));
                }
            }
            this.tmodel.setDataValues(stringArray);
            CvTblSlider.this.currentPage;
            CvTblSlider.this.previousPage;
        }

        public final void waitRowIndex() throws SMAPIException {
            CvTblPageResponser cvTblPageResponser = this;
            synchronized (cvTblPageResponser) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    throw new SMAPIException(exception.getMessage());
                }
            }
        }
    }

    class RowNumberUpdator
    extends Thread {
        CvTblSlider parent;
        SMTableRequest request;
        String[] filters = new String[4];
        String url;

        public RowNumberUpdator(CvTblSlider cvTblSlider2, String string, SMTableRequest sMTableRequest) {
            this.request = sMTableRequest;
            this.parent = cvTblSlider2;
            this.url = string;
            this.filters[0] = SMTableRequest.createFilter((boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.filters[1] = SMTableRequest.createFilter((boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.filters[2] = SMTableRequest.createFilter((boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            this.filters[3] = SMTableRequest.createFilter((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        }

        public void run() {
            while (CvTblSlider.this.continueGet) {
                String[] stringArray = new String[5];
                stringArray[0] = String.valueOf(this.request.getTableDepth(this.url));
                int n = 0;
                while (n < 4) {
                    stringArray[n + 1] = String.valueOf(this.request.getTableDepth(this.url, this.filters[n]));
                    ++n;
                }
                this.parent.fireFilterChange(stringArray);
                try {
                    Thread.currentThread();
                    Thread.sleep(6000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

