/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security.medium;

import com.sun.symon.base.security.SyEndInsecureInterface;
import com.sun.symon.base.security.SyExponentialKeyAgreement;
import com.sun.symon.base.security.SyKeyExchange;
import com.sun.symon.base.security.SyKeyHashAuthentication;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.security.medium.PublicKey;
import com.sun.symon.base.security.medium.SyScheme;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

class EndInsecure
implements SyEndInsecureInterface {
    private SyExponentialKeyAgreement key = new SyExponentialKeyAgreement();
    private SyKeyHashAuthentication author;
    private boolean wantEncryption;
    private Signature dsa;

    EndInsecure(String string) throws SySecurityException {
        try {
            this.dsa = Signature.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SyScheme.handleEx(noSuchAlgorithmException);
        }
        try {
            this.dsa.initVerify(new PublicKey(string));
        }
        catch (InvalidKeyException invalidKeyException) {
            SyScheme.handleEx(invalidKeyException);
        }
    }

    private synchronized byte[] authenticate(byte[] byArray) throws SySecurityException {
        byte[][] byArray2 = SyScheme.splitBytes(byArray);
        byArray = byArray2[0];
        byte[] byArray3 = byArray2[1];
        try {
            this.dsa.update(byArray);
            if (!this.dsa.verify(byArray3)) {
                throw new SySecurityException("unauthentic data", 1);
            }
        }
        catch (SignatureException signatureException) {
            SyScheme.handleEx(signatureException);
        }
        return byArray;
    }

    public byte[] decode(byte[] byArray, boolean bl) throws SySecurityException {
        if (bl) {
            byArray = this.decrypt(byArray);
            byArray = this.authenticate(byArray);
        } else if (this.wantEncryption) {
            byArray = this.decrypt(byArray);
        }
        return byArray;
    }

    private byte[] decrypt(byte[] byArray) throws SySecurityException {
        return byArray;
    }

    public byte[] encode(byte[] byArray, boolean bl) throws SySecurityException {
        byArray = this.sign(byArray);
        if (bl) {
            byArray = SyKeyExchange.create(this.key.getSecretKey(), byArray);
        } else if (this.wantEncryption) {
            byArray = this.encrypt(byArray);
        }
        return byArray;
    }

    private byte[] encrypt(byte[] byArray) throws SySecurityException {
        return byArray;
    }

    public void negotiateEnd(byte[] byArray) throws SySecurityException {
        byte[] byArray2 = this.authenticate(byArray);
        this.key.setPublicValue(byArray2);
        this.author = new SyKeyHashAuthentication(this.key.getSecretKey());
    }

    public byte[] negotiateStart(boolean bl) {
        this.wantEncryption = bl;
        return this.key.getPublicValue();
    }

    private byte[] sign(byte[] byArray) throws SySecurityException {
        byte[] byArray2 = this.author.sign(byArray);
        return SyScheme.joinBytes(byArray, byArray2);
    }
}

