/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.MsgType;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.GarbageCollector;
import com.visigenic.vbroker.orb.GiopConnection;
import com.visigenic.vbroker.orb.GiopConnectionFactory;
import com.visigenic.vbroker.orb.GiopMessage;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolManager;
import com.visigenic.vbroker.util.PropertyManager;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import oracle.aurora.sess_iiop.orb_dep.SessionComponent;
import oracle.aurora.sess_iiop.ssl.orb_dep.SessionSSLComponent;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_RESOURCES;

public class GiopConnectionFactoryImpl
implements Observer,
GiopConnectionFactory,
OrbObject,
GarbageCollector.Collectable {
    protected Hashtable _activeConnections = new Hashtable();
    protected Dictionary _cachedConnections = new Hashtable();
    protected MessagePool _messagePool = null;
    protected BufferPool _bufferPool = null;
    protected ORB _orb;
    protected int _bufferSize;
    protected int _maxConnections = 0;
    protected int _connectionIdleTime;
    protected long _timeStamp;
    protected int _maxCache = 0;
    protected final Object connectionLock = new Object();
    private static final byte[] HEADER;
    private static final byte[] LENGTH;

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 79;
        byArray[3] = 80;
        byArray[4] = 1;
        HEADER = byArray;
        LENGTH = new byte[4];
    }

    synchronized void addMessage(GiopMessage message) {
        MessagePool msg = (MessagePool)message;
        msg.next = this._messagePool;
        this._messagePool = msg;
    }

    public void close(GiopConnection gconn) {
        gconn.connection().close();
    }

    private void closeOldestConnection() {
        GiopConnection oldestConnection = null;
        Dictionary dictionary = null;
        dictionary = this._cachedConnections.size() > 0 ? this._cachedConnections : this._activeConnections;
        Enumeration connections = dictionary.elements();
        long oldestTime = System.currentTimeMillis();
        while (connections.hasMoreElements()) {
            GiopConnection gconn = (GiopConnection)connections.nextElement();
            if (gconn.inUse() || gconn.lastUsed() >= oldestTime) continue;
            oldestTime = gconn.lastUsed();
            oldestConnection = gconn;
        }
        if (oldestConnection == null) {
            throw new NO_RESOURCES("Too many connections in use");
        }
        Connection conn = oldestConnection.connection();
        TaggedProfile profile = conn.getPeerProfile();
        ConnectionFactory factory = this._orb.protocolManager().getProtocol(profile).connectionFactory();
        Object key = factory.hashEndpoint(profile);
        dictionary.remove(key);
        oldestConnection.close();
    }

    public void collect(long currentTime) {
        if (this._connectionIdleTime == 0) {
            return;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            Enumeration cachedConnections = this._cachedConnections.elements();
            while (cachedConnections.hasMoreElements()) {
                GiopConnection gconn = (GiopConnection)cachedConnections.nextElement();
                if (currentTime - gconn.lastUsed() <= (long)this._connectionIdleTime) continue;
                Connection conn = gconn.connection();
                TaggedProfile profile = conn.getPeerProfile();
                ConnectionFactory factory = this._orb.protocolManager().getProtocol(profile).connectionFactory();
                Object key = factory.hashEndpoint(profile);
                this._cachedConnections.remove(key);
                gconn.close();
            }
        }
    }

    public GiopConnection connect(TaggedProfile profile) {
        ConnectionFactory factory = null;
        ProtocolManager.Protocol protocol = this._orb.protocolManager().getProtocol(profile);
        if (protocol == null || !(protocol instanceof GiopProtocol)) {
            throw new BAD_PARAM("GiopConnectionFactory: trying to connect using unknown protocol");
        }
        factory = protocol.connectionFactory();
        Object key = factory.hashEndpoint(profile);
        Object object = this.connectionLock;
        synchronized (object) {
            GiopConnection gconn = (GiopConnection)this._activeConnections.get(key);
            if (gconn == null) {
                gconn = (GiopConnection)this._cachedConnections.remove(key);
                if (gconn != null) {
                    if (this._orb.debug) {
                        this._orb.println("Found cached connection: " + gconn);
                    }
                    this._activeConnections.put(key, gconn);
                }
            } else if (this._orb.debug) {
                this._orb.println("Found active connection: " + gconn);
            }
            if (gconn == null) {
                if (this._maxConnections != 0 && this._activeConnections.size() + this._cachedConnections.size() >= this._maxConnections) {
                    this.closeOldestConnection();
                }
                Connection conn = this.connect(factory, profile);
                Object[] args = new Object[]{conn, this};
                gconn = (GiopConnection)this._orb.create(32, args);
                if (this._orb.debug) {
                    this._orb.println("Adding to active connections: " + conn);
                }
                this._activeConnections.put(key, gconn);
            } else {
                gconn.duplicate();
            }
            GiopConnection giopConnection = gconn;
            Object var7_10 = null;
            return giopConnection;
        }
    }

    protected Connection connect(ConnectionFactory factory, TaggedProfile profile) {
        return factory.connect(profile);
    }

    public GiopConnection create(Connection conn) {
        Object[] args = new Object[]{conn, this};
        return (GiopConnection)this._orb.create(32, args);
    }

    public void destroy(GiopConnection gconn, boolean force) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (gconn.refCount() == 0 || force) {
                if (!this._activeConnections.contains(gconn)) {
                    Object var4_4 = null;
                    return;
                }
                TaggedProfile profile = gconn.connection().getPeerProfile();
                ProtocolManager.Protocol _proto = this._orb.protocolManager().getProtocol(profile);
                Object key = _proto.connectionFactory().hashEndpoint(profile);
                boolean found = false;
                if (this._activeConnections.remove(key) != gconn) {
                    if ((_proto instanceof SessionComponent || _proto instanceof SessionSSLComponent) && this._activeConnections.contains(gconn)) {
                        Enumeration keys = this._activeConnections.keys();
                        while (keys.hasMoreElements()) {
                            Object nextKey = keys.nextElement();
                            if (this._activeConnections.get(nextKey) != gconn) continue;
                            found = true;
                            this._activeConnections.remove(nextKey);
                        }
                    }
                    if (!found) {
                        throw new INTERNAL();
                    }
                }
                if (!force) {
                    if (this._maxCache > 0 && this._cachedConnections.size() > this._maxCache) {
                        this.closeOldestConnection();
                    }
                    if (this._orb.debug) {
                        this._orb.println("Caching connection: " + gconn);
                    }
                    this._cachedConnections.put(key, gconn);
                }
            }
        }
    }

    public synchronized GiopMessage getMessage() {
        if (this._messagePool == null) {
            return new MessagePool(this._orb, new byte[this._bufferSize]);
        }
        MessagePool msg = this._messagePool;
        this._messagePool = msg.next;
        return msg;
    }

    public void init(ORB orb, Object[] args) {
        this._orb = orb;
        PropertyManager pm = this._orb.getPropertyManager();
        this.update((Observable)pm, "ORBmbufSize");
        this.update((Observable)pm, "ORBconnectionMax");
        this.update((Observable)pm, "ORBconnectionMaxIdle");
        this.update((Observable)pm, "ORBconnectionCacheMax");
        this._orb.garbageCollector().addCollectable((GarbageCollector.Collectable)this);
    }

    public GiopOutputStream newMessage(MsgType message_type, boolean byteOrder) {
        GiopOutputStream output;
        GiopConnectionFactoryImpl giopConnectionFactoryImpl = this;
        synchronized (giopConnectionFactoryImpl) {
            if (this._bufferPool != null) {
                output = this._bufferPool.output;
                this._bufferPool = this._bufferPool.next;
            } else {
                output = this._orb.newGiopOutputStream();
            }
        }
        output.offset(0);
        output.byteOrder(byteOrder);
        output.write_octet_array(HEADER, 0, HEADER.length);
        output.write_octet((byte)(byteOrder ? 1 : 0));
        output.write_octet((byte)message_type.value());
        output.write_octet_array(LENGTH, 0, LENGTH.length);
        return output;
    }

    public void release(GiopOutputStream output) {
        if (output.bytes().length <= this._bufferSize) {
            BufferPool link = new BufferPool();
            link.output = output;
            GiopConnectionFactoryImpl giopConnectionFactoryImpl = this;
            synchronized (giopConnectionFactoryImpl) {
                link.next = this._bufferPool;
                this._bufferPool = link;
            }
        }
    }

    public void update(Observable o, Object target) {
        String property = (String)target;
        PropertyManager pm = (PropertyManager)o;
        if (property.equals("ORBmbufSize")) {
            this._bufferSize = pm.getInt(property);
        } else if (property.equals("ORBconnectionMax")) {
            this._maxConnections = pm.getInt(property);
        } else if (property.equals("ORBconnectionMaxIdle")) {
            this._connectionIdleTime = pm.getInt(property);
            this._connectionIdleTime *= 1000;
        } else if (property.equals("ORBconnectionCacheMax")) {
            this._maxCache = pm.getInt(property);
        }
    }

    private class MessagePool
    extends GiopMessage {
        MessagePool next;

        MessagePool(ORB orb, byte[] buffer) {
            super(orb, buffer);
        }

        public void release() {
            GiopConnectionFactoryImpl.this.addMessage(this);
        }
    }

    private class BufferPool {
        GiopOutputStream output;
        BufferPool next;

        BufferPool() {
        }
    }
}

