/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.AdapterImpl;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.IiopAdapter;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.PersistentId;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import com.visigenic.vbroker.orb.ServiceId;
import com.visigenic.vbroker.orb.ServiceSkeleton;
import com.visigenic.vbroker.orb.SkeletonDelegate;
import com.visigenic.vbroker.orb.TSIiopAdapter;
import com.visigenic.vbroker.orb.TransientId;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.InitialReferencesImpl;
import oracle.aurora.server.LoginServerImpl;
import oracle.aurora.server.Properties;
import oracle.aurora.server.ThreadSessionDispatcher;
import oracle.aurora.server.VCIiopConnection;
import oracle.aurora.server.publishing.PublishedObjectImpl;
import oracle.aurora.server.publishing.PublishingContextImpl;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Skeleton;

public class AuroraIiopAdapter
extends TSIiopAdapter {
    private void _verifyPermission(Skeleton object) {
        VCIiopConnection conn;
        try {
            if (Properties.properties().getString("VERIFY_PERMISSIONS").equals("false")) {
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (((AdapterImpl)this)._orb.AuroraDebug) {
            System.out.println("Doing the check, object = " + object.toString());
        }
        if ((conn = (VCIiopConnection)ServerThreadInfo.instance((ORB)((AdapterImpl)this)._orb).connection) == null) {
            return;
        }
        int userId = conn.userId();
        if (((AdapterImpl)this)._orb.AuroraDebug) {
            System.out.println("userId = " + userId + ", current schema = " + Schema.currentSchema().ownerNumber());
        }
        if (Schema.currentSchema().equals(userId)) {
            return;
        }
        ClassHandle ch = ClassHandle.lookup(object.getClass());
        try {
            if (ch.hasExecutePrivilege(userId, null)) {
                return;
            }
        }
        catch (ObjectTypeChangedException objectTypeChangedException) {}
        if (object instanceof LoginServerImpl) {
            return;
        }
        if (object instanceof PublishingContextImpl) {
            return;
        }
        if (object instanceof PublishedObjectImpl) {
            return;
        }
        if (object instanceof InitialReferencesImpl) {
            return;
        }
        throw new NO_PERMISSION(MinorCodes.getMessage(2), 2, CompletionStatus.COMPLETED_NO);
    }

    public Adapter create(String name) {
        return new AuroraIiopAdapter();
    }

    public Adapter.Dispatcher createDispatcher(Connection connection) {
        return new ThreadSessionDispatcher(((AdapterImpl)this)._orb, (Adapter)this, ((IiopAdapter)this)._protocol.createProtocolAdapter((Adapter)this), connection);
    }

    protected ObjectId createObjectId(Skeleton skeleton, String service_name, byte[] ref_data) {
        java.lang.Object oid = null;
        if (service_name != null) {
            if (ref_data == null) {
                ref_data = new byte[]{};
            }
            oid = new ServiceId(((AdapterImpl)this)._orb, service_name, ref_data);
        } else {
            String id = skeleton._ids()[0];
            String name = skeleton._object_name();
            oid = new TransientId(((AdapterImpl)this)._orb, id);
        }
        if (((AdapterImpl)this)._orb.debug || ((AdapterImpl)this)._orb.AuroraDebug) {
            ((AdapterImpl)this)._orb.println("new ObjectId: " + (java.lang.Object)oid);
        }
        return oid;
    }

    public Skeleton getSkeleton(ObjectId oid) {
        Skeleton object = (Skeleton)((AdapterImpl)this)._skeletons.get(oid);
        if (object != null) {
            this._verifyPermission(object);
            return object;
        }
        if (oid instanceof PersistentId) {
            PersistentId pid = (PersistentId)oid;
            Dictionary skeletons = (Dictionary)((AdapterImpl)this)._typeIds.get(pid.repId());
            if (skeletons != null) {
                String objectName = pid.objectName();
                if (objectName == null || objectName.equals("")) {
                    try {
                        return (Skeleton)skeletons.elements().nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        return null;
                    }
                }
                object = (Skeleton)skeletons.get(pid.objectName());
                this._verifyPermission(object);
                return object;
            }
            return null;
        }
        if (oid instanceof ServiceId) {
            ServiceId sid = (ServiceId)oid;
            ServiceSkeleton serviceSkeleton = (ServiceSkeleton)((AdapterImpl)this)._serviceSkeletons.get(sid.serviceName());
            if (serviceSkeleton == null) {
                return null;
            }
            object = (Skeleton)serviceSkeleton.activate(sid.id());
            this.obj_is_ready((Object)object, sid.serviceName(), sid.id());
            return object;
        }
        return null;
    }

    public synchronized void impl_is_ready() {
    }

    public void init(ORB orb, java.util.Properties properties) {
        super.init(orb, properties);
        ProfileBody listener = ((IiopAdapter)this)._protocol.profileBody(((AdapterImpl)this)._listener.listenEndpoint());
        ((IiopAdapter)this)._serverProfile.port = listener.port;
        ((IiopAdapter)this)._serverProfile.host = listener.host;
    }

    public synchronized Adapter.Dispatcher newConnection(Connection connection) {
        if (((AdapterImpl)this)._shutdown) {
            return null;
        }
        if (((AdapterImpl)this)._maxConnections != 0 && ((AdapterImpl)this)._connections.size() >= ((AdapterImpl)this)._maxConnections && !this.detachAgedConnection()) {
            connection.close();
            return null;
        }
        Adapter.Dispatcher dispatcher = this.createDispatcher(connection);
        ((AdapterImpl)this)._connections.addElement(dispatcher);
        return dispatcher;
    }

    public void obj_is_ready(Object object, ObjectId oid) {
        if (((AdapterImpl)this)._shutdown) {
            return;
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Skeleton skeleton = null;
        Hashtable hashtable = ((AdapterImpl)this)._skeletons;
        synchronized (hashtable) {
            skeleton = this.getSkeleton(object);
            try {
                SkeletonDelegate delegate = (SkeletonDelegate)skeleton._get_delegate();
                if (((AdapterImpl)this)._skeletons.containsKey(delegate.key_id((Object)skeleton))) {
                    java.lang.Object var5_6 = null;
                    return;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {}
            this.addSkeleton(skeleton, oid);
            if (oid instanceof PersistentId) {
                this.registerPersistentObject(skeleton, (PersistentId)oid);
            } else {
                ((AdapterImpl)this)._skeletons.put(oid, skeleton);
            }
            if (((AdapterImpl)this)._orb.debug) {
                ((AdapterImpl)this)._orb.println(String.valueOf(((java.lang.Object)((java.lang.Object)this)).getClass().getName()) + ".obj_is_ready(" + skeleton + ")");
            }
        }
        ((AdapterImpl)this)._orb.adapterManager().registerSkeleton(skeleton);
    }
}

