/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import com.sun.symon.tools.migration.TmDuplicateObjectException;
import com.sun.symon.tools.migration.datasource.MdAttribute;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTableSpace;
import com.sun.symon.tools.migration.datasource.MdValue;
import java.io.Serializable;
import java.util.Vector;

public class MdTable
implements Serializable {
    private MdTableSpace tableSpace;
    private String name;
    private MdDataSourceProperties dataSourceProperties;
    private String preSource;
    private String postSource;
    private final Vector attributes = new Vector();

    protected MdTable(MdTableSpace mdTableSpace, String string) {
        if (mdTableSpace == null) {
            throw new IllegalArgumentException("tableSpace is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.tableSpace = mdTableSpace;
        this.name = string;
        this.dataSourceProperties = new MdDataSourceProperties(mdTableSpace.getMdDataSourceProperties());
    }

    public int attributes() {
        return this.attributes.size();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MdTable && ((MdTable)object).getQualifiedName().equals(this.getQualifiedName());
    }

    public MdAttribute getMdAttribute(int n) {
        return (MdAttribute)this.attributes.elementAt(n);
    }

    public MdAttribute getMdAttribute(String string) {
        int n = this.indexOfMdAttribute(string);
        if (n >= 0) {
            return this.getMdAttribute(n);
        }
        return null;
    }

    public MdDataSourceProperties getMdDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public MdTableSpace getMdTableSpace() {
        return this.tableSpace;
    }

    public String getName() {
        return this.name;
    }

    public String getPostSource() {
        return this.postSource;
    }

    public String getPreSource() {
        return this.preSource;
    }

    public String getQualifiedName() {
        if (this.tableSpace == null) {
            return this.name;
        }
        return String.valueOf(this.tableSpace.getQualifiedName()) + "." + this.name;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public int indexOfMdAttribute(String string) {
        int n = 0;
        while (n < this.attributes.size()) {
            MdAttribute mdAttribute = (MdAttribute)this.attributes.elementAt(n);
            if (mdAttribute.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public MdAttribute newMdAttribute(String string, int n, String string2, String string3) throws TmDuplicateObjectException {
        MdAttribute mdAttribute = this.getMdAttribute(string);
        if (mdAttribute != null) {
            throw new TmDuplicateObjectException(String.valueOf(this.getQualifiedName()) + "." + string, "attribute already exists");
        }
        mdAttribute = new MdAttribute(this, this.attributes.size(), string, n, string2, string3);
        this.attributes.addElement(mdAttribute);
        return mdAttribute;
    }

    public MdRecord newMdRecord() {
        int n = this.attributes();
        MdRecord mdRecord = new MdRecord();
        mdRecord.setMdTable(this);
        int n2 = 0;
        while (n2 < n) {
            MdValue mdValue = new MdValue(this.getMdAttribute(n2));
            mdRecord.addMdValue(mdValue);
            ++n2;
        }
        return mdRecord;
    }

    public void removeMdAttribute(int n) {
        this.attributes.removeElementAt(n);
    }

    public void setPostSource(String string) {
        this.postSource = string;
    }

    public void setPreSource(String string) {
        this.preSource = string;
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

