/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FRUFilter {
    private Vector fruNames;
    private Vector devNames;
    private Hashtable devCount = new Hashtable(15);
    private Hashtable filter = new Hashtable(15);
    private Hashtable devInfo = new Hashtable(5);
    private String devList;
    private boolean debug = false;

    public FRUFilter() {
        this.filter.put("memory", "pmemtest");
        this.filter.put("floppy", "diskette");
        this.filter.put("disk", "disktest");
        this.filter.put("network", "nettest");
        this.filter.put("scsi", "fas,esp");
        this.filter.put("graphics", "cg6,cg14test,afbtest,fbtest,ffbtest,leotest,m64test,sxtest,tcxtest");
        this.filter.put("serial", "sptest");
        this.filter.put("sound", "audiotest");
        this.filter.put("parallel", "bpptest,ecpptest");
        this.filter.put("cdrom", "cdtest");
        this.filter.put("tapedrive", "tapetest");
        this.filter.put("diskarray", "plntest,photest,ifptest,enctest");
        this.filter.put("environ", "envtest,sentest,env2test");
        this.filter.put("link", "scitest");
        this.devInfo.put("scsi", "SCSI controller");
        this.devInfo.put("sbus", "SBUS");
        this.devInfo.put("system", "System Board");
        this.devInfo.put("cpuboard", "CPU-MEMORY Board");
        this.devInfo.put("ioboard", "I/O Board");
    }

    public String deviceName(String string) {
        int n = string.indexOf("(");
        String string2 = n < 0 ? ((n = string.indexOf(":")) < 0 ? new String(string) : string.substring(0, n)) : string.substring(0, n);
        return string2;
    }

    public String getDevice(String string) {
        int n = this.fruNames.indexOf(string);
        if (n < 0) {
            return null;
        }
        String string2 = new String((String)this.devNames.elementAt(n));
        return string2;
    }

    public String getFRU(String string) {
        if (string == null) {
            return null;
        }
        int n = this.devNames.indexOf(string);
        if (n < 0) {
            return null;
        }
        String string2 = new String((String)this.fruNames.elementAt(n));
        return string2;
    }

    public String getInfo(String string) {
        String string2 = new String(" ");
        Enumeration enumeration = this.devInfo.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            String string3 = (String)enumeration.nextElement();
            int n2 = string.indexOf(string3);
            if (n2 == -1) {
                n = string.indexOf("board");
                if (n != 0) continue;
                String string4 = string.substring(5);
                Integer n3 = new Integer(0);
                try {
                    n3 = new Integer(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Couldn't convert board number:" + numberFormatException);
                    break;
                }
                int n4 = n3;
                int n5 = n4 % 2;
                if (n5 == 0) {
                    string2 = new String((String)this.devInfo.get("cpuboard"));
                    break;
                }
                string2 = new String((String)this.devInfo.get("ioboard"));
                break;
            }
            n = string.indexOf("scsi");
            if (n == -1) {
                string2 = new String((String)this.devInfo.get(string3));
                break;
            }
            string2 = new String(String.valueOf((String)this.devInfo.get(string3)) + " " + this.getFRU(string));
            break;
        }
        return string2;
    }

    public String getList() {
        return this.devList;
    }

    private void printVector(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            System.out.println("vector " + string);
            ++n;
        }
    }

    public void setList(String string) {
        this.devCount.put(new String("processor"), new Integer(0));
        this.devCount.put(new String("memory"), new Integer(0));
        this.devCount.put(new String("disk"), new Integer(0));
        this.devCount.put(new String("network"), new Integer(0));
        this.devCount.put(new String("scsi"), new Integer(0));
        this.devCount.put(new String("graphics"), new Integer(0));
        this.devCount.put(new String("serial"), new Integer(0));
        this.devCount.put(new String("sound"), new Integer(0));
        this.devCount.put(new String("parallel"), new Integer(0));
        this.devCount.put(new String("cdrom"), new Integer(0));
        this.devCount.put(new String("floppy"), new Integer(0));
        this.devCount.put(new String("tapedrive"), new Integer(0));
        this.devCount.put(new String("diskarray"), new Integer(0));
        this.devCount.put(new String("environ"), new Integer(0));
        this.devCount.put(new String("link"), new Integer(0));
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ={}");
        int n = stringTokenizer.countTokens();
        this.fruNames = new Vector(n);
        this.devNames = new Vector(n);
        this.devList = new String(string);
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            int n3;
            string = this.devList;
            String string2 = new String(stringTokenizer.nextToken());
            if (this.debug) {
                System.out.println("token " + string2);
            }
            String string3 = this.deviceName(string2);
            String string4 = this.testName(string2);
            String string5 = this.testState(string2);
            if (string4 == null) {
                string4 = string3.substring(0, string3.length() - 1);
            }
            Enumeration enumeration = this.filter.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string6 = (String)enumeration.nextElement();
                String string7 = (String)this.filter.get(string6);
                n3 = string7.indexOf(string4);
                if (string4.equals("pmemtest")) {
                    object = string3.substring(3);
                    string3 = new String(String.valueOf(string6) + (String)object);
                    break;
                }
                if (n3 == -1) continue;
                object = (Integer)this.devCount.get(string6);
                string3 = new String(String.valueOf(string6) + object);
                this.devCount.put(string6, new Integer((Integer)object + 1));
                break;
            }
            if (this.debug) {
                System.out.println("device name " + string3);
            }
            if ((n2 = string2.indexOf(":")) < 0) {
                this.fruNames.addElement(string2);
            } else {
                this.fruNames.addElement(string2.substring(0, n2));
            }
            this.devNames.addElement(string3);
            if (string2.equals(string3)) continue;
            int n4 = string.indexOf(string2);
            n3 = n4 + string2.length();
            this.devList = String.valueOf(string.substring(0, n4)) + string3 + string5 + string.substring(n3);
        }
        if (this.debug) {
            System.out.println("frus");
            this.printVector(this.fruNames);
            System.out.println("devices");
            this.printVector(this.devNames);
            System.out.println("device list");
            System.out.println(this.devList);
        }
    }

    private String testName(String string) {
        int n;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        String string2 = n2 == -1 ? null : ((n = string.indexOf("diskette")) == -1 ? string.substring(n2 + 1, n3) : string.substring(0, n2));
        return string2;
    }

    private String testState(String string) {
        int n = string.indexOf(":");
        String string2 = n < 0 ? "0" : string.substring(n);
        return string2;
    }
}

