#
# Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
#
# ident  "@(#)configd-check.sh  1.8  01/01/12  SMI."

# Supported Platforms   Package Name  Executable Name  Platform Keyword
# -------------------   ------------  ---------------  ----------------
#  Desktop/Workstation   SUNWeswsa     configddt        Default
#  WorkGroup Server      SUNWeswga     configdWG        Default
#  Netra-t Server        SUNWesnta     configdnt        Default
#  Starfire              NoPackage     configd4u        Ultra-Enterprise-10000
#  Starcat Domain	 NoPackage     configd4u	Sun-Fire-15000
#  Starcat Controller	 NoPackage     configd4u	UltraSPARC-IIi-cEngine
#  Enterprise Server     SUNWsycfd     configd          Ultra-Enterprise:SPARCserver:SPARCcenter
#  Serengeti		 SUNWessda     configd          Default
#

#  where: NoPackage: This is for the case when we have only the binary of confid,
#		        which will be installed with the SUNWedag package under
#                    	SUNWsymon/addons/AdvancedMonitoring/lib/agent directory.
#         Default:   For the case when the platform support list is provided by
#                  	the configd package.

# PKG_LIST format is defined by three different fields delimited by ";".
# Each entry is separated by at least a whitespace character and has the 
# following format: 
#        package_name;executable_name;platform_keyword
#
# The platform_keyword field is delimited by a colon.
# NOTE: No whitespace character is allowed in any field of each enty, since 
#	 is being used as a delimitation between entries.

PKG_LIST="SUNWeswsa;configddt;Default \
	  SUNWeswga;configdWG;Default \
          SUNWesnta;configdnt;Default \
          NoPackage;configd4u1;Ultra-Enterprise-10000 \
	  NoPackage;configd4u1;Sun-Fire-15000 \
	  NoPackage;configd4u1;UltraSPARC-IIi-cEngine \
       	  SUNWsycfd;configd;Ultra-Enterprise:SPARCserver:SPARCcenter \
 	  SUNWessda;configd;Default \
         "
## Some variable definitions
SYMONDIR=/SUNWsymon/bin
TMP_BUF=""
CMD_BUF=""
cmd_exist=0
no_pkg=0
no_bin=0
configd_count=0

###############################
## Parse package List Function
###############################
parse_data() {	

    for LIST in $1
    do
   	PKG=`echo $LIST | awk -F\; '{print $1}'`
    	BIN=`echo $LIST | awk -F\; '{print $2}'`
    	KEY=`echo $LIST | awk -F\; '{print $3}'`
    done

    return 0
}


###################################
## Check Platform Support Function
###################################
check_platform() {

#
#  $1 = list of platforms to check
#
#  Return code of zero means platform check failed (no match)
#
    PLATFORM_MATCH=""
	
    # We have to make sure that "configd" of SUNWsycfd package is not 
    # being run under Starfire system, because is not compatible with
    # this new system.
    if [ "$PKG" = "SUNWsycfd" ] && 
       [ "$platdir" = "SUNW,Ultra-Enterprise-10000" ]; then
    	return 0
    fi
    	
    OLDIFS=$IFS
    IFS=:
    for each_platform in $1
    do
        echo "$PLATFORM_NAME" | /usr/bin/grep "$each_platform" >/dev/null 2>&1
        if [ $? -eq 0 ] ; then
            IFS="$OLDIFS"
            PLATFORM_MATCH="$each_platform"
            return 1
        fi
    done
    	
    IFS="$OLDIFS"
    	
    return 0
}

#######################
## Main Check Function
#######################
configd_check() {

echo ""
eval echo "\"`gettext 'Checking config reader support for ${ProductName} ...'`\""

## Getting current platform name.
platdir=`/bin/uname -i`
if [ -f /usr/platform/"$platdir"/sbin/prtdiag ] ; then
    prtout=`/usr/platform/"$platdir"/sbin/prtdiag | /usr/bin/head -1 | /usr/bin/cut -f2 -d:`
else
    prtout="$platdir"
fi

# Main for loop for the script
#
for PKG_INFO in $PKG_LIST
do
    # Counting the number of entries in the PKG_LIST variable.
    configd_count=`expr $configd_count + 1`

    # Parse Package List string.
    parse_data $PKG_INFO

    # Check if it has a package
    if [ "$PKG" = "NoPackage" ]; then
        # It doen't have a package name, then get platform list from Platform Keyword.
        PLATFORMLIST=$KEY
        PLATFORM_NAME="$platdir"
        # Checking the platfrom list. 
        if [ -n "$PLATFORMLIST" ] ; then
            check_platform "$PLATFORMLIST"
        fi
  
        # Getting package informations
        TMPCMD="SUNWsymon/addons/AdvancedMonitoring/lib/cfd/$BIN"

        # Getting command informations if the platform is supported.
        if [ -n "$PLATFORM_MATCH" ]; then
            cmd_exist=1
        else
            # Platform not supported.
            no_bin=`expr $no_bin + 1`
            CMD_BUF="$CMD_BUF $BIN"
        fi
	 
    else
        # Check if the package is installed or no
        /bin/pkginfo -qi $PKG
        # The package exist
        if [ $? -eq 0 ]; then 
            # Getting the Platform support list
            if [ "$KEY" = "Default" ]; then
                # Getting from the package's ES_ADDON_PLATFORM variable.
                PLATFORMLIST=`/usr/bin/pkgparam $PKG  ES_ADDON_PLATFORM`
                PLATFORM_NAME="$prtout"
            else
                # Getting from Platform Keyword variable.
                PLATFORMLIST=$KEY
                PLATFORM_NAME="$platdir"
            fi

            # Checking the platfrom list. 
            if [ -n "$PLATFORMLIST" ] ; then
                check_platform "$PLATFORMLIST"
            fi
   
            # Getting command informations if the platform is supported.
            if [ -n "$PLATFORM_MATCH" ]; then
                cmd_exist=1
            else
                # Platform not supported.
                TMP_BUF="$TMP_BUF $PKG"
            fi
        else
            no_pkg=`expr $no_pkg + 1`
        fi
    fi
done

if [ $cmd_exist -eq 1 ]; then
    echo `gettext "Checking for required config reader done."`
    echo ""
    return 0
fi

# Printing error messages.
if [ $configd_count -eq `expr $no_pkg + $no_bin` ]; then
    # None of the configd packages are installed
    echo ""
    echo `gettext "ERROR: config reader package not available."`
else 
    echo ""
    eval echo "\"`gettext 'ERROR: Platform not supported by:${TMP_BUF} package${OPEN}s${CLOSE}'`\""
    if [ $no_bin -ne 0 ]; then
        eval echo "\"`gettext 'and by:${CMD_BUF} ${OPEN}s${CLOSE}'`\""
    fi
fi

return 1

}
