/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLineParser {
    private static String BACK_SLASH = "\\";
    private static String COMMENT_CHAR = "#";
    private static String ESCAPED_NEW_LINE = "\\n";
    private static String LITERAL_QUOTE = "\\\"";
    private static String NEW_LINE = "\n";
    private static String NEWLINE_PROMPT = "> ";
    private static String QUOTE = "\"";
    private static char QUOTE_CHAR = (char)34;
    private static String SPACE = " ";
    private StringTokenizer parser;
    private BufferedReader input;
    private PrintStream output;
    private Vector tokens;

    public CommandLineParser(BufferedReader in, PrintStream out) {
        this.input = in;
        this.output = out;
    }

    private String parse(String token) throws IOException {
        if (token.startsWith(COMMENT_CHAR)) {
            this.parser = null;
            return SPACE;
        }
        if (!token.startsWith(BACK_SLASH) && token.endsWith(BACK_SLASH)) {
            token = token.substring(0, token.length() - 1);
            if (this.parser.hasMoreTokens()) {
                return String.valueOf(token) + " " + this.parse(this.parser.nextToken(SPACE));
            }
        }
        if (token.startsWith(BACK_SLASH) && token.length() > 1) {
            return token.substring(1);
        }
        if (token.equals(SPACE)) {
            try {
                return this.parse(this.parser.nextToken(SPACE));
            }
            catch (NoSuchElementException noSuchElementException) {
                return token;
            }
        }
        if (token.charAt(0) == QUOTE_CHAR) {
            token = token.substring(1);
            try {
                return String.valueOf(token) + this.parseQuotedString();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.output.print(NEWLINE_PROMPT);
                this.parser = new StringTokenizer(this.input.readLine(), QUOTE, true);
                return String.valueOf(token) + NEW_LINE + this.parseQuotedString();
            }
        }
        if (token.equals(LITERAL_QUOTE)) {
            return QUOTE;
        }
        if (token.equals(ESCAPED_NEW_LINE)) {
            return NEW_LINE;
        }
        if (token.equals(BACK_SLASH)) {
            if (this.parser.hasMoreTokens()) {
                return SPACE;
            }
            token = token.substring(0, token.length() - 1);
            this.parser = new StringTokenizer(this.input.readLine(), SPACE, true);
            try {
                token = this.parse(this.parser.nextToken(SPACE));
                return token;
            }
            catch (NoSuchElementException noSuchElementException) {
                return SPACE;
            }
        }
        return token;
    }

    private void parseLine() throws IOException {
        String strRead = this.input.readLine();
        if (strRead == null) {
            throw new EOFException();
        }
        String s = strRead.replace('\t', ' ');
        this.parser = new StringTokenizer(s, SPACE, true);
        while (this.parser != null && this.parser.hasMoreTokens()) {
            String s1 = this.parse(this.parser.nextToken(SPACE));
            if (s1.equals(SPACE)) continue;
            this.tokens.addElement(s1);
        }
    }

    private String parseQuotedString() throws IOException {
        String token = this.parser.nextToken(QUOTE);
        if (token.equals(QUOTE)) {
            return "";
        }
        try {
            this.parser.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.output.print(NEWLINE_PROMPT);
            this.parser = new StringTokenizer(this.input.readLine(), QUOTE, true);
            return String.valueOf(token) + NEW_LINE + this.parseQuotedString();
        }
        if (token.equals(ESCAPED_NEW_LINE)) {
            return NEW_LINE;
        }
        if (token.endsWith(BACK_SLASH)) {
            token = token.substring(0, token.length() - 1);
            if (this.parser.hasMoreTokens()) {
                return String.valueOf(token) + QUOTE;
            }
        }
        return token;
    }

    public String[] tokens() throws IOException {
        this.tokens = new Vector();
        this.parseLine();
        Object[] args = new String[this.tokens.size()];
        this.tokens.copyInto(args);
        return args;
    }
}

