/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.server.tools.sess_iiop.ChainProperties;
import oracle.aurora.server.tools.sess_iiop.FSNameParser;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import oracle.aurora.server.tools.sess_iiop.WindowsFSContext;
import oracle.aurora.server.tools.sess_iiop.WorkingDirectory;

public class LocalWorkingDirectory
extends WorkingDirectory {
    private static final boolean isWindows = new File("").getAbsolutePath().indexOf(":") > 0;

    public LocalWorkingDirectory() throws ToolsException {
        this(System.getProperties());
    }

    private LocalWorkingDirectory(String msgFile, Properties env, Context initialContext) throws ToolsException {
    }

    public LocalWorkingDirectory(Properties env) throws ToolsException {
        this.environment = new ChainProperties((Hashtable)env);
        this.parser = new FSNameParser();
        this.ic = isWindows ? new WindowsFSContext(this.environment) : LocalWorkingDirectory.createFSContext(System.getProperty("file.separator"));
        this.wd = this.ic;
        this.cd(this.parse(this.default_directory()));
    }

    private LocalWorkingDirectory(Properties env, Context initialContext) throws ToolsException {
    }

    public void cd(String directory) throws ToolsException {
        if (directory.length() == 0) {
            directory = this.userHome().toString();
        }
        super.cd(directory.replace('\\', '/'));
    }

    protected static Context createFSContext(String root) throws ToolsException {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.fscontext.FSContextFactory");
        environment.put("java.naming.provider.url", "file:" + root);
        try {
            return (Context)new InitialContext(environment).lookup(System.getProperty("file.separator"));
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String default_directory() throws ToolsException {
        try {
            String path = new File("").getCanonicalPath();
            return path.replace('\\', '/');
        }
        catch (IOException e) {
            this.error("IOException during determination of default directory: " + e.getMessage());
            return null;
        }
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot retreive full name");
    }

    private String getRoot(String name) {
        if (name.indexOf(":") > 0) {
            return name;
        }
        return "/";
    }

    private boolean isRoot(String name) {
        if (name.equals("")) {
            return true;
        }
        return name.indexOf(":") > 0;
    }

    public boolean isWindows() {
        return isWindows;
    }

    public Name parse(String nameString) throws ToolsException {
        return super.parse(nameString.replace('\\', '/'));
    }

    private String provider_url() throws ToolsException {
        try {
            File parent = new File(new File("").getCanonicalPath());
            while (parent.getParent() != null) {
                parent = new File(parent.getParent());
            }
            return "file:" + parent;
        }
        catch (IOException e) {
            this.error(e.getMessage());
            return null;
        }
    }

    public Name rootName() throws ToolsException {
        return this.wd_name.getPrefix(0);
    }

    public Name transformName(Name source, Name transform) throws ToolsException {
        if (this.isRoot(transform.get(0))) {
            source = this.parse(this.getRoot(transform.get(0)));
            if (transform.size() == 1) {
                return source;
            }
            transform = transform.getSuffix(1);
        } else if (transform.get(0).equals("~")) {
            source = this.userHome();
            if (transform.size() == 1) {
                return source;
            }
            transform = transform.getSuffix(1);
        }
        Name dir = (Name)source.clone();
        int i = 0;
        while (i < transform.size()) {
            String component = transform.get(i);
            dir = this.operate(dir, component);
            ++i;
        }
        return dir;
    }
}

