/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.server.tools.sess_iiop.BindingEnumeration;
import oracle.aurora.server.tools.sess_iiop.ChainProperties;
import oracle.aurora.server.tools.sess_iiop.FSNameParser;
import oracle.aurora.server.tools.sess_iiop.LocalWorkingDirectory;
import oracle.aurora.server.tools.sess_iiop.ToolsException;

public class WindowsFSContext
implements Context {
    protected ChainProperties env;
    protected Hashtable bindings = new Hashtable(5, 0.75f);
    final FSNameParser parser = new FSNameParser();

    public WindowsFSContext(Hashtable e) throws ToolsException {
        this.env = new ChainProperties(e);
        String roots = "CDEFGHIJKLMNOPQRSTUVWXYZ";
        Vector<String> found = new Vector<String>();
        int i = 0;
        while (i < roots.length()) {
            String root = String.valueOf(roots.substring(i, i + 1)) + ":/";
            if (new File(root).exists()) {
                found.addElement(root);
            }
            ++i;
        }
        Enumeration disks = found.elements();
        while (disks.hasMoreElements()) {
            String disk = (String)disks.nextElement();
            this.bindings.put(disk.substring(0, 2), LocalWorkingDirectory.createFSContext(disk));
        }
    }

    public Object addToEnvironment(String key, Object value) throws NamingException {
        return ((Hashtable)this.env).put(key, value);
    }

    public void bind(String key, Object value) throws NamingException {
        this.bind(this.parser.parse(key), value);
    }

    public void bind(Name name, Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException("NAME_IS_EMPTY");
        }
        if (name.size() == 1) {
            this.bindings.put(name.get(0), object);
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.bind(name.getSuffix(1), object);
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    public void close() throws NamingException {
        Enumeration sessions = this.bindings.elements();
        while (sessions.hasMoreElements()) {
            ((Context)sessions.nextElement()).close();
        }
        this.env = null;
        this.bindings = null;
    }

    public String composeName(String name1, String name2) throws NamingException {
        if (name2.equals("")) {
            return name1;
        }
        if (name1.equals("")) {
            return name2;
        }
        return String.valueOf(String.valueOf(name2)) + "/" + name1;
    }

    public Name composeName(Name name1, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name1);
        return name3;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parser.parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new CannotProceedException("Cannot create new disks");
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(this.parser.parse(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException("NAME_IS_EMPTY");
        }
        if (name.size() == 1) {
            try {
                Context ctx = (Context)this.bindings.remove(name.get(0));
                ctx.close();
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException();
            }
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.destroySubcontext(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    private Enumeration getBindings() {
        Vector<Binding> b = new Vector<Binding>(this.bindings.size());
        Enumeration keys = this.bindings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object obj = this.bindings.get(key);
            b.addElement(new Binding(key, obj));
        }
        return b.elements();
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot retreive full name");
    }

    public NameParser getNameParser(String arg1) throws NamingException {
        return this.parser;
    }

    public NameParser getNameParser(Name arg1) throws NamingException {
        return this.parser;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(this.parser.parse(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return new BindingEnumeration(this.getBindings());
        }
        try {
            Context ctx = (Context)this.bindings.get(name.get(0).toUpperCase());
            return ctx.listBindings(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(this.parser.parse(string));
    }

    public Object lookup(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return this;
        }
        try {
            Object obj = this.bindings.get(name.get(0).toUpperCase());
            if (obj == null) {
                throw new NameNotFoundException(name.get(0));
            }
            if (name.size() == 1) {
                return obj;
            }
            return ((Context)obj).lookup(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(String string, Object obj) throws NamingException {
        this.rebind(this.parser.parse(string), obj);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException("NAME_IS_EMPTY");
        }
        if (name.size() == 1) {
            if (object instanceof Context) {
                throw new NotContextException("ONLY_SESSIONS");
            }
            this.bindings.put(name.get(0), object);
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.rebind(name.getSuffix(1), object);
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        return ((Hashtable)this.env).remove(key);
    }

    public void rename(String from, String to) throws NamingException {
        this.rename(this.parser.parse(from), this.parser.parse(to));
    }

    public void rename(Name from, Name to) throws NamingException {
        from = this.trim(from);
        to = this.trim(to);
        if (from.size() == 0 || to.size() == 0) {
            throw new InvalidNameException("ONE_OR_BOTH_NAMES_EMPTY");
        }
        Object object = this.lookup(from);
        this.bind(to, object);
        this.unbind(from);
    }

    /*
     * Unable to fully structure code
     */
    private Name trim(Name name) throws NamingException {
        if (name.size() != 0) ** GOTO lbl4
        return name;
lbl-1000:
        // 1 sources

        {
            name = name.getSuffix(1);
lbl4:
            // 2 sources

            ** while (name.size() > 0 && name.get((int)0).equals((Object)""))
        }
lbl5:
        // 1 sources

        return name;
    }

    public void unbind(String string) throws NamingException {
        this.unbind(this.parser.parse(string));
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("NAME_IS_EMPTY");
        }
        if (name.size() == 1) {
            this.bindings.remove(name.get(0));
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.unbind(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }
}

