/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.objectgroup;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.console.SMDomainChangeEvent;
import com.sun.symon.base.client.console.SMDomainChangeListener;
import com.sun.symon.base.client.console.SMTopologyInfo;
import com.sun.symon.base.client.group.SMFilter;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMFilterInfo;
import com.sun.symon.base.client.group.SMObjectGroup;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.console.grouping.CgDialogContainer;
import com.sun.symon.base.console.grouping.CgDialogInterface;
import com.sun.symon.base.console.grouping.CgFieldValidator;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.objectgroup.CgOGInfoPane;
import com.sun.symon.base.console.grouping.objectgroup.CgOGPreviewDialog;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgRowTransEvent;
import com.sun.symon.base.console.grouping.table.CgTable;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.grouping.table.CgTblUpdateEvent;
import com.sun.symon.base.console.grouping.table.CgTblUpdateListener;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcThreadWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class CgOGManagerDialog
extends JDialog
implements ActionListener,
CgDialogInterface {
    private JButton helpBtn;
    private JButton cancelBtn;
    private JButton deleteBtn;
    private JButton okBtn;
    private JButton applyBtn;
    private JButton previewBtn;
    private JButton delCurSelBtn;
    private JButton udtCurSelBtn;
    private JRadioButton allObjRBtn;
    private JRadioButton selObjRBtn;
    private JTextArea descArea;
    private JList objLst;
    SMDBChangeListener ogChangeListener;
    SMDBChangeListener filterChangeListener;
    DefaultListModel selObjsLstModel;
    private CgTblPane ogTblPane;
    private JLabel statusLbl;
    private JComboBox filterCmB;
    private CgOGInfoPane filterPane;
    private JLabel domainLbl;
    private JLabel selHintLbl;
    private String udtGroupName;
    private boolean bNeedClose = false;
    private SMFilterInfo[] filterInfos = new SMFilterInfo[0];
    private SMObjectGroupInfo[] ogData = new SMObjectGroupInfo[0];
    SMObjectGroup ogHandle = null;
    SMFilter filterHandle = null;
    private Frame owner;
    private SMDomainChangeListener domainChangeListener;
    String curDomain;
    String curI18nDomain;
    private String noneStr = CgUtil.getI18nMsg((String)"ogMgr.emptyRowMsg");
    boolean bSaving = false;
    boolean bNotRefresh = false;

    public CgOGManagerDialog(Frame frame, SMObjectGroup sMObjectGroup, SMFilter sMFilter) throws SMAPIException {
        this(frame, "", sMObjectGroup, sMFilter);
    }

    public CgOGManagerDialog(Frame frame, String string, SMObjectGroup sMObjectGroup, SMFilter sMFilter) throws SMAPIException {
        super(frame);
        this.setDefaultCloseOperation(0);
        this.owner = frame;
        this.udtGroupName = string;
        this.setTitle(CgUtil.getI18nMsg((String)"ogMgr.title"));
        this.curDomain = SMConsoleContext.getInstance().getCurrentDomain();
        this.curI18nDomain = UcInternationalizer.translateKey((String)this.curDomain);
        SMRawDataRequest sMRawDataRequest = SMConsoleContext.getInstance().getAPIHandle();
        this.ogHandle = sMObjectGroup;
        this.filterHandle = sMFilter;
        this.createGUI();
        this.initData();
        this.installListeners();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-og-manager-help");
        } else if (object == this.deleteBtn) {
            String string = CgUtil.getI18nMsg((String)"DeleteConfirmation.msgLabel");
            if (UcDialog.showYesNo((String)string) != 0) {
                return;
            }
            UcThreadWorker ucThreadWorker = new UcThreadWorker(){

                public void doWork() {
                    CgOGManagerDialog.this.deleteOG();
                }
            };
            ucThreadWorker.start();
        } else if (object == this.previewBtn) {
            int n = this.ogTblPane.getSelectedRow();
            if (this.ogTblPane.getSelectedRowCount() == 0) {
                return;
            }
            SMObjectGroupData sMObjectGroupData = this.getObjectGroupData();
            if (sMObjectGroupData == null) {
                return;
            }
            this.showPreviewDialog(sMObjectGroupData, this);
        } else if (object == this.udtCurSelBtn) {
            if (!this.fillCurTopObjs()) {
                UcDialog.showError((Object)CgUtil.getI18nMsg((String)"ogMgr.noTopoSel"));
            }
        } else if (object == this.delCurSelBtn) {
            int[] nArray = this.objLst.getSelectedIndices();
            if (nArray != null) {
                this.objLst.clearSelection();
                int n = nArray.length - 1;
                while (n >= 0) {
                    this.selObjsLstModel.remove(nArray[n]);
                    --n;
                }
            }
        } else if (object == this.okBtn) {
            this.bNeedClose = true;
            this.save();
        } else if (object == this.applyBtn) {
            this.save();
        }
    }

    public void close() {
        Object object;
        int n;
        if ((this.ogTblPane.isTableDataUpdated() || this.ogTblPane.getTable().isEditing()) && (n = UcDialog.showOkCancel((String)(object = CgUtil.getI18nMsg((String)"TaskManager.closeMsg")))) == 1) {
            return;
        }
        object = CgUtil.getDialogFromPool((String)"og previewer");
        if (object != null) {
            ((CgOGPreviewDialog)object).close();
        }
        if (this.owner instanceof CgDialogContainer) {
            ((CgDialogContainer)this.owner).removeDialogFromPool("group");
        }
        SMConsoleContext sMConsoleContext = SMConsoleContext.getInstance();
        sMConsoleContext.removeDomainChangeListener(this.domainChangeListener);
        this.removeAll();
        try {
            this.ogHandle.removeDBChangeListener(this.ogChangeListener);
            this.filterHandle.removeDBChangeListener(this.filterChangeListener);
        }
        catch (Exception exception) {}
        this.dispose();
        System.gc();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.statusLbl = new JLabel(" ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(12, 12, 12, 12));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        jPanel.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg((String)"ogMgr.ogLbl"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        gridBagConstraints.fill = 1;
        this.ogTblPane = this.createOGTblPane();
        jPanel2.add((Component)this.ogTblPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.deleteBtn = new JButton(CgUtil.getI18nMsg((String)"ogMgr.delBtn"));
        this.deleteBtn.setEnabled(false);
        jPanel2.add((Component)this.deleteBtn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(CgUtil.getI18nMsg((String)"Description.labelString")), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        this.descArea = new JTextArea(2, 20);
        this.descArea.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.descArea);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.allObjRBtn = new JRadioButton(CgUtil.getI18nMsg((String)"ogMgr.allObjRBtn"));
        this.allObjRBtn.setEnabled(false);
        jPanel3.add((Component)this.allObjRBtn, "West");
        this.domainLbl = new JLabel(this.curI18nDomain);
        this.domainLbl.setEnabled(false);
        this.domainLbl.setForeground(Color.black);
        Font font = this.domainLbl.getFont();
        this.domainLbl.setFont(font.deriveFont(0));
        jPanel3.add(this.domainLbl);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.selObjRBtn = new JRadioButton(CgUtil.getI18nMsg((String)"ogMgr.selObjRBtn"));
        this.selObjRBtn.setEnabled(false);
        this.selObjRBtn.setSelected(true);
        jPanel4.add((Component)this.selObjRBtn, "West");
        this.selHintLbl = new JLabel(CgUtil.getI18nMsg((String)"ogMgr.selHint"));
        this.selHintLbl.setEnabled(false);
        font = this.selHintLbl.getFont();
        this.selHintLbl.setFont(font.deriveFont(0));
        this.selHintLbl.setForeground(Color.black);
        jPanel4.add(this.selHintLbl);
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.selObjsLstModel = new DefaultListModel();
        this.objLst = new JList(this.selObjsLstModel);
        this.objLst.setBackground(UcCommon.getLightGrayColor());
        JScrollPane jScrollPane2 = new JScrollPane(this.objLst);
        jScrollPane2.setPreferredSize(new Dimension(200, 90));
        jPanel2.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.delCurSelBtn = new JButton(CgUtil.getI18nMsg((String)"standard.delete"));
        this.delCurSelBtn.setEnabled(false);
        jPanel2.add((Component)this.delCurSelBtn, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.udtCurSelBtn = new JButton(CgUtil.getI18nMsg((String)"ogMgr.refresh"));
        jPanel2.add((Component)this.udtCurSelBtn, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.previewBtn = new JButton(CgUtil.getI18nMsg((String)"ogMgr.previewBtn"));
        jPanel2.add((Component)this.previewBtn, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        gridBagConstraints.fill = 1;
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), " " + CgUtil.getI18nMsg((String)"ogMgr.filter") + " "));
        this.filterPane = new CgOGInfoPane();
        this.filterPane.setFilter(null);
        jPanel5.add(this.filterPane);
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JSeparator jSeparator = new JSeparator();
        jPanel6.add((Component)jSeparator, "North");
        JPanel jPanel7 = new JPanel(new GridLayout(1, 3, 5, 0));
        jPanel7.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.okBtn = new JButton(CgUtil.getI18nMsg((String)"standard.ok"));
        jPanel7.add(this.okBtn);
        this.applyBtn = new JButton(CgUtil.getI18nMsg((String)"standard.apply"));
        jPanel7.add(this.applyBtn);
        this.cancelBtn = new JButton(CgUtil.getI18nMsg((String)"standard.cancel"));
        jPanel7.add(this.cancelBtn);
        this.helpBtn = new JButton(CgUtil.getI18nMsg((String)"ogMgr.helpBtn"));
        jPanel7.add(this.helpBtn);
        jPanel6.add((Component)jPanel7, "East");
        this.statusLbl.setBorder(new EmptyBorder(0, 12, 0, 0));
        this.statusLbl.setForeground(Color.black);
        jPanel6.add((Component)this.statusLbl, "South");
        jPanel.add((Component)jPanel6, "South");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allObjRBtn);
        buttonGroup.add(this.selObjRBtn);
        this.pack();
    }

    private CgTblPane createOGTblPane() {
        CgTblPane cgTblPane = null;
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[3];
        String[] stringArray = new String[]{CgUtil.getI18nMsg((String)"ogMgr.tbl_grp_header"), CgUtil.getI18nMsg((String)"ogMgr.tbl_domain_header"), CgUtil.getI18nMsg((String)"ogMgr.tbl_filter_header")};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] blArray2 = blArray;
        String[] stringArray2 = new String[]{"", this.curI18nDomain, this.noneStr};
        this.filterCmB = new JComboBox();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField((Document)new CgFieldValidator(32, 8L), "", 32));
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(this.filterCmB);
        DefaultCellEditor[] defaultCellEditorArray = new DefaultCellEditor[]{defaultCellEditor, null, defaultCellEditor2};
        int n = 0;
        while (n < 3) {
            cgTblColumnFormatArray[n] = new CgTblColumnFormat(stringArray[n], blArray2[n], defaultCellEditorArray[n], new CgData(stringArray2[n]));
            ++n;
        }
        cgTblColumnFormatArray[0].setToolTip(CgUtil.getI18nMsg((String)"standard.click"));
        cgTblColumnFormatArray[2].setToolTip(CgUtil.getI18nMsg((String)"ogMgr.filter_tooltip"));
        cgTblPane = new CgTblPane(cgTblColumnFormatArray, true);
        cgTblPane.setPreferredSize(new Dimension(420, 150));
        cgTblPane.getTable().setSelectionMode(0);
        return cgTblPane;
    }

    private CgData[][] createTblData() {
        CgData[][] cgDataArray = new CgData[this.ogData.length][3];
        int n = 0;
        while (n < this.ogData.length) {
            cgDataArray[n] = new CgData[3];
            cgDataArray[n][0] = new CgData(this.ogData[n].getName());
            String string = " ";
            String string2 = " ";
            string = UcInternationalizer.translateKey((String)this.ogData[n].getDomain());
            string2 = this.ogData[n].getFilterName();
            if (string2.trim().length() == 0) {
                string2 = this.noneStr;
            }
            cgDataArray[n][1] = new CgData(string);
            cgDataArray[n][2] = new CgData(string2);
            ++n;
        }
        return cgDataArray;
    }

    void deleteOG() {
        int n = this.ogTblPane.getSelectedRow();
        try {
            this.ogHandle.delete(this.ogData[n].getObjectID());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
    }

    boolean fillCurTopObjs() {
        int n;
        String string;
        CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
        if (cmConsoleSession == null) {
            cmConsoleSession = new CmConsoleSession();
        }
        if ((string = cmConsoleSession.getConsoleParameter("selectionPath")) == null || string.length() == 0) {
            string = cmConsoleSession.getConsoleParameter("mainNavPath");
            if (string != null) {
                string = CmTopologyPath.decode((String)string).toString();
            } else {
                return false;
            }
        }
        string = (n = string.indexOf("/")) != -1 ? string.substring(n) : "";
        SMConsoleContext sMConsoleContext = SMConsoleContext.getInstance();
        SMTopologyInfo[] sMTopologyInfoArray = sMConsoleContext.getSelectedTopologyObjects();
        this.selObjsLstModel.removeAllElements();
        boolean bl = false;
        if (sMTopologyInfoArray != null) {
            if (sMTopologyInfoArray.length > 0) {
                bl = true;
            }
            int n2 = 0;
            while (n2 < sMTopologyInfoArray.length) {
                String string2 = String.valueOf(string) + "/" + sMTopologyInfoArray[n2].getName();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.selObjsLstModel.addElement(string2);
                ++n2;
            }
        }
        return bl;
    }

    void fillDetail(final int n) {
        Object object;
        SMObjectGroupData sMObjectGroupData = null;
        if (n < this.ogData.length) {
            if (this.ogData[n] instanceof SMObjectGroupData) {
                sMObjectGroupData = (SMObjectGroupData)this.ogData[n];
            } else {
                try {
                    sMObjectGroupData = this.ogHandle.load(this.ogData[n]);
                    this.ogData[n] = sMObjectGroupData;
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Object)sMAPIException.getMessage());
                    return;
                }
            }
        }
        String string = null;
        string = sMObjectGroupData != null ? sMObjectGroupData.getDomain() : this.curDomain;
        String string2 = UcInternationalizer.translateKey((String)string);
        this.domainLbl.setText(string2);
        boolean bl = string.equals(this.curDomain);
        this.udtCurSelBtn.setEnabled(bl);
        if (sMObjectGroupData != null) {
            this.objLst.clearSelection();
            this.selObjsLstModel.removeAllElements();
            if (sMObjectGroupData.isAllObjectsInDomain()) {
                this.allObjRBtn.setSelected(true);
            } else {
                this.selObjRBtn.setSelected(true);
                object = sMObjectGroupData.getObjects();
                if (object != null) {
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        Object object2 = object[n2];
                        if (((String)object2).startsWith("/")) {
                            object2 = ((String)object2).substring(1);
                        }
                        this.selObjsLstModel.addElement(object2);
                        ++n2;
                    }
                }
            }
            this.descArea.setText(this.ogData[n].getDescription());
        } else {
            this.selObjRBtn.setSelected(true);
            this.fillCurTopObjs();
            this.descArea.setText(" ");
        }
        if (sMObjectGroupData != null) {
            object = new UcThreadWorker(){

                public void doWork() {
                    SMFilterData sMFilterData = this.getOGFilter(ogData[n]);
                    filterPane.setFilter(sMFilterData);
                }
            };
            ((Thread)object).start();
        } else {
            this.filterPane.setFilter(null);
        }
    }

    void filterChanged(SMDBChangeEvent sMDBChangeEvent) {
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"ogMgr.reload"));
        try {
            this.filterInfos = null;
            this.filterInfos = this.filterHandle.getAll();
            if (this.filterInfos == null) {
                this.filterInfos = new SMFilterData[0];
            }
        }
        catch (SMSecurityException sMSecurityException) {
            UcDialog.showError((Component)this, (Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:securityError"));
        }
        catch (SMDatabaseException sMDatabaseException) {
            UcDialog.showError((Component)this, (Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:databaseError"));
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:APIError"));
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (CgOGManagerDialog.this.filterInfos != null) {
                        int n = 0;
                        while (n < CgOGManagerDialog.this.filterInfos.length) {
                            ((CgOGManagerDialog)CgOGManagerDialog.this).filterInfos[n] = CgOGManagerDialog.this.filterHandle.load(CgOGManagerDialog.this.filterInfos[n]);
                            ++n;
                        }
                    }
                }
                catch (SMSecurityException sMSecurityException) {
                    UcDialog.showError((Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:securityError"));
                }
                catch (SMDatabaseException sMDatabaseException) {
                    UcDialog.showError((Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:databaseError"));
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:APIError"));
                }
            }
        };
        new Thread(runnable).start();
        Runnable runnable2 = new Runnable(){

            public void run() {
                Object object = CgOGManagerDialog.this.filterCmB.getSelectedItem();
                Vector<String> vector = new Vector<String>();
                vector.addElement(CgOGManagerDialog.this.noneStr);
                if (CgOGManagerDialog.this.filterInfos != null) {
                    int n = 0;
                    while (n < CgOGManagerDialog.this.filterInfos.length) {
                        vector.addElement(CgOGManagerDialog.this.filterInfos[n].getName());
                        ++n;
                    }
                } else {
                    CgOGManagerDialog.this.filterInfos = (SMFilterInfo[])new SMFilterData[0];
                }
                CgOGManagerDialog.this.filterCmB.setModel(new DefaultComboBoxModel(vector));
                CgOGManagerDialog.this.filterCmB.setSelectedItem(object);
                CgOGManagerDialog.this.statusLbl.setText(" ");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            SwingUtilities.invokeLater(runnable2);
        }
    }

    private SMFilterData getOGFilter(SMObjectGroupInfo sMObjectGroupInfo) {
        SMFilterData sMFilterData = null;
        SMDBObjectID sMDBObjectID = sMObjectGroupInfo.getFilter();
        if (sMDBObjectID != null && this.filterInfos != null) {
            int n = 0;
            while (n < this.filterInfos.length) {
                if (this.filterInfos[n].getObjectID().equals((Object)sMDBObjectID)) {
                    if (!(this.filterInfos[n] instanceof SMFilterData)) {
                        try {
                            sMFilterData = this.filterHandle.load(this.filterInfos[n]);
                            break;
                        }
                        catch (SMAPIException sMAPIException) {
                            UcDialog.showError((Object)sMAPIException.getMessage());
                            return null;
                        }
                    }
                    sMFilterData = (SMFilterData)this.filterInfos[n];
                    break;
                }
                ++n;
            }
        }
        return sMFilterData;
    }

    public SMObjectGroup getOGHandle() {
        return this.ogHandle;
    }

    SMObjectGroupData getObjectGroupData() {
        String string;
        Vector vector;
        SMObjectGroupData sMObjectGroupData = new SMObjectGroupData();
        String string2 = null;
        int n = this.ogTblPane.getSelectedRow();
        if (n == -1) {
            return null;
        }
        if (n == this.ogData.length) {
            string2 = this.curDomain;
        } else {
            vector = null;
            if (!(this.ogData[n] instanceof SMObjectGroupData)) {
                return null;
            }
            vector = (SMObjectGroupData)this.ogData[n];
            try {
                sMObjectGroupData.setDomain(vector.getDomain());
            }
            catch (SMLengthException sMLengthException) {}
            sMObjectGroupData.setObjectID(this.ogData[n].getObjectID());
            sMObjectGroupData.setTimestamp(this.ogData[n].getTimestamp());
        }
        vector = this.ogTblPane.getRowData(n);
        if (vector == null) {
            return null;
        }
        CgData cgData = (CgData)vector.get(0);
        if (cgData == null) {
            return null;
        }
        this.udtGroupName = string = cgData.toString();
        cgData = (CgData)vector.get(2);
        String string3 = "";
        if (cgData != null && (string3 = cgData.toString()).equals(this.noneStr)) {
            string3 = "";
        }
        try {
            sMObjectGroupData.setDescription(this.descArea.getText());
            sMObjectGroupData.setName(string);
            if (string2 != null) {
                sMObjectGroupData.setDomain(string2);
            }
        }
        catch (SMLengthException sMLengthException) {
            UcDialog.showError((Component)this, (Object)sMLengthException.getMessage());
            return null;
        }
        if (this.allObjRBtn.isSelected()) {
            sMObjectGroupData.setAllObjectsInDomain(true);
        } else {
            sMObjectGroupData.setAllObjectsInDomain(false);
            int n2 = this.selObjsLstModel.getSize();
            if (n2 == 0) {
                UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"ogMgr.noTopo"));
                return null;
            }
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                String string4 = (String)this.selObjsLstModel.elementAt(n3);
                stringArray[n3] = "/" + string4;
                ++n3;
            }
            try {
                sMObjectGroupData.setObjects(stringArray);
            }
            catch (SMLengthException sMLengthException) {
                UcDialog.showError((Component)this, (Object)sMLengthException.getMessage());
                return null;
            }
        }
        SMDBObjectID sMDBObjectID = null;
        if (!string3.trim().equals("")) {
            int n4 = 0;
            n4 = 0;
            while (n4 < this.filterInfos.length) {
                if (this.filterInfos[n4].getName().equals(string3)) break;
                ++n4;
            }
            if (n4 < this.filterInfos.length) {
                sMDBObjectID = this.filterInfos[n4].getObjectID();
            }
        }
        sMObjectGroupData.setFilter(sMDBObjectID);
        return sMObjectGroupData;
    }

    void initData() {
        Runnable runnable = new Runnable(){

            public void run() {
                CgOGManagerDialog.this.filterChanged(null);
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                CgOGManagerDialog.this.objectGroupChanged(null);
            }
        };
        new Thread(runnable).start();
        new Thread(runnable2).start();
    }

    void installListeners() {
        this.ogChangeListener = new SMDBChangeListener(){

            public void changed(SMDBChangeEvent sMDBChangeEvent) {
                CgOGManagerDialog.this.objectGroupChanged(sMDBChangeEvent);
            }
        };
        this.filterChangeListener = new SMDBChangeListener(){

            public void changed(SMDBChangeEvent sMDBChangeEvent) {
                CgOGManagerDialog.this.filterChanged(sMDBChangeEvent);
            }
        };
        try {
            this.ogHandle.addDBChangeListener(this.ogChangeListener);
            this.filterHandle.addDBChangeListener(this.filterChangeListener);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        this.filterCmB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = CgOGManagerDialog.this.filterCmB.getSelectedIndex();
                    if (n == -1) {
                        return;
                    }
                    SMFilterData sMFilterData = null;
                    if (n != 0) {
                        if (!(CgOGManagerDialog.this.filterInfos[n - 1] instanceof SMFilterData)) {
                            try {
                                sMFilterData = CgOGManagerDialog.this.filterHandle.load(CgOGManagerDialog.this.filterInfos[n - 1]);
                            }
                            catch (SMAPIException sMAPIException) {
                                UcDialog.showError((Object)sMAPIException.getMessage());
                                return;
                            }
                        } else {
                            sMFilterData = (SMFilterData)CgOGManagerDialog.this.filterInfos[n - 1];
                        }
                    }
                    CgOGManagerDialog.this.filterPane.setFilter(sMFilterData);
                }
            }
        });
        this.objLst.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                boolean bl = true;
                if (listSelectionModel.isSelectionEmpty()) {
                    bl = false;
                }
                CgOGManagerDialog.this.delCurSelBtn.setEnabled(bl);
            }
        });
        this.ogTblPane.addCgTblSelectListener(new CgTblSelectListener(){

            public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
                int n = -1;
                if (cgTblSelectEvent.getEventType() == CgTblSelectEvent.SELECT) {
                    n = CgOGManagerDialog.this.ogTblPane.getSelectedRow();
                }
                CgOGManagerDialog.this.selectOGTblRow(n);
            }
        });
        this.ogTblPane.addCgRowSaveListener(new CgRowSaveListener(){

            public boolean saveData(CgRowSaveEvent cgRowSaveEvent) {
                CgOGManagerDialog.this.save();
                return true;
            }
        });
        this.ogTblPane.addCgTblUpdateListener(new CgTblUpdateListener(){

            public boolean tblDataUpdated(CgTblUpdateEvent cgTblUpdateEvent) {
                CgOGManagerDialog.this.okBtn.setEnabled(true);
                CgOGManagerDialog.this.applyBtn.setEnabled(true);
                return true;
            }
        });
        this.ogTblPane.getTable().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component == CgOGManagerDialog.this.filterCmB && CgOGManagerDialog.this.filterCmB.getItemCount() == 1) {
                    UcDialog.showError((Component)CgOGManagerDialog.this, (Object)CgUtil.getI18nMsg((String)"ogMgr.filter_emptyPrompt"));
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
            }
        });
        SMConsoleContext sMConsoleContext = SMConsoleContext.getInstance();
        this.domainChangeListener = new SMDomainChangeListener(){

            public void changed(SMDomainChangeEvent sMDomainChangeEvent) {
                if (sMDomainChangeEvent.getStateChange() == 0) {
                    CgOGManagerDialog.this.curDomain = SMConsoleContext.getInstance().getCurrentDomain();
                    CgOGManagerDialog.this.curI18nDomain = UcInternationalizer.translateKey((String)CgOGManagerDialog.this.curDomain);
                    CgOGManagerDialog.this.ogTblPane.setColumnDefaultVal(1, new CgData(CgOGManagerDialog.this.curI18nDomain));
                    int n = CgOGManagerDialog.this.ogTblPane.getSelectedRow();
                    if (n == CgOGManagerDialog.this.ogData.length) {
                        CgTable cgTable = CgOGManagerDialog.this.ogTblPane.getTable();
                        cgTable.setValueAt(new CgData(CgOGManagerDialog.this.curI18nDomain), n, 1);
                        cgTable.clearSelection();
                        cgTable.setRowSelectionInterval(n, n);
                    }
                }
            }
        };
        sMConsoleContext.addDomainChangeListener(this.domainChangeListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgOGManagerDialog.this.close();
            }
        });
        this.helpBtn.addActionListener(this);
        this.okBtn.addActionListener(this);
        this.applyBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.deleteBtn.addActionListener(this);
        this.previewBtn.addActionListener(this);
        this.delCurSelBtn.addActionListener(this);
        this.udtCurSelBtn.addActionListener(this);
    }

    public void objectGroupChanged(SMDBChangeEvent sMDBChangeEvent) {
        Object object;
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"ogMgr.loading"));
        SMObjectGroupInfo[] sMObjectGroupInfoArray = null;
        if (this.ogTblPane.isTableDataUpdated() && !this.bSaving) {
            if (this.bNotRefresh) {
                return;
            }
            this.bNotRefresh = true;
            object = CgUtil.getI18nMsg((String)"ogMgr.refreshWarning");
            int n = UcDialog.showYesNo((String)object);
            this.bNotRefresh = false;
            if (n == 0) {
                this.save();
                return;
            }
        }
        try {
            sMObjectGroupInfoArray = this.ogHandle.getAll();
            this.ogData = sMObjectGroupInfoArray != null ? sMObjectGroupInfoArray : new SMObjectGroupInfo[0];
        }
        catch (SMAPIException sMAPIException) {
            CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this);
        }
        object = new Runnable(){

            public void run() {
                CgOGManagerDialog.this.ogTblPane.clearSelection();
                CgOGManagerDialog.this.ogTblPane.removeAllRows();
                CgOGManagerDialog.this.ogTblPane.setData(CgOGManagerDialog.this.createTblData());
                int n = 0;
                if (CgOGManagerDialog.this.ogData != null && CgOGManagerDialog.this.ogData.length > 0) {
                    int n2 = 0;
                    n2 = 0;
                    while (n2 < CgOGManagerDialog.this.ogData.length) {
                        if (CgOGManagerDialog.this.ogData[n2].getName().equals(CgOGManagerDialog.this.udtGroupName)) break;
                        ++n2;
                    }
                    n = n2;
                }
                if (n == CgOGManagerDialog.this.ogData.length) {
                    n = 0;
                }
                CgOGManagerDialog.this.ogTblPane.setRowSelectionInterval(n, n);
                CgOGManagerDialog.this.selectOGTblRow(n);
                CgOGManagerDialog.this.statusLbl.setText(" ");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            object.run();
        } else {
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    void save() {
        this.statusLbl.setText(" ");
        final SMObjectGroupData sMObjectGroupData = this.getObjectGroupData();
        if (sMObjectGroupData == null) {
            this.bNeedClose = false;
            return;
        }
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){
            boolean saveSuc = false;

            public void doWork() {
                bSaving = true;
                statusLbl.setText(CgUtil.getI18nMsg((String)"standard.saving"));
                if (CgUtil.saveObj((SMHandle)ogHandle, (SMDBObject)sMObjectGroupData)) {
                    ogTblPane.transactionFinished(new CgRowTransEvent((Object)this, 0));
                } else {
                    bNeedClose = false;
                }
                statusLbl.setText(" ");
                bSaving = false;
                if (bNeedClose) {
                    this.close();
                }
            }
        };
        ucThreadWorker.start();
    }

    void selectOGTblRow(int n) {
        boolean bl = n != -1;
        boolean bl2 = n == this.ogData.length;
        this.deleteBtn.setEnabled(bl && !bl2);
        ListSelectionModel listSelectionModel = this.objLst.getSelectionModel();
        this.delCurSelBtn.setEnabled(bl && !listSelectionModel.isSelectionEmpty());
        this.allObjRBtn.setEnabled(bl);
        this.selObjRBtn.setEnabled(bl);
        this.domainLbl.setEnabled(bl);
        this.selHintLbl.setEnabled(bl);
        this.descArea.setEnabled(bl);
        if (bl) {
            if (!bl2) {
                this.udtGroupName = this.ogData[n].getName();
            }
            this.fillDetail(n);
        } else {
            this.selObjRBtn.setSelected(true);
            this.selObjsLstModel.removeAllElements();
            this.descArea.setText(" ");
            this.filterPane.setFilter(null);
        }
    }

    public void showPreviewDialog(SMObjectGroupData sMObjectGroupData, Component component) {
        JDialog jDialog = CgUtil.getDialogFromPool((String)"og previewer");
        if (jDialog == null) {
            this.setCursor(new Cursor(3));
            jDialog = new CgOGPreviewDialog(this);
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            this.setCursor(new Cursor(0));
        }
        ((Component)jDialog).setVisible(true);
        ((CgOGPreviewDialog)jDialog).setObjectGroupData(sMObjectGroupData);
    }
}

