/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CvBorderEditor
extends JPanel {
    private JComboBox borderType = new JComboBox();
    private JTextField borderWidth = new JTextField("2", 20);

    public CvBorderEditor() {
        String string = "base.console.views.graph.Graph:border.style.";
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JLabel jLabel = new JLabel(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nBorderType"));
        JLabel jLabel2 = new JLabel(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nBorderWidth"));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "none")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "plain")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "etchedin")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "etchedout")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "in")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "out")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "framein")));
        this.borderType.addItem(UcInternationalizer.translateKey((String)(String.valueOf(string) + "frameout")));
        this.addRow(gridBagLayout, gridBagConstraints, jLabel, this.borderType);
        this.addRow(gridBagLayout, gridBagConstraints, jLabel2, this.borderWidth);
        this.setBorder(BorderFactory.createTitledBorder(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nBorder")));
    }

    private void addRow(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, Component component2) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        this.add(component2);
    }

    private int getBorderKey(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 5;
        }
        if (n == 2) {
            return 1;
        }
        if (n == 3) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        if (n == 5) {
            return 4;
        }
        if (n == 6) {
            return 6;
        }
        if (n == 7) {
            return 7;
        }
        return 0;
    }

    public int getBorderType() {
        int n = this.borderType.getSelectedIndex();
        return this.getBorderKey(n);
    }

    public String getBorderTypeString() {
        int n = this.borderType.getSelectedIndex();
        if (n == 0) {
            return "none";
        }
        if (n == 1) {
            return "plain";
        }
        if (n == 2) {
            return "etchedin";
        }
        if (n == 3) {
            return "etchedout";
        }
        if (n == 4) {
            return "in";
        }
        if (n == 5) {
            return "out";
        }
        if (n == 6) {
            return "framein";
        }
        if (n == 7) {
            return "frameout";
        }
        return "none";
    }

    public int getBorderWidth() throws CvGraphInvalidInputException {
        String string = this.borderWidth.getText().trim();
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidborder");
            throw new CvGraphInvalidInputException(string2);
        }
        return n;
    }

    public JTextField getBorderWidthField() {
        return this.borderWidth;
    }

    public String getBorderWidthString() {
        return this.borderWidth.getText().trim();
    }

    public void setBorderType(int n) {
        if (n == 3) {
            this.borderType.setSelectedIndex(4);
        } else if (n == 4) {
            this.borderType.setSelectedIndex(5);
        } else if (n == 5) {
            this.borderType.setSelectedIndex(1);
        } else if (n == 1) {
            this.borderType.setSelectedIndex(2);
        } else if (n == 2) {
            this.borderType.setSelectedIndex(3);
        } else if (n == 6) {
            this.borderType.setSelectedIndex(6);
        } else if (n == 7) {
            this.borderType.setSelectedIndex(7);
        } else {
            this.borderType.setSelectedIndex(0);
        }
    }

    public void setBorderWidth(int n) {
        this.borderWidth.setText(new Integer(n).toString());
    }
}

