/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.RequestTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RequestTable
extends JTable
implements TableCellRenderer {
    private RequestTableModel model;
    private DiscoverPanel parent;
    private Font labelFont = null;
    private Color selectionBackground = this.getSelectionBackground();
    private Color selectionForeground = this.getSelectionForeground();
    private Color labelBackground = Color.white;
    private Color labelForeground = Color.black;
    private JLabel cellLabel = new JLabel(" ");

    public RequestTable(DiscoverPanel discoverPanel, String[] stringArray, boolean[] blArray) throws DiscoverGUIException {
        this.parent = discoverPanel;
        this.model = new RequestTableModel(discoverPanel, stringArray, blArray);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = this.cellLabel;
        if (object instanceof String) {
            jLabel.setText((String)object);
            if (bl) {
                ((Component)jLabel).setBackground(this.selectionBackground);
                ((Component)jLabel).setForeground(this.selectionForeground);
            } else {
                ((Component)jLabel).setBackground(this.labelBackground);
                ((Component)jLabel).setForeground(this.labelForeground);
            }
            if (this.labelFont == null) {
                ((Component)jLabel).setFont(this.getFont());
            } else {
                ((Component)jLabel).setFont(this.labelFont);
            }
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
        } else {
            jLabel.setText(" ");
            jLabel.setOpaque(true);
            ((Component)jLabel).setBackground(this.labelBackground);
            ((Component)jLabel).setForeground(this.labelForeground);
        }
        return jLabel;
    }

    public void init() {
        this.setAutoCreateColumnsFromModel(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setModel(this.model);
        int n = 0;
        while (n < this.model.getColumnCount()) {
            if (this.model.isColumnVisible(n)) {
                TableColumn tableColumn = new TableColumn(n);
                tableColumn.setCellRenderer(this);
                tableColumn.setResizable(false);
                this.addColumn(tableColumn);
            }
            ++n;
        }
        this.selectionBackground = this.getSelectionBackground();
        this.selectionForeground = this.getSelectionForeground();
    }

    public void setLabelBackground(Color color) {
        this.labelBackground = color;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public void setLabelForeground(Color color) {
        this.labelForeground = color;
    }

    public void setRequestList(Vector vector) {
        this.model.setRequestList(vector);
        TableModelEvent tableModelEvent = new TableModelEvent(this.model);
        this.tableChanged(tableModelEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.getSelectedRow();
        if (this.parent == null) {
            return;
        }
        if (n < 0 || n >= this.model.getRealRowCount()) {
            this.parent.informRowSelected(-1);
        } else {
            this.parent.informRowSelected(n);
        }
        this.repaint();
    }
}

