/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.topology;

import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.topology.MoEntityInfo;
import com.sun.symon.tools.migration.util.MuDebug;
import java.util.HashMap;

public class MoLeaf {
    private static final HashMap leafs = new HashMap();
    private long leaf_id;
    private String hostname;
    private String ip_address;
    private Long port;
    private String arch;
    private Long family_type_id;
    private Long licensable;
    private boolean written;

    public MoLeaf() {
    }

    public MoLeaf(MoEntityInfo moEntityInfo) {
        this.leaf_id = moEntityInfo.getEntity_id();
        this.hostname = moEntityInfo.getHostname();
        this.ip_address = moEntityInfo.getIp_address();
        if (moEntityInfo.getUrl() != null && moEntityInfo.getUrl().startsWith("snmp://")) {
            this.port = new Long(MoLeaf.extractPort(moEntityInfo.getUrl()));
        }
        this.arch = moEntityInfo.getArch();
        this.family_type_id = moEntityInfo.getFamily_type_id();
        this.licensable = this.port == null ? new Long(0L) : new Long(100L);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MoLeaf && this.idString().equals(((MoLeaf)object).idString());
    }

    public static final int extractPort(String string) {
        if (string == null) {
            throw new IllegalArgumentException("url is null");
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(58, n + 1);
        int n3 = string.indexOf(47, n2 + 1);
        if (n2 == -1 || n3 == -1) {
            throw new IllegalArgumentException("no port found in url: " + string);
        }
        String string2 = string.substring(n2 + 1, n3);
        return Integer.parseInt(string2);
    }

    public String getArch() {
        return this.arch;
    }

    public Long getFamily_type_id() {
        return this.family_type_id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp_address() {
        return this.ip_address;
    }

    public Long getLicensable() {
        return this.licensable;
    }

    public MdRecord getMdRecord(MdRecord mdRecord) {
        mdRecord.getMdValue("leaf_id").set(this.leaf_id);
        mdRecord.getMdValue("hostname").set(this.hostname);
        mdRecord.getMdValue("ip_address").set(this.ip_address);
        mdRecord.getMdValue("port").set(this.port);
        mdRecord.getMdValue("arch").set(this.arch);
        mdRecord.getMdValue("family_type_id").set(this.family_type_id);
        mdRecord.getMdValue("licensable").set(this.licensable);
        return mdRecord;
    }

    public long getMoLeaf_id() {
        return this.leaf_id;
    }

    public Long getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.idString().hashCode();
    }

    public String idString() {
        return String.valueOf(this.ip_address) + ":" + this.port;
    }

    public MoLeaf intern() {
        MoLeaf moLeaf = (MoLeaf)leafs.get(this);
        if (moLeaf == null) {
            moLeaf = this;
            leafs.put(moLeaf, moLeaf);
        }
        return moLeaf;
    }

    public boolean isWritten() {
        return this.written;
    }

    public static MoLeaf leafFor(MoEntityInfo moEntityInfo) {
        MuDebug.println("\nleafFor: " + moEntityInfo);
        MoLeaf moLeaf = new MoLeaf(moEntityInfo);
        moLeaf = moLeaf.intern();
        return moLeaf;
    }

    public void setArch(String string) {
        this.arch = string;
    }

    public void setFamily_type_id(Long l) {
        this.family_type_id = l;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setIp_address(String string) {
        this.ip_address = string;
    }

    public void setLicensable(Long l) {
        this.licensable = l;
    }

    public void setMoLeaf_id(long l) {
        this.leaf_id = l;
    }

    public void setPort(Long l) {
        this.port = l;
    }

    public void setWritten(boolean bl) {
        this.written = bl;
    }

    public String toString() {
        return this.idString();
    }
}

