/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.xml;

import com.sun.symon.tools.migration.TmMigrationException;
import com.sun.symon.tools.migration.xml.MxNodeHandler;
import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MxNodeRecursor {
    private final Hashtable nodeHandlers = new Hashtable();
    private Node rootNode;
    private String location;
    private final Stack locationStack = new Stack();
    private final MxNodeHandler defaultMxNodeHandler;

    public MxNodeRecursor(Node node, MxNodeHandler mxNodeHandler) {
        if (node == null) {
            throw new IllegalArgumentException("rootNode is null");
        }
        this.rootNode = node;
        this.defaultMxNodeHandler = mxNodeHandler;
        this.location = node.getNodeName().toLowerCase();
    }

    public void bind(String string, MxNodeHandler mxNodeHandler) {
        this.nodeHandlers.put(string.toLowerCase(), mxNodeHandler);
    }

    private void dispatchEvent(String string, Node node) throws TmMigrationException {
        MxNodeHandler mxNodeHandler = this.getHandler(string);
        if (mxNodeHandler != null) {
            mxNodeHandler.handleNode(string, node);
        } else if (this.defaultMxNodeHandler != null) {
            this.defaultMxNodeHandler.handleNode(string, node);
        }
    }

    public MxNodeHandler getDefaultMxNodeHandler() {
        return this.defaultMxNodeHandler;
    }

    protected MxNodeHandler getHandler(String string) {
        return (MxNodeHandler)this.nodeHandlers.get(string);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void recurse() throws TmMigrationException {
        this.dispatchEvent(this.location, this.rootNode);
        this.recurseChildren(this.rootNode.getChildNodes(), 0);
    }

    private void recurseChildren(NodeList nodeList, int n) throws TmMigrationException {
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            String string = node.getNodeName();
            if (!string.startsWith("#")) {
                string = string.toLowerCase();
                this.locationStack.push(this.location);
                this.location = String.valueOf(this.location) + "." + string;
                this.dispatchEvent(this.location, node);
                this.recurseChildren(node.getChildNodes(), n + 1);
                this.location = (String)this.locationStack.pop();
            }
            ++n2;
        }
    }

    public void unbind(String string) {
        this.nodeHandlers.remove(string);
    }
}

