/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.beans;

import com.sun.symon.base.beans.BcPod;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.xobject.XObjectBase;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BcShell
extends XObjectBase {
    private static Hashtable commands;
    private XObjectBase current;
    protected InputStream in = System.in;
    protected PrintWriter out = new PrintWriter(System.out, true);
    protected PrintWriter err = new PrintWriter(System.err, true);
    private static Object lock;
    static /* synthetic */ Class class$com$sun$symon$base$beans$BcShell;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$sun$symon$base$beans$BcPod;

    static {
        lock = new Object();
        commands = new Hashtable();
        BcShell.addCommands();
    }

    public BcShell() {
    }

    public BcShell(XObjectBase xObjectBase) {
        super(xObjectBase, "_shell", null);
    }

    public void activate() {
        Thread thread = new Thread("BcShell"){

            public void run() {
                BcShell.this.runCmdLoop();
            }
        };
        thread.setPriority(4);
        thread.start();
    }

    public static void addCommand(String string, Handler handler) {
        Object object = lock;
        synchronized (object) {
            if (commands.get(string) != null) {
                UcDDL.logWarningMessage("Command '" + string + "' already exists");
            }
            commands.put(string, handler);
        }
    }

    private static void addCommands() {
        BcShell.addCommand("ls", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.ls(stringArray);
            }
        });
        BcShell.addCommand("cd", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.cd(stringArray);
            }
        });
        BcShell.addCommand("dump", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.dump(stringArray);
            }
        });
        BcShell.addCommand("threads", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.threads(stringArray);
            }
        });
        BcShell.addCommand("memory", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.memory(stringArray);
            }
        });
        BcShell.addCommand("trace", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.trace(stringArray);
            }
        });
        BcShell.addCommand("recycle", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.recycle(stringArray);
            }
        });
        BcShell.addCommand("finalize", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.doFinalize(stringArray);
            }
        });
        BcShell.addCommand("help", new Handler(){

            public void process(BcShell bcShell, String[] stringArray) {
                bcShell.help(stringArray);
            }
        });
        Handler handler = new Handler(){

            public void process(BcShell bcShell, String[] stringArray) throws IOException {
                bcShell.exit(stringArray);
            }
        };
        BcShell.addCommand("exit", handler);
        BcShell.addCommand("quit", handler);
    }

    private void cd(String[] stringArray) {
        if (stringArray.length < 1) {
            this.err.println("usage: cd <node>");
            return;
        }
        String string = stringArray[0];
        XObjectBase xObjectBase = string.equals(".") ? this.root() : (string.equals("..") ? this.current.superior() : this.current.locate(string, true, null, null));
        if (xObjectBase == null) {
            this.err.println("'" + string + "' not found");
        } else {
            this.current = xObjectBase;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void doFinalize(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        runtime.runFinalization();
    }

    private void dump(String[] stringArray) {
        Vector vector;
        Object object;
        Object object2;
        Vector vector2;
        this.out.println("name: " + this.current.fullName());
        if (this.current.superior() != null) {
            this.out.println("superior: " + this.current.superior().name());
        }
        if ((vector2 = this.current.inferiors()) != null) {
            object2 = "inferiors:";
            int n = 0;
            while (n < vector2.size()) {
                XObjectBase xObjectBase = (XObjectBase)vector2.elementAt(n);
                object2 = String.valueOf(object2) + " " + xObjectBase.name();
                ++n;
            }
            this.out.println((String)object2);
        }
        if ((object2 = this.current.parents()) != null) {
            String string = "parents:";
            int n = 0;
            while (n < ((Vector)object2).size()) {
                object = (XObjectBase)((Vector)object2).elementAt(n);
                string = String.valueOf(string) + " " + ((XObjectBase)object).fullName();
                ++n;
            }
            this.out.println(string);
        }
        if ((vector = this.current.slices()) != null) {
            this.out.println("data:");
            int n = 0;
            while (n < vector.size()) {
                object = (String)vector.elementAt(n);
                Vector vector3 = this.current.keys((String)object);
                int n2 = 0;
                while (n2 < vector3.size()) {
                    String string = (String)vector3.elementAt(n2);
                    this.out.println("  " + (String)object + ":" + string + " = " + this.current.ilookup((String)object, string, null));
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void exit(String[] stringArray) throws IOException {
        this.out.print("This will cause the server to exit.  Continue? (y/n) ");
        this.out.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        String string = bufferedReader.readLine();
        if (string.equals("y") || string.equals("Y")) {
            System.exit(0);
        }
        this.out.println("cancelled");
    }

    public final PrintWriter getErr() {
        return this.err;
    }

    public final InputStream getIn() {
        return this.in;
    }

    public final PrintWriter getOut() {
        return this.out;
    }

    private void help(String[] stringArray) {
        Object object = lock;
        synchronized (object) {
            this.out.print("available commands:");
            Enumeration enumeration = commands.keys();
            while (enumeration.hasMoreElements()) {
                this.out.print(" " + enumeration.nextElement());
            }
            this.out.println("");
        }
    }

    private String listThreads(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            return "";
        }
        int n = threadGroup.activeCount();
        int n2 = threadGroup.activeGroupCount();
        Thread[] threadArray = new Thread[n];
        ThreadGroup[] threadGroupArray = new ThreadGroup[n2];
        n = threadGroup.enumerate(threadArray, false);
        n2 = threadGroup.enumerate(threadGroupArray, false);
        String string2 = String.valueOf(string) + "group: " + threadGroup.getName() + ", priority = " + threadGroup.getMaxPriority();
        int n3 = 0;
        while (n3 < n) {
            string2 = String.valueOf(string2) + "\n" + string + "    thread: " + threadArray[n3].getName() + ", priority = " + threadArray[n3].getPriority();
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            string2 = String.valueOf(string2) + "\n" + this.listThreads(threadGroupArray[n4], "    ");
            ++n4;
        }
        return string2;
    }

    private void ls(String[] stringArray) {
        Vector vector = this.current.inferiors();
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < vector.size()) {
            XObjectBase xObjectBase = (XObjectBase)vector.elementAt(n);
            stringBuffer.append(String.valueOf(xObjectBase.name()) + " ");
            ++n;
        }
        this.out.println(stringBuffer.toString());
    }

    private void memory(String[] stringArray) {
        String string = "usage: memory [total|free]";
        if (stringArray.length < 1) {
            this.err.println(string);
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        if (stringArray[0].equals("total")) {
            this.out.println(runtime.totalMemory() + " bytes");
        } else if (stringArray[0].equals("free")) {
            this.out.println(runtime.freeMemory() + " bytes");
        } else {
            this.err.println(string);
            return;
        }
    }

    public void processCommand(Object object, String string, String[] stringArray) throws Exception {
        try {
            Method method = object.getClass().getMethod(string, class$com$sun$symon$base$beans$BcShell != null ? class$com$sun$symon$base$beans$BcShell : (class$com$sun$symon$base$beans$BcShell = BcShell.class$("com.sun.symon.base.beans.BcShell")), array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = BcShell.class$("[Ljava.lang.String;")));
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            method.invoke(object, this, stringArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (object.getClass().isAssignableFrom(class$com$sun$symon$base$beans$BcPod != null ? class$com$sun$symon$base$beans$BcPod : (class$com$sun$symon$base$beans$BcPod = BcShell.class$("com.sun.symon.base.beans.BcPod")))) {
                this.processCommand(((BcPod)object).getBean(), string, stringArray);
            } else {
                this.err.println("method '" + string + "' not found");
            }
            return;
        }
    }

    public void processCommand(String string) throws Exception {
        this.processCommand(string, null);
    }

    public void processCommand(String string, String[] stringArray) throws Exception {
        Handler handler;
        Object object = lock;
        synchronized (object) {
            handler = (Handler)commands.get(string);
        }
        if (handler == null) {
            this.processCommand(this.current, string, stringArray);
        } else {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            handler.process(this, stringArray);
        }
    }

    public void processLine(String string) throws Exception {
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList(string, vector)) {
            this.err.println("can't parse line '" + string + "'");
            return;
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        String string2 = (String)vector.elementAt(0);
        String[] stringArray = new String[n - 1];
        if (n > 1) {
            int n2 = 1;
            while (n2 < n) {
                stringArray[n2 - 1] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        this.processCommand(string2, stringArray);
    }

    private void recycle(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
    }

    protected void runCmdLoop() {
        this.current = this.root();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        while (true) {
            this.out.print(String.valueOf(this.current.fullName()) + "> ");
            this.out.flush();
            try {
                String string = bufferedReader.readLine();
                if (string == null) break;
                this.processLine(string);
                continue;
            }
            catch (EOFException eOFException) {
            }
            catch (Throwable throwable) {
                this.err.println("exception: " + throwable);
                throwable.printStackTrace(this.err);
                continue;
            }
            break;
        }
        this.err.println("goodbye!");
    }

    private void threads(String[] stringArray) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup2.getParent();
        }
        this.out.println(this.listThreads(threadGroup, ""));
    }

    private void trace(String[] stringArray) {
        String string = "usage: trace [instructions|methods] [on|off]";
        if (stringArray.length < 2) {
            this.err.println(string);
            return;
        }
        boolean bl = false;
        if (stringArray[1].equals("on")) {
            bl = true;
        } else if (stringArray[1].equals("off")) {
            bl = false;
        } else {
            this.err.println(string);
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        if (stringArray[0].equals("instructions")) {
            runtime.traceInstructions(bl);
        } else if (stringArray[0].equals("methods")) {
            runtime.traceMethodCalls(bl);
        } else {
            this.err.println(string);
            return;
        }
    }

    public static interface Handler {
        public void process(BcShell var1, String[] var2) throws Exception;
    }
}

