/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.beans;

import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcListUtil;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BcTreeNode
extends DefaultMutableTreeNode {
    private static Hashtable commands;
    protected static InputStream in;
    protected static PrintWriter out;
    protected static PrintWriter err;
    private static Object lock;
    private static BcTreeNode current;
    protected static BcTreeNode root;
    protected static boolean isDebugOn;
    private Object bean = null;
    static /* synthetic */ Class class$com$sun$symon$base$beans$BcTreeNode;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    static {
        in = System.in;
        out = new PrintWriter(System.out, true);
        err = new PrintWriter(System.err, true);
        lock = new Object();
        isDebugOn = false;
        commands = new Hashtable();
        BcTreeNode.addCommands();
    }

    public BcTreeNode() {
    }

    public BcTreeNode(String string, Object object) {
        super(string);
        this.bean = object;
    }

    public void activate() {
        Thread thread = new Thread("BcShell"){

            public void run() {
                BcTreeNode.this.runCmdLoop();
            }
        };
        thread.setPriority(4);
        thread.start();
    }

    public static void addCommand(String string, Handler handler) {
        Object object = lock;
        synchronized (object) {
            if (commands.get(string) != null) {
                UcDDL.logWarningMessage("Command '" + string + "' already exists");
            }
            commands.put(string, handler);
        }
    }

    private static void addCommands() {
        BcTreeNode.addCommand("ls", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.ls(stringArray);
            }
        });
        BcTreeNode.addCommand("cd", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.cd(stringArray);
            }
        });
        BcTreeNode.addCommand("methods", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.methods(stringArray);
            }
        });
        BcTreeNode.addCommand("dump", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.dump(stringArray);
            }
        });
        BcTreeNode.addCommand("threads", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.threads(stringArray);
            }
        });
        BcTreeNode.addCommand("memory", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.memory(stringArray);
            }
        });
        BcTreeNode.addCommand("trace", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.trace(stringArray);
            }
        });
        BcTreeNode.addCommand("recycle", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.recycle(stringArray);
            }
        });
        BcTreeNode.addCommand("finalize", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.doFinalize(stringArray);
            }
        });
        BcTreeNode.addCommand("help", new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) {
                bcTreeNode.help(stringArray);
            }
        });
        Handler handler = new Handler(){

            public void process(BcTreeNode bcTreeNode, String[] stringArray) throws IOException {
                bcTreeNode.exit(stringArray);
            }
        };
        BcTreeNode.addCommand("exit", handler);
        BcTreeNode.addCommand("quit", handler);
    }

    private void cd(String[] stringArray) {
        BcTreeNode bcTreeNode = null;
        if (stringArray.length < 1) {
            err.println("usage: cd <node>");
            return;
        }
        String string = stringArray[0];
        if (string.equals(".")) {
            bcTreeNode = current;
        } else if (string.equals("..")) {
            if (bcTreeNode != root) {
                bcTreeNode = (BcTreeNode)current.getParent();
            }
        } else {
            int n = current.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                BcTreeNode bcTreeNode2 = (BcTreeNode)current.getChildAt(n2);
                if (bcTreeNode2.fullName().equals(string)) {
                    bcTreeNode = bcTreeNode2;
                    break;
                }
                ++n2;
            }
        }
        if (bcTreeNode == null) {
            err.println("'" + string + "' not found");
        } else {
            current = bcTreeNode;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void doFinalize(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        runtime.runFinalization();
    }

    private void dump(String[] stringArray) {
        out.println("name: " + current.fullName());
    }

    private void exit(String[] stringArray) throws IOException {
        out.print("This will cause the server to exit.  Continue? (y/n) ");
        out.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        String string = bufferedReader.readLine();
        if (string.equals("y") || string.equals("Y")) {
            System.exit(0);
        }
        out.println("cancelled");
    }

    private String fullName() {
        return this.toString();
    }

    public Object getBean() {
        return this.bean;
    }

    public final PrintWriter getErr() {
        return err;
    }

    public final InputStream getIn() {
        return in;
    }

    public final PrintWriter getOut() {
        return out;
    }

    public static BcTreeNode getRootNode() {
        return root;
    }

    private void help(String[] stringArray) {
        Object object = lock;
        synchronized (object) {
            out.print("available commands:");
            Enumeration enumeration = commands.keys();
            while (enumeration.hasMoreElements()) {
                out.print(" " + enumeration.nextElement());
            }
            out.println("");
        }
    }

    public static boolean isDebugOn() {
        return isDebugOn;
    }

    private String listThreads(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            return "";
        }
        int n = threadGroup.activeCount();
        int n2 = threadGroup.activeGroupCount();
        Thread[] threadArray = new Thread[n];
        ThreadGroup[] threadGroupArray = new ThreadGroup[n2];
        n = threadGroup.enumerate(threadArray, false);
        n2 = threadGroup.enumerate(threadGroupArray, false);
        String string2 = String.valueOf(string) + "group: " + threadGroup.getName() + ", priority = " + threadGroup.getMaxPriority();
        int n3 = 0;
        while (n3 < n) {
            string2 = String.valueOf(string2) + "\n" + string + "    thread: " + threadArray[n3].getName() + ", priority = " + threadArray[n3].getPriority();
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            string2 = String.valueOf(string2) + "\n" + this.listThreads(threadGroupArray[n4], "    ");
            ++n4;
        }
        return string2;
    }

    private void ls(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        Enumeration<TreeNode> enumeration = current.children();
        while (enumeration.hasMoreElements()) {
            BcTreeNode bcTreeNode = (BcTreeNode)enumeration.nextElement();
            stringBuffer.append(String.valueOf(bcTreeNode.toString()) + " ");
        }
        out.println(stringBuffer.toString());
    }

    private void memory(String[] stringArray) {
        String string = "usage: memory [total|free]";
        if (stringArray.length < 1) {
            err.println(string);
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        if (stringArray[0].equals("total")) {
            out.println(runtime.totalMemory() + " bytes");
        } else if (stringArray[0].equals("free")) {
            out.println(runtime.freeMemory() + " bytes");
        } else {
            err.println(string);
            return;
        }
    }

    private void methods(String[] stringArray) {
        String string = "usage: methods [standard|specific]";
        if (stringArray.length < 1) {
            err.println(string);
            return;
        }
        if (stringArray[0].equals("standard")) {
            out.println("Standard methods: memory | ls | cd | dump ");
        } else if (stringArray[0].equals("specific")) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            stringBuffer.append("Specific methods:");
            try {
                Class<?> clazz = current.getBean().getClass();
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (n < methodArray.length) {
                    Class<?>[] classArray = methodArray[n].getParameterTypes();
                    if (classArray != null && (classArray.length == 1 || classArray.length == 2) && classArray[0].equals(class$com$sun$symon$base$beans$BcTreeNode != null ? class$com$sun$symon$base$beans$BcTreeNode : BcTreeNode.class$("com.sun.symon.base.beans.BcTreeNode"))) {
                        if (classArray.length == 1) {
                            if (bl) {
                                bl = false;
                            } else {
                                stringBuffer.append(" | ");
                            }
                            stringBuffer.append(methodArray[n].getName());
                        } else if (classArray.length == 2 && classArray[1].isArray() && classArray[1].getComponentType().equals(class$java$lang$String != null ? class$java$lang$String : BcTreeNode.class$("java.lang.String"))) {
                            if (bl) {
                                bl = false;
                            } else {
                                stringBuffer.append(" | ");
                            }
                            stringBuffer.append(methodArray[n].getName());
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            out.println(stringBuffer.toString());
        } else {
            err.println(string);
            return;
        }
    }

    public void processCommand(Object object, String string, String[] stringArray) throws Exception {
        try {
            Method method = object.getClass().getMethod(string, class$com$sun$symon$base$beans$BcTreeNode != null ? class$com$sun$symon$base$beans$BcTreeNode : (class$com$sun$symon$base$beans$BcTreeNode = BcTreeNode.class$("com.sun.symon.base.beans.BcTreeNode")), array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = BcTreeNode.class$("[Ljava.lang.String;")));
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            method.invoke(object, this, stringArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (object instanceof BcTreeNode) {
                BcTreeNode bcTreeNode = (BcTreeNode)object;
                if (bcTreeNode.getBean() != null) {
                    this.processCommand(bcTreeNode.getBean(), string, stringArray);
                } else {
                    err.println("method '" + string + "' not found");
                }
            } else {
                err.println("method '" + string + "' not found");
            }
            return;
        }
    }

    public void processCommand(String string) throws Exception {
        this.processCommand(string, null);
    }

    public void processCommand(String string, String[] stringArray) throws Exception {
        Handler handler;
        Object object = lock;
        synchronized (object) {
            handler = (Handler)commands.get(string);
        }
        if (handler == null) {
            this.processCommand(current, string, stringArray);
        } else {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            handler.process(this, stringArray);
        }
    }

    public void processLine(String string) throws Exception {
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList(string, vector)) {
            err.println("can't parse line '" + string + "'");
            return;
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        String string2 = (String)vector.elementAt(0);
        String[] stringArray = new String[n - 1];
        if (n > 1) {
            int n2 = 1;
            while (n2 < n) {
                stringArray[n2 - 1] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        this.processCommand(string2, stringArray);
    }

    private void recycle(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
    }

    protected void runCmdLoop() {
        current = this;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        while (true) {
            out.print(String.valueOf(current.fullName()) + "> ");
            out.flush();
            try {
                String string = bufferedReader.readLine();
                if (string == null) break;
                this.processLine(string);
                continue;
            }
            catch (EOFException eOFException) {
            }
            catch (Throwable throwable) {
                err.println("exception: " + throwable);
                throwable.printStackTrace(err);
                continue;
            }
            break;
        }
        err.println("goodbye!");
    }

    private void threads(String[] stringArray) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup2.getParent();
        }
        out.println(this.listThreads(threadGroup, ""));
    }

    private void trace(String[] stringArray) {
        String string = "usage: trace [instructions|methods] [on|off]";
        if (stringArray.length < 2) {
            err.println(string);
            return;
        }
        boolean bl = false;
        if (stringArray[1].equals("on")) {
            bl = true;
        } else if (stringArray[1].equals("off")) {
            bl = false;
        } else {
            err.println(string);
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        if (stringArray[0].equals("instructions")) {
            runtime.traceInstructions(bl);
        } else if (stringArray[0].equals("methods")) {
            runtime.traceMethodCalls(bl);
        } else {
            err.println(string);
            return;
        }
    }

    public static interface Handler {
        public void process(BcTreeNode var1, String[] var2) throws Exception;
    }
}

