/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.utility;

import com.sun.symon.base.utility.UcDDL;
import java.util.Date;

public abstract class UcTicker {
    private UcTicker Prev;
    private UcTicker Next;
    private long TimeToFire;
    private boolean InQueue = false;
    private boolean Running = false;
    private int Count;
    private static int Num = 0;
    private static UcTicker Head = null;
    private static Thread TickerThread = null;
    private static final boolean DO_CHECKING = true;
    private static final boolean DO_LOGGING = false;
    private static Object lock = new Object();

    protected UcTicker() {
        this.log("created");
    }

    private void addAlarm(long l) {
        UcTicker ucTicker = Head;
        UcTicker ucTicker2 = null;
        this.TimeToFire = l;
        this.log("adding " + this.TimeToFire);
        while (ucTicker != null) {
            if (this.TimeToFire <= ucTicker.TimeToFire) break;
            ucTicker2 = ucTicker;
            ucTicker = ucTicker.Next;
        }
        this.log("add done");
        this.Next = ucTicker;
        this.Prev = ucTicker2;
        if (this.Next != null) {
            this.Next.Prev = this;
        }
        if (this.Prev == null) {
            this.setHead(this);
        } else {
            this.Prev.Next = this;
        }
        this.log("add really done");
    }

    protected abstract long calcNextAlarm();

    private static void checkList() {
        Object object = lock;
        synchronized (object) {
            UcTicker ucTicker = Head;
            UcTicker ucTicker2 = null;
            int n = 0;
            while (ucTicker != null) {
                if (n++ > 1000) {
                    UcDDL.logErrorMessage("infinite loop", new Throwable());
                    System.exit(0);
                }
                if (ucTicker.Next != null && ucTicker.Next.Prev != ucTicker) {
                    UcDDL.logErrorMessage("ERROR Next.Prev != ticker (" + n + ")", new Throwable());
                    System.exit(0);
                }
                if (ucTicker.Prev != ucTicker2) {
                    UcDDL.logErrorMessage("ERROR ticker.Prev != prev (" + n + ")", new Throwable());
                    System.exit(0);
                }
                if (ucTicker2 != null && ucTicker2.TimeToFire > ucTicker.TimeToFire) {
                    UcDDL.logErrorMessage("ERROR bad order (" + n + ")", new Throwable());
                    System.exit(0);
                }
                ucTicker2 = ucTicker;
                ucTicker = ucTicker.Next;
            }
        }
    }

    private static void dumpQueue(String string) {
        Object object = lock;
        synchronized (object) {
            UcTicker.checkList();
        }
    }

    private void handleAlarm() {
        boolean bl;
        this.log("handleAlarm enter");
        UcTicker.checkList();
        this.processTick();
        Object object = lock;
        synchronized (object) {
            bl = this.Running && !this.InQueue ? this.setupNextAlarm() : false;
        }
        if (bl) {
            this.processTickEnd();
        }
        UcTicker.checkList();
        this.log("handleAlarm exit");
    }

    private void log(String string) {
    }

    private static void logStatic(String string) {
    }

    protected abstract void processTick();

    protected abstract void processTickEnd();

    private void removeAlarm() {
        if (this.Next != null) {
            this.Next.Prev = this.Prev;
        }
        if (this.Prev == null) {
            this.setHead(this.Next);
        } else {
            this.Prev.Next = this.Next;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runThread() {
        UcDDL.logInfoMessage("ticker thread created");
        while (true) {
            Object object;
            UcTicker ucTicker;
            Object object2;
            block15: {
                object2 = lock;
                synchronized (object2) {
                    Object var5_4;
                    block14: {
                        block13: {
                            block12: {
                                UcTicker.checkList();
                                if (Head == null) {
                                    TickerThread = null;
                                    UcDDL.logInfoMessage("ticker thread exiting");
                                    return;
                                }
                                long l = UcTicker.Head.TimeToFire - new Date().getTime();
                                UcTicker.logStatic("sleeping for " + l + " ms");
                                if (l > 0L) {
                                    try {
                                        UcTicker ucTicker2 = Head;
                                        UcTicker.dumpQueue("before wait");
                                        lock.wait(l);
                                        UcTicker.dumpQueue("after wait");
                                        if (ucTicker2 == Head) break block12;
                                        UcTicker.logStatic("continue1");
                                        break block13;
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            UcTicker.checkList();
                            ucTicker = Head;
                            long l = new Date().getTime();
                            object = ucTicker;
                            while (object != null && ((UcTicker)object).TimeToFire <= l) {
                                ((UcTicker)object).InQueue = false;
                                object = ((UcTicker)object).Next;
                            }
                            if (object == ucTicker) {
                                UcTicker.logStatic("continue2");
                                break block14;
                            }
                            if (object != null) {
                                ((UcTicker)object).Prev.Next = null;
                                ((UcTicker)object).Prev = null;
                            }
                            Head = object;
                            UcTicker.checkList();
                            UcTicker.logStatic("about to release lock");
                            break block15;
                        }
                        var5_4 = null;
                        continue;
                    }
                    var5_4 = null;
                    continue;
                }
            }
            UcTicker.checkList();
            object = ucTicker;
            do {
                object2 = ((UcTicker)object).Next;
                UcTicker.checkList();
                ((UcTicker)object).handleAlarm();
                UcTicker.checkList();
            } while ((object = object2) != null);
            UcTicker.checkList();
        }
    }

    private void setHead(UcTicker ucTicker) {
        Head = ucTicker;
        if (TickerThread == null) {
            TickerThread = new Thread("UcTicker"){

                public void run() {
                    UcTicker.runThread();
                }
            };
            TickerThread.start();
        } else {
            lock.notify();
        }
    }

    private boolean setupNextAlarm() {
        boolean bl;
        UcTicker.dumpQueue("setupNextAlarm before");
        long l = this.calcNextAlarm();
        if (l == 0L) {
            this.Running = false;
            this.InQueue = false;
            bl = true;
        } else {
            this.Running = true;
            this.InQueue = true;
            this.addAlarm(l);
            bl = false;
        }
        UcTicker.dumpQueue("setupNextAlarm after");
        return bl;
    }

    public boolean start() {
        boolean bl;
        boolean bl2;
        this.log("start enter");
        UcTicker.checkList();
        Object object = lock;
        synchronized (object) {
            if (this.Running) {
                bl2 = false;
                bl = false;
            } else {
                bl2 = this.setupNextAlarm();
                bl = true;
            }
        }
        if (bl2) {
            this.processTickEnd();
        }
        UcTicker.checkList();
        this.log("start exit");
        return bl;
    }

    public void stop() {
        Object object = lock;
        synchronized (object) {
            this.log("stop enter");
            UcTicker.checkList();
            if (this.InQueue) {
                UcTicker.dumpQueue("stop before");
                this.removeAlarm();
                UcTicker.dumpQueue("stop after");
                this.InQueue = false;
            }
            this.Running = false;
            UcTicker.checkList();
            this.log("stop exit");
        }
    }
}

