#!/bin/sh
#
# @(#)mcp_publish.sh	1.12 02/12/18
# Copyright (c) 12/18/02 Sun Microsystems, Inc. All Rights Reserved.
#

setup_safe_tmp_dir() {
	# determine architecture

	MACH=`uname -m`
	SYS=`uname -s`
	REL=`uname -r`
	VER=`uname -v`
	case "$MACH:$SYS:$REL:$VER" in
    	i86pc*:SunOS:5.*:*)
        	REL="`echo ${REL} | sed 's/^5/2/' | cut -d\. -f1,2`"
			ARCH="i386-sun-solaris${REL}" ;;
		sun4*:SunOS:5.*:*)
			REL="`echo ${REL} | sed 's/^5/2/' | cut -d\. -f1,2`"
			ARCH="sparc-sun-solaris${REL}" ;;
		sun4*:SunOS:*:*)
			REL="`echo ${REL} | cut -d\. -f1,2`"
			ARCH="sparc-sun-sunos${REL}" ;;
	esac

	if [ ! -x  $ESROOT/util/bin/$ARCH/uclock ]
	then
		/usr/bin/gettext "ERROR: Could not find uclock in $ESROOT/util/bin/$ARCH"
		exit 1
	fi

    timestamp=`$ESROOT/util/bin/$ARCH/uclock`
    safedir="${TMPDIR:-/tmp}/sunmclog-${timestamp}-$$"

    if [ ! -d "$safedir" ]; then
	/usr/bin/mkdir -m 700 $safedir
	if [ $? != 0 ]; then
	    /usr/bin/gettext "ERROR: Unable to make temporary directory $safedir\n"
	    exit 1
	fi
	TMP_LOG_DIR="$safedir"
    else
	/usr/bin/gettext "ERROR: Unable to use $safedir due to possible security issues.\n"
	exit 2
    fi
}

LOCAL_BASE=`expr "$INTERFACE_PATH" : '\([^:]*\)'`
LOCAL_BASE=`dirname $LOCAL_BASE`

setup_safe_tmp_dir

PRODUCT_BASE=$ESROOT
LOGFILE="$TMP_LOG_DIR/"`basename $0`.$$.log
PUT=es-mcp-put

#
# initialize the log file
#
echo $0 called at `date` with args: $* >$LOGFILE

echo "ESROOT=$ESROOT" >> $LOGFILE
echo "INTERFACE_PATH=$INTERFACE_PATH" >> $LOGFILE
echo "LOCAL_BASE=$LOCAL_BASE" >> $LOGFILE

#
# create new base dir
#
mkdir -p "$TMP_LOG_DIR/cfg"

# Module parameters
FILE_MODULE_PARAMS="cfg/base-modules-d.dat"
echo "FILE_MODULE_PARAMS=$FILE_MODULE_PARAMS" >> $LOGFILE
touch "$TMP_LOG_DIR/${FILE_MODULE_PARAMS}.MCP"

#
# check expanded argument list
#
if [ $# -ne 1 ]
then
    echo "Usage: $0 id,url,parcel,module[+instance],module[+instance]..." >&2
    exit 1
fi

#
# expand first argument into its components
#
OLDIFS=$IFS
IFS=,
set $1
IFS=$OLDIFS

#
# check expanded argument list
#
if [ $# -lt 4 ]
then
    echo "Usage: $0 id,url,parcel,module[+instance],module[+instance]..." >&2
    exit 1
fi

ID=$1
URL=$2
PARCEL=$3
shift 3
MODULES=$*

#
# DAT publishing filter
#
filterDatFile () {
    #
    # remove all alarm acknowledgements
    #
#    grep -v "^value:" $1 |  grep -v value:ackName
    grep -v value:ackName $1
}

#
# get or create relevant files
#
FILES=""
echo "" >>$LOGFILE
for MODULE
do
    echo "module: $MODULE" >>$LOGFILE

    #
    # find "dat" files associated with module
    #
    FILE="cfg/$MODULE.dat"
    echo "  modfile: $FILE LOCAL_BASE $LOCAL_BASE" >>$LOGFILE
    if [ ! -f "$LOCAL_BASE/$FILE"  ] ; then # Skip if dat file doesn't exist
	continue
    fi

    # Save module parameters
    module_params=`/usr/bin/grep "^$MODULE" "$LOCAL_BASE/$FILE_MODULE_PARAMS"`
    if [ "$module_params" != "" ] ; then
	echo "$module_params" >>"$TMP_LOG_DIR/${FILE_MODULE_PARAMS}.MCP"
    fi

    #
    # determine destination file name and directory
    #
    NEWFILE=$FILE.MCP
    NEWNAME=`basename $NEWFILE`

    mkdir -p `dirname $TMP_LOG_DIR/$NEWFILE`

    echo "  file: $FILE -> $NEWFILE" >>$LOGFILE

    #
    # create header for MCP content
    #
    echo "        adding filtered contents of $FILE" >>$LOGFILE
    echo "" >$TMP_LOG_DIR/$NEWFILE
    echo "#" >>$TMP_LOG_DIR/$NEWFILE
    echo "# The following content was added by the MCP system" >>$TMP_LOG_DIR/$NEWFILE
    echo "#" >>$TMP_LOG_DIR/$NEWFILE
    echo "" >>$TMP_LOG_DIR/$NEWFILE

    #
    # tack on filtered dat file
    #
    filterDatFile $LOCAL_BASE/$FILE >> $TMP_LOG_DIR/$NEWFILE

    FILES="$FILES $NEWFILE"
    echo "" >>$LOGFILE
done

# Also upload module parameters
FILES="$FILES $FILE_MODULE_PARAMS.MCP"

echo target files: $FILES >>$LOGFILE
echo "" >>$LOGFILE

#
# perform the put
#
if [ -n "$FILES" ]
then
#    MODULES=`echo "$MODULES" | /usr/bin/sed -e "s/+/%2B/g"` # Convert + for HTTP
    
    #
    # log command
    #
    echo running: $PUT $ID $URL $TMP_LOG_DIR \"$PARCEL $MODULES\" $FILES >>$LOGFILE

    #
    # execute command
    #
    eval $PUT $ID $URL $TMP_LOG_DIR \"$PARCEL $MODULES\" $FILES >>$LOGFILE 2>&1

    STATUS=$?

    #
    # check status
    #
    if [ $STATUS -ne 0 ]
    then
        #
        # failure - log error and exit, leaving log file for perusal
        #
        echo "" >>$LOGFILE
        echo "error: $PUT failed - see $LOGFILE for details" >>$LOGFILE
        echo "result: failure" >>$LOGFILE
        echo "failure"
        exit 2
    fi
else
    echo "" >>$LOGFILE
    echo "error: no files found for publish operation" >>$LOGFILE
    echo "failure"
    exit 3
fi

#
# success - clean up log file and exit
#
rm -rf $TMP_LOG_DIR
echo "success"
exit 0
