# cus_net_server.mk - "make" command file to reload Connection
# Manager executables
# 
#
#
# NOTE:         ORACLE_HOME must be either:
#               . set in the user's environment
#               . passed in on the command line
#               . defined in a modified version of this makefile


include  $(ORACLE_HOME)/network/lib/env_network.mk

RDBMSHOME = $(ORACLE_HOME)/rdbms/
RDBMSLIB  = $(ORACLE_HOME)/rdbms/lib/
RDBMSBIN  = $(ORACLE_HOME)/rdbms/bin/
LDFLAGS   = -L$(LIBHOME) -L$(ORACLE_HOME)/rdbms/lib  -L$(ORACLE_HOME)/network/lib
LDCCOM    = $(LINK) $(LDFLAGS) $(EXOSFLAGS) -o $@
ECHO      = $(ORACLE_HOME)/bin/echodo


INSTALL_TARGS=clean icmctl icmadmin icmgw

cmctl: $(S0NFPC) $(LIBNFP)
	$(ECHODO) $(LDCCOM) $(S0NFPC) $(LLIBNFP) \
           $(TTLIBS) $(LOCALNETLIBS) $(LINKEXSYSLIBS)

icmctl: cmctl
	-mv -f $(ORACLE_HOME)/bin/cmctl $(ORACLE_HOME)/bin/cmctl0
	-mv cmctl $(ORACLE_HOME)/bin/cmctl
	-chmod 751 $(ORACLE_HOME)/bin/cmctl


cmadmin: $(S0NFPA) $(LIBNFP)
	$(ECHODO) $(LDCCOM) $(S0NFPA) $(LLIBNFP) \
           $(TTLIBS) $(LOCALNETLIBS) $(LINKEXSYSLIBS)


icmadmin: cmadmin
	-mv -f $(ORACLE_HOME)/bin/cmadmin $(ORACLE_HOME)/bin/cmadmin0
	-mv cmadmin $(ORACLE_HOME)/bin/cmadmin
	-chmod 751 $(ORACLE_HOME)/bin/cmadmin

cmgw: $(S0NFPGW) $(LIBNFP)
	$(ECHODO) $(LDCCOM) $(S0NFPGW) $(LLIBNFP) \
           $(TTLIBS) $(LOCALNETLIBS) $(LINKEXSYSLIBS)

icmgw: cmgw
	-mv -f $(ORACLE_HOME)/bin/cmgw $(ORACLE_HOME)/bin/cmgw0
	-mv cmgw $(ORACLE_HOME)/bin/cmgw
	-chmod 751 $(ORACLE_HOME)/bin/cmgw


preinstall:
	-chmod 755 $(ORACLE_HOME)/bin

install: preinstall $(INSTALL_TARGS)

clean:
