/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_SENDFILE_H
#define	_SYS_SENDFILE_H

#pragma ident	"@(#)sendfile.h	1.1	01/03/12 SMI"

#include <sys/feature_tests.h>

#ifdef	__cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <sys/uio.h>

/*
 * Structure used by sendfilev()
 */
typedef struct sendfilevec {
	int		sfv_fd;
	uint_t		sfv_flag;
	off_t		sfv_off;
	size_t		sfv_len;
} sendfilevec_t;

#if	defined(_LARGEFILE64_SOURCE)
/*
 * For 32-bit apps accessing largefile offsets
 * using sendfilev64.
 */
typedef struct sendfilevec64 {
	int		sfv_fd;
	uint_t		sfv_flag;
	off64_t		sfv_off;
	size_t		sfv_len;
} sendfilevec64_t;
#endif /* _LARGEFILE64_SOURCE */

#if	defined(_SYSCALL32)
/*
 * For 32-bit app on a 64-bit kernel to copyin the data.
 */
typedef struct ksendfilevec32 {
	int		sfv_fd;
	uint_t		sfv_flag;
	off32_t		sfv_off;
	size32_t	sfv_len;
} ksendfilevec32_t;

/*
 * For 32-bit app on a 64-bit kernel in largefile environment
 * (sendfilev64) to copyin data.
 */
typedef struct ksendfilevec64 {
	int		sfv_fd;
	uint_t		sfv_flag;
	off64_t		sfv_off;
	size32_t	sfv_len;
} ksendfilevec64_t;
#endif /* _SYSCALL32 */


/* The sfv_fd can be a file descriptor or self proc */
#define	SFV_FD_SELF	(-2)

/* System call subcodes */
#define	SENDFILEV	0
#define	SENDFILEV64	1

#ifndef	_KERNEL
/* large file compilation environment setup */
#if !defined(_LP64) && _FILE_OFFSET_BITS == 64
#ifdef	__PRAGMA_REDEFINE_EXTNAME
#pragma	redefine_extname	sendfilev	sendfilev64
#else	/* __PRAGMA_REDEFINE_EXTNAME */
#define	sendfilev			sendfilev64
#endif	/* __PRAGMA_REDEFINE_EXTNAME */
#endif	/* !_LP64 && _FILE_OFFSET_BITS == 64 */

/* In the LP64 compilation environment, the APIs are already large file */
#if defined(_LP64) && defined(_LARGEFILE64_SOURCE)
#ifdef	__PRAGMA_REDEFINE_EXTNAME
#pragma redefine_extname	sendfilev64	sendfilev
#else	/* __PRAGMA_REDEFINE_EXTNAME */
#define	sendfilev64			sendfilev
#endif	/* __PRAGMA_REDEFINE_EXTNAME */
#endif	/* _LP64 && _LARGEFILE64_SOURCE */

#ifdef	__STDC__
extern ssize_t sendfilev(int, const struct sendfilevec *, int, size_t *);
/* Transitional largefile interface */
#if	defined(_LARGEFILE64_SOURCE) && !((_FILE_OFFSET_BITS == 64) && \
	    !defined(__PRAGMA_REDEFINE_EXTNAME))
extern ssize_t sendfilev64(int, const struct sendfilevec64 *, int, size_t *);
#endif
#else	/* __STDC__ */
extern int sendfilev();
#if	defined(_LARGEFILE64_SOURCE) && !((_FILE_OFFSET_BITS == 64) && \
	    !defined(__PRAGMA_REDEFINE_EXTNAME))
extern int sendfilev64();
#endif
#endif	/* __STDC__ */
#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SENDFILE_H */
