/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class AnComboBox
extends JComboBox
implements ActionListener {
    public static final int COMBO_TEXT = 0;
    public static final int COMBO_ITEM = 1;
    private ComboObj current_obj = null;

    public AnComboBox() {
        this.setRenderer(new AnComboRenderer());
        this.setEditor(new AnComboEditor());
        this.setEditable(true);
        this.setBorder(new EtchedBorder(1));
    }

    public void add(int n, String string, String string2) {
        this.addItem(new ComboObj(n, false, string, string2));
    }

    public String getText() {
        ComboObj comboObj = (ComboObj)this.getEditor().getEditorComponent();
        if (comboObj.getType() == 1) {
            return null;
        }
        return comboObj.getText();
    }

    public Component getEditorText() {
        return ((ComboObj)this.getEditor().getEditorComponent()).getTextField();
    }

    public Point getEditorLocation() {
        return ((AnComboEditor)this.getEditor()).getTextLocation();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JTextField) {
            this.current_obj.setText(((JTextField)object).getText());
        }
    }

    private class AnComboEditor
    implements ComboBoxEditor,
    FocusListener {
        private ComboObj editor;
        private JTextField text;

        public AnComboEditor() {
            this.editor = new ComboObj(0, true, "", "");
            this.editor.setBorder(null);
            this.text = this.editor.getTextField();
            this.text.addFocusListener(this);
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        public void setItem(Object object) {
            ComboObj comboObj = (ComboObj)object;
            if (comboObj != null) {
                AnComboBox.this.current_obj = comboObj;
                int n = comboObj.getType();
                if (n == 0) {
                    this.text.requestFocus();
                }
                this.editor.setType(n);
                this.editor.setHeader(comboObj.getHeader());
                this.editor.setText(comboObj.getText());
            }
        }

        public Object getItem() {
            return this.editor;
        }

        public Point getTextLocation() {
            return this.text.getLocationOnScreen();
        }

        public void selectAll() {
            this.editor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            AnComboBox.this.current_obj.setText(this.text.getText());
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }

    private class AnComboRenderer
    extends DefaultListCellRenderer {
        private AnComboRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ComboObj comboObj = (ComboObj)object;
            if (bl) {
                comboObj.setBackground(jList.getSelectionBackground());
                comboObj.setForeground(jList.getSelectionForeground());
            } else {
                comboObj.setBackground(jList.getBackground());
                comboObj.setForeground(jList.getForeground());
            }
            return comboObj;
        }
    }

    private class ComboObj
    extends JPanel {
        private boolean editor;
        private int type;
        private String header;
        private JLabel label;
        private JTextField text;

        public ComboObj(int n, boolean bl, String string, String string2) {
            this.editor = bl;
            this.type = n;
            this.header = string;
            BoxLayout boxLayout = new BoxLayout(this, 0);
            this.setLayout(boxLayout);
            this.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.label = (JLabel)AnUtility.getTitle(string);
            this.text = new JTextField(n == 0 ? 14 : 0);
            this.text.setFont(AnUtility.text_font);
            this.text.setBorder(null);
            this.add(this.label);
            this.add(this.text);
            this.setText(string2);
            boxLayout.layoutContainer(this);
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public String getHeader() {
            return this.header;
        }

        public void setHeader(String string) {
            this.header = string;
            this.label.setText(string);
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String string) {
            this.text.setText(string);
            this.text.setEditable(this.editor && this.type == 0);
        }

        public JTextField getTextField() {
            return this.text;
        }

        public void selectAll() {
            this.text.selectAll();
            this.text.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            this.text.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.text.removeActionListener(actionListener);
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            if (this.text != null) {
                this.text.setBackground(color);
            }
            if (this.label != null) {
                this.label.setBackground(color);
            }
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            if (this.text != null) {
                this.text.setForeground(color);
            }
            if (this.label != null) {
                this.label.setForeground(color);
            }
        }
    }
}

