/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import java.io.File;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class AnExpChooser
extends JFileChooser {
    public static final int EXP_NOT = 0;
    public static final int EXP_NORMAL = 1;
    public static final int EXP_GROUP = 2;
    public static final int EXP_BAD = 3;
    public static final int EXP_OLD = 4;
    private static String start_dir = AnVariable.pwd_dir;
    private int win_id;
    private AnWindow window;
    private boolean restart;

    public AnExpChooser(int n, String string, boolean bl) {
        super(start_dir);
        this.win_id = n;
        this.window = AnWindow.get_win(n);
        this.restart = bl;
        this.setDialogTitle(string);
        this.setFileFilter(new ExpFilter());
        this.setFileView(new ExpView());
        this.setFileSelectionMode(2);
        this.setMultiSelectionEnabled(true);
    }

    public int getExperimentType(File file) {
        if (file == null) {
            return 0;
        }
        String string = file.getName();
        if (string.endsWith(".er")) {
            if (file.isDirectory()) {
                return 1;
            }
            if (file.isFile()) {
                return 4;
            }
            return 0;
        }
        if (string.endsWith(".erg") && file.isFile()) {
            return 2;
        }
        return 0;
    }

    public void approveSelection() {
        File[] fileArray = this.getSelectedFiles();
        int n = fileArray.length;
        if (n == 0) {
            return;
        }
        File file = fileArray[0];
        if (this.getExperimentType(file) == 0 && file.isDirectory()) {
            start_dir = file.getAbsolutePath();
            this.setCurrentDirectory(file);
            return;
        }
        start_dir = this.getCurrentDirectory().getAbsolutePath();
        Vector vector = new Vector();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            int n3 = this.getExperimentType(file);
            if (n3 == 1 || n3 == 2) {
                vector.addAll(AnUtility.getGroupList(file.getAbsolutePath()));
            } else {
                if (!string.equals("")) {
                    string = string + "\n";
                }
                string = n3 == 4 ? string + AnLocale.getString("Old experiment is not supported:") : (n3 == 3 ? string + AnLocale.getString("Bad experiment:") : string + AnLocale.getString("Not a valid experiment:"));
                string = string + " " + file;
            }
            ++n2;
        }
        if (!string.equals("")) {
            this.window.showError(string);
        }
        if (vector.size() > 0) {
            this.window.openExpList(vector, this.restart);
            super.approveSelection();
        }
    }

    public void cancelSelection() {
        start_dir = this.getCurrentDirectory().getAbsolutePath();
        super.cancelSelection();
    }

    private class ExpView
    extends FileView {
        private ExpView() {
        }

        public Icon getIcon(File file) {
            switch (AnExpChooser.this.getExperimentType(file)) {
                case 1: {
                    return AnUtility.expt_icon;
                }
                case 2: {
                    return AnUtility.egrp_icon;
                }
                case 4: {
                    return AnUtility.eold_icon;
                }
                case 3: {
                    return AnUtility.ebad_icon;
                }
            }
            return null;
        }

        public Boolean isTraversable(File file) {
            return AnExpChooser.this.getExperimentType(file) == 0 ? Boolean.TRUE : Boolean.FALSE;
        }

        public String getName(File file) {
            return null;
        }

        public String getDescription(File file) {
            return null;
        }

        public String getTypeDescription(File file) {
            return null;
        }
    }

    private class ExpFilter
    extends FileFilter {
        private ExpFilter() {
        }

        public boolean accept(File file) {
            return AnExpChooser.this.getExperimentType(file) != 0 || file.isDirectory();
        }

        public String getDescription() {
            return AnLocale.getString("Performance Analyzer Experiment (*.er, *.erg)");
        }
    }
}

