/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnCheckList;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnListener;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnMetric;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.Presentation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class AnMetricList
extends JPanel
implements AnListener {
    private static final Font list_font = new JList().getFont();
    private static final Font plain_font = list_font.deriveFont(0);
    private static final Font bold_font = list_font.deriveFont(1);
    private AnMetricData[] data = null;
    private AnCheckList list;
    private Dimension check_size;

    public AnMetricList(String string, String string2, String string3, char c) {
        this.setLayout(new BorderLayout(4, 4));
        this.list = new AnCheckList(string3);
        this.add((Component)new JScrollPane(this.list), "Center");
        this.list.setCellRenderer(new MetricListRenderer());
        this.list.addAnListener(this);
        JComponent jComponent = AnUtility.getHeader(string);
        JLabel jLabel = (JLabel)AnUtility.getTitle(string2, AnUtility.mtna_icon);
        jLabel.setDisplayedMnemonic(c);
        jLabel.setLabelFor(this.list);
        this.check_size = new Dimension(jComponent.getPreferredSize().width, jLabel.getPreferredSize().height);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(jComponent);
        jPanel.add(jLabel);
        this.add((Component)jPanel, "North");
        jPanel = new JPanel(new GridLayout(1, 0, 4, 0));
        jPanel.add(new ResponseAction(AnLocale.getString("Move Up"), AnUtility.up_icon, 'U'));
        jPanel.add(new ResponseAction(AnLocale.getString("Move Down"), AnUtility.down_icon, 'D'));
        this.add((Component)jPanel, "South");
    }

    public void setVisible(boolean[] blArray) {
        if (this.data == null) {
            return;
        }
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            this.data[n2].visible = blArray[n2];
            ++n2;
        }
        this.list.repaint();
    }

    public void setCheck(int n) {
        this.data[n].getCheck().setSelected(true);
        this.list.repaint();
        this.list.ensureIndexIsVisible(n);
    }

    public AnMetric getMetric(int n) {
        return this.data[n].getMetric();
    }

    public AnMetric getSortMetric() {
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.data[n2].getCheck().isSelected()) {
                return this.data[n2].getMetric();
            }
            ++n2;
        }
        return null;
    }

    public void setListData(AnMetric[] anMetricArray) {
        int n = anMetricArray.length;
        this.data = new AnMetricData[n];
        ButtonGroup buttonGroup = new ButtonGroup();
        int n2 = 0;
        while (n2 < n) {
            this.data[n2] = new AnMetricData(anMetricArray[n2], buttonGroup);
            ++n2;
        }
        this.list.setListData(this.data);
        this.list.setSelectedIndex(0);
    }

    public void moveOne(int n, int n2) {
        int n3 = this.data.length;
        if (n == n2 || n3 == 0) {
            return;
        }
        AnMetricData anMetricData = this.data[n];
        if (n < n2) {
            int n4 = n;
            while (n4 < n2) {
                this.data[n4] = this.data[n4 + 1];
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 > n2) {
                this.data[n5] = this.data[n5 - 1];
                --n5;
            }
        }
        this.data[n2] = anMetricData;
        int[] nArray = new int[]{n2};
        this.list.setListData(this.data);
        this.list.setSelectedIndices(nArray);
        this.list.ensureIndexIsVisible(n2);
    }

    private void moveUp() {
        int[] nArray = this.list.getSelectedIndices();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            if (n4 == n2) {
                ++n2;
            } else {
                AnMetricData anMetricData = this.data[n4 - 1];
                this.data[n4 - 1] = this.data[n4];
                this.data[n4] = anMetricData;
                int n5 = n3;
                nArray[n5] = nArray[n5] - 1;
            }
            ++n3;
        }
        this.list.setListData(this.data);
        this.list.setSelectedIndices(nArray);
        this.list.ensureIndexIsVisible(nArray[0]);
    }

    private void moveDown() {
        int[] nArray = this.list.getSelectedIndices();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = this.data.length - 1;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = nArray[n3];
            if (n4 == n2) {
                --n2;
            } else {
                AnMetricData anMetricData = this.data[n4 + 1];
                this.data[n4 + 1] = this.data[n4];
                this.data[n4] = anMetricData;
                int n5 = n3;
                nArray[n5] = nArray[n5] + 1;
            }
            --n3;
        }
        this.list.setListData(this.data);
        this.list.setSelectedIndices(nArray);
        this.list.ensureIndexIsVisible(nArray[n - 1]);
    }

    public void valueChanged(AnEvent anEvent) {
        if (anEvent.getType() == 7) {
            this.data[anEvent.getValue()].getCheck().setSelected(true);
            this.list.repaint();
        }
    }

    private class ResponseAction
    extends JButton
    implements ActionListener {
        public ResponseAction(String string, Icon icon, char c) {
            super(string, icon);
            this.setMargin(AnVariable.buttonMargin);
            this.setMnemonic(c);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(AnLocale.getString("Move Up"))) {
                AnMetricList.this.moveUp();
            } else if (string.equals(AnLocale.getString("Move Down"))) {
                AnMetricList.this.moveDown();
            }
        }
    }

    private class MetricListRenderer
    extends DefaultListCellRenderer {
        private MetricListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color;
            Color color2;
            AnMetricData anMetricData = (AnMetricData)object;
            String string = anMetricData.getName();
            if (string.endsWith(Presentation.time_str)) {
                string = string.substring(0, string.length() - Presentation.time_str.length());
            }
            this.setText(string);
            this.setFont(anMetricData.isVisible() ? bold_font : plain_font);
            this.setIcon(string.startsWith(Presentation.excl_name) ? AnUtility.excl_icon : (string.startsWith(Presentation.incl_name) ? AnUtility.incl_icon : (string.startsWith(Presentation.attr_name) ? AnUtility.attr_icon : AnUtility.mtna_icon)));
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            jPanel.setComponentOrientation(jList.getComponentOrientation());
            jPanel.setEnabled(jList.isEnabled());
            jPanel.setBorder(bl2 ? AnVariable.listFocusBorder : DefaultListCellRenderer.noFocusBorder);
            JRadioButton jRadioButton = anMetricData.getCheck();
            jPanel.add(jRadioButton);
            jPanel.add(this);
            if (bl) {
                color2 = jList.getSelectionBackground();
                color = jList.getSelectionForeground();
            } else {
                color2 = jList.getBackground();
                color = jList.getForeground();
            }
            this.setBackground(color2);
            this.setForeground(color);
            jPanel.setBackground(color2);
            jPanel.setForeground(color);
            jRadioButton.setBackground(color2);
            jRadioButton.setForeground(color);
            return jPanel;
        }
    }

    public class AnMetricData {
        AnMetric metric;
        boolean visible;
        JRadioButton check;

        private AnMetricData(AnMetric anMetric, ButtonGroup buttonGroup) {
            this.metric = anMetric;
            this.visible = anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible();
            this.check = new JRadioButton("", anMetric.isSorted());
            this.check.setPreferredSize(AnMetricList.this.check_size);
            this.check.setHorizontalAlignment(0);
            buttonGroup.add(this.check);
        }

        public JRadioButton getCheck() {
            return this.check;
        }

        public AnMetric getMetric() {
            return this.metric;
        }

        public String getName() {
            return this.metric.getName();
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

