/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnAddress;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnListener;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnObject;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.Presentation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AnTable
extends JScrollPane {
    static final int AT_LIST = 0;
    static final int AT_SRC = 1;
    static final int AT_SRC_ONLY = 2;
    static final int AT_DIS = 3;
    static final int AT_COM = 4;
    static final int AT_QUOTE = 5;
    static final int AT_FUNC = 6;
    static final int AT_EMPTY = 7;
    static final int NUMBER_SPACE = 3;
    static final Font table_font;
    static final Font quote_font;
    static final Font bold_font;
    private AnTable fl_table;
    private int type;
    private JTable table;
    private JTableHeader header;
    private FListTableModel model;
    private FListColumnModel column;
    private JViewport error_view;
    private JLabel error_label;
    private FontMetrics table_fm;
    private int[][] col_width;
    private int row_height;
    private String[] names;
    private int org_row;
    private int sel_row;
    private int name_col;
    private int sort_col;
    private int name_width;
    private boolean has_header;
    private boolean can_sort;
    private boolean is_single;
    private boolean col_scroll;
    private boolean has_select;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$forte$st$mpmt$AnListener;

    public AnTable(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.fl_table = this;
        this.type = n;
        this.table_fm = null;
        this.col_width = new int[1][4];
        this.row_height = 0;
        this.org_row = -1;
        this.sel_row = 0;
        this.name_col = 0;
        this.sort_col = 0;
        this.name_width = 0;
        this.has_header = bl;
        this.can_sort = bl2;
        this.is_single = bl3;
        this.col_scroll = bl4;
        this.has_select = bl5;
        this.col_width[0][0] = 30;
        this.col_width[0][3] = 10;
        this.col_width[0][2] = 10;
        this.col_width[0][1] = 10;
        this.initComponents();
    }

    private void initComponents() {
        this.model = new FListTableModel();
        this.column = new FListColumnModel();
        this.table = new JTable(this.model, this.column);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(0);
        this.table.setAutoscrolls(false);
        if (this.is_single) {
            Dimension dimension = this.table.getPreferredScrollableViewportSize();
            dimension.height = this.table.getRowHeight() + this.table.getRowMargin();
            this.table.setPreferredScrollableViewportSize(dimension);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(this.can_sort ? 0 : 1);
        if (!this.is_single) {
            listSelectionModel.addListSelectionListener(new CellHandler());
        }
        if (!this.has_select) {
            CallHandler callHandler = new CallHandler();
            this.table.addMouseListener(callHandler);
            this.table.registerKeyboardAction(callHandler, AnLocale.getString("OK"), KeyStroke.getKeyStroke(32, 0), 1);
        }
        this.table.setFont(table_font);
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = AnTable.class$("java.lang.Object")) : class$java$lang$Object, new CellRenderer());
        this.setViewportView(this.table);
        JLabel jLabel = new JLabel();
        jLabel.setBorder(new EtchedBorder(1));
        this.setCorner("UPPER_RIGHT_CORNER", jLabel);
        this.setHorizontalScrollBarPolicy(this.col_scroll ? 30 : 31);
        this.setVerticalScrollBarPolicy(22);
        if (this.is_single) {
            this.getVerticalScrollBar().setEnabled(false);
        }
        this.header = this.table.getTableHeader();
        if (this.has_header) {
            this.header.setDefaultRenderer(new HeaderRenderer());
            this.setColumnHeaderView(this.header);
            if (this.can_sort) {
                this.header.addMouseListener(new HeaderHandler());
            }
            this.table.getColumnModel().addColumnModelListener(new ColumnHandler());
        } else {
            this.table.setTableHeader(null);
            if (this.col_scroll) {
                this.getHorizontalScrollBar().addAdjustmentListener(new ScrollHandler());
            }
        }
        this.addComponentListener(new TableListener());
        this.error_label = new JLabel();
        this.error_label.setHorizontalAlignment(0);
        this.error_view = new JViewport();
        this.error_view.setView(this.error_label);
    }

    public void setHeader(AnTable anTable) {
        this.header = anTable.header;
    }

    public void setViewport() {
        this.setViewportView(this.table);
    }

    public void removeAll() {
        this.model.removeAll();
    }

    public void removeAllRows() {
        this.model.removeAllRows();
    }

    public void showError(String string) {
        if (string == null) {
            return;
        }
        this.error_label.setText(string);
        this.setViewportView(this.error_view);
    }

    public void setData(Presentation.MetricLabel[] metricLabelArray, Object[][] objectArray, String[] stringArray, int[] nArray, int n, int n2, int n3) {
        this.names = stringArray;
        this.org_row = n;
        this.name_col = n2;
        this.sort_col = n3;
        this.model.setData(metricLabelArray, objectArray, nArray);
    }

    public void setLabel(Presentation.MetricLabel[] metricLabelArray) {
        this.model.setLabel(metricLabelArray);
    }

    public void setColumn(Presentation.MetricLabel[] metricLabelArray, int n, int[][] nArray) {
        this.row_height = n;
        this.col_width = nArray;
        this.model.setColumn(metricLabelArray);
    }

    public void showSelectedRow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = AnTable.this.can_sort ? AnTable.this.model.getSortRow(AnTable.this.org_row) : AnTable.this.org_row;
                Rectangle rectangle = AnTable.this.table.getCellRect(n, 0, false);
                Rectangle rectangle2 = AnTable.this.table.getVisibleRect();
                rectangle.x = rectangle2.x;
                if (!rectangle2.contains(rectangle)) {
                    rectangle.height += rectangle2.height / 2;
                    AnTable.this.table.scrollRectToVisible(rectangle);
                }
                if (AnTable.this.table.getSelectedRow() != n) {
                    AnTable.this.table.changeSelection(n, 0, false, false);
                }
            }
        });
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnTable.this.table.requestFocus();
            }
        });
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void clearSelectedRow() {
        this.table.clearSelection();
        this.org_row = -1;
    }

    public int getScroll() {
        return this.getHorizontalScrollBar().getValue();
    }

    public void setScroll(int n) {
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnTable.this.getHorizontalScrollBar().setValue(n2);
            }
        });
    }

    public void moveColumn(int n, int n2) {
        this.table.moveColumn(n, n2);
    }

    public void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        if (tableColumn.getPreferredWidth() != n2) {
            int n3 = n2;
            this.col_width[n][0] = n3;
            tableColumn.setPreferredWidth(n3);
        }
    }

    public int[][] getColWidth() {
        return this.col_width;
    }

    public int getRowHeight() {
        return this.row_height;
    }

    public int stringWidth(String string) {
        if (this.table_fm == null) {
            this.table_fm = this.table.getGraphics().getFontMetrics();
        }
        return this.table_fm.stringWidth(string);
    }

    public String setSelectedRow(int n) {
        this.org_row = n;
        this.showSelectedRow();
        if (this.name_col >= 0) {
            return (String)this.model.getValueAt(this.model.getSortRow(n), this.name_col);
        }
        return "";
    }

    public int getSelectedRow() {
        return this.org_row;
    }

    public int findAfter(String string, boolean bl) {
        int n = this.model.getSortRow(this.org_row);
        int n2 = this.model.getRowCount();
        int n3 = n2 - 1;
        if (bl) {
            if (n < n3) {
                return this.model.find(string, 1, n + 1, n2);
            }
        } else if (n > 0) {
            return this.model.find(string, -1, n - 1, -1);
        }
        return -1;
    }

    public int findBefore(String string, boolean bl) {
        int n = this.model.getSortRow(this.org_row);
        int n2 = this.model.getRowCount();
        int n3 = n2 - 1;
        if (bl) {
            if (n >= 0) {
                return this.model.find(string, 1, 0, n + 1);
            }
        } else if (n <= n3) {
            return this.model.find(string, -1, n3, n - 1);
        }
        return -1;
    }

    public void sort(int n) {
        if (this.can_sort && n >= 0) {
            this.model.sort(this.table.convertColumnIndexToModel(n));
        }
    }

    public void addAnListener(AnListener anListener) {
        this.listenerList.add(class$com$sun$forte$st$mpmt$AnListener == null ? (class$com$sun$forte$st$mpmt$AnListener = AnTable.class$("com.sun.forte.st.mpmt.AnListener")) : class$com$sun$forte$st$mpmt$AnListener, anListener);
    }

    public void removeAnListener(AnListener anListener) {
        this.listenerList.remove(class$com$sun$forte$st$mpmt$AnListener == null ? (class$com$sun$forte$st$mpmt$AnListener = AnTable.class$("com.sun.forte.st.mpmt.AnListener")) : class$com$sun$forte$st$mpmt$AnListener, anListener);
    }

    private void fireAnEvent(AnEvent anEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$forte$st$mpmt$AnListener == null ? AnTable.class$("com.sun.forte.st.mpmt.AnListener") : class$com$sun$forte$st$mpmt$AnListener)) {
                ((AnListener)objectArray[n + 1]).valueChanged(anEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int[][] access$1102(AnTable anTable, int[][] nArray) {
        anTable.col_width = nArray;
        return nArray;
    }

    static {
        JTable jTable = new JTable();
        Font font = jTable.getFont();
        table_font = new Font("Monospaced", font.getStyle(), font.getSize());
        quote_font = table_font.deriveFont(2);
        bold_font = jTable.getTableHeader().getFont().deriveFont(1);
    }

    private class FListColumnModel
    extends DefaultTableColumnModel {
        private FListColumnModel() {
        }

        public void addColumn(TableColumn tableColumn) {
            int n = AnTable.this.col_width[tableColumn.getModelIndex()][0];
            tableColumn.setPreferredWidth(n);
            tableColumn.setWidth(n);
            super.addColumn(tableColumn);
        }

        public TableColumn getColumn(int n) {
            int n2 = this.tableColumns.size();
            if (n < 0 || n >= n2) {
                if (n2 > 0) {
                    n = 0;
                } else {
                    return new TableColumn();
                }
            }
            return (TableColumn)this.tableColumns.elementAt(n);
        }
    }

    private class FListTableModel
    extends AbstractTableModel {
        private Presentation.MetricLabel[] label;
        private Object[][] data;
        private int[] src_type;
        private Row[] rows;
        private int nr;
        private int nc;

        public FListTableModel() {
            this.initData();
        }

        private void initData() {
            this.label = new Presentation.MetricLabel[0];
            this.data = new Object[1][0];
            this.src_type = new int[0];
            this.rows = new Row[0];
            this.nc = 0;
            this.nr = 0;
        }

        public void removeAll() {
            this.initData();
            this.fireTableChanged(null);
        }

        public void removeAllRows() {
            this.nr = 0;
            this.fireTableChanged(null);
        }

        public void setData(Presentation.MetricLabel[] metricLabelArray, Object[][] objectArray, int[] nArray) {
            this.data = objectArray;
            this.src_type = nArray;
            this.nc = objectArray.length;
            this.nr = objectArray[0].length;
            this.rows = new Row[this.nr];
            int n = 0;
            while (n < this.nr) {
                this.rows[n] = new Row(n);
                ++n;
            }
            this.setLabel(metricLabelArray);
        }

        public void setLabel(Presentation.MetricLabel[] metricLabelArray) {
            this.label = metricLabelArray;
            AnTable.access$1102(AnTable.this, new int[this.nc][4]);
            this.initWidth();
            if (AnTable.this.has_select) {
                this.fitColumn();
                AnTable.this.table.setRowHeight(AnTable.this.row_height);
                this.fireTableChanged(null);
            }
        }

        public void setColumn(Presentation.MetricLabel[] metricLabelArray) {
            this.label = metricLabelArray;
            this.fitColumn();
            AnTable.this.table.setRowHeight(AnTable.this.row_height);
            this.fireTableChanged(null);
        }

        private void fitColumn() {
            if (AnTable.this.is_single || AnTable.this.name_col < 0) {
                return;
            }
            int n = AnTable.this.getViewportBorderBounds().width;
            int n2 = 0;
            while (n2 < this.nc) {
                if (n2 != AnTable.this.name_col) {
                    n -= AnTable.this.col_width[n2][0];
                }
                ++n2;
            }
            AnTable.this.name_width = AnTable.this.col_width[AnTable.this.name_col][0];
            if (AnTable.this.col_width[AnTable.this.name_col][0] < n) {
                ((AnTable)AnTable.this).col_width[((AnTable)AnTable.this).name_col][0] = n;
            }
        }

        public void fitColumnResize(int n) {
            if (AnTable.this.is_single || n == AnTable.this.name_col || AnTable.this.name_col < 0) {
                return;
            }
            int n2 = AnTable.this.getViewportBorderBounds().width;
            TableColumnModel tableColumnModel = AnTable.this.table.getColumnModel();
            int n3 = 0;
            while (n3 < this.nc) {
                if (n3 != AnTable.this.name_col) {
                    n2 -= tableColumnModel.getColumn(n3).getWidth();
                }
                ++n3;
            }
            if (AnTable.this.name_width < n2) {
                TableColumn tableColumn = tableColumnModel.getColumn(AnTable.this.name_col);
                tableColumn.setPreferredWidth(n2);
                tableColumn.setWidth(n2);
                if (AnTable.this.type == 6) {
                    AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 13, AnTable.this.name_col, n2));
                }
            }
        }

        private void initWidth() {
            int n = AnTable.this.sort_col;
            FListLabel[] fListLabelArray = new FListLabel[3];
            CellPanel cellPanel = new CellPanel(AnTable.this.table, true, true, 1);
            cellPanel.add(new FListLabel("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-=\\`[];',./!@#$%^&*()_+|~{}:\"<>?", AnTable.this.table, 2));
            AnTable.this.row_height = cellPanel.getPreferredSize().height;
            int n2 = AnTable.this.column.getColumnMargin();
            int n3 = AnTable.this.stringWidth(String.valueOf('@')) - 3;
            int n4 = 0;
            while (n4 < this.nc) {
                int n5;
                Dimension dimension;
                int[] nArray = AnTable.this.col_width[n4];
                nArray[3] = 0;
                nArray[2] = 0;
                nArray[1] = 0;
                nArray[0] = 0;
                Presentation.MetricLabel metricLabel = this.label[n4];
                AnTable.this.sort_col = n4;
                HeaderPanel headerPanel = new HeaderPanel(metricLabel, AnTable.this.header, n4);
                cellPanel = this.nr > 0 ? new CellPanel(AnTable.this.table, true, true, 1) : null;
                fListLabelArray[2] = null;
                fListLabelArray[1] = null;
                fListLabelArray[0] = null;
                if (this.data[n4] instanceof String[]) {
                    fListLabelArray[0] = new FListLabel(metricLabel.max_obj.toString(), AnTable.this.table, 2);
                    dimension = fListLabelArray[0].getPreferredSize();
                    nArray[1] = dimension.width;
                } else {
                    if (metricLabel.clock != -1.0) {
                        n5 = (AnTable)AnTable.this.new FListLabel((String)metricLabel.max_obj.toFormTime((double)metricLabel.clock), (JComponent)((AnTable)AnTable.this).table, (int)4).getPreferredSize().width;
                        fListLabelArray[0] = new FListLabel(AnLocale.getString("(sec.)"), AnTable.this.header, 0);
                        headerPanel.add(fListLabelArray[0]);
                        dimension = fListLabelArray[0].getPreferredSize();
                        if (dimension.width < n5) {
                            dimension.width = n5;
                        }
                        nArray[1] = dimension.width;
                        fListLabelArray[0].setPreferredSize(dimension);
                    }
                    if (metricLabel.unit != null) {
                        String string = metricLabel.max_obj.toFormString();
                        n5 = (AnTable)AnTable.this.new FListLabel((String)string, (JComponent)((AnTable)AnTable.this).table, (int)4).getPreferredSize().width;
                        int n6 = string.length() - 1;
                        while (n6 >= 0) {
                            if (string.charAt(n6) == '@') {
                                n5 -= n3;
                            }
                            --n6;
                        }
                        fListLabelArray[1] = new FListLabel(metricLabel.unit, AnTable.this.header, 0);
                        headerPanel.add(fListLabelArray[1]);
                        dimension = fListLabelArray[1].getPreferredSize();
                        if (dimension.width < n5) {
                            dimension.width = n5;
                        }
                        nArray[2] = dimension.width;
                        fListLabelArray[1].setPreferredSize(dimension);
                    }
                    if (metricLabel.total != -1.0) {
                        n5 = (AnTable)AnTable.this.new FListLabel((String)metricLabel.max_obj.toPercent((double)metricLabel.total), (JComponent)((AnTable)AnTable.this).table, (int)4).getPreferredSize().width;
                        fListLabelArray[2] = new FListLabel("(%)", AnTable.this.header, 0);
                        headerPanel.add(fListLabelArray[2]);
                        dimension = fListLabelArray[2].getPreferredSize();
                        if (dimension.width < n5) {
                            dimension.width = n5;
                        }
                        nArray[3] = dimension.width;
                        fListLabelArray[2].setPreferredSize(dimension);
                    }
                }
                nArray[0] = headerPanel.getPreferredSize().width;
                if (cellPanel != null) {
                    if (fListLabelArray[0] != null) {
                        cellPanel.add(fListLabelArray[0]);
                    }
                    if (fListLabelArray[1] != null) {
                        cellPanel.add(fListLabelArray[1]);
                    }
                    if (fListLabelArray[2] != null) {
                        cellPanel.add(fListLabelArray[2]);
                    }
                    dimension = cellPanel.getPreferredSize();
                    n5 = dimension.width;
                    if (nArray[0] < n5) {
                        nArray[0] = n5;
                    }
                    int n7 = dimension.height;
                    if (AnTable.this.row_height < n7) {
                        AnTable.this.row_height = n7;
                    }
                }
                nArray[0] = nArray[0] + n2;
                ++n4;
            }
            AnTable.this.sort_col = n;
        }

        public int getRowCount() {
            return this.nr;
        }

        public int getColumnCount() {
            return this.nc;
        }

        public int getSrcType(int n) {
            return this.src_type == null ? 0 : this.src_type[n];
        }

        public Presentation.MetricLabel getLabel(int n) {
            return this.label[n];
        }

        public String getColumnName(int n) {
            return this.label[n].title[0] + this.label[n].title[1] + this.label[n].icon;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n2][this.rows[n].index];
        }

        public int find(String string, int n, int n2, int n3) {
            block5: {
                block4: {
                    if (string != null) break block4;
                    while (n2 != n3) {
                        if (this.getSrcType(n2) < 0) {
                            return n2;
                        }
                        n2 += n;
                    }
                    break block5;
                }
                if (AnTable.this.name_col < 0) break block5;
                while (n2 != n3) {
                    String string2 = (String)this.getValueAt(n2, AnTable.this.name_col);
                    if (string2.indexOf(string) != -1) {
                        return this.getRow(n2);
                    }
                    n2 += n;
                }
            }
            return -1;
        }

        public int getRow(int n) {
            return this.nr == 0 ? n : this.rows[n].index;
        }

        public int getSortRow(int n) {
            if (this.nr == 0 || n == -1 || this.rows[n].index == n) {
                return n;
            }
            int n2 = 0;
            while (n2 < this.nr) {
                if (this.rows[n2].index == n) {
                    return n2;
                }
                ++n2;
            }
            return n;
        }

        public void sort(int n) {
            AnTable.this.sort_col = n;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
            if (AnTable.this.has_header) {
                AnTable.this.header.repaint();
            }
            if (AnTable.this.has_select) {
                AnTable.this.showSelectedRow();
            }
        }

        private class Row
        implements Comparable {
            public int index;

            public Row(int n) {
                this.index = n;
            }

            public int compareTo(Object object) {
                int n = AnTable.this.sort_col >= 0 ? AnTable.this.sort_col : -AnTable.this.sort_col - 1;
                int n2 = ((Row)object).index;
                Object object2 = FListTableModel.this.data[n][this.index];
                Object object3 = FListTableModel.this.data[n][n2];
                if (object2 instanceof String || object2 instanceof AnAddress) {
                    return ((Comparable)object2).compareTo(object3);
                }
                if (object2 instanceof Comparable) {
                    return ((Comparable)object3).compareTo(object2);
                }
                return this.index - n2;
            }
        }
    }

    private class ColumnHandler
    implements TableColumnModelListener {
        private ColumnHandler() {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            int n;
            int n2 = tableColumnModelEvent.getFromIndex();
            if (n2 == (n = tableColumnModelEvent.getToIndex())) {
                return;
            }
            AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 12, n2, n));
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (AnTable.this.header == null) {
                return;
            }
            TableColumn tableColumn = AnTable.this.header.getResizingColumn();
            if (tableColumn == null) {
                return;
            }
            TableColumnModel tableColumnModel = AnTable.this.table.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                if (tableColumnModel.getColumn(n2) == tableColumn) {
                    AnTable.this.model.fitColumnResize(n2);
                    if (AnTable.this.type != 6) break;
                    int n3 = tableColumn.getWidth();
                    AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 13, n2, n3));
                    break;
                }
                ++n2;
            }
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class ScrollHandler
    implements AdjustmentListener {
        private ScrollHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 11, adjustmentEvent.getValue(), 0));
        }
    }

    private class HeaderHandler
    extends MouseAdapter {
        private HeaderHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = AnTable.this.table.columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            int n2 = AnTable.this.table.convertColumnIndexToModel(n);
            AnTable.this.model.sort(n2);
            AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 9, n2, n));
        }
    }

    private class CallHandler
    extends MouseAdapter
    implements ActionListener {
        private CallHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.setSelectedRow(AnTable.this.table.rowAtPoint(mouseEvent.getPoint()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(AnLocale.getString("OK"))) {
                this.setSelectedRow(AnTable.this.table.getSelectedRow());
            }
        }

        public void setSelectedRow(int n) {
            if (AnTable.this.org_row == -1 || n == -1) {
                return;
            }
            AnTable.this.org_row = AnTable.this.model.getRow(n);
            AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 8, AnTable.this.org_row, 0));
        }
    }

    private class CellHandler
    implements ListSelectionListener {
        private CellHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = listSelectionEvent.getFirstIndex();
            if (AnTable.this.sel_row == n) {
                int n2 = listSelectionEvent.getLastIndex();
                if (AnTable.this.sel_row == n2 && AnTable.this.has_select) {
                    return;
                }
                AnTable.this.sel_row = n2;
            } else {
                AnTable.this.sel_row = n;
            }
            Rectangle rectangle = AnTable.this.table.getCellRect(AnTable.this.sel_row, 0, false);
            Rectangle rectangle2 = AnTable.this.table.getVisibleRect();
            rectangle.x = rectangle2.x;
            if (!rectangle2.contains(rectangle)) {
                AnTable.this.table.scrollRectToVisible(rectangle);
            }
            if (AnTable.this.can_sort) {
                int n3 = AnTable.this.model.getRow(AnTable.this.sel_row);
                if (AnTable.this.org_row != n3) {
                    AnTable.this.org_row = n3;
                    AnTable.this.fireAnEvent(new AnEvent(AnTable.this.fl_table, 8, AnTable.this.org_row, 0));
                }
            }
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer,
    Serializable {
        private HeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Dimension dimension;
            FListLabel fListLabel;
            JTableHeader jTableHeader = jTable.getTableHeader();
            int n3 = jTable.convertColumnIndexToModel(n2);
            Presentation.MetricLabel metricLabel = AnTable.this.model.getLabel(n3);
            HeaderPanel headerPanel = new HeaderPanel(metricLabel, jTableHeader, n3);
            int n4 = headerPanel.getUnitHeight();
            int[] nArray = AnTable.this.col_width[n3];
            if (metricLabel.clock != -1.0) {
                fListLabel = new FListLabel(AnLocale.getString("(sec.)"), jTableHeader, 0);
                headerPanel.add(fListLabel);
                dimension = new Dimension(nArray[1], n4);
                fListLabel.setVerticalAlignment(0);
                fListLabel.setPreferredSize(dimension);
                fListLabel.setMinimumSize(dimension);
                fListLabel.setMaximumSize(dimension);
            }
            if (metricLabel.unit != null) {
                fListLabel = new FListLabel(metricLabel.unit, jTableHeader, 0);
                headerPanel.add(fListLabel);
                dimension = new Dimension(nArray[2], n4);
                fListLabel.setVerticalAlignment(0);
                fListLabel.setPreferredSize(dimension);
                fListLabel.setMinimumSize(dimension);
                fListLabel.setMaximumSize(dimension);
            }
            if (metricLabel.total != -1.0) {
                fListLabel = new FListLabel("(%)", jTableHeader, 0);
                headerPanel.add(fListLabel);
                dimension = new Dimension(nArray[3], n4);
                fListLabel.setVerticalAlignment(0);
                fListLabel.setPreferredSize(dimension);
                fListLabel.setMinimumSize(dimension);
                fListLabel.setMaximumSize(dimension);
            }
            if (n3 != AnTable.this.name_col) {
                headerPanel.setLayout();
            }
            return headerPanel;
        }
    }

    private class HeaderPanel
    extends JPanel {
        private JPanel sub;
        private int unit_height;
        private int header_height;
        private BoxLayout layout = null;
        private boolean first = true;
        private ImageIcon so_icon;

        public HeaderPanel(Presentation.MetricLabel metricLabel, JTableHeader jTableHeader, int n) {
            Font font;
            this.setBorder(new SoftBevelBorder(0));
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setToolTipText(metricLabel.tip);
            if (AnTable.this.can_sort) {
                if (n == AnTable.this.sort_col) {
                    font = bold_font;
                    this.so_icon = metricLabel.sort_icon;
                } else {
                    font = jTableHeader.getFont();
                    this.so_icon = AnUtility.sono_icon;
                }
            } else {
                font = n == AnTable.this.name_col ? table_font : jTableHeader.getFont();
                this.so_icon = null;
            }
            this.unit_height = font.getSize() + 1;
            if (n == AnTable.this.name_col) {
                this.setHeader(jTableHeader, font);
            } else {
                this.setHeader(jTableHeader, font, metricLabel);
            }
        }

        private void setHeader(JTableHeader jTableHeader, Font font, Presentation.MetricLabel metricLabel) {
            int n;
            this.layout = new BoxLayout(this, 1);
            this.setLayout(this.layout);
            this.header_height = metricLabel.icon != null ? ((n = metricLabel.icon.getIconHeight()) > this.unit_height ? n : this.unit_height) : this.unit_height;
            JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
            jPanel.setForeground(jTableHeader.getForeground());
            jPanel.setBackground(jTableHeader.getBackground());
            FListLabel fListLabel = this.getHeader(metricLabel.title[0], metricLabel.icon, jTableHeader, 0, font);
            jPanel.add(fListLabel);
            int n2 = fListLabel.getPreferredSize().width;
            fListLabel = this.getHeader(metricLabel.title[1], null, jTableHeader, 0, font);
            jPanel.add(fListLabel);
            int n3 = fListLabel.getPreferredSize().width;
            if (n2 < n3) {
                n2 = n3;
            }
            Dimension dimension = new Dimension(n2, 2 * this.header_height);
            jPanel.setPreferredSize(dimension);
            super.add(jPanel);
            this.sub = new JPanel(new FlowLayout(1, 0, 0));
            this.sub.setForeground(jTableHeader.getForeground());
            this.sub.setBackground(jTableHeader.getBackground());
            super.add(this.sub);
        }

        private void setHeader(JTableHeader jTableHeader, Font font) {
            this.setLayout(new GridLayout(3, 1, 0, 0));
            this.header_height = this.unit_height;
            super.add(this.getHeader(AnTable.this.names[0], null, jTableHeader, 2, font));
            super.add(this.getHeader(AnTable.this.names[1], null, jTableHeader, 2, font));
            super.add(this.getHeader(AnTable.this.names[2], this.so_icon, jTableHeader, 2, font));
        }

        private FListLabel getHeader(String string, ImageIcon imageIcon, JTableHeader jTableHeader, int n, Font font) {
            FListLabel fListLabel = new FListLabel(string, jTableHeader, n);
            fListLabel.setVerticalAlignment(0);
            fListLabel.setFont(font);
            if (imageIcon != null) {
                fListLabel.setIcon(imageIcon);
            }
            Dimension dimension = fListLabel.getPreferredSize();
            dimension.height = this.header_height;
            fListLabel.setPreferredSize(dimension);
            return fListLabel;
        }

        public int getUnitHeight() {
            return this.unit_height;
        }

        public void add(JComponent jComponent) {
            if (this.sub != null) {
                if (this.first) {
                    this.first = false;
                    ((FListLabel)jComponent).setIcon(this.so_icon);
                }
                this.sub.add(jComponent);
            }
        }

        public void setLayout() {
            this.layout.layoutContainer(this);
        }
    }

    private class CellRenderer
    implements TableCellRenderer,
    Serializable {
        private CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Dimension dimension;
            FListLabel fListLabel;
            CellPanel cellPanel = new CellPanel(jTable, bl, bl2, object instanceof String ? 0 : 1);
            int n3 = jTable.convertColumnIndexToModel(n2);
            int[] nArray = AnTable.this.col_width[n3];
            int n4 = AnTable.this.model.getSrcType(n);
            if (n4 < 0) {
                n4 = -n4;
                if (n3 != AnTable.this.name_col) {
                    cellPanel.setBackground(AnVariable.HILIT_COLOR);
                }
            }
            if (object instanceof String) {
                FListLabel fListLabel2 = new FListLabel((String)object, jTable, 2);
                cellPanel.add(fListLabel2);
                if (((String)object).startsWith("<")) {
                    fListLabel2.setFont(quote_font);
                }
                Dimension dimension2 = new Dimension(nArray[1], AnTable.this.row_height);
                fListLabel2.setPreferredSize(dimension2);
                fListLabel2.setMinimumSize(dimension2);
                fListLabel2.setMaximumSize(dimension2);
                if (n4 == 4) {
                    fListLabel2.setForeground(AnVariable.CCOMP_COLOR);
                } else if (AnTable.this.type == 4 && (n4 == 1 || n4 == 2)) {
                    fListLabel2.setForeground(AnVariable.DISRC_COLOR);
                } else if (n4 == 5 || n4 == 6) {
                    fListLabel2.setForeground(AnVariable.QUOTE_COLOR);
                    fListLabel2.setFont(quote_font);
                }
                return cellPanel;
            }
            if (n4 == 2 || n4 == 4 || n4 == 6 || n4 == 7) {
                return cellPanel;
            }
            Presentation.MetricLabel metricLabel = AnTable.this.model.getLabel(n3);
            if (metricLabel.clock != -1.0) {
                fListLabel = new FListLabel(((AnObject)object).toFormTime(metricLabel.clock), jTable, 4);
                cellPanel.add(fListLabel);
                dimension = new Dimension(nArray[1], AnTable.this.row_height);
                fListLabel.setPreferredSize(dimension);
                fListLabel.setMinimumSize(dimension);
                fListLabel.setMaximumSize(dimension);
            }
            if (metricLabel.unit != null) {
                fListLabel = new FListLabel(((AnObject)object).toFormString(), jTable, 4);
                cellPanel.add(fListLabel);
                dimension = new Dimension(nArray[2], AnTable.this.row_height);
                fListLabel.setPreferredSize(dimension);
                fListLabel.setMinimumSize(dimension);
                fListLabel.setMaximumSize(dimension);
            }
            if (metricLabel.total != -1.0) {
                fListLabel = new FListLabel(((AnObject)object).toPercent(metricLabel.total), jTable, 4);
                cellPanel.add(fListLabel);
                dimension = new Dimension(nArray[3], AnTable.this.row_height);
                fListLabel.setPreferredSize(dimension);
                fListLabel.setMinimumSize(dimension);
                fListLabel.setMaximumSize(dimension);
            }
            return cellPanel;
        }
    }

    private class CellPanel
    extends JPanel {
        public CellPanel(JTable jTable, boolean bl, boolean bl2, int n) {
            this.setLayout(new FlowLayout(n, 0, 0));
            if (bl || AnTable.this.is_single) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setBorder(bl2 ? AnVariable.tableFocusBorder : AnVariable.noFocusBorder);
        }
    }

    private class FListLabel
    extends JLabel {
        boolean is_number;

        public FListLabel(String string, JComponent jComponent, int n) {
            super(string);
            this.setHorizontalAlignment(n);
            this.setVerticalAlignment(1);
            this.setFont(jComponent.getFont());
            this.setBorder(AnVariable.labelBorder);
            this.setForeground(jComponent.getForeground());
            this.setBackground(jComponent.getBackground());
            this.is_number = jComponent instanceof JTable && n == 4;
        }

        protected void paintComponent(Graphics graphics) {
            if (!this.is_number) {
                super.paintComponent(graphics);
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getAscent();
            int n2 = this.getWidth() - this.getInsets().right;
            String string = this.getText();
            int n3 = string.length() - 1;
            while (n3 >= 0) {
                char c = string.charAt(n3);
                if (c == '@') {
                    n2 -= 3;
                } else {
                    String string2 = String.valueOf(c);
                    graphics.drawString(string2, n2 -= fontMetrics.stringWidth(string2), n);
                }
                --n3;
            }
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == "text") {
                super.firePropertyChange(string, object, object2);
            }
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    private class TableListener
    implements ComponentListener {
        private TableListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            AnTable.this.model.fitColumnResize(-1);
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }
}

