/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnTextIcon;
import com.sun.forte.st.mpmt.AnVariable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class AnTree
extends JTree {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;
    private int expand_row;
    private AnTreeRenderer renderer;

    public AnTree(String string, int n) {
        this.root = new DefaultMutableTreeNode(string, true);
        this.model = new DefaultTreeModel(this.root);
        this.expand_row = n;
        this.model.setAsksAllowsChildren(true);
        this.setModel(this.model);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.renderer = new AnTreeRenderer();
        this.setCellRenderer(this.renderer);
        this.setCellEditor(new AnTreeEditor(this, this.renderer));
    }

    private void addNode(AnTextIcon anTextIcon) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(anTextIcon, true);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(null, false));
        this.root.add(defaultMutableTreeNode);
    }

    public int addExtra(String string, boolean bl) {
        int n;
        if (bl) {
            this.root.removeAllChildren();
            n = 0;
        } else {
            n = this.root.getChildCount();
        }
        if (n == 0) {
            this.addNode(new AnTextIcon(string, null));
            this.model.nodeStructureChanged(this.root);
        } else {
            --n;
        }
        return n;
    }

    public void addNodes(AnTextIcon[] anTextIconArray, int n) {
        int n2 = anTextIconArray.length;
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            nArray[n3++] = n4 + 1;
            this.addNode(anTextIconArray[n4]);
            ++n4;
        }
        this.model.nodesWereInserted(this.root, nArray);
        if (n == 0) {
            this.expandRow(this.expand_row);
        }
    }

    public void removeNodes(int[] nArray) {
        int n = nArray.length;
        if (n >= this.root.getChildCount() - 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(0);
            this.addExtra(((AnTextIcon)defaultMutableTreeNode.getUserObject()).getText(), true);
            return;
        }
        int[] nArray2 = new int[n];
        Object[] objectArray = new Object[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            nArray2[n2] = nArray[n2] + 1;
            objectArray[n2] = this.root.getChildAt(nArray2[n2]);
            this.root.remove(nArray2[n2]);
            --n2;
        }
        this.model.nodesWereRemoved(this.root, nArray2, objectArray);
    }

    public void setContent(int n, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(n);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        defaultMutableTreeNode2.setUserObject(object);
        this.model.nodeChanged(defaultMutableTreeNode2);
    }

    private class AnTreeEditor
    extends DefaultTreeCellEditor {
        public AnTreeEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.editingComponent = this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
            return this.editingComponent;
        }
    }

    private class AnTreeRenderer
    extends DefaultTreeCellRenderer {
        private AnTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Icon icon = null;
            if (object instanceof DefaultMutableTreeNode) {
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 instanceof AnTextIcon) {
                    AnTextIcon anTextIcon = (AnTextIcon)object2;
                    object = anTextIcon.getText();
                    icon = anTextIcon.getIcon();
                } else if (object2 instanceof JComponent) {
                    ((JComponent)object2).setBorder(bl4 ? AnVariable.treeFocusBorder : AnVariable.noFocusBorder);
                    return (Component)object2;
                }
            }
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

