/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnComboBox;
import com.sun.forte.st.mpmt.AnDisplay;
import com.sun.forte.st.mpmt.AnExpChooser;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.Analyzer;
import com.sun.forte.st.mpmt.CallDisp;
import com.sun.forte.st.mpmt.DropSelector;
import com.sun.forte.st.mpmt.ExperimentDisp;
import com.sun.forte.st.mpmt.FilterSelector;
import com.sun.forte.st.mpmt.FuncListDisp;
import com.sun.forte.st.mpmt.LeakListDisp;
import com.sun.forte.st.mpmt.LoadObjectSelector;
import com.sun.forte.st.mpmt.MapfileChooser;
import com.sun.forte.st.mpmt.Presentation;
import com.sun.forte.st.mpmt.PrintChooser;
import com.sun.forte.st.mpmt.StatisticsDisp;
import com.sun.forte.st.mpmt.SummaryDisp;
import com.sun.forte.st.mpmt.timeline.TimelineDisp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnWindow
extends JFrame {
    private static final int PROGRESS_WIDTH = 250;
    private static final int PROGRESS_HEIGHT = 10;
    private static Vector win_list = new Vector();
    private static int cur_id = 0;
    private static DropSelector drop = null;
    private static MapfileChooser mapfile = null;
    private static PrintChooser print = null;
    private static Presentation present = null;
    private static FilterSelector filter = null;
    private static LoadObjectSelector load_object = null;
    private AnWindow window;
    private int win_id;
    private JTabbedPane tab_pane;
    private JProgressBar progress_bar;
    private AnUtility.AnLabel progress_label;
    private SummaryDisp summary;
    private AnDisplay cur_display;
    private FuncListDisp func_list;
    private CallDisp call_list;
    private FuncListDisp src_list;
    private FuncListDisp dis_list;
    private TimelineDisp timeline;
    private StatisticsDisp statistic;
    private ExperimentDisp experiment;
    private LeakListDisp leaklist;
    private MenuAction sel_present;
    private MenuAction sel_filter;
    private MenuAction show_hide_obj;
    private MenuAction find_up;
    private MenuAction find_down;
    private AnComboBox combo;
    private JPanel sel_panel;
    private JTextField sel_func;
    private JLabel sel_space;
    private JSplitPane split_pane;
    private JTabbedPane info_tab_pane;

    public AnWindow() {
        super(AnLocale.getString("Performance Analyzer"));
        win_list.add(this);
        this.window = this;
        this.win_id = cur_id++;
        AnWindow.initWindow(this.win_id);
        this.initComponents();
        this.pack();
        this.cur_display = this.func_list;
        this.addWindowListener(new WindowHandler());
        Dimension dimension = this.getSize();
        int n = 25 * this.win_id;
        this.setLocation(n + (AnVariable.SCREEN_SIZE.width - dimension.width) / 2, n + (AnVariable.SCREEN_SIZE.height - dimension.height) / 2);
        this.setIconImage(AnUtility.anal_icon.getImage());
        this.setVisible(true);
        this.adjustSpace();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        JMenuBar jMenuBar = this.initMenu();
        this.setJMenuBar(jMenuBar);
        container.add((Component)this.initToolBar(), "North");
        container.add((Component)this.initTab(), "Center");
        this.initHelp(jMenuBar);
    }

    private void adjustSpace() {
        int n = this.sel_func.getLocationOnScreen().x - this.combo.getEditorLocation().x;
        Dimension dimension = this.sel_space.getPreferredSize();
        dimension.width += n;
        this.sel_space.setPreferredSize(dimension);
        this.sel_panel.doLayout();
    }

    private JMenuBar initMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(AnLocale.getString("File"));
        jMenuBar.add(jMenu);
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Open Experiment...")));
        jMenuItem.setMnemonic('O');
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Add Experiment...")));
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Drop Experiment...")));
        jMenuItem.setMnemonic('D');
        jMenu.insertSeparator(4);
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Create Mapfile...")));
        jMenuItem.setMnemonic('M');
        jMenu.insertSeparator(6);
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Print...")));
        jMenuItem.setMnemonic('P');
        jMenu.insertSeparator(8);
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Create New Window")));
        jMenuItem.setMnemonic('N');
        jMenu.insertSeparator(10);
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Close")));
        jMenuItem.setMnemonic('C');
        jMenuItem = jMenu.add(new MenuAction(AnLocale.getString("Exit")));
        jMenuItem.setMnemonic('x');
        JMenu jMenu2 = new JMenu(AnLocale.getString("View"));
        jMenuBar.add(jMenu2);
        jMenu2.setMnemonic('V');
        this.sel_present = new MenuAction(AnLocale.getString("Set Data Presentation..."), AnUtility.pres_icon);
        jMenuItem = jMenu2.add(this.sel_present);
        jMenuItem.setMnemonic('P');
        this.sel_filter = new MenuAction(AnLocale.getString("Filter Data..."), AnUtility.filt_icon);
        jMenuItem = jMenu2.add(this.sel_filter);
        jMenuItem.setMnemonic('F');
        this.show_hide_obj = new MenuAction(AnLocale.getString("Show/Hide Functions..."), AnUtility.epcl_icon);
        jMenuItem = jMenu2.add(this.show_hide_obj);
        jMenuItem.setMnemonic('S');
        return jMenuBar;
    }

    private void initHelp(JMenuBar jMenuBar) {
        this.sel_func = (JTextField)AnUtility.getText("", 50);
        this.sel_func.setBorder(null);
        JLabel jLabel = (JLabel)AnUtility.getItem(AnLocale.getString("Selected Function/Load-Object:"));
        jLabel.setDisplayedMnemonic('S');
        jLabel.setLabelFor(this.sel_func);
        this.sel_panel = new JPanel(new FlowLayout(2, 0, 1));
        this.sel_panel.add(jLabel);
        this.sel_panel.add(this.sel_func);
        this.sel_space = new JLabel("");
        this.sel_panel.add(this.sel_space);
        jMenuBar.add(this.sel_panel);
        if (Analyzer.help_broker != null) {
            Analyzer.help_broker.enableHelpKey(this.getContentPane(), AnLocale.getString("Performance Analyzer"), null);
            JMenu jMenu = new JMenu(AnLocale.getString("Help"));
            jMenuBar.add(jMenu);
            jMenu.setMnemonic('H');
            CSH.DisplayHelpFromSource displayHelpFromSource = new CSH.DisplayHelpFromSource(Analyzer.help_broker);
            JMenuItem jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("Performance Analyzer")));
            CSH.setHelpIDString(jMenuItem, "Welcome_Analyzer");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('P');
            jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("New Features")));
            CSH.setHelpIDString(jMenuItem, "Welcome_WhatsNew");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('N');
            jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("Quick Reference")));
            CSH.setHelpIDString(jMenuItem, "Navigate_QuickRef");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('Q');
            jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("Keyboard Shortcuts")));
            CSH.setHelpIDString(jMenuItem, "Navigate_Keyboard");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('K');
            jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("Help Shortcuts")));
            CSH.setHelpIDString(jMenuItem, "Navigate_KbdNavHelp");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('S');
            jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("Troubleshooting")));
            CSH.setHelpIDString(jMenuItem, "Trouble_Trouble");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('r');
            jMenuItem = jMenu.add(new JMenuItem(AnLocale.getString("Tutorial")));
            CSH.setHelpIDString(jMenuItem, "Tutorial_Intro");
            jMenuItem.addActionListener(displayHelpFromSource);
            jMenuItem.setMnemonic('T');
        }
    }

    private JPanel initToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.sel_present.setToolButton(jToolBar);
        this.sel_filter.setToolButton(jToolBar);
        this.show_hide_obj.setToolButton(jToolBar);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.add(jToolBar);
        this.combo = new AnComboBox();
        this.combo.add(0, AnLocale.getString("Text:"), "");
        this.combo.add(1, AnLocale.getString("High Metric Value"), "");
        this.combo.setEnabled(false);
        this.combo.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getID() == 1001) {
                    AnWindow.this.find(AnWindow.this.combo.getText(), true);
                }
            }
        });
        JLabel jLabel = (JLabel)AnUtility.getTitle(AnLocale.getString("Find"));
        jLabel.setDisplayedMnemonic('d');
        jLabel.setLabelFor(this.combo.getEditorText());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(jLabel);
        jPanel2.add(this.combo);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 2, 2));
        jPanel3.add(jPanel2);
        this.find_up = new MenuAction(AnLocale.getString("Find Previous"), AnUtility.prev_icon);
        jPanel3.add(this.find_up.getButton());
        this.find_down = new MenuAction(AnLocale.getString("Find Next"), AnUtility.next_icon);
        jPanel3.add(this.find_down.getButton());
        Dimension dimension = jPanel.getPreferredSize();
        dimension.height = jPanel3.getPreferredSize().height;
        jPanel.setPreferredSize(dimension);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel, "West");
        jPanel4.add((Component)jPanel3, "East");
        dimension = jPanel4.getPreferredSize();
        dimension.width = 700;
        jPanel4.setPreferredSize(dimension);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        this.progress_bar = new JProgressBar();
        dimension = this.progress_bar.getPreferredSize();
        dimension.height = 10;
        this.progress_bar.setPreferredSize(dimension);
        this.progress_bar.setBorderPainted(false);
        jPanel5.add(this.progress_bar);
        this.progress_label = (AnUtility.AnLabel)AnUtility.getTitle("");
        jPanel5.add(this.progress_label);
        dimension = jPanel5.getPreferredSize();
        dimension.width = 250;
        jPanel5.setPreferredSize(dimension);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel4, "West");
        jPanel6.add((Component)jPanel5, "East");
        return jPanel6;
    }

    private JSplitPane initTab() {
        this.tab_pane = new JTabbedPane();
        this.info_tab_pane = new JTabbedPane();
        if (this.win_id == 0) {
            drop = new DropSelector(this.win_id, this);
            print = new PrintChooser(this.win_id, this);
            mapfile = new MapfileChooser(this.win_id, this);
            present = new Presentation(this.win_id, this);
            filter = new FilterSelector(this.win_id, this);
            load_object = new LoadObjectSelector(this.win_id, this);
        }
        this.summary = new SummaryDisp(this.win_id, "Tabs_Summary");
        this.func_list = new FuncListDisp(this.win_id, 1, true, "Tabs_Functions");
        this.func_list.setValue(present);
        this.tab_pane.addTab(AnLocale.getString("Functions"), this.func_list);
        this.call_list = new CallDisp(this.win_id, 6, false, "Tabs_CallersCallees");
        this.call_list.setValue(present);
        this.tab_pane.addTab(AnLocale.getString("Callers-Callees"), this.call_list);
        this.src_list = new FuncListDisp(this.win_id, 3, false, "Tabs_Source");
        this.src_list.setValue(present);
        this.tab_pane.addTab(AnLocale.getString("Source"), this.src_list);
        this.dis_list = new FuncListDisp(this.win_id, 4, false, "Tabs_Disassembly");
        this.dis_list.setValue(present);
        this.tab_pane.addTab(AnLocale.getString("Disassembly"), this.dis_list);
        this.timeline = new TimelineDisp(this.win_id, 9, false, "Tabs_Timeline");
        this.tab_pane.addTab(AnLocale.getString("Timeline"), this.timeline);
        this.leaklist = new LeakListDisp(this.win_id, 12, false, "Tabs_Leaklist");
        this.tab_pane.addTab(AnLocale.getString("LeakList"), this.leaklist);
        this.statistic = new StatisticsDisp(this.win_id, 10, false, "Tabs_Statistics");
        this.tab_pane.addTab(AnLocale.getString("Statistics"), this.statistic);
        this.experiment = new ExperimentDisp(this.win_id, 11, false, "Tabs_Experiments");
        this.tab_pane.addTab(AnLocale.getString("Experiments"), this.experiment);
        this.tab_pane.addChangeListener(new DisplayHandler());
        this.info_tab_pane.insertTab(AnLocale.getString("Summary"), null, this.summary, "", 0);
        this.split_pane = new JSplitPane(1, this.tab_pane, this.info_tab_pane);
        this.split_pane.setContinuousLayout(true);
        this.split_pane.setOneTouchExpandable(true);
        this.split_pane.setDividerSize(8);
        this.split_pane.setDividerLocation(700);
        this.split_pane.setResizeWeight(1.0);
        return this.split_pane;
    }

    public JSplitPane getSplitPane() {
        return this.split_pane;
    }

    public JTabbedPane getInfoTabPane() {
        return this.info_tab_pane;
    }

    public static AnWindow get_win(int n) {
        int n2 = win_list.size();
        int n3 = 0;
        while (n3 < n2) {
            AnWindow anWindow = (AnWindow)win_list.elementAt(n3);
            if (anWindow.win_id == n) {
                return anWindow;
            }
            ++n3;
        }
        return (AnWindow)win_list.elementAt(0);
    }

    public static void clearAll() {
        int n = win_list.size();
        int n2 = 0;
        while (n2 < n) {
            AnWindow anWindow = (AnWindow)win_list.elementAt(n2);
            ((AnDisplay)anWindow.tab_pane.getSelectedComponent()).clear();
            ++n2;
        }
    }

    public void recompute() {
        String string;
        String[] stringArray = AnUtility.getExpName();
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            string = " - " + string;
        } else {
            string = "";
        }
        string = AnLocale.getString("Performance Analyzer") + string;
        if (stringArray != null && stringArray.length > 1) {
            string = string + ", ...";
        }
        this.setTitle(string);
        if (this.win_id == 0) {
            drop.setComponents();
            print.setComponents();
            mapfile.setComponents();
            present.setComponents();
            filter.setComponents();
            load_object.setComponents();
        }
        this.compute();
    }

    public void compute() {
        this.func_list.setComputed(false);
        this.call_list.setComputed(false);
        this.src_list.setComputed(false);
        this.dis_list.setComputed(false);
        this.timeline.setComputed(false);
        this.leaklist.setComputed(false);
        this.statistic.setComputed(false);
        this.experiment.setComputed(false);
        ((AnDisplay)this.tab_pane.getSelectedComponent()).compute(null);
    }

    public static void recomputeAll() {
        int n = win_list.size();
        int n2 = 0;
        while (n2 < n) {
            AnWindow anWindow = (AnWindow)win_list.elementAt(n2);
            anWindow.summary.reset();
            anWindow.recompute();
            ++n2;
        }
    }

    public static void computeAll() {
        int n = win_list.size();
        int n2 = 0;
        while (n2 < n) {
            final AnWindow anWindow = (AnWindow)win_list.elementAt(n2);
            anWindow.compute();
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = AnVariable.worker_lock;
                    synchronized (object) {
                        anWindow.setBusyCursor(true);
                        anWindow.update_func();
                        anWindow.setBusyCursor(false);
                    }
                }
            };
            thread.start();
            ++n2;
        }
    }

    public static void addExperiment(boolean bl) {
        int n = win_list.size();
        int n2 = 0;
        while (n2 < n) {
            AnWindow anWindow = (AnWindow)win_list.elementAt(n2);
            anWindow.statistic.addExperiment(bl);
            anWindow.experiment.addExperiment(bl);
            ++n2;
        }
    }

    public static void dropExperiment(int[] nArray) {
        int n = win_list.size();
        int n2 = 0;
        while (n2 < n) {
            AnWindow anWindow = (AnWindow)win_list.elementAt(n2);
            anWindow.statistic.dropExperiment(nArray);
            anWindow.experiment.dropExperiment(nArray);
            ++n2;
        }
    }

    public String print(String string, String string2) {
        return ((AnDisplay)this.tab_pane.getSelectedComponent()).print(string, string2);
    }

    public void setSelFunc(String string) {
        this.sel_func.setText(string);
    }

    public int getFuncIndex() {
        return this.func_list.getSelectedRow();
    }

    public void setFuncIndex(int n) {
        this.setSelFunc(this.func_list.setSelectedRow(n));
    }

    public void update_func() {
        boolean bl = this.func_list.isSelected();
        this.func_list.setSelected(true);
        this.func_list.doCompute(null);
        this.func_list.setSelected(bl);
    }

    public void update_summary(int n, int n2) {
        this.summary.doCompute(n, n2);
    }

    public void openExpList(Vector vector, boolean bl) {
        final int n = vector.size();
        final Vector vector2 = vector;
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n == 0) {
                    AnWindow.this.loadExp(AnLocale.getString("Open Experiment"), true);
                    return;
                }
                Thread thread = new Thread(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = AnVariable.worker_lock;
                        synchronized (object) {
                            AnWindow.access$500(3.access$400(this.this$1)).setBusyCursor(true);
                            3.access$400(this.this$1).doOpenExpList(3.access$600(this.this$1), 3.access$700(this.this$1), 3.access$800(this.this$1));
                            AnWindow.access$500(3.access$400(this.this$1)).setBusyCursor(false);
                        }
                    }
                };
                thread.start();
            }

            static /* synthetic */ AnWindow access$400(3 var0) {
                return var0.AnWindow.this;
            }

            static /* synthetic */ int access$600(3 var0) {
                return var0.n;
            }

            static /* synthetic */ Vector access$700(3 var0) {
                return var0.vector2;
            }

            static /* synthetic */ boolean access$800(3 var0) {
                return var0.bl2;
            }
        });
    }

    public void doOpenExpList(int n, Vector vector, boolean bl) {
        AnWindow.clearAll();
        this.showError(AnUtility.openExperiment(n, vector, bl));
        AnWindow.addExperiment(bl);
        AnWindow.recomputeAll();
    }

    private void loadExp(String string, boolean bl) {
        AnExpChooser anExpChooser = new AnExpChooser(this.win_id, string, bl);
        anExpChooser.showOpenDialog(this);
    }

    public void setSelectedDisplay(AnDisplay anDisplay) {
        this.tab_pane.setSelectedComponent(anDisplay);
    }

    public void find(String string, boolean bl) {
        if (string != null && string.length() == 0) {
            return;
        }
        int n = ((AnDisplay)this.tab_pane.getSelectedComponent()).find(string, bl);
        if (n == -1) {
            this.showError(string == null ? AnLocale.getString("Not found") : AnLocale.getString("String not found: ") + string);
        }
    }

    private void close() {
        if (win_list.size() == 1) {
            System.exit(0);
        }
        win_list.remove(this);
        AnWindow.disposeWindow(this.win_id);
        this.dispose();
    }

    public void appendLog(String string) {
        this.experiment.appendLog(string);
    }

    public void showError(String string) {
        if (string != null) {
            this.appendLog(AnLocale.getString("Error: ") + string);
            AnWindow.showMsg(this.window, string, AnLocale.getString("Error"), 0);
        }
    }

    public void showWarning(String string) {
        if (string != null) {
            this.appendLog(AnLocale.getString("Warning: ") + string);
            AnWindow.showMsg(this.window, string, AnLocale.getString("Warning"), 2);
        }
    }

    public static void showMsg(Component component, String string, String string2, int n) {
        final Component component2 = component;
        final String string3 = string;
        final String string4 = string2;
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(component2, string3, string4, n2);
            }
        });
    }

    public void setBusyCursor(boolean bl) {
        this.setCursor(bl ? AnUtility.wait_cursor : AnUtility.norm_cursor);
    }

    public void setProgress(int n, String string) {
        this.progress_bar.setBorderPainted(n != 0);
        this.progress_bar.setValue(n);
        if (string != null) {
            this.progress_label.setText(string);
        }
    }

    private static native void initWindow(int var0);

    private static native void disposeWindow(int var0);

    static /* synthetic */ AnWindow access$500(AnWindow anWindow) {
        return anWindow.window;
    }

    static /* synthetic */ AnDisplay access$1000(AnWindow anWindow) {
        return anWindow.cur_display;
    }

    static /* synthetic */ MenuAction access$1100(AnWindow anWindow) {
        return anWindow.show_hide_obj;
    }

    static /* synthetic */ MenuAction access$1200(AnWindow anWindow) {
        return anWindow.sel_present;
    }

    static /* synthetic */ MenuAction access$1300(AnWindow anWindow) {
        return anWindow.find_up;
    }

    static /* synthetic */ MenuAction access$1400(AnWindow anWindow) {
        return anWindow.find_down;
    }

    static /* synthetic */ AnDisplay access$1002(AnWindow anWindow, AnDisplay anDisplay) {
        anWindow.cur_display = anDisplay;
        return anWindow.cur_display;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AnWindow.this.close();
        }
    }

    private class MenuAction
    extends AbstractAction {
        public MenuAction(String string) {
            super(string);
        }

        public MenuAction(String string, Icon icon) {
            super(string, icon);
        }

        public JButton setToolButton(JToolBar jToolBar) {
            JButton jButton = jToolBar.add(this);
            String string = (String)this.getValue("Name");
            jButton.setMargin(AnVariable.buttonMargin);
            jButton.setActionCommand(string);
            String string2 = AnLocale.getString("...");
            if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - string2.length());
            }
            jButton.setToolTipText(string);
            return jButton;
        }

        public JButton getButton() {
            JButton jButton = new JButton((Icon)this.getValue("SmallIcon"));
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
            jButton.setMargin(AnVariable.buttonMargin);
            jButton.setAction(this);
            String string = (String)this.getValue("Name");
            jButton.setActionCommand(string);
            jButton.setToolTipText(string);
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(AnLocale.getString("Open Experiment..."))) {
                AnWindow.this.loadExp(AnLocale.getString("Open Experiment"), true);
            } else if (string.equals(AnLocale.getString("Add Experiment..."))) {
                AnWindow.this.loadExp(AnLocale.getString("Add Experiment"), false);
            } else if (string.equals(AnLocale.getString("Drop Experiment..."))) {
                drop.setVisible(true);
            } else if (string.equals(AnLocale.getString("Create Mapfile..."))) {
                mapfile.setVisible(true);
            } else if (string.equals(AnLocale.getString("Print..."))) {
                print.setVisible(true);
            } else if (string.equals(AnLocale.getString("Create New Window"))) {
                AnWindow anWindow = new AnWindow();
                anWindow.statistic.addExperiment(true);
                anWindow.experiment.addExperiment(true);
                anWindow.recompute();
            } else if (string.equals(AnLocale.getString("Set Data Presentation..."))) {
                present.setVisible(true);
            } else if (string.equals(AnLocale.getString("Filter Data..."))) {
                filter.setVisible(true);
            } else if (string.equals(AnLocale.getString("Show/Hide Functions..."))) {
                load_object.setVisible(true);
            } else if (string.equals(AnLocale.getString("Find Previous"))) {
                AnWindow.this.find(AnWindow.this.combo.getText(), false);
            } else if (string.equals(AnLocale.getString("Find Next"))) {
                AnWindow.this.find(AnWindow.this.combo.getText(), true);
            } else if (string.equals(AnLocale.getString("Close"))) {
                AnWindow.this.close();
            } else if (string.equals(AnLocale.getString("Exit"))) {
                System.exit(0);
            }
        }
    }

    private class DisplayHandler
    implements ChangeListener {
        private DisplayHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            int n = jTabbedPane.getTabCount();
            SwingUtilities.invokeLater(new Runnable(this, n, jTabbedPane){
                private final /* synthetic */ int val$size;
                private final /* synthetic */ JTabbedPane val$src;
                private final /* synthetic */ DisplayHandler this$1;
                {
                    this.this$1 = displayHandler;
                    this.val$size = n;
                    this.val$src = jTabbedPane;
                }

                public void run() {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    int n = 0;
                    while (n < this.val$size) {
                        ((AnDisplay)this.val$src.getComponentAt(n)).setSelected(false);
                        ++n;
                    }
                    AnDisplay anDisplay = (AnDisplay)this.val$src.getSelectedComponent();
                    anDisplay.setSelected(true);
                    anDisplay.compute(AnWindow.access$1000(DisplayHandler.access$900(this.this$1)));
                    int n2 = anDisplay.getType();
                    if (n2 == 1 || n2 == 6) {
                        bl4 = true;
                        bl3 = true;
                        bl2 = true;
                        bl = false;
                    } else {
                        bl2 = false;
                        if (n2 == 2) {
                            bl4 = true;
                            bl3 = true;
                            bl = false;
                        } else if (n2 == 3 || n2 == 4) {
                            bl4 = true;
                            bl = true;
                            bl3 = true;
                        } else {
                            bl4 = false;
                            bl = false;
                            bl3 = false;
                        }
                    }
                    AnWindow.access$1100(DisplayHandler.access$900(this.this$1)).setEnabled(bl2);
                    AnWindow.access$1200(DisplayHandler.access$900(this.this$1)).setEnabled(bl3);
                    int n3 = AnWindow.access$100(DisplayHandler.access$900(this.this$1)).getSelectedIndex();
                    AnWindow.access$1000(DisplayHandler.access$900(this.this$1)).setFindType(n3);
                    if (!bl) {
                        AnWindow.access$100(DisplayHandler.access$900(this.this$1)).setSelectedIndex(0);
                    } else {
                        n2 = anDisplay.getFindType();
                        if (n2 == -1) {
                            n2 = n3;
                            anDisplay.setFindType(n2);
                        }
                        AnWindow.access$100(DisplayHandler.access$900(this.this$1)).setSelectedIndex(n2);
                    }
                    AnWindow.access$100(DisplayHandler.access$900(this.this$1)).setEnabled(bl);
                    AnWindow.access$100(DisplayHandler.access$900(this.this$1)).getEditorText().setEnabled(bl4);
                    AnWindow.access$1300(DisplayHandler.access$900(this.this$1)).setEnabled(bl4);
                    AnWindow.access$1400(DisplayHandler.access$900(this.this$1)).setEnabled(bl4);
                    AnWindow.access$1002(DisplayHandler.access$900(this.this$1), anDisplay);
                }
            });
        }

        static /* synthetic */ AnWindow access$900(DisplayHandler displayHandler) {
            return displayHandler.AnWindow.this;
        }
    }
}

