/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnDisplay;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnListener;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnObject;
import com.sun.forte.st.mpmt.AnTable;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.FuncListDisp;
import com.sun.forte.st.mpmt.Presentation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;

public class CallDisp
extends FuncListDisp {
    private static final int CALLER_MIN_HEIGHT = 80;
    private static final int CALLEE_MIN_HEIGHT = 60;
    private AnTable caller;
    private AnTable func_item;
    private AnTable callee;
    private Object[][] caller_data = null;
    private Object[][] func_data = null;
    private Object[][] callee_data = null;

    public CallDisp(int n, int n2, boolean bl, String string) {
        super(n, n2, bl, string);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.table = this.caller = new AnTable(6, true, true, false, false, false);
        this.caller.addAnListener(new TableHandler());
        this.func_item = new AnTable(5, false, true, true, false, true);
        this.func_item.setHeader(this.caller);
        this.callee = new AnTable(7, false, true, false, true, false);
        this.callee.setHeader(this.caller);
        this.callee.addAnListener(new TableHandler());
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(AnUtility.calr_icon);
        jLabel.setToolTipText(AnLocale.getString("Callers"));
        jLabel.setBorder(new EmptyBorder(40, 1, 0, 1));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.caller, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jLabel = new JLabel(AnUtility.func_icon);
        jLabel.setToolTipText(AnLocale.getString("Selected Function"));
        jLabel.setBorder(AnVariable.iconBorder);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.func_item, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jLabel = new JLabel(AnUtility.cale_icon);
        jLabel.setToolTipText(AnLocale.getString("Callees"));
        jLabel.setBorder(AnVariable.iconBorder);
        jPanel3.add((Component)jLabel, "West");
        jPanel3.add((Component)this.callee, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 4));
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "Center");
        Dimension dimension = jPanel.getMinimumSize();
        dimension.height = 80;
        jPanel.setMinimumSize(dimension);
        dimension = jPanel4.getMinimumSize();
        dimension.height = 60;
        jPanel4.setMinimumSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel4);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(8);
        jSplitPane.setDividerLocation(225);
        this.add((Component)jSplitPane, "Center");
    }

    public void clear() {
        this.caller.removeAll();
        this.func_item.removeAll();
        this.callee.removeAll();
    }

    public void reset() {
        this.caller.removeAllRows();
        this.func_item.removeAllRows();
        this.callee.removeAllRows();
    }

    public void doCompute(AnDisplay anDisplay) {
        if (!this.selected) {
            return;
        }
        int n = this.window.getFuncIndex();
        if (this.sel_ind != n) {
            this.sel_ind = n;
            this.computed = false;
        }
        if (!this.computed) {
            this.window.update_func();
            this.sel_ind = this.window.getFuncIndex();
        }
        Presentation.MetricLabel[] metricLabelArray = null;
        Presentation.MetricLabel[] metricLabelArray2 = null;
        Presentation.MetricLabel[] metricLabelArray3 = null;
        if (!this.computed) {
            this.reset();
            int n2 = FuncListDisp.getFuncData(this.win_id, this.sel_ind, this.type);
            String string = AnDisplay.errorMsg(this.win_id, n2);
            if (string == null) {
                this.showWarning(AnDisplay.warningMsg(this.win_id));
                this.table = this.caller;
                this.table.setViewport();
                Object[] objectArray = CallDisp.getCallerList(this.win_id);
                this.caller_data = this.processData(objectArray);
                int[] nArray = (int[])objectArray[objectArray.length - 1];
                metricLabelArray3 = this.present.getLabel(this.caller_data, FuncListDisp.getTotalMax(this.win_id, 6), true, this.caller);
                this.name_col = this.present.getNameCol();
                this.names = FuncListDisp.getNames(this.win_id, this.type);
                int n3 = this.present.getSortCol(true);
                this.caller.setData(metricLabelArray3, this.caller_data, this.names, nArray, 0, this.name_col, n3);
                objectArray = CallDisp.getFuncItem(this.win_id);
                this.func_data = this.processData(objectArray);
                int[] nArray2 = (int[])objectArray[objectArray.length - 1];
                metricLabelArray2 = this.present.getLabel(this.func_data, FuncListDisp.getTotalMax(this.win_id, 5), true, this.func_item);
                this.func_item.setData(metricLabelArray2, this.func_data, this.names, nArray2, 0, this.name_col, n3);
                objectArray = CallDisp.getCalleeList(this.win_id);
                this.callee_data = this.processData(objectArray);
                int[] nArray3 = (int[])objectArray[objectArray.length - 1];
                metricLabelArray = this.present.getLabel(this.callee_data, FuncListDisp.getTotalMax(this.win_id, 7), true, this.callee);
                this.callee.setData(metricLabelArray, this.callee_data, this.names, nArray3, 0, this.name_col, n3);
            } else {
                this.window.appendLog(AnLocale.getString("Error: ") + string);
                this.table.showError(string);
            }
        } else if (!this.updated) {
            metricLabelArray3 = this.present.getLabel(this.caller_data, FuncListDisp.getTotalMax(this.win_id, 6), true, this.caller);
            this.caller.setLabel(metricLabelArray3);
            metricLabelArray2 = this.present.getLabel(this.func_data, FuncListDisp.getTotalMax(this.win_id, 5), true, this.func_item);
            this.func_item.setLabel(metricLabelArray2);
            metricLabelArray = this.present.getLabel(this.callee_data, FuncListDisp.getTotalMax(this.win_id, 7), true, this.callee);
            this.callee.setLabel(metricLabelArray);
        }
        if (metricLabelArray3 != null) {
            int n4;
            int n5;
            AnObject anObject;
            int n6;
            int[][] nArray = this.caller.getColWidth();
            int[][] nArray4 = this.func_item.getColWidth();
            int[][] nArray5 = this.callee.getColWidth();
            AnObject anObject2 = metricLabelArray3[this.name_col].max_obj;
            int n7 = this.caller.stringWidth(anObject2.toString());
            if (n7 < (n6 = this.func_item.stringWidth((anObject = metricLabelArray2[this.name_col].max_obj).toString()))) {
                n7 = n6;
                anObject2 = anObject;
            }
            if (n7 < (n6 = this.callee.stringWidth((anObject = metricLabelArray[this.name_col].max_obj).toString()))) {
                n7 = n6;
                anObject2 = anObject;
            }
            if ((n5 = this.caller.getRowHeight()) < (n4 = this.func_item.getRowHeight())) {
                n5 = n4;
            }
            if (n5 < (n4 = this.callee.getRowHeight())) {
                n5 = n4;
            }
            metricLabelArray2[this.name_col].max_obj = metricLabelArray[this.name_col].max_obj = anObject2;
            metricLabelArray3[this.name_col].max_obj = metricLabelArray[this.name_col].max_obj;
            int n8 = 0;
            while (n8 < nArray.length) {
                int n9 = 0;
                while (n9 < 4) {
                    if (nArray[n8][n9] < nArray4[n8][n9]) {
                        nArray[n8][n9] = nArray4[n8][n9];
                    }
                    if (nArray[n8][n9] < nArray5[n8][n9]) {
                        nArray[n8][n9] = nArray5[n8][n9];
                    }
                    ++n9;
                }
                ++n8;
            }
            this.caller.setColumn(metricLabelArray3, n5, nArray);
            this.func_item.setColumn(metricLabelArray2, n5, nArray);
            this.callee.setColumn(metricLabelArray, n5, nArray);
            this.caller.clearSelectedRow();
            this.callee.clearSelectedRow();
            this.window.update_summary(this.sel_ind, 1);
        }
        this.computed = true;
        this.updated = true;
    }

    public int find(String string, boolean bl) {
        if (string == null) {
            return -1;
        }
        this.table.clearSelection();
        AnTable anTable = this.table == this.caller ? this.callee : this.caller;
        int n = this.table.findAfter(string, bl);
        if (n == -1) {
            n = anTable.findBefore(string, bl);
            if (n == -1) {
                n = anTable.findAfter(string, bl);
                if (n == -1) {
                    n = this.table.findBefore(string, bl);
                } else {
                    this.table = anTable;
                }
            } else {
                this.table = anTable;
            }
        }
        if (n != -1) {
            this.setCurrent(n);
        }
        return n;
    }

    public void sort(int n) {
        this.caller.sort(n);
        this.callee.sort(n);
    }

    private static Object[] getFuncItem(int n) {
        return FuncListDisp.getFuncList(n, 5);
    }

    private static Object[] getCallerList(int n) {
        return FuncListDisp.getFuncList(n, 6);
    }

    private static Object[] getCalleeList(int n) {
        return FuncListDisp.getFuncList(n, 7);
    }

    private class TableHandler
    implements AnListener {
        private TableHandler() {
        }

        public void valueChanged(AnEvent anEvent) {
            AnTable anTable = (AnTable)anEvent.getSource();
            switch (anEvent.getType()) {
                case 8: {
                    anTable.clearSelectedRow();
                    int n = AnDisplay.findFuncIndex(CallDisp.this.win_id, anEvent.getValue(), CallDisp.this.caller == anTable ? 6 : 7);
                    if (n == -1) break;
                    CallDisp.this.window.setFuncIndex(n);
                    CallDisp.this.compute(null);
                    break;
                }
                case 9: {
                    if (anTable == CallDisp.this.caller) {
                        CallDisp.this.callee.sort(anEvent.getValue());
                    }
                    CallDisp.this.present.updateSortList(anEvent.getAux(), CallDisp.this.type);
                    break;
                }
                case 11: {
                    if (anTable != CallDisp.this.callee) break;
                    CallDisp.this.caller.setScroll(anEvent.getValue());
                    CallDisp.this.func_item.setScroll(anEvent.getValue());
                    break;
                }
                case 12: {
                    int n = anEvent.getValue();
                    int n2 = anEvent.getAux();
                    if (anTable == CallDisp.this.caller) {
                        CallDisp.this.func_item.moveColumn(n, n2);
                        CallDisp.this.callee.moveColumn(n, n2);
                    }
                    CallDisp.this.present.updateOrderList(n, n2, CallDisp.this.type);
                    break;
                }
                case 13: {
                    if (anTable != CallDisp.this.caller) break;
                    int n = anEvent.getValue();
                    int n3 = anEvent.getAux();
                    CallDisp.this.func_item.setColumnWidth(n, n3);
                    CallDisp.this.callee.setColumnWidth(n, n3);
                }
            }
        }
    }
}

