/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnTextIcon;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class DropSelector
extends AnDialog {
    private JList list;

    public DropSelector(int n, JFrame jFrame) {
        super(n, jFrame, AnLocale.getString("Drop Experiment"), false, null, null, null);
        this.initComponents();
    }

    private void initComponents() {
        this.list = new JList();
        JLabel jLabel = this.setLabel(AnLocale.getString("Experiments:"));
        jLabel.setDisplayedMnemonic('E');
        jLabel.setLabelFor(this.list);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.list.setCellRenderer(new ListRenderer());
        this.setAccessory(jScrollPane);
    }

    public void setComponents() {
        AnTextIcon[] anTextIconArray = AnUtility.getExperimentList();
        if (anTextIconArray == null) {
            this.list.setListData(new AnTextIcon[0]);
            return;
        }
        this.list.setListData(anTextIconArray);
        this.list.setSelectedIndex(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final int[] nArray = this.list.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AnVariable.worker_lock;
                synchronized (object) {
                    AnWindow.dropExperiment(nArray);
                    DropSelector.this.window.setBusyCursor(true);
                    DropSelector.this.doDropExperiment(nArray);
                    DropSelector.this.window.setBusyCursor(false);
                }
            }
        };
        thread.start();
    }

    public void doDropExperiment(int[] nArray) {
        this.showError(AnUtility.dropExperiment(nArray));
        AnWindow.recomputeAll();
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            AnTextIcon anTextIcon = (AnTextIcon)object;
            super.getListCellRendererComponent((JList<?>)jList, anTextIcon.getText(), n, bl, bl2);
            this.setIcon(anTextIcon.getIcon());
            return this;
        }
    }
}

