/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnDisplay;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnTextIcon;
import com.sun.forte.st.mpmt.AnTree;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.Analyzer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class ExperimentDisp
extends AnDisplay {
    private AnTree tree;
    private AnUtility.AnTextArea log;

    public ExperimentDisp(int n, int n2, boolean bl, String string) {
        super(n, n2, bl, string);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)AnUtility.getTitle(Analyzer.fdversion + " (" + Analyzer.fdhome + ")"), "North");
        this.tree = new AnTree(AnLocale.getString("Experiments"), 2);
        this.log = new AnUtility.AnTextArea(null);
        JLabel jLabel = (JLabel)AnUtility.getTitle(AnLocale.getString("Error/Warning Logs:"));
        jLabel.setDisplayedMnemonic('L');
        jLabel.setLabelFor(this.log);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)new JScrollPane(this.log), "Center");
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.tree), jPanel);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(8);
        jSplitPane.setDividerLocation(315);
        this.add((Component)jSplitPane, "Center");
    }

    public void addExperiment(boolean bl) {
        AnTextIcon[] anTextIconArray = AnUtility.getExperimentList();
        if (anTextIconArray == null) {
            return;
        }
        int n = this.tree.addExtra(AnLocale.getString("Load Objects"), bl);
        this.tree.addNodes(anTextIconArray, n);
    }

    public void dropExperiment(int[] nArray) {
        this.tree.removeNodes(nArray);
    }

    public void appendLog(String string) {
        this.log.append(AnUtility.trimNewLine(string) + "\n");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension dimension = ExperimentDisp.this.log.getPreferredSize();
                Rectangle rectangle = new Rectangle(0, dimension.height, 1, 1);
                ExperimentDisp.this.log.scrollRectToVisible(rectangle);
            }
        });
    }

    public void doCompute(AnDisplay anDisplay) {
        if (!this.selected) {
            return;
        }
        if (!this.computed) {
            String[] stringArray = AnUtility.getExpInfo();
            if (stringArray != null) {
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JPanel jPanel = new JPanel(new FlowLayout(0, 2, 2));
                    jPanel.setBorder(new EtchedBorder(1));
                    jPanel.add(new AnUtility.AnTextArea(AnUtility.trimNewLine(stringArray[n2])));
                    this.tree.setContent(n2, jPanel);
                    ++n2;
                }
            }
        } else if (!this.updated) {
            // empty if block
        }
        this.tree.setSelectionRow(0);
        this.computed = true;
        this.updated = true;
    }
}

