/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnCheckList;
import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnListener;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FilterSelector
extends AnDialog
implements ListSelectionListener,
AnListener {
    private static final String[] aux = new String[]{AnLocale.getString("Default")};
    private static final char[] mnemonic = new char[]{'f'};
    private static final int SAMPLES_SEL = 1;
    private static final int THREADS_SEL = 2;
    private static final int LWPS_SEL = 3;
    private static final int SELECT_ALL = 4;
    private static final int CLEAR_ALL = 5;
    private static final int REVERSE_SEL = 6;
    private static final int ENABLE_ALL = 7;
    private static final int DISABLE_ALL = 8;
    private static final int ENABLE_SEL = 9;
    private static final int DISABLE_SEL = 10;
    private static final int SAMPLE_ALL = 11;
    private static final int THREAD_ALL = 12;
    private static final int LWP_ALL = 13;
    private static final int DEFAULT = 14;
    private int size = 0;
    private int nselected = 0;
    private boolean[] selected = null;
    private AnCheckList list;
    private JCheckBox[] data;
    private TextAction samples_text;
    private TextAction threads_text;
    private TextAction LWPs_text;
    private JLabel samples_status;
    private JLabel threads_status;
    private JLabel LWPs_status;

    public FilterSelector(int n, JFrame jFrame) {
        super(n, jFrame, AnLocale.getString("Filter Data"), false, aux, mnemonic, "Data_FilterData");
        this.initComponents();
    }

    private void initComponents() {
        this.list = new AnCheckList(AnLocale.getString("Double-click to select/clear the experiment"));
        this.list.addListSelectionListener(this);
        this.list.addAnListener(this);
        JLabel jLabel = (JLabel)AnUtility.getTitle(AnLocale.getString("Experiments:"));
        jLabel.setDisplayedMnemonic('E');
        jLabel.setLabelFor(this.list);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(AnVariable.boxBorder);
        jPanel.setBackground(AnUtility.text_color);
        jPanel.add((Component)this.list, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)new JScrollPane(jPanel), "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 3, 4, 4));
        jPanel3.add(new ResponseAction(AnLocale.getString("Select All"), 'S', null, AnLocale.getString("select all experiments")));
        jPanel3.add(new ResponseAction(AnLocale.getString("Clear All"), 'r', null, AnLocale.getString("clear all experiments")));
        jPanel3.add(new ResponseAction(AnLocale.getString("Reverse"), 'v', null, AnLocale.getString("select unselected experiments and clear selected experiments")));
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EtchedBorder(1));
        AnUtility.AnLabel anLabel = (AnUtility.AnLabel)AnUtility.getItem(AnLocale.getString("Samples:"));
        this.samples_text = new TextAction();
        this.samples_status = (AnUtility.AnLabel)AnUtility.getHeader(AnLocale.getString("(100 % of total range: 1-1)"));
        AnUtility.AnLabel anLabel2 = (AnUtility.AnLabel)AnUtility.getItem(AnLocale.getString("Threads:"));
        this.threads_text = new TextAction();
        this.threads_status = (AnUtility.AnLabel)AnUtility.getHeader(AnLocale.getString("(total range: 1-1)"));
        AnUtility.AnLabel anLabel3 = (AnUtility.AnLabel)AnUtility.getItem(AnLocale.getString("LWPs:"));
        this.LWPs_text = new TextAction();
        this.LWPs_status = (AnUtility.AnLabel)AnUtility.getHeader(AnLocale.getString("(total range: 1-1)"));
        Dimension dimension = anLabel.getPreferredSize();
        int n = dimension.width;
        int n2 = anLabel2.getPreferredSize().width;
        if (n < n2) {
            n = n2;
        }
        if (n < (n2 = anLabel3.getPreferredSize().width)) {
            n = n2;
        }
        dimension.width = n;
        anLabel.setPreferredSize(dimension);
        anLabel2.setPreferredSize(dimension);
        anLabel3.setPreferredSize(dimension);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.AddSelectItem('m', 'c', AnLocale.getString("Samples"), anLabel, this.samples_text, this.samples_status));
        jPanel.add(new JSeparator(0));
        jPanel.add(this.AddSelectItem('h', 't', AnLocale.getString("Threads"), anLabel2, this.threads_text, this.threads_status));
        jPanel.add(new JSeparator(0));
        jPanel.add(this.AddSelectItem('W', 'l', AnLocale.getString("LWPs"), anLabel3, this.LWPs_text, this.LWPs_status));
        jPanel.add(new JSeparator(0));
        jPanel3 = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel3.setBorder(AnVariable.boxBorder);
        jPanel3.add(new ResponseAction(AnLocale.getString("Enable All"), 'n', null, AnLocale.getString("enable data display for all experiments")));
        jPanel3.add(new ResponseAction(AnLocale.getString("Disable All"), 'D', null, AnLocale.getString("disable data display for all experiments")));
        jPanel3.add(new ResponseAction(AnLocale.getString("Enable Selected"), 'b', null, AnLocale.getString("enable data display for selected experiments")));
        jPanel3.add(new ResponseAction(AnLocale.getString("Disable Selected"), 'i', null, AnLocale.getString("disable data display for selected experiments")));
        jPanel.add(jPanel3);
        jPanel4.add((Component)jPanel, "North");
        jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "East");
        this.setAccessory(jPanel);
    }

    private JPanel AddSelectItem(char c, char c2, String string, JLabel jLabel, TextAction textAction, JLabel jLabel2) {
        jLabel.setDisplayedMnemonic(c);
        jLabel.setLabelFor(textAction);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(1.0f);
        jPanel.add(jLabel);
        jPanel.add(textAction);
        jPanel.add(new ResponseAction(AnLocale.getString("Select All"), c2, AnLocale.getString("All ") + string));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jLabel2, "South");
        return jPanel2;
    }

    public void setComponents() {
        Object[] objectArray = FilterSelector.getExpSelection();
        if (objectArray == null) {
            this.size = 0;
            this.nselected = 0;
            this.selected = null;
            this.data = new JCheckBox[0];
            this.list.setListData(this.data);
            return;
        }
        String[] stringArray = (String[])objectArray[0];
        boolean[] blArray = (boolean[])objectArray[1];
        this.size = stringArray.length;
        this.data = new JCheckBox[this.size];
        int n = 0;
        while (n < this.size) {
            this.data[n] = new JCheckBox(stringArray[n], blArray[n]);
            this.data[n].setMargin(AnVariable.buttonMargin);
            ++n;
        }
        this.list.setListData(this.data);
        this.selected = (boolean[])objectArray[2];
        n = 0;
        while (n < this.size) {
            if (this.selected[n]) {
                this.list.setSelectedIndex(n);
            }
            ++n;
        }
        this.setStatus();
    }

    private void setStatus() {
        Object[] objectArray = FilterSelector.getSampleStatus(this.nselected, this.selected);
        if (objectArray == null) {
            return;
        }
        String[] stringArray = (String[])objectArray[0];
        String[] stringArray2 = (String[])objectArray[1];
        if (this.nselected == 1) {
            this.samples_text.setText(stringArray[0]);
            this.threads_text.setText(stringArray[1]);
            this.LWPs_text.setText(stringArray[2]);
        }
        this.samples_status.setText(stringArray2[0]);
        this.threads_status.setText(stringArray2[1]);
        this.LWPs_status.setText(stringArray2[2]);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.selected = new boolean[this.size];
        this.nselected = 0;
        int n = 0;
        while (n < this.size) {
            this.selected[n] = this.list.isSelectedIndex(n);
            if (this.selected[n]) {
                ++this.nselected;
            }
            ++n;
        }
        boolean bl = this.nselected != 0;
        this.samples_text.setEnabled(bl);
        this.threads_text.setEnabled(bl);
        this.LWPs_text.setEnabled(bl);
        this.setStatus();
    }

    public void valueChanged(AnEvent anEvent) {
        if (anEvent.getType() == 7) {
            int[] nArray;
            int n = anEvent.getAux();
            if (n == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = anEvent.getValue();
            } else {
                nArray = this.list.getSelectedIndices();
            }
            int[] nArray3 = nArray;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox jCheckBox;
                jCheckBox.setSelected(!(jCheckBox = this.data[nArray3[n2]]).isSelected());
                ++n2;
            }
            this.list.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(AnLocale.getString("OK")) || string.equals(AnLocale.getString("Apply"))) {
            this.compute();
        } else if (string.equals(AnLocale.getString("Select All"))) {
            this.setSelected(4);
        } else if (string.equals(AnLocale.getString("Clear All"))) {
            this.setSelected(5);
        } else if (string.equals(AnLocale.getString("Reverse"))) {
            this.setSelected(6);
        } else if (string.equals(AnLocale.getString("Enable All"))) {
            this.setEnabled(7, true);
        } else if (string.equals(AnLocale.getString("Disable All"))) {
            this.setEnabled(8, false);
        } else if (string.equals(AnLocale.getString("Enable Selected"))) {
            this.setEnabled(9, true);
        } else if (string.equals(AnLocale.getString("Disable Selected"))) {
            this.setEnabled(10, false);
        } else if (string.equals(AnLocale.getString("All Samples"))) {
            this.setDefault(11);
        } else if (string.equals(AnLocale.getString("All Threads"))) {
            this.setDefault(12);
        } else if (string.equals(AnLocale.getString("All LWPs"))) {
            this.setDefault(13);
        } else if (string.equals(AnLocale.getString("Default"))) {
            this.setDefault(14);
        }
    }

    private void compute() {
        boolean[] blArray = new boolean[this.size];
        String[] stringArray = new String[3];
        int n = 0;
        while (n < this.size) {
            blArray[n] = this.data[n].isSelected();
            ++n;
        }
        stringArray[0] = this.samples_text.getText();
        stringArray[1] = this.threads_text.getText();
        stringArray[2] = this.LWPs_text.getText();
        if (FilterSelector.updateFilter(this.win_id, this.nselected, this.selected, blArray, stringArray)) {
            AnWindow.computeAll();
        }
        this.setStatus();
        this.showError(AnDialog.errorMsg(this.win_id, 0));
    }

    private void setSelected(int n) {
        switch (n) {
            case 4: {
                this.list.setSelectionInterval(0, this.size);
                break;
            }
            case 5: {
                this.list.clearSelection();
                break;
            }
            case 6: {
                int n2 = 0;
                while (n2 < this.size) {
                    if (this.list.isSelectedIndex(n2)) {
                        this.list.removeSelectionInterval(n2, n2);
                    } else {
                        this.list.addSelectionInterval(n2, n2);
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    private void checkPattern(String string, int n) {
        this.showError(FilterSelector.checkPattern(this.win_id, this.nselected, this.selected, string, n));
    }

    private void setEnabled(int n, boolean bl) {
        switch (n) {
            case 7: 
            case 8: {
                int n2 = 0;
                while (n2 < this.size) {
                    this.data[n2].setSelected(bl);
                    ++n2;
                }
                break;
            }
            case 9: 
            case 10: {
                if (this.nselected == 0) {
                    return;
                }
                int n3 = 0;
                while (n3 < this.size) {
                    if (this.list.isSelectedIndex(n3)) {
                        this.data[n3].setSelected(bl);
                    }
                    ++n3;
                }
                break;
            }
        }
        this.list.repaint();
    }

    private void setDefault(int n) {
        if (this.size == 0) {
            return;
        }
        if (n == 14) {
            this.list.clearSelection();
            this.list.setSelectionInterval(0, 0);
            this.nselected = 1;
            this.selected[0] = true;
            int n2 = 1;
            while (n2 < this.size) {
                this.selected[n2] = false;
                ++n2;
            }
            int[] nArray = FilterSelector.getSampleSize(this.selected);
            if (nArray != null) {
                this.samples_text.setText("1-" + nArray[0]);
                this.threads_text.setText("1-" + nArray[1]);
                this.LWPs_text.setText("1-" + nArray[2]);
            }
            this.setEnabled(7, true);
        } else {
            int[] nArray = FilterSelector.getSampleSize(this.selected);
            if (nArray == null) {
                return;
            }
            switch (n) {
                case 11: {
                    this.samples_text.setText("1-" + nArray[0]);
                    break;
                }
                case 12: {
                    this.threads_text.setText("1-" + nArray[1]);
                    break;
                }
                case 13: {
                    this.LWPs_text.setText("1-" + nArray[2]);
                }
            }
        }
    }

    private static native Object[] getExpSelection();

    private static native Object[] getSampleStatus(int var0, boolean[] var1);

    private static native int[] getSampleSize(boolean[] var0);

    private static native String checkPattern(int var0, int var1, boolean[] var2, String var3, int var4);

    private static native boolean updateFilter(int var0, int var1, boolean[] var2, boolean[] var3, String[] var4);

    private class TextAction
    extends JTextField
    implements FocusListener {
        public TextAction() {
            super(12);
            this.addActionListener(FilterSelector.this.dialog);
            this.addFocusListener(this);
            this.setActionCommand(AnLocale.getString("Apply"));
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary() || FilterSelector.this.nselected == 0) {
                return;
            }
            if (this == FilterSelector.this.samples_text) {
                FilterSelector.this.checkPattern(FilterSelector.this.samples_text.getText(), 1);
            } else if (this == FilterSelector.this.threads_text) {
                FilterSelector.this.checkPattern(FilterSelector.this.threads_text.getText(), 2);
            } else if (this == FilterSelector.this.LWPs_text) {
                FilterSelector.this.checkPattern(FilterSelector.this.LWPs_text.getText(), 3);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }

    private class ResponseAction
    extends JButton {
        public ResponseAction(String string, char c, String string2, String string3) {
            super(string);
            this.addActionListener(FilterSelector.this.dialog);
            if (string2 != null) {
                this.setActionCommand(string2);
            }
            if (string3 != null) {
                this.setToolTipText(string3);
            }
            if (c != '\u0000') {
                this.setMnemonic(c);
            }
        }

        public ResponseAction(String string, char c, String string2) {
            this(string, c, string2, null);
        }

        public ResponseAction(String string, char c) {
            this(string, c, null, null);
        }

        public ResponseAction(String string) {
            this(string, '\u0000', null, null);
        }
    }
}

