/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnAddress;
import com.sun.forte.st.mpmt.AnDisplay;
import com.sun.forte.st.mpmt.AnDouble;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnInteger;
import com.sun.forte.st.mpmt.AnListener;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnLong;
import com.sun.forte.st.mpmt.AnTable;
import com.sun.forte.st.mpmt.Presentation;
import java.awt.BorderLayout;
import java.awt.Component;

public class FuncListDisp
extends AnDisplay {
    protected Presentation present;
    protected AnTable table;
    protected int sel_ind = -1;
    protected int name_col = 0;
    protected String[] names;
    private boolean init_focus;
    private Object[][] table_data = null;

    public FuncListDisp(int n, int n2, boolean bl, String string) {
        super(n, n2, bl, string);
        this.init_focus = bl;
    }

    public void setValue(Presentation presentation) {
        this.present = presentation;
        presentation.addAnListener(new PresentHandler());
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.table = new AnTable(this.type, true, this.can_sort, false, true, true);
        this.table.addAnListener(new TableHandler());
        this.add((Component)this.table, "Center");
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public String setSelectedRow(int n) {
        return this.table.setSelectedRow(n);
    }

    public void clear() {
        this.table.removeAll();
    }

    public void doCompute(AnDisplay anDisplay) {
        int n;
        if (!this.selected) {
            return;
        }
        if (this.can_sort) {
            this.sel_ind = this.table.getSelectedRow();
        } else {
            n = this.window.getFuncIndex();
            if (this.sel_ind != n) {
                this.sel_ind = n;
                this.computed = false;
            }
            if (!this.computed) {
                this.window.update_func();
                this.sel_ind = this.window.getFuncIndex();
            }
        }
        if (!this.computed) {
            this.reset();
            int n2 = FuncListDisp.getFuncData(this.win_id, this.sel_ind, this.type);
            String string = AnDisplay.errorMsg(this.win_id, n2);
            if (string == null) {
                this.showWarning(AnDisplay.warningMsg(this.win_id));
                this.table.setViewport();
                Object[] objectArray = FuncListDisp.getFuncList(this.win_id, this.type);
                this.names = FuncListDisp.getNames(this.win_id, this.type);
                this.table_data = this.processData(objectArray);
                int[] nArray = (int[])objectArray[objectArray.length - 1];
                Presentation.MetricLabel[] metricLabelArray = this.present.getLabel(this.table_data, FuncListDisp.getTotalMax(this.win_id, this.type), false, this.table);
                this.name_col = this.present.getNameCol();
                int n3 = this.present.getSortCol(false);
                this.table.setData(metricLabelArray, this.table_data, this.names, nArray, FuncListDisp.getSelIndex(this.win_id, this.type), this.name_col, n3);
            } else {
                this.window.appendLog(AnLocale.getString("Error: ") + string);
                this.table.showError(string);
            }
        } else if (!this.updated) {
            Presentation.MetricLabel[] metricLabelArray = this.present.getLabel(this.table_data, FuncListDisp.getTotalMax(this.win_id, this.type), false, this.table);
            this.table.setLabel(metricLabelArray);
        }
        if (!this.computed || !this.updated) {
            if (this.can_sort) {
                n = this.table.getSelectedRow();
                if (n != -1) {
                    this.setCurrent(n);
                }
            } else {
                this.table.showSelectedRow();
            }
        }
        if (this.init_focus) {
            this.init_focus = false;
            this.table.requestFocus();
        }
        this.computed = true;
        this.updated = true;
    }

    public void setCurrent(int n) {
        String string = this.table.setSelectedRow(n);
        if (this.type == 1 || this.type == 2) {
            this.sel_ind = n;
            this.window.setSelFunc(string);
            this.window.update_summary(n, this.type);
        }
    }

    public String print(String string, String string2) {
        return AnDisplay.printData(this.win_id, this.sel_ind, this.type, string, string2);
    }

    public int find(String string, boolean bl) {
        if (string == null && this.type != 3 && this.type != 4) {
            return -1;
        }
        int n = this.table.findAfter(string, bl);
        if (n == -1) {
            n = this.table.findBefore(string, bl);
        }
        if (n != -1) {
            this.setCurrent(n);
        }
        return n;
    }

    public void sort(int n) {
        this.table.sort(n);
    }

    protected Object[][] processData(Object[] objectArray) {
        int n = objectArray.length - 1;
        Object[][] objectArray2 = new Object[n][];
        int n2 = 0;
        while (n2 < n) {
            objectArray2[n2] = objectArray[n2] instanceof double[] ? AnDouble.toArray((double[])objectArray[n2]) : (objectArray[n2] instanceof int[] ? AnInteger.toArray((int[])objectArray[n2]) : (objectArray[n2] instanceof long[] ? (((long[])objectArray[n2]).length == 0 || !AnAddress.isAddress(((long[])objectArray[n2])[0]) ? AnLong.toArray((long[])objectArray[n2]) : AnAddress.toArray((long[])objectArray[n2])) : (Object[])objectArray[n2]));
            ++n2;
        }
        return objectArray2;
    }

    protected static native int getFuncData(int var0, int var1, int var2);

    protected static native Object[] getFuncList(int var0, int var1);

    protected static native String[] getNames(int var0, int var1);

    protected static native Object[] getTotalMax(int var0, int var1);

    protected static native int getSelIndex(int var0, int var1);

    private class TableHandler
    implements AnListener {
        private TableHandler() {
        }

        public void valueChanged(AnEvent anEvent) {
            switch (anEvent.getType()) {
                case 8: {
                    FuncListDisp.this.setCurrent(anEvent.getValue());
                    break;
                }
                case 9: {
                    FuncListDisp.this.present.updateSortList(anEvent.getAux(), FuncListDisp.this.type);
                    break;
                }
                case 12: {
                    int n = anEvent.getValue();
                    int n2 = anEvent.getAux();
                    FuncListDisp.this.present.updateOrderList(n, n2, FuncListDisp.this.type);
                }
            }
        }
    }

    private class PresentHandler
    implements AnListener {
        private PresentHandler() {
        }

        public void valueChanged(AnEvent anEvent) {
            switch (anEvent.getType()) {
                case 1: {
                    FuncListDisp.this.computed = false;
                    break;
                }
                case 3: {
                    if (!FuncListDisp.this.can_sort) break;
                    FuncListDisp.this.computed = false;
                    break;
                }
                case 4: {
                    if (FuncListDisp.this.type != 3) break;
                    FuncListDisp.this.computed = false;
                    break;
                }
                case 5: {
                    if (FuncListDisp.this.type != 4) break;
                    FuncListDisp.this.computed = false;
                    break;
                }
                case 2: {
                    FuncListDisp.this.updated = false;
                    break;
                }
                case 9: {
                    if (!FuncListDisp.this.can_sort || anEvent.getValue() == FuncListDisp.this.type) {
                        return;
                    }
                    int n = FuncListDisp.this.present.getSortCol(FuncListDisp.this.type == 6);
                    if (n >= 0) {
                        FuncListDisp.this.sort(n);
                        break;
                    }
                    FuncListDisp.this.computed = false;
                    break;
                }
                case 10: {
                    if (anEvent.getValue() == FuncListDisp.this.type) {
                        return;
                    }
                    FuncListDisp.this.computed = false;
                    break;
                }
                case 6: {
                    FuncListDisp.this.compute(null);
                }
            }
        }
    }
}

