/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnCheckList;
import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnListener;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LoadObjectSelector
extends AnDialog
implements AnListener {
    private static final String[] aux = new String[]{AnLocale.getString("Select All"), AnLocale.getString("Clear All")};
    private static final char[] mnemonic = new char[]{'t', 'r'};
    private static final int PRF_HEIGHT = 200;
    private int size = 0;
    private boolean[] selected = null;
    private AnCheckList list;
    private JCheckBox[] data;

    public LoadObjectSelector(int n, JFrame jFrame) {
        super(n, jFrame, AnLocale.getString("Show/Hide Functions"), false, aux, mnemonic, "Data_ShowHide");
        this.initComponents();
    }

    private void initComponents() {
        this.list = new AnCheckList(AnLocale.getString("Double-click to select/clear the load object"));
        this.list.addAnListener(this);
        JLabel jLabel = this.setLabel(AnLocale.getString("Select/clear the checkbox for a load object to show/hide its functions"));
        jLabel.setDisplayedMnemonic('S');
        jLabel.setLabelFor(this.list);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(AnVariable.boxBorder);
        jPanel.setBackground(AnUtility.text_color);
        jPanel.add((Component)this.list, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.height = 200;
        jScrollPane.setPreferredSize(dimension);
        this.setAccessory(jScrollPane);
    }

    public void setComponents() {
        String[] stringArray = AnUtility.getLoadObjectName();
        if (stringArray == null) {
            this.size = 0;
            this.selected = null;
            this.data = new JCheckBox[0];
            this.list.setListData(this.data);
            return;
        }
        this.size = stringArray.length;
        this.selected = LoadObjectSelector.getLoadObjectState();
        this.data = new JCheckBox[this.size];
        int n = 0;
        while (n < this.size) {
            this.data[n] = new JCheckBox(stringArray[n], this.selected[n]);
            this.data[n].setMargin(AnVariable.buttonMargin);
            ++n;
        }
        this.list.setListData(this.data);
        this.list.setSelectedIndex(0);
    }

    public void valueChanged(AnEvent anEvent) {
        if (anEvent.getType() == 7) {
            int[] nArray;
            int n = anEvent.getAux();
            if (n == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = anEvent.getValue();
            } else {
                nArray = this.list.getSelectedIndices();
            }
            int[] nArray3 = nArray;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox jCheckBox;
                jCheckBox.setSelected(!(jCheckBox = this.data[nArray3[n2]]).isSelected());
                ++n2;
            }
            this.list.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(AnLocale.getString("OK")) || string.equals(AnLocale.getString("Apply"))) {
            this.compute();
        } else if (string.equals(AnLocale.getString("Select All"))) {
            this.setState(true);
        } else if (string.equals(AnLocale.getString("Clear All"))) {
            this.setState(false);
        }
    }

    public void closePerformed(ActionEvent actionEvent) {
        this.selected = LoadObjectSelector.getLoadObjectState();
        int n = 0;
        while (n < this.size) {
            this.data[n].setSelected(this.selected[n]);
            ++n;
        }
    }

    private void compute() {
        int n = 0;
        while (n < this.size) {
            this.selected[n] = this.data[n].isSelected();
            ++n;
        }
        LoadObjectSelector.setLoadObjectState(this.selected);
        AnWindow.computeAll();
    }

    private void setState(boolean bl) {
        int n = 0;
        while (n < this.size) {
            this.selected[n] = bl;
            this.data[n].setSelected(this.selected[n]);
            ++n;
        }
        this.list.repaint();
    }

    public static native boolean[] getLoadObjectState();

    public static native void setLoadObjectState(boolean[] var0);
}

