/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class MapfileChooser
extends JFileChooser
implements PropertyChangeListener,
ListSelectionListener {
    private int win_id;
    private AnWindow window;
    private JFrame frame;
    private JList list;

    public MapfileChooser(int n, JFrame jFrame) {
        super(AnVariable.pwd_dir);
        this.win_id = n;
        this.window = AnWindow.get_win(n);
        this.frame = jFrame;
        this.setDialogTitle(AnLocale.getString("Create Mapfile"));
        this.setFileFilter(new MapfileFilter());
        this.setFileSelectionMode(0);
        this.addPropertyChangeListener(this);
        this.initComponents();
    }

    private void initComponents() {
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JLabel jLabel = new JLabel(AnLocale.getString("Load Objects:"));
        jLabel.setBorder(AnVariable.labelBorder);
        jLabel.setDisplayedMnemonic('L');
        jLabel.setLabelFor(this.list);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add((Component)jScrollPane, "Center");
        int n = this.getPreferredSize().width / 2;
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = n;
        jScrollPane.setPreferredSize(dimension);
        this.setAccessory(jPanel);
    }

    public void setComponents() {
        String[] stringArray = AnUtility.getLoadObjectName();
        if (stringArray == null) {
            this.list.setListData(new String[0]);
            return;
        }
        this.list.setListData(stringArray);
        if (stringArray.length != 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.setMapfile();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
            this.setMapfile();
        }
    }

    private void setMapfile() {
        String string = (String)this.list.getSelectedValue();
        if (string == null) {
            return;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if (string.startsWith("<") && string.endsWith(">")) {
            string = string.substring(1, string.length() - 1);
        }
        this.setSelectedFile(new File(this.getCurrentDirectory(), string + ".mapfile"));
    }

    public void setVisible(boolean bl) {
        File file;
        if (this.showSaveDialog(this.frame) == 0 && (file = this.getSelectedFile()) != null) {
            final int n = this.list.getSelectedIndex();
            if (n == -1) {
                this.showError(AnLocale.getString("No load object selected."));
                this.setVisible(true);
                return;
            }
            if (file.exists() && !this.showWarning(AnLocale.getString("Overwrite existing") + " \"" + file.getName() + "\".")) {
                this.setVisible(true);
                return;
            }
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = AnVariable.worker_lock;
                    synchronized (object) {
                        MapfileChooser.this.window.setBusyCursor(true);
                        MapfileChooser.this.doCreateMapfile(file, n);
                        MapfileChooser.this.window.setBusyCursor(false);
                    }
                }
            };
            thread.start();
        }
    }

    public void doCreateMapfile(File file, int n) {
        this.showError(MapfileChooser.createMapfile(this.win_id, file.getAbsolutePath(), n));
    }

    private void showError(String string) {
        if (string != null) {
            JOptionPane.showMessageDialog(this.frame, string, AnLocale.getString("Error"), 0);
        }
    }

    private boolean showWarning(String string) {
        return 0 == JOptionPane.showConfirmDialog(this.frame, string, AnLocale.getString("Warning"), 0, 2);
    }

    private static native String createMapfile(int var0, String var1, int var2);

    private class MapfileFilter
    extends FileFilter {
        private MapfileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(".mapfile");
        }

        public String getDescription() {
            return AnLocale.getString("Performance Analyzer Mapfile (*.mapfile)");
        }
    }
}

