/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnAddress;
import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnDouble;
import com.sun.forte.st.mpmt.AnEvent;
import com.sun.forte.st.mpmt.AnInteger;
import com.sun.forte.st.mpmt.AnList;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnLong;
import com.sun.forte.st.mpmt.AnMetric;
import com.sun.forte.st.mpmt.AnMetricList;
import com.sun.forte.st.mpmt.AnObject;
import com.sun.forte.st.mpmt.AnString;
import com.sun.forte.st.mpmt.AnTable;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Presentation
extends AnDialog
implements ItemListener {
    private static final String[] aux = new String[]{AnLocale.getString("Save")};
    private static final char[] mnemonic = new char[]{'S'};
    private static final String home_str = AnLocale.getString("User's home directory, ") + AnVariable.home_dir;
    private static final String pwd_str = AnLocale.getString("Current directory, ") + AnVariable.pwd_dir;
    static final int CUNIT_NULL = -1;
    static final int CUNIT_BYTES = -2;
    static final int CUNIT_TIME = -3;
    static final int[] ccmv_type;
    static final String[] ccmv_desc;
    static final String[] ccmv_comd;
    static final char[] ccmv_mnem;
    static final int size_ccmv = 11;
    static final int CCMV_BASIC = 1024;
    static final int CCMV_VER = 1;
    static final int CCMV_WARN = 2;
    static final int CCMV_PAR = 4;
    static final int CCMV_QUERY = 8;
    static final int CCMV_LOOP = 16;
    static final int CCMV_PIPE = 32;
    static final int CCMV_INLINE = 64;
    static final int CCMV_MEMOPS = 128;
    static final int CCMV_FE = 256;
    static final int CCMV_CG = 512;
    static final String excl_abbr;
    static final String incl_abbr;
    static final String attr_abbr;
    static final String excl_name;
    static final String incl_name;
    static final String attr_name;
    static final String time_str;
    private int size = 0;
    private int gsize = 0;
    private int name_col = -1;
    private AnMetric[] met_ref = null;
    private AnMetric[] metrics = null;
    private AnMetric[] gmetrics = null;
    private int[] order = null;
    private JTabbedPane tab_pane;
    private AnList metric_visible;
    private JComponent[] value_chks_ref;
    private JComponent[] time_chks_ref;
    private JComponent[] percent_chks_ref;
    private JComponent[] value_chks;
    private JComponent[] time_chks;
    private JComponent[] percent_chks;
    private AnMetricList order_list;
    private boolean drag_order = false;
    private int vis_src;
    private int vis_dis;
    private int threshold_src;
    private int threshold_dis;
    private boolean src_visible;
    private boolean src_metric;
    private boolean hex_visible;
    private boolean long_name;
    private JComponent[] src_chks;
    private JComponent[] dis_chks;
    private JComponent[] threshold;
    private JCheckBox dis_src;
    private JCheckBox dis_asrc;
    private JCheckBox dis_hex;
    private JRadioButton long_fmt;
    private Object save_result = home_str;

    public Presentation(int n, JFrame jFrame) {
        super(n, jFrame, AnLocale.getString("Set Data Presentation"), false, aux, mnemonic, "Data_SetPref");
        this.initComponents();
    }

    private void initComponents() {
        this.tab_pane = new JTabbedPane();
        this.metric_visible = new AnList(false);
        this.tab_pane.addTab(AnLocale.getString("Metrics"), new JScrollPane(this.metric_visible));
        this.order_list = new AnMetricList(AnLocale.getString("Sort by"), AnLocale.getString("Order of Columns"), AnLocale.getString("Double-click to set the sort metric"), 'O');
        this.tab_pane.addTab(AnLocale.getString("Sort"), this.order_list);
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        this.initSourceDisassembly(jPanel);
        this.tab_pane.addTab(AnLocale.getString("Source/Disassembly"), new JScrollPane(jPanel));
        AnList anList = new AnList(false);
        this.initNameFormat(anList);
        this.tab_pane.addTab(AnLocale.getString("Formats"), new JScrollPane(anList));
        this.tab_pane.addChangeListener(new TabHandler());
        this.setAccessory(this.tab_pane);
    }

    public void initSourceDisassembly(JPanel jPanel) {
        JLabel jLabel;
        int[] nArray = Presentation.getAnoValue(this.win_id);
        this.vis_src = nArray[0];
        this.vis_dis = nArray[1];
        this.threshold_src = nArray[2];
        this.threshold_dis = nArray[3];
        this.src_visible = nArray[4] != 0;
        this.src_metric = nArray[5] != 0;
        this.hex_visible = nArray[6] != 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        AnList anList = new AnList(false);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(AnUtility.getHeader(AnLocale.getString("Source")));
        jPanel3.add(AnUtility.getHeader(AnLocale.getString("Disassembly")));
        anList.add(AnUtility.getItem(AnLocale.getString("Compiler Commentary:")), jPanel3);
        this.src_chks = new JComponent[11];
        this.dis_chks = new JComponent[11];
        this.threshold = new JComponent[2];
        int n = 0;
        while (n < 11) {
            jLabel = (JLabel)AnUtility.getItem(ccmv_desc[n]);
            jPanel3 = new JPanel(new GridLayout(1, 2));
            anList.add(jLabel, jPanel3);
            JCheckBox jCheckBox = new JCheckBox(" ");
            this.src_chks[n] = jCheckBox;
            jCheckBox.setMargin(AnVariable.buttonMargin);
            jCheckBox.setHorizontalAlignment(0);
            jCheckBox.setSelected((this.vis_src & ccmv_type[n]) != 0);
            jPanel3.add(jCheckBox);
            jCheckBox = new JCheckBox(" ");
            this.dis_chks[n] = jCheckBox;
            jCheckBox.setMargin(AnVariable.buttonMargin);
            jCheckBox.setHorizontalAlignment(0);
            jCheckBox.setSelected((this.vis_dis & ccmv_type[n]) != 0);
            jPanel3.add(jCheckBox);
            jLabel.setDisplayedMnemonic(ccmv_mnem[n]);
            jLabel.setLabelFor(this.src_chks[n]);
            ++n;
        }
        jPanel3 = new JPanel(new GridLayout(1, 2));
        String[] stringArray = new String[]{Integer.toString(this.threshold_src), Integer.toString(this.threshold_dis)};
        n = 0;
        while (n < 2) {
            this.threshold[n] = AnUtility.getNumber(stringArray[n], 3);
            ((JTextField)this.threshold[n]).setEditable(true);
            JPanel jPanel4 = new JPanel();
            jPanel3.add(jPanel4);
            jPanel4.add(this.threshold[n]);
            ++n;
        }
        jLabel = (JLabel)AnUtility.getItem(AnLocale.getString("Highlighting Threshold (%):"));
        jLabel.setDisplayedMnemonic('T');
        jLabel.setLabelFor(this.threshold[0]);
        anList.add(jLabel, jPanel3);
        anList.setAlignmentX();
        anList.add(AnUtility.getItem(AnLocale.getString("Show in Disassembly Listing:")), null);
        jPanel2.add(anList);
        this.dis_src = new JCheckBox(AnLocale.getString("Source Code"));
        this.dis_src.setMargin(AnVariable.buttonMargin);
        this.dis_src.setMnemonic('r');
        this.dis_src.setSelected(this.src_visible);
        this.dis_src.addItemListener(this);
        this.dis_asrc = new JCheckBox(AnLocale.getString("Metrics for Source Lines"));
        this.dis_asrc.setMargin(AnVariable.buttonMargin);
        this.dis_asrc.setMnemonic('e');
        this.dis_asrc.setSelected(this.src_metric);
        this.dis_asrc.addItemListener(this);
        jPanel3 = new JPanel(new FlowLayout(0, 20, 0));
        jPanel3.add(this.dis_src);
        jPanel3.add(this.dis_asrc);
        jPanel2.add(jPanel3);
        this.dis_hex = new JCheckBox(AnLocale.getString("Hexadecimal Instructions"));
        this.dis_hex.setMargin(AnVariable.buttonMargin);
        this.dis_hex.setMnemonic('x');
        this.dis_hex.setSelected(this.hex_visible);
        jPanel3 = new JPanel(new FlowLayout(0, 20, 0));
        jPanel3.add(this.dis_hex);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
    }

    public void initNameFormat(AnList anList) {
        this.long_name = Presentation.getNameFormat(this.win_id);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.long_fmt = new JRadioButton(AnLocale.getString("Long"), this.long_name);
        this.long_fmt.setMnemonic('L');
        buttonGroup.add(this.long_fmt);
        anList.add(AnUtility.getTitle(AnLocale.getString("Function Name Style:")), this.long_fmt);
        JRadioButton jRadioButton = new JRadioButton(AnLocale.getString("Short"), !this.long_name);
        jRadioButton.setMnemonic('h');
        buttonGroup.add(jRadioButton);
        anList.add((JComponent)null, jRadioButton);
    }

    public void setComponents() {
        this.metrics = this.getMetrics(false);
        this.gmetrics = this.getMetrics(true);
        if (this.metrics == null) {
            return;
        }
        this.met_ref = new AnMetric[this.size];
        int n = 0;
        while (n < this.size) {
            this.met_ref[n] = this.metrics[this.order[n]];
            ++n;
        }
        this.setMetricsVisible();
        this.order_list.setListData(this.metrics);
        this.pack();
    }

    public void setMetricsVisible() {
        this.metric_visible.removeAll();
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(AnUtility.getHeader(excl_name, AnUtility.excl_icon));
        jPanel.add(AnUtility.getHeader(incl_name, AnUtility.incl_icon));
        this.metric_visible.add((JComponent)null, jPanel);
        jPanel = new JPanel(new GridLayout(1, 6));
        int n = 0;
        while (n < 2) {
            jPanel.add(AnUtility.getHeader(AnLocale.getString("Time")));
            jPanel.add(AnUtility.getHeader(AnLocale.getString("Value")));
            jPanel.add(AnUtility.getHeader("%"));
            ++n;
        }
        this.metric_visible.add((JComponent)null, jPanel);
        this.time_chks_ref = new JComponent[this.size];
        this.value_chks_ref = new JComponent[this.size];
        this.percent_chks_ref = new JComponent[this.size];
        JPanel jPanel2 = null;
        n = 0;
        while (n < this.size) {
            AnMetric anMetric = this.met_ref[n];
            if (anMetric.canValue()) {
                JCheckBox jCheckBox;
                JLabel jLabel = null;
                Object var5_6 = null;
                String string = anMetric.getName();
                if (!string.startsWith(incl_name)) {
                    if (string.startsWith(excl_name)) {
                        if ((string = string.substring(excl_name.length())).endsWith(time_str)) {
                            string = string.substring(0, string.length() - time_str.length());
                        }
                        jLabel = (JLabel)AnUtility.getItem(string);
                        jPanel2 = new JPanel(new GridLayout(1, 6));
                        this.metric_visible.add(jLabel, jPanel2);
                    } else {
                        jLabel = (JLabel)AnUtility.getItem(string);
                        jPanel2 = new JPanel(new GridLayout(1, 3));
                        jPanel = new JPanel(new GridLayout(1, 2));
                        jPanel.add(jPanel2);
                        jPanel.add(new JLabel(""));
                        this.metric_visible.add(jLabel, jPanel);
                    }
                    char c = anMetric.getMnemonic();
                    if (c != '\u0000') {
                        jLabel.setDisplayedMnemonic(c);
                    } else {
                        jLabel = null;
                    }
                }
                if (anMetric.canValue()) {
                    jCheckBox = new JCheckBox(" ");
                    this.value_chks_ref[n] = jCheckBox;
                    jCheckBox.setMargin(AnVariable.buttonMargin);
                    jCheckBox.setHorizontalAlignment(0);
                    jCheckBox.setSelected(anMetric.isVisible());
                } else {
                    this.value_chks_ref[n] = new JLabel("");
                }
                if (anMetric.canTime()) {
                    jCheckBox = new JCheckBox(" ");
                    this.time_chks_ref[n] = jCheckBox;
                    jCheckBox.setMargin(AnVariable.buttonMargin);
                    jCheckBox.setHorizontalAlignment(0);
                    jCheckBox.setSelected(anMetric.isTVisible());
                } else {
                    this.time_chks_ref[n] = new JLabel("");
                }
                if (anMetric.getClock() == -3 && anMetric.canPercent()) {
                    jPanel2.add(this.value_chks_ref[n]);
                    jPanel2.add(this.time_chks_ref[n]);
                    jLabel = this.setLabelFor(jLabel, this.value_chks_ref[n]);
                    jLabel = this.setLabelFor(jLabel, this.time_chks_ref[n]);
                } else {
                    jPanel2.add(this.time_chks_ref[n]);
                    jPanel2.add(this.value_chks_ref[n]);
                    jLabel = this.setLabelFor(jLabel, this.time_chks_ref[n]);
                    jLabel = this.setLabelFor(jLabel, this.value_chks_ref[n]);
                }
                if (anMetric.canPercent()) {
                    jCheckBox = new JCheckBox(" ");
                    this.percent_chks_ref[n] = jCheckBox;
                    jCheckBox.setMargin(AnVariable.buttonMargin);
                    jCheckBox.setHorizontalAlignment(0);
                    jCheckBox.setSelected(anMetric.isPVisible());
                } else {
                    this.percent_chks_ref[n] = new JLabel("");
                }
                jPanel2.add(this.percent_chks_ref[n]);
                this.setLabelFor(jLabel, this.percent_chks_ref[n]);
            }
            ++n;
        }
        this.metric_visible.setAlignmentX();
        this.setCheckBox();
    }

    private JLabel setLabelFor(JLabel jLabel, JComponent jComponent) {
        if (jLabel == null || jComponent instanceof JLabel) {
            return jLabel;
        }
        jLabel.setLabelFor(jComponent);
        return null;
    }

    private void setCheckBox() {
        this.time_chks = new JComponent[this.size];
        this.value_chks = new JComponent[this.size];
        this.percent_chks = new JComponent[this.size];
        int n = 0;
        while (n < this.size) {
            int n2 = this.order[n];
            this.time_chks[n2] = this.time_chks_ref[n];
            this.value_chks[n2] = this.value_chks_ref[n];
            this.percent_chks[n2] = this.percent_chks_ref[n];
            ++n;
        }
    }

    private AnMetric[] getMetrics(boolean bl) {
        Object[] objectArray = Presentation.getDefaultMetric(this.win_id, bl);
        if (objectArray == null) {
            return null;
        }
        int n = ((String[])objectArray[0]).length;
        AnMetric[] anMetricArray = new AnMetric[n];
        int n2 = 0;
        while (n2 < n) {
            anMetricArray[n2] = new AnMetric(((String[])objectArray[0])[n2], ((String[])objectArray[1])[n2], ((String[])objectArray[2])[n2], ((String[])objectArray[3])[n2], ((char[])objectArray[4])[n2], ((int[])objectArray[5])[n2], ((int[])objectArray[6])[n2], ((boolean[])objectArray[7])[n2], ((boolean[])objectArray[8])[n2], ((boolean[])objectArray[9])[n2], ((boolean[])objectArray[10])[n2], ((boolean[])objectArray[11])[n2], ((boolean[])objectArray[12])[n2], ((boolean[])objectArray[13])[n2], ((boolean[])objectArray[14])[n2]);
            ++n2;
        }
        if (bl) {
            this.gsize = n;
        } else {
            this.size = n;
            this.order = (int[])objectArray[6];
        }
        return anMetricArray;
    }

    private void updateListVisible() {
        boolean[] blArray = new boolean[this.size];
        int n = 0;
        while (n < this.size) {
            AnMetric anMetric = this.order_list.getMetric(n);
            int n2 = 0;
            while (n2 < this.size) {
                if (anMetric == this.met_ref[n2]) break;
                ++n2;
            }
            blArray[n] = !anMetric.canValue() || ((JCheckBox)this.value_chks_ref[n2]).isSelected() || anMetric.canTime() && ((JCheckBox)this.time_chks_ref[n2]).isSelected() || anMetric.canPercent() && ((JCheckBox)this.percent_chks_ref[n2]).isSelected();
            ++n;
        }
        this.order_list.setVisible(blArray);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.dis_src) {
            if (itemEvent.getStateChange() == 2) {
                this.dis_asrc.setSelected(false);
            }
        } else if (itemSelectable == this.dis_asrc && itemEvent.getStateChange() == 1) {
            this.dis_src.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(AnLocale.getString("OK")) || string.equals(AnLocale.getString("Apply"))) {
            this.compute();
            this.updateListVisible();
        } else if (string.equals(AnLocale.getString("Save"))) {
            this.save();
        }
    }

    private void compute() {
        boolean bl = this.needNewFormat();
        boolean[] blArray = this.needNewAno();
        boolean bl2 = this.needNewData();
        boolean bl3 = this.needNewSort();
        boolean bl4 = this.needNewOrder();
        if (bl) {
            this.fireAnEvent(new AnEvent(this, 3, 0, 0));
        }
        if (blArray[0]) {
            this.fireAnEvent(new AnEvent(this, 4, 0, 0));
        }
        if (blArray[1]) {
            this.fireAnEvent(new AnEvent(this, 5, 0, 0));
        }
        if (this.drag_order || bl4 || bl2) {
            this.drag_order = false;
            Presentation.setGMetrics(this.win_id);
            this.gmetrics = this.getMetrics(true);
            this.updateGMetrics(!bl3);
            this.fireAnEvent(new AnEvent(this, 1, 0, 0));
        } else {
            this.updateGMetrics(!bl3);
            if (bl3) {
                Presentation.setSort(this.win_id, this.getSortIndex(true), true);
                this.fireAnEvent(new AnEvent(this, 9, 0, 0));
            } else {
                this.fireAnEvent(new AnEvent(this, 2, 0, 0));
            }
        }
        this.fireAnEvent(new AnEvent(this, 6, 0, 0));
    }

    private boolean[] needNewAno() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        int n2;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 11) {
            if (((JCheckBox)this.src_chks[n5]).isSelected()) {
                n4 |= ccmv_type[n5];
            }
            if (((JCheckBox)this.dis_chks[n5]).isSelected()) {
                n3 |= ccmv_type[n5];
            }
            ++n5;
        }
        if (this.vis_src != n4) {
            this.vis_src = n4;
            bl4 = true;
        }
        if (this.vis_dis != n3) {
            this.vis_dis = n3;
            bl5 = true;
        }
        if (this.threshold_src != (n2 = Integer.parseInt(((JTextField)this.threshold[0]).getText()))) {
            this.threshold_src = n2;
            bl4 = true;
        }
        if (this.threshold_dis != (n = Integer.parseInt(((JTextField)this.threshold[1]).getText()))) {
            this.threshold_dis = n;
            bl5 = true;
        }
        if (this.src_visible != (bl3 = this.dis_src.isSelected())) {
            this.src_visible = bl3;
            bl5 = true;
        }
        if (this.src_metric != (bl2 = this.dis_asrc.isSelected())) {
            this.src_metric = bl2;
            bl5 = true;
        }
        if (this.hex_visible != (bl = this.dis_hex.isSelected())) {
            this.hex_visible = bl;
            bl5 = true;
        }
        if (bl4 || bl5) {
            int[] nArray = new int[]{this.vis_src, this.vis_dis, this.threshold_src, this.threshold_dis, this.src_visible ? 1 : 0, this.src_metric ? 1 : 0, this.hex_visible ? 1 : 0};
            Presentation.setAnoValue(this.win_id, nArray);
        }
        boolean[] blArray = new boolean[]{bl4, bl5};
        return blArray;
    }

    private boolean needNewFormat() {
        boolean bl = this.long_fmt.isSelected();
        if (this.long_name != bl) {
            this.long_name = bl;
            Presentation.setNameFormat(this.win_id, this.long_name);
            return true;
        }
        return false;
    }

    private boolean needNewData() {
        boolean[] blArray = new boolean[this.size];
        boolean[] blArray2 = new boolean[this.size];
        boolean[] blArray3 = new boolean[this.size];
        boolean bl = false;
        int n = 0;
        while (n < this.size) {
            AnMetric anMetric = this.metrics[n];
            boolean bl2 = anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible();
            blArray[n] = !anMetric.canValue() || ((JCheckBox)this.value_chks[n]).isSelected();
            blArray2[n] = anMetric.canTime() && ((JCheckBox)this.time_chks[n]).isSelected();
            blArray3[n] = anMetric.canPercent() && ((JCheckBox)this.percent_chks[n]).isSelected();
            anMetric.setVisible(blArray[n]);
            anMetric.setTVisible(blArray2[n]);
            anMetric.setPVisible(blArray3[n]);
            if (bl2 != (blArray[n] || blArray2[n] || blArray3[n])) {
                bl = true;
            }
            ++n;
        }
        Presentation.setVisible(this.win_id, blArray, blArray2, blArray3, false);
        return bl;
    }

    private boolean needNewSort() {
        int n = this.getSortIndex(false);
        AnMetric anMetric = this.order_list.getSortMetric();
        int n2 = 0;
        while (n2 < this.size) {
            if (anMetric == this.metrics[n2]) {
                if (n == n2) {
                    return false;
                }
                this.setSortIndex(n2, false);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean needNewOrder() {
        AnMetric anMetric;
        boolean bl = false;
        int n = 0;
        while (n < this.size) {
            anMetric = this.order_list.getMetric(n);
            if (this.order[n] != anMetric.getOrder()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < this.size) {
                anMetric = this.order_list.getMetric(n);
                int n2 = 0;
                while (n2 < this.size) {
                    if (anMetric == this.met_ref[n2]) {
                        this.order[n2] = n;
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            this.setCheckBox();
            n = 0;
            while (n < this.size) {
                this.metrics[n] = this.order_list.getMetric(n);
                this.metrics[n].setOrder(this.order[n]);
                ++n;
            }
            Presentation.setOrder(this.win_id, this.order);
        }
        return bl;
    }

    private void save() {
        Object[] objectArray = new Object[]{home_str, pwd_str};
        Object object = JOptionPane.showInputDialog(this, AnLocale.getString("Save Preferences in:"), AnLocale.getString("Save Preferences"), 2, null, objectArray, this.save_result);
        if (object == home_str) {
            this.save(AnVariable.home_dir);
        } else if (object == pwd_str) {
            this.save(AnVariable.pwd_dir);
        } else {
            return;
        }
        this.save_result = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String string) {
        String string2 = string + "/.er.rc";
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
                this.write(printWriter);
            }
            catch (IOException iOException) {
                this.showError(iOException.toString());
                Object var6_5 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            Object var6_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    private void write(PrintWriter printWriter) {
        int n = this.size - 1;
        AnMetric anMetric = null;
        char c = '\u0000';
        boolean bl = true;
        printWriter.print("dmetrics ");
        int n2 = 0;
        while (n2 < this.size) {
            AnMetric anMetric2 = this.order_list.getMetric(n2);
            String string = anMetric2.getAbbr();
            char c2 = string.startsWith(excl_abbr) ? (char)'e' : (string.startsWith(incl_abbr) ? (char)'i' : '\u0000');
            boolean bl2 = anMetric2.isVisible();
            boolean bl3 = anMetric2.isTVisible();
            boolean bl4 = anMetric2.isPVisible();
            if (anMetric2.isSorted()) {
                anMetric = anMetric2;
                c = c2;
                boolean bl5 = bl = bl2 || bl3 || bl4;
            }
            if (c2 == '\u0000') {
                if (!bl2) {
                    printWriter.print('!');
                }
            } else {
                printWriter.print(c2);
                String string2 = "";
                if (anMetric2.canTime()) {
                    if (bl2) {
                        string2 = string2 + '+';
                    }
                    if (bl3) {
                        string2 = string2 + '.';
                    }
                } else if (bl2 || bl3) {
                    string2 = string2 + '.';
                }
                if (bl4) {
                    string2 = string2 + '%';
                }
                if (string2.equals("")) {
                    printWriter.print('!');
                } else {
                    printWriter.print(string2);
                }
            }
            String string3 = anMetric2.getComd();
            if (n2 == n) {
                printWriter.println(string3);
            } else {
                printWriter.print(string3 + ":");
            }
            ++n2;
        }
        if (anMetric != null) {
            printWriter.print("dsort ");
            if (c != '\u0000') {
                printWriter.print(c);
                printWriter.print(bl ? (char)'.' : '!');
            } else if (!bl) {
                printWriter.print('!');
            }
            printWriter.println(anMetric.getComd());
        }
        printWriter.println("scc " + this.getCompComm(this.vis_src, false, false, false));
        printWriter.println("dcc " + this.getCompComm(this.vis_dis, this.src_visible, this.src_metric, this.hex_visible));
        printWriter.println("sthresh " + this.threshold_src);
        printWriter.println("dthresh " + this.threshold_dis);
        printWriter.println("name " + (this.long_name ? "long" : "short"));
    }

    private String getCompComm(int n, boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        boolean bl4 = true;
        int n2 = 0;
        while (n2 < 11) {
            if ((n & ccmv_type[n2]) != 0) {
                if (bl4) {
                    bl4 = false;
                } else {
                    string = string + ":";
                }
                string = string + ccmv_comd[n2];
            }
            ++n2;
        }
        if (bl4) {
            string = "none";
        }
        if (bl) {
            string = string + ":src";
        }
        if (bl2) {
            string = string + ":asrc";
        }
        if (bl3) {
            string = string + ":hex";
        }
        return string;
    }

    private String getAttrAbbr(String string) {
        if (string.startsWith(excl_abbr)) {
            return attr_abbr + string.substring(excl_abbr.length());
        }
        if (string.startsWith(incl_abbr)) {
            return attr_abbr + string.substring(incl_abbr.length());
        }
        return null;
    }

    private void updateGMetrics(boolean bl) {
        AnMetric anMetric;
        String string;
        boolean[] blArray = new boolean[this.gsize];
        boolean[] blArray2 = new boolean[this.gsize];
        boolean[] blArray3 = new boolean[this.gsize];
        boolean bl2 = bl ? (string = this.getAttrAbbr(this.metrics[this.getSortIndex(false)].getAbbr())) == null || !string.equals(this.gmetrics[this.getSortIndex(true)].getAbbr()) : true;
        int n = 0;
        while (n < this.gsize) {
            anMetric = this.gmetrics[n];
            if (bl2) {
                anMetric.setSorted(false);
            }
            anMetric.setVisible(false);
            anMetric.setTVisible(false);
            anMetric.setPVisible(false);
            ++n;
        }
        n = 0;
        while (n < this.size) {
            anMetric = this.metrics[n];
            boolean bl3 = bl2 && anMetric.isSorted();
            boolean bl4 = anMetric.isVisible();
            boolean bl5 = anMetric.isTVisible();
            boolean bl6 = anMetric.isPVisible();
            if (bl4 || bl5 || bl6) {
                String string2 = anMetric.getAbbr();
                string = this.getAttrAbbr(string2);
                int n2 = 0;
                while (n2 < this.gsize) {
                    AnMetric anMetric2 = this.gmetrics[n2];
                    String string3 = anMetric2.getAbbr();
                    boolean bl7 = string3.equals(string2);
                    if (bl7 || string3.equals(string)) {
                        if (bl3 && bl7) {
                            anMetric2.setSorted(true);
                        }
                        if (bl4) {
                            anMetric2.setVisible(true);
                        }
                        if (bl5) {
                            anMetric2.setTVisible(true);
                        }
                        if (bl6) {
                            anMetric2.setPVisible(true);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.gsize) {
            anMetric = this.gmetrics[n];
            blArray[n] = anMetric.isVisible();
            blArray2[n] = anMetric.isTVisible();
            blArray3[n] = anMetric.isPVisible();
            ++n;
        }
        Presentation.setVisible(this.win_id, blArray, blArray2, blArray3, true);
    }

    public int getSortCol(boolean bl) {
        AnMetric[] anMetricArray;
        int n;
        int n2 = 0;
        if (bl) {
            n = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            n = this.size;
            anMetricArray = this.metrics;
        }
        int n3 = 0;
        while (n3 < n) {
            boolean bl2;
            AnMetric anMetric = anMetricArray[n3];
            boolean bl3 = bl2 = anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible();
            if (anMetric.isSorted()) {
                return bl2 ? n2 : -n3 - 1;
            }
            if (bl2) {
                ++n2;
            }
            ++n3;
        }
        return 0;
    }

    public void setSortCol(int n, boolean bl) {
        AnMetric[] anMetricArray;
        int n2;
        int n3 = 0;
        if (bl) {
            n2 = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            n2 = this.size;
            anMetricArray = this.metrics;
        }
        int n4 = 0;
        while (n4 < n2) {
            AnMetric anMetric = anMetricArray[n4];
            if (anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible()) {
                anMetric.setSorted(n3 == n);
                ++n3;
            } else {
                anMetric.setSorted(false);
            }
            ++n4;
        }
    }

    public int getSortIndex(boolean bl) {
        AnMetric[] anMetricArray;
        int n;
        if (bl) {
            n = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            n = this.size;
            anMetricArray = this.metrics;
        }
        int n2 = 0;
        while (n2 < n) {
            if (anMetricArray[n2].isSorted()) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public void setSortIndex(int n, boolean bl) {
        AnMetric[] anMetricArray;
        int n2;
        if (bl) {
            n2 = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            n2 = this.size;
            anMetricArray = this.metrics;
        }
        int n3 = 0;
        while (n3 < n2) {
            anMetricArray[n3].setSorted(n3 == n);
            ++n3;
        }
        Presentation.setSort(this.win_id, n, bl);
    }

    public int getVisibleIndex(int n, boolean bl) {
        AnMetric[] anMetricArray;
        int n2;
        int n3 = 0;
        if (bl) {
            n2 = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            n2 = this.size;
            anMetricArray = this.metrics;
        }
        int n4 = 0;
        while (n4 < n2) {
            AnMetric anMetric = anMetricArray[n4];
            if (anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible()) {
                if (n == n3) {
                    return n4;
                }
                ++n3;
            }
            ++n4;
        }
        return -1;
    }

    public void updateSortList(int n, int n2) {
        boolean bl = n2 == 6;
        n = this.getVisibleIndex(n, bl);
        this.setSortIndex(n, bl);
        int n3 = -1;
        if (bl) {
            Object[] objectArray = new AnMetric[this.size];
            int n4 = 0;
            while (n4 < this.size) {
                objectArray[n4] = this.order_list.getMetric(n4);
                ++n4;
            }
            n3 = this.getMetricIndex(objectArray, this.gmetrics[n], false);
        } else {
            AnMetric anMetric = this.metrics[n];
            int n5 = 0;
            while (n5 < this.size) {
                if (anMetric == this.order_list.getMetric(n5)) {
                    n3 = n5;
                    break;
                }
                ++n5;
            }
        }
        if (n3 != -1) {
            this.order_list.setCheck(n3);
            this.needNewSort();
            if (!bl) {
                this.updateGMetrics(true);
                Presentation.setSort(this.win_id, this.getSortIndex(true), true);
            }
            this.fireAnEvent(new AnEvent(this, 9, n2, 0));
        }
    }

    public void updateOrderList(int n, int n2, int n3) {
        boolean bl = n3 == 6;
        if ((n = this.getVisibleIndex(n, bl)) == (n2 = this.getVisibleIndex(n2, bl))) {
            return;
        }
        if (bl) {
            this.switchMetrics(n, n2, true);
            n = this.getMetricIndex(this.metrics, this.gmetrics[n], true);
            if (n == -1) {
                return;
            }
            if ((n2 = this.getMetricIndex(this.metrics, this.gmetrics[n2], true)) == -1) {
                return;
            }
        } else {
            this.switchMetrics(this.getMetricIndex(this.gmetrics, this.metrics[n], false), this.getMetricIndex(this.gmetrics, this.metrics[n2], false), true);
        }
        this.order_list.moveOne(n, n2);
        this.drag_order = true;
        this.needNewOrder();
        this.fireAnEvent(new AnEvent(this, 10, n3, 0));
    }

    private void switchMetrics(int n, int n2, boolean bl) {
        AnMetric anMetric;
        AnMetric[] anMetricArray;
        if (bl) {
            int n3 = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            int n4 = this.size;
            anMetricArray = this.metrics;
        }
        AnMetric anMetric2 = anMetricArray[n];
        anMetricArray[n] = anMetric = anMetricArray[n2];
        anMetricArray[n2] = anMetric2;
        Presentation.setSwitch(this.win_id, n, n2, bl);
    }

    private int getMetricIndex(Object[] objectArray, AnMetric anMetric, boolean bl) {
        String string;
        String string2 = anMetric.getAbbr();
        String string3 = string = string2.startsWith(attr_abbr) ? string2.substring(attr_abbr.length()) : null;
        if (bl && string != null) {
            return -1;
        }
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string4 = ((AnMetric)objectArray[n2]).getAbbr();
            if (string == null ? string2.equals(string4) : (string4.startsWith(excl_abbr) ? string.equals(string4.substring(excl_abbr.length())) : string4.startsWith(incl_abbr) && string.equals(string4.substring(incl_abbr.length())))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private String[] getTitle(String string) {
        int n;
        JLabel jLabel = new JLabel(string, AnUtility.mtna_icon, 0);
        int n2 = jLabel.getPreferredSize().width;
        int n3 = n2 / 2;
        String[] stringArray = new String[2];
        int n4 = 0;
        stringArray[0] = "";
        stringArray[1] = string;
        while ((n = string.indexOf(32, n4)) != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
            jLabel = new JLabel(stringArray[0], AnUtility.mtna_icon, 0);
            if (jLabel.getPreferredSize().width > n3) break;
            n4 = n + 1;
        }
        return stringArray;
    }

    public MetricLabel[] getLabel(Object[][] objectArray, Object[] objectArray2, boolean bl, AnTable anTable) {
        AnMetric anMetric;
        AnMetric[] anMetricArray;
        int n;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        double[] dArray = (double[])objectArray2[0];
        double[] dArray2 = (double[])objectArray2[1];
        if (bl) {
            n = this.gsize;
            anMetricArray = this.gmetrics;
        } else {
            n = this.size;
            anMetricArray = this.metrics;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            anMetric = anMetricArray[n3];
            if (anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible()) {
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        MetricLabel[] metricLabelArray = new MetricLabel[n2];
        n3 = 0;
        while (n3 < n) {
            anMetric = anMetricArray[n3];
            if (anMetric.isVisible() || anMetric.isTVisible() || anMetric.isPVisible()) {
                int n5;
                String string;
                ImageIcon imageIcon;
                AnObject anObject;
                if (objectArray[n4] instanceof AnDouble[]) {
                    anObject = new AnDouble(dArray[n3]);
                    imageIcon = AnUtility.sodn_icon;
                } else if (objectArray[n4] instanceof AnInteger[]) {
                    anObject = new AnInteger((int)dArray[n3]);
                    imageIcon = AnUtility.sodn_icon;
                } else if (objectArray[n4] instanceof AnAddress[]) {
                    anObject = new AnAddress((long)dArray[n3] | Long.MIN_VALUE);
                    imageIcon = AnUtility.soup_icon;
                } else if (objectArray[n4] instanceof AnLong[]) {
                    anObject = new AnLong((long)dArray[n3]);
                    imageIcon = AnUtility.sodn_icon;
                } else if (objectArray[n4] instanceof String[]) {
                    String[] stringArray = (String[])objectArray[n4];
                    int n6 = stringArray.length;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < n6) {
                        int n10 = anTable.stringWidth(stringArray[n9]);
                        if (n7 < n10) {
                            n7 = n10;
                            n8 = n9;
                        }
                        ++n9;
                    }
                    anObject = new AnString(n6 == 0 ? "" : stringArray[n8]);
                    this.name_col = n4;
                    imageIcon = AnUtility.soup_icon;
                } else {
                    anObject = null;
                    imageIcon = AnUtility.sono_icon;
                }
                String string2 = anMetric.getName();
                if (anMetric.isVisible()) {
                    string = anMetric.getUnit();
                    if (string.length() > 0) {
                        string = "(" + string + ")";
                    }
                } else {
                    string = null;
                }
                double d = anMetric.isTVisible() ? ((n5 = anMetric.getClock()) != 0 ? 1.0E-6 / (double)n5 : 0.0) : -1.0;
                double d2 = anMetric.isPVisible() ? (dArray[n3] != 0.0 ? 100.0 / dArray[n3] : 0.0) : -1.0;
                metricLabelArray[n4++] = new MetricLabel(anMetric.getAbbr(), string2, string, d, d2, anObject, imageIcon);
            }
            ++n3;
        }
        return metricLabelArray;
    }

    public int getNameCol() {
        return this.name_col;
    }

    private static native Object[] getDefaultMetric(int var0, boolean var1);

    private static native void setVisible(int var0, boolean[] var1, boolean[] var2, boolean[] var3, boolean var4);

    private static native void setSort(int var0, int var1, boolean var2);

    private static native void setOrder(int var0, int[] var1);

    private static native void setSwitch(int var0, int var1, int var2, boolean var3);

    private static native void setGMetrics(int var0);

    private static native int[] getAnoValue(int var0);

    private static native void setAnoValue(int var0, int[] var1);

    private static native boolean getNameFormat(int var0);

    private static native void setNameFormat(int var0, boolean var1);

    static {
        excl_abbr = AnLocale.getString("Excl. ");
        incl_abbr = AnLocale.getString("Incl. ");
        attr_abbr = AnLocale.getString("Attr. ");
        excl_name = AnLocale.getString("Exclusive ");
        incl_name = AnLocale.getString("Inclusive ");
        attr_name = AnLocale.getString("Attributed ");
        time_str = AnLocale.getString(" Time");
        ccmv_type = new int[11];
        ccmv_desc = new String[11];
        ccmv_comd = new String[11];
        ccmv_mnem = new char[11];
        Presentation.ccmv_type[0] = 1024;
        Presentation.ccmv_desc[0] = AnLocale.getString("Default");
        Presentation.ccmv_comd[0] = "basic";
        Presentation.ccmv_mnem[0] = 68;
        Presentation.ccmv_type[1] = 1;
        Presentation.ccmv_desc[1] = AnLocale.getString("Versioning");
        Presentation.ccmv_comd[1] = "version";
        Presentation.ccmv_mnem[1] = 86;
        Presentation.ccmv_type[2] = 2;
        Presentation.ccmv_desc[2] = AnLocale.getString("Warning");
        Presentation.ccmv_comd[2] = "warn";
        Presentation.ccmv_mnem[2] = 87;
        Presentation.ccmv_type[3] = 4;
        Presentation.ccmv_desc[3] = AnLocale.getString("Parallelization");
        Presentation.ccmv_comd[3] = "parallel";
        Presentation.ccmv_mnem[3] = 80;
        Presentation.ccmv_type[4] = 8;
        Presentation.ccmv_desc[4] = AnLocale.getString("Compiler queries");
        Presentation.ccmv_comd[4] = "query";
        Presentation.ccmv_mnem[4] = 113;
        Presentation.ccmv_type[5] = 16;
        Presentation.ccmv_desc[5] = AnLocale.getString("Loop detail");
        Presentation.ccmv_comd[5] = "loop";
        Presentation.ccmv_mnem[5] = 76;
        Presentation.ccmv_type[6] = 32;
        Presentation.ccmv_desc[6] = AnLocale.getString("Pipelining");
        Presentation.ccmv_comd[6] = "pipe";
        Presentation.ccmv_mnem[6] = 110;
        Presentation.ccmv_type[7] = 64;
        Presentation.ccmv_desc[7] = AnLocale.getString("Inlining information");
        Presentation.ccmv_comd[7] = "inline";
        Presentation.ccmv_mnem[7] = 73;
        Presentation.ccmv_type[8] = 128;
        Presentation.ccmv_desc[8] = AnLocale.getString("Memory operations");
        Presentation.ccmv_comd[8] = "memops";
        Presentation.ccmv_mnem[8] = 77;
        Presentation.ccmv_type[9] = 256;
        Presentation.ccmv_desc[9] = AnLocale.getString("Front-end");
        Presentation.ccmv_comd[9] = "fe";
        Presentation.ccmv_mnem[9] = 70;
        Presentation.ccmv_type[10] = 512;
        Presentation.ccmv_desc[10] = AnLocale.getString("Code-generator");
        Presentation.ccmv_comd[10] = "cg";
        Presentation.ccmv_mnem[10] = 103;
    }

    public class MetricLabel {
        ImageIcon icon;
        ImageIcon sort_icon;
        String[] title;
        String tip;
        String unit;
        double clock;
        double total;
        AnObject max_obj;

        public MetricLabel(String string, String string2, String string3, double d, double d2, AnObject anObject, ImageIcon imageIcon) {
            this.tip = string2;
            this.unit = string3;
            this.clock = d;
            this.total = d2;
            this.max_obj = anObject;
            this.sort_icon = imageIcon;
            if (string.startsWith(excl_abbr)) {
                this.icon = AnUtility.excl_icon;
                this.title = Presentation.this.getTitle(string.substring(excl_abbr.length()));
            } else if (string.startsWith(incl_abbr)) {
                this.icon = AnUtility.incl_icon;
                this.title = Presentation.this.getTitle(string.substring(incl_abbr.length()));
            } else if (string.startsWith(attr_abbr)) {
                this.icon = AnUtility.attr_icon;
                this.title = Presentation.this.getTitle(string.substring(attr_abbr.length()));
            } else {
                this.icon = null;
                this.title = Presentation.this.getTitle(string);
            }
        }
    }

    private class TabHandler
    implements ChangeListener {
        private TabHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            String string = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
            if (string.equals(AnLocale.getString("Sort"))) {
                Presentation.this.updateListVisible();
            }
        }
    }
}

