/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnList;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class PrintChooser
extends AnDialog {
    private JRadioButton chk_printer;
    private JRadioButton chk_file;
    private JTextField printer;
    private JTextField file;

    public PrintChooser(int n, JFrame jFrame) {
        super(n, jFrame, AnLocale.getString("Print"), false, null, null, null);
        this.initComponents();
    }

    private void initComponents() {
        AnList anList = new AnList(false);
        anList.setBorder(new EtchedBorder(1));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.chk_printer = new JRadioButton(AnLocale.getString("Printer:"), true);
        buttonGroup.add(this.chk_printer);
        this.chk_printer.setMnemonic('P');
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.printer = new JTextField(20);
        jPanel.add(this.printer);
        anList.add(this.chk_printer, jPanel);
        this.chk_file = new JRadioButton(AnLocale.getString("File:"), false);
        buttonGroup.add(this.chk_file);
        this.chk_file.setMnemonic('F');
        jPanel = new JPanel(new FlowLayout(0));
        this.file = new JTextField(20);
        jPanel.add(this.file);
        JButton jButton = new JButton(AnLocale.getString("Browse..."));
        jPanel.add(jButton);
        jButton.addActionListener(this.dialog);
        jButton.setMnemonic('B');
        anList.add(this.chk_file, jPanel);
        anList.setAlignmentX();
        jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)AnUtility.getTitle(AnLocale.getString("Print to:")), "North");
        jPanel.add((Component)anList, "Center");
        this.setAccessory(jPanel);
        this.chk_printer.setNextFocusableComponent(this.printer);
        this.printer.setNextFocusableComponent(this.chk_file);
        this.chk_file.setNextFocusableComponent(this.file);
    }

    public void setComponents() {
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.chk_printer.isSelected()) {
                this.printer.requestFocus();
            } else {
                this.file.requestFocus();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(AnLocale.getString("Browse..."))) {
            String string = this.getFile();
            if (string != null) {
                this.file.setText(string);
            }
        } else {
            this.showError(this.window.print(this.chk_printer.isSelected() ? this.printer.getText() : null, this.chk_file.isSelected() ? this.file.getText() : null));
        }
    }

    private String getFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser(AnVariable.pwd_dir);
        jFileChooser.setDialogTitle(AnLocale.getString("Print to File"));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showSaveDialog(this.dialog) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            return file.getAbsolutePath();
        }
        return null;
    }
}

