/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnDisplay;
import com.sun.forte.st.mpmt.AnDouble;
import com.sun.forte.st.mpmt.AnList;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnTextIcon;
import com.sun.forte.st.mpmt.AnTree;
import com.sun.forte.st.mpmt.AnUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;

public class StatisticsDisp
extends AnDisplay {
    private static final DecimalFormat statis_fmt = new DecimalFormat("0.###");
    private AnTree tree;

    public StatisticsDisp(int n, int n2, boolean bl, String string) {
        super(n, n2, bl, string);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.tree = new AnTree(AnLocale.getString("Experiments"), 1);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void addExperiment(boolean bl) {
        AnTextIcon[] anTextIconArray = AnUtility.getExperimentList();
        if (anTextIconArray == null) {
            return;
        }
        int n = this.tree.addExtra(AnLocale.getString("<Sum across selected experiments>"), bl);
        this.tree.addNodes(anTextIconArray, n);
    }

    public void dropExperiment(int[] nArray) {
        this.tree.removeNodes(nArray);
    }

    public void doCompute(AnDisplay anDisplay) {
        if (!this.selected) {
            return;
        }
        if (!this.computed) {
            Object[] objectArray = StatisticsDisp.getOverviewList(this.win_id);
            String string = AnDisplay.errorMsg(this.win_id, 0);
            if (objectArray != null && string == null) {
                Object[] objectArray2 = StatisticsDisp.getStatisList(this.win_id);
                string = AnDisplay.errorMsg(this.win_id, 0);
                if (objectArray2 != null && string == null) {
                    int n = objectArray.length;
                    int n2 = 1;
                    while (n2 < n) {
                        this.tree.setContent(n2 - 1, this.getContent(objectArray, objectArray2, n2));
                        ++n2;
                    }
                }
            }
            this.showError(string);
        } else if (!this.updated) {
            // empty if block
        }
        this.tree.setSelectionRow(0);
        this.computed = true;
        this.updated = true;
    }

    private JPanel getContent(Object[] objectArray, Object[] objectArray2, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        AnList anList = this.processOVData(objectArray, n);
        anList.setBorder(new EtchedBorder(1));
        jPanel.add(anList);
        jPanel.add(Box.createHorizontalStrut(4));
        AnList anList2 = this.processSTData(objectArray2, n);
        anList2.setBorder(new EtchedBorder(1));
        jPanel.add(anList2);
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        jPanel2.setBorder(new EtchedBorder(1));
        jPanel2.add((Component)AnUtility.getHeader(AnLocale.getString("Execution statistics for entire program:")), "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    private AnList processOVData(Object[] objectArray, int n) {
        AnDouble anDouble;
        AnList anList = new AnList(false);
        String[] stringArray = (String[])objectArray[0];
        double[] dArray = (double[])objectArray[n];
        int n2 = stringArray.length;
        double d = 0.0;
        int n3 = 3;
        while (n3 < n2) {
            d += dArray[n3];
            ++n3;
        }
        int n4 = new AnDouble(d).toString().length() + "         ".length();
        if (d != 0.0) {
            d = 100.0 / d;
        }
        n3 = 0;
        while (n3 < 3) {
            anDouble = new AnDouble(dArray[n3]);
            String string = anDouble.doubleValue() < 0.0 ? AnLocale.getString("N/A") : anDouble.toString();
            anList.add(AnUtility.getItem(stringArray[n3] + ":"), AnUtility.getNumber(string + "         ", n4));
            ++n3;
        }
        anList.add((JComponent)null, null);
        anList.add(AnUtility.getItem(AnLocale.getString("Process Times (sec):")), null);
        n3 = 3;
        while (n3 < n2) {
            anDouble = new AnDouble(dArray[n3]);
            anList.add(AnUtility.getItem(stringArray[n3] + ":"), AnUtility.getNumber(new AnDouble(dArray[n3]).toPercentQuote(d), n4));
            ++n3;
        }
        return anList;
    }

    private AnList processSTData(Object[] objectArray, int n) {
        AnList anList = new AnList(false);
        String[] stringArray = (String[])objectArray[0];
        double[] dArray = (double[])objectArray[n];
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            stringArray2[n4] = statis_fmt.format(dArray[n4]);
            int n5 = stringArray2[n4].length();
            if (n3 < n5) {
                n3 = n5;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            anList.add(AnUtility.getItem(stringArray[n4] + ":"), AnUtility.getNumber(stringArray2[n4], n3));
            ++n4;
        }
        return anList;
    }

    private static native Object[] getOverviewList(int var0);

    private static native Object[] getStatisList(int var0);
}

