/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt;

import com.sun.forte.st.mpmt.AnDouble;
import com.sun.forte.st.mpmt.AnInteger;
import com.sun.forte.st.mpmt.AnList;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnLong;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import com.sun.forte.st.mpmt.Analyzer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SummaryDisp
extends JPanel {
    private static final int PRF_WIDTH = 370;
    private static final int MIN_WIDTH = 200;
    private int win_id;
    private AnWindow window;
    private AnList func_info;
    private AnList metrics_info;
    private JComponent[] func_text;
    private JComponent[] excl_text;
    private JComponent[] ev_text;
    private JComponent[] incl_text;
    private JComponent[] iv_text;
    private boolean func_renew;
    private boolean metrics_renew;
    private int[] align;

    public SummaryDisp(int n, String string) {
        this.win_id = n;
        this.window = AnWindow.get_win(n);
        this.func_renew = true;
        this.metrics_renew = true;
        this.align = null;
        this.initComponents();
        if (Analyzer.help_broker != null && string != null) {
            Analyzer.help_broker.enableHelpKey(this, string, null);
        }
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(AnUtility.getHeader(AnLocale.getString("Data for Selected Function/Load-Object:")));
        this.func_info = new AnList(true);
        jPanel.add(this.func_info);
        jPanel.add(new JSeparator(0));
        jPanel.add(AnUtility.getHeader(AnLocale.getString("Process Times (sec.) / Counts")));
        this.metrics_info = new AnList(true);
        jPanel.add(this.metrics_info);
        this.add((Component)new JScrollPane(jPanel), "Center");
        this.func_info.setBorder(AnVariable.boxBorder);
        this.metrics_info.setBorder(AnVariable.boxBorder);
        this.setPreferredSize(new Dimension(370, 450));
        this.setMinimumSize(new Dimension(200, 450));
    }

    public void reset() {
        this.metrics_renew = true;
    }

    public void compute(int n, int n2) {
        final int n3 = n;
        final int n4 = n2;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AnVariable.worker_lock;
                synchronized (object) {
                    SummaryDisp.this.window.setBusyCursor(true);
                    SummaryDisp.this.doCompute(n3, n4);
                    SummaryDisp.this.window.setBusyCursor(false);
                }
            }
        };
        thread.start();
    }

    public void doCompute(int n, int n2) {
        JLabel jLabel;
        int n3;
        int n4;
        String[] stringArray;
        char[] cArray;
        boolean bl = false;
        Object[] objectArray = SummaryDisp.getSummary(this.win_id, n, n2);
        if (objectArray == null) {
            return;
        }
        Object[] objectArray2 = (Object[])objectArray[0];
        if (objectArray2 != null) {
            this.align = (int[])objectArray2[0];
            cArray = (char[])objectArray2[1];
            stringArray = (String[])objectArray2[2];
            String[] stringArray2 = (String[])objectArray2[3];
            n4 = stringArray.length;
            if (this.func_renew) {
                this.func_info.removeAll();
                this.func_text = new AnUtility.AnText[n4];
                n3 = 0;
                while (n3 < n4) {
                    this.func_text[n3] = AnUtility.getText(stringArray2[n3] != null ? stringArray2[n3] : "", 30);
                    jLabel = (JLabel)AnUtility.getItem(stringArray[n3] + ":");
                    jLabel.setDisplayedMnemonic(cArray[n3]);
                    jLabel.setLabelFor(this.func_text[n3]);
                    this.func_info.add(jLabel, this.func_text[n3]);
                    ++n3;
                }
                Dimension dimension = this.func_info.getMaximumSize();
                dimension.height = this.func_info.getPreferredSize().height;
                this.func_info.setMaximumSize(dimension);
                this.func_renew = false;
                bl = true;
            } else {
                n3 = 0;
                while (n3 < n4) {
                    ((JTextField)this.func_text[n3]).setText(stringArray2[n3] != null ? stringArray2[n3] : "");
                    ++n3;
                }
            }
        } else {
            this.func_info.removeAll();
            this.func_info.addLabel(new JLabel(AnLocale.getString("No Data")));
        }
        Object[] objectArray3 = (Object[])objectArray[1];
        if (objectArray3 != null) {
            stringArray = (String[])objectArray3[0];
            double[] dArray = (double[])objectArray3[1];
            double[] dArray2 = (double[])objectArray3[2];
            double[] dArray3 = (double[])objectArray3[3];
            double[] dArray4 = (double[])objectArray3[4];
            double[] dArray5 = (double[])objectArray3[5];
            int[] nArray = (int[])objectArray3[6];
            cArray = (char[])objectArray3[7];
            n4 = stringArray.length;
            String[] stringArray3 = new String[n4];
            String[] stringArray4 = new String[n4];
            String[] stringArray5 = new String[n4];
            String[] stringArray6 = new String[n4];
            int n5 = 0;
            n3 = 0;
            while (n3 < n4) {
                stringArray6[n3] = null;
                stringArray4[n3] = null;
                switch (nArray[n3]) {
                    case 5: {
                        stringArray3[n3] = new AnDouble(dArray2[n3]).toPercentQuote(dArray3[n3]);
                        stringArray5[n3] = new AnDouble(dArray4[n3]).toPercentQuote(dArray5[n3]);
                        break;
                    }
                    case 2: {
                        stringArray3[n3] = new AnInteger((int)dArray2[n3]).toPercentQuote(dArray3[n3]);
                        stringArray5[n3] = new AnInteger((int)dArray4[n3]).toPercentQuote(dArray5[n3]);
                        break;
                    }
                    case 3: {
                        if (dArray[n3] == 0.0) {
                            stringArray3[n3] = new AnLong((long)dArray2[n3]).toPercentQuote(dArray3[n3]);
                            stringArray5[n3] = new AnLong((long)dArray4[n3]).toPercentQuote(dArray5[n3]);
                            break;
                        }
                        stringArray4[n3] = new AnLong((long)dArray2[n3]).toString() + "         ";
                        stringArray3[n3] = new AnDouble(dArray2[n3] / dArray[n3]).toPercentQuote(dArray3[n3]);
                        stringArray6[n3] = new AnLong((long)dArray4[n3]).toString() + "         ";
                        stringArray5[n3] = new AnDouble(dArray4[n3] / dArray[n3]).toPercentQuote(dArray5[n3]);
                        break;
                    }
                    default: {
                        stringArray5[n3] = " ";
                        stringArray3[n3] = " ";
                    }
                }
                int n6 = stringArray3[n3].length();
                if (n5 < n6) {
                    n5 = n6;
                }
                if (n5 < (n6 = stringArray5[n3].length())) {
                    n5 = n6;
                }
                if (stringArray4[n3] != null) {
                    n6 = stringArray4[n3].length();
                    if (n5 < n6) {
                        n5 = n6;
                    }
                    if (n5 < (n6 = stringArray6[n3].length())) {
                        n5 = n6;
                    }
                }
                ++n3;
            }
            if (this.metrics_renew) {
                this.metrics_info.removeAll();
                JPanel jPanel = new JPanel(new GridLayout(1, 2));
                jPanel.add(AnUtility.getHeader(AnLocale.getString("Exclusive"), AnUtility.excl_icon));
                jPanel.add(AnUtility.getHeader(AnLocale.getString("Inclusive"), AnUtility.incl_icon));
                this.metrics_info.add((JComponent)null, jPanel);
                this.excl_text = new AnUtility.AnText[n4];
                this.ev_text = new AnUtility.AnText[n4];
                this.incl_text = new AnUtility.AnText[n4];
                this.iv_text = new AnUtility.AnText[n4];
                n3 = 0;
                while (n3 < n4) {
                    this.excl_text[n3] = AnUtility.getNumber(stringArray3[n3], n5);
                    this.incl_text[n3] = AnUtility.getNumber(stringArray5[n3], n5);
                    jPanel = new JPanel(new GridLayout(1, 2));
                    jPanel.add(this.excl_text[n3]);
                    jPanel.add(this.incl_text[n3]);
                    jLabel = (JLabel)AnUtility.getItem(stringArray[n3] + ":");
                    if (cArray[n3] != '\u0000') {
                        jLabel.setDisplayedMnemonic(cArray[n3]);
                        jLabel.setLabelFor(this.excl_text[n3]);
                    }
                    this.metrics_info.add(jLabel, jPanel);
                    if (stringArray4[n3] != null) {
                        this.ev_text[n3] = AnUtility.getNumber(stringArray4[n3], n5);
                        this.iv_text[n3] = AnUtility.getNumber(stringArray6[n3], n5);
                        jPanel = new JPanel(new GridLayout(1, 2));
                        jPanel.add(this.ev_text[n3]);
                        jPanel.add(this.iv_text[n3]);
                        this.metrics_info.add(AnUtility.getItem(AnLocale.getString("\" count:")), jPanel);
                    } else {
                        this.iv_text[n3] = null;
                        this.ev_text[n3] = null;
                    }
                    ++n3;
                }
                this.metrics_info.setAlignmentX();
                this.metrics_renew = false;
                bl = true;
            } else {
                if (n5 != 0) {
                    n5 += 2;
                }
                n3 = 0;
                while (n3 < n4) {
                    ((JTextField)this.excl_text[n3]).setText(stringArray3[n3]);
                    ((JTextField)this.excl_text[n3]).setColumns(n5);
                    ((JTextField)this.incl_text[n3]).setText(stringArray5[n3]);
                    ((JTextField)this.incl_text[n3]).setColumns(n5);
                    if (this.ev_text[n3] != null && stringArray4[n3] != null) {
                        ((JTextField)this.ev_text[n3]).setText(stringArray4[n3]);
                        ((JTextField)this.ev_text[n3]).setColumns(n5);
                        ((JTextField)this.iv_text[n3]).setText(stringArray6[n3]);
                        ((JTextField)this.iv_text[n3]).setColumns(n5);
                    }
                    ++n3;
                }
            }
        } else {
            this.metrics_info.removeAll();
            this.metrics_info.addLabel(new JLabel(AnLocale.getString("No Data")));
        }
        if (bl) {
            this.validate();
        }
        n4 = this.func_text.length;
        n3 = 0;
        while (n3 < n4) {
            ((AnUtility.AnText)this.func_text[n3]).setVisibleAlign(this.align[n3]);
            ++n3;
        }
    }

    private void showError(String string) {
        this.window.showError(string);
    }

    private static native Object[] getSummary(int var0, int var1, int var2);
}

