/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.timeline.AnalyzerThread;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimelineEvent;
import com.sun.forte.st.mpmt.timeline.DurationEvent;
import com.sun.forte.st.mpmt.timeline.Event;
import com.sun.forte.st.mpmt.timeline.Experiment;
import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewRenderer;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import java.util.Enumeration;

public class AnalyzerRenderer
extends ThreadViewRenderer {
    protected transient Event[][] data;
    protected int[] labels;
    protected AnalyzerThread[] athreads;
    protected int maxPixels = 5;
    protected long clickTime;
    protected int blankIndex;
    protected boolean invalidState;
    protected Event[][] eventData;
    public int xWidth;

    public AnalyzerRenderer(PhatDataSet phatDataSet, Timeline timeline) {
        this.set = phatDataSet;
        this.canvas = timeline;
        this.zoom = 1.0f;
        this.gatherData();
    }

    public void gatherData() {
        this.out = new AnalyzerTimelineEvent(this);
        ((AnalyzerTimelineEvent)this.out).firstPass = true;
        this.group = this.set.getAllThreads();
        this.maxTime = ((Experiment)this.set).getEndTime();
        Enumeration enumeration = this.group.allChildThreads();
        this.numThreads = this.group.numThreads();
        this.data = new Event[this.numThreads][];
        this.lastIndex = new int[this.numThreads];
        this.labels = new int[this.numThreads];
        this.athreads = new AnalyzerThread[this.numThreads];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            this.athreads[n] = (AnalyzerThread)enumeration.nextElement();
            this.data[n] = this.athreads[n].getData();
            this.labels[n] = this.athreads[n].getNumber();
            this.lastIndex[n] = -1;
            ++n;
        }
        this.subData = new long[n][];
        this.eventData = new Event[n][];
        int n2 = 0;
        while (n2 < this.numThreads) {
            this.subData[n2] = new long[this.width + 2];
            this.eventData[n2] = new Event[this.width + 2];
            ++n2;
        }
        this.blankIndex = 0;
        this.navigationIndex = 0;
        this.thread = 0;
        while (this.thread < this.data.length && this.data[this.thread].length == 0) {
            ++this.thread;
        }
        this.doCalculations();
        if (this.thread < this.data.length) {
            this.invalidState = false;
            this.clickTime = this.data[this.thread][0].getTimestamp() + this.timeStep;
        } else {
            this.invalidState = true;
            this.thread = -1;
        }
        this.last = this.out;
    }

    public ThreadViewEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void computeDrawing(ThreadViewEvent threadViewEvent) {
        ThreadViewEvent threadViewEvent2 = threadViewEvent;
        if (this.invalidState) {
            this.out.data = null;
            this.sendReply(this.out);
        }
        if (threadViewEvent2.zoom == -1.0f && threadViewEvent2.width == -1 && threadViewEvent2.hScroll == this.start && threadViewEvent2.direction == -1 && threadViewEvent2.x <= 0) {
            return;
        }
        ((AnalyzerTimelineEvent)this.out).event = null;
        if (threadViewEvent2.zoom != -1.0f) {
            this.zoom = threadViewEvent2.zoom;
        }
        this.out.zoom = this.zoom;
        if (threadViewEvent2.width > 0) {
            this.width = threadViewEvent2.width;
            this.subData = new long[this.numThreads][];
            this.eventData = new Event[this.numThreads][];
            int n = 0;
            while (n < this.numThreads) {
                this.subData[n] = new long[this.width + 2];
                this.eventData[n] = new Event[this.width + 2];
                ++n;
            }
        }
        this.out.width = this.width;
        if (threadViewEvent2.hScroll != -1) {
            this.start = threadViewEvent2.hScroll;
        }
        this.out.hScroll = this.start;
        if (threadViewEvent2.windowWidth != -1) {
            this.windowWidth = threadViewEvent2.windowWidth;
        }
        this.out.windowWidth = this.windowWidth;
        if (threadViewEvent2.findIndex != -1) {
            this.navigationIndex = threadViewEvent2.findIndex - 1;
            this.thread = threadViewEvent2.thread;
        }
        if (threadViewEvent2.direction == -2) {
            if (this.navigationIndex == -2 && this.blankIndex != -2) {
                this.navigationIndex = this.blankIndex + 1;
                this.blankIndex = -2;
            } else if (this.navigationIndex + 1 < this.data[this.thread].length) {
                ++this.navigationIndex;
            }
            if (this.navigationIndex + 1 < this.data[this.thread].length && this.data[this.thread][this.navigationIndex].getData() == null) {
                ++this.navigationIndex;
            }
            this.render();
            threadViewEvent2.x = this.xSel;
            this.clickTime = (long)(this.start + this.xSel) * this.timeStep;
            ((AnalyzerTimelineEvent)this.out).event = this.data[this.thread][this.navigationIndex];
        } else if (threadViewEvent2.direction == -3) {
            if (this.navigationIndex == -2 && this.blankIndex != -2) {
                this.navigationIndex = this.blankIndex;
                this.blankIndex = -2;
            } else if (this.navigationIndex - 1 >= 0) {
                --this.navigationIndex;
            }
            if (this.data[this.thread].length > 0 && this.clickTime > this.data[this.thread][this.data[this.thread].length - 1].getTimestamp()) {
                this.navigationIndex = this.data[this.thread].length - 1;
            }
            if (this.data[this.thread][this.navigationIndex].getData() == null && this.navigationIndex - 1 >= 0) {
                --this.navigationIndex;
            }
            this.render();
            this.clickTime = (long)(this.start + this.xSel) * this.timeStep;
            threadViewEvent2.x = this.xSel;
            ((AnalyzerTimelineEvent)this.out).event = this.data[this.thread][this.navigationIndex];
        } else if (threadViewEvent2.direction == -4 && this.thread > 0) {
            while (this.thread > 0 && !this.athreads[this.thread - 1].isVisible()) {
                --this.thread;
            }
            --this.thread;
            if (this.thread == -1) {
                this.thread = this.last.thread;
            }
            this.last.thread = this.thread;
            this.last.x = (int)(this.clickTime / this.timeStep - (long)this.start);
            this.findState(this.last, this.out);
            this.render();
            threadViewEvent2 = this.last;
        } else if (threadViewEvent2.direction == -5 && this.thread < this.numThreads - 1) {
            while (this.thread < this.numThreads - 1 && !this.athreads[this.thread + 1].isVisible()) {
                ++this.thread;
            }
            ++this.thread;
            if (this.thread == this.data.length) {
                this.thread = this.last.thread;
            }
            this.last.thread = this.thread;
            this.last.x = (int)(this.clickTime / this.timeStep - (long)this.start);
            this.findState(this.last, this.out);
            this.render();
            threadViewEvent2 = this.last;
        } else if (threadViewEvent2.x >= 0 && threadViewEvent2.thread != -1) {
            this.findState(threadViewEvent2, this.out);
            this.render();
            this.clickTime = (long)(this.start + threadViewEvent2.x) * this.timeStep;
        } else if (threadViewEvent2.findIndex == -1 && threadViewEvent2.x == -1) {
            this.render();
        } else {
            this.render();
        }
        if (this.thread >= 0 && this.navigationIndex == -1 && this.data[this.thread].length > 0) {
            this.out.thread = this.thread;
            this.out.state = 0L;
            this.out.x = this.xSel;
            this.out.time = this.data[this.thread][0].getTimestamp();
            this.out.timeAt = 0L;
            this.out.isSmall = this.isSmall;
            ((AnalyzerTimelineEvent)this.out).event = this.data[this.thread][0];
            ((AnalyzerTimelineEvent)this.out).selectWidth = this.xWidth;
        } else if (this.thread >= 0 && this.navigationIndex != -2 && this.navigationIndex < this.data[this.thread].length && this.data[this.thread].length > 0) {
            this.out.thread = this.thread;
            this.out.x = this.xSel;
            this.out.state = 0L;
            this.out.timeAt = this.data[this.thread][this.navigationIndex].getTimestamp();
            this.out.isSmall = this.isSmall;
            ((AnalyzerTimelineEvent)this.out).event = this.data[this.thread][this.navigationIndex];
            ((AnalyzerTimelineEvent)this.out).selectWidth = this.xWidth;
        } else if (this.thread >= 0) {
            this.out.x = (int)(this.clickTime / this.timeStep - (long)this.start);
            this.out.thread = this.thread;
            ((AnalyzerTimelineEvent)this.out).event = null;
            this.out.state = 0L;
        }
        this.out.enableForward = this.thread >= 0 && this.blankIndex + 1 >= this.data[this.thread].length && this.navigationIndex == -2 ? false : this.thread < 0 || this.navigationIndex != this.data[this.thread].length - 1 && (this.navigationIndex != this.data[this.thread].length - 2 || this.navigationIndex != -2 && this.data[this.thread][this.navigationIndex + 1].getData() != null) && (this.data[this.thread].length <= 2 || this.clickTime <= this.data[this.thread][this.data[this.thread].length - 2].getTimestamp());
        this.out.enableBack = this.thread >= 0 && this.data[this.thread].length > 0 && this.clickTime > this.data[this.thread][this.data[this.thread].length - 1].getTimestamp() ? true : this.navigationIndex > 0 || this.blankIndex > 0;
        this.out.data = this.subData;
        this.out.timeStep = this.timeStep;
        ((AnalyzerTimelineEvent)this.out).labels = this.labels;
        ((AnalyzerTimelineEvent)this.out).events = this.eventData;
        this.currentEvent = this.out;
        this.last = threadViewEvent2;
        this.sendReply(this.out);
    }

    public void sendReply(ThreadViewEvent threadViewEvent) {
        this.canvas.redraw(threadViewEvent);
        this.out = new AnalyzerTimelineEvent(this);
    }

    /*
     * Unable to fully structure code
     */
    private void findState(ThreadViewEvent var1_1, ThreadViewEvent var2_2) {
        if (var1_1.thread > this.data.length || var1_1.thread == -1) {
            this.thread = -1;
            var2_2.thread = -1;
            var1_1.thread = -1;
            return;
        }
        if (this.data[var1_1.thread].length == 0) {
            this.navigationIndex = -2;
            this.blankIndex = 0;
            this.thread = var1_1.thread;
            var2_2.thread = var1_1.thread;
            return;
        }
        this.doCalculations();
        var3_3 = this.start;
        if (var1_1.x <= 0) {
            var1_1.x += this.start;
            this.start = 0;
        }
        var7_4 = null;
        var8_5 = this.start - 1;
        var9_6 = this.start;
        var10_7 = -1;
        var11_8 = this.data[var1_1.thread];
        this.navigationIndex = -1;
        var12_9 = var11_8.length;
        var13_10 = false;
        var14_11 = var11_8[0] instanceof DurationEvent;
        var4_12 = -1;
        var5_13 = this.timeStep * (long)this.start;
        this.xSel = -1;
        while (var10_7 == -1 && var4_12 + 1 < var12_9) {
            block24: {
                block25: {
                    if (var5_13 < var11_8[var4_12 + 1].getTimestamp()) break block24;
                    if (!var14_11) ** GOTO lbl-1000
                    while (var4_12 + 1 < var12_9 && var5_13 > var11_8[var4_12 + 1].getTimestamp()) {
                        ++var4_12;
                    }
                    break block25;
                    while (++var4_12 + 1 >= var12_9 || var11_8[var4_12 + 1].getData() != null || var7_4 != null) lbl-1000:
                    // 2 sources

                    {
                        if (var4_12 + 1 < var12_9 && var5_13 > var11_8[var4_12 + 1].getTimestamp()) continue;
                    }
                }
                var7_4 = var11_8[var4_12].getData();
                if (var8_5 < var1_1.x + this.start) {
                    var9_6 = var8_5;
                    this.navigationIndex = var4_12;
                    var13_10 = true;
                } else if (var8_5 >= var1_1.x + this.start) {
                    var10_7 = var8_5;
                }
                if (var9_6 > this.start) {
                    this.xSel = var8_5 - this.start;
                }
            }
            if (!var14_11 && var8_5 - var9_6 > this.maxPixels && var8_5 == var1_1.x + this.start) {
                this.blankIndex = this.navigationIndex;
                this.navigationIndex = -2;
                var13_10 = true;
            }
            if (var14_11 && var5_13 < var11_8[0].getTimestamp()) {
                this.navigationIndex = -2;
            }
            ++var8_5;
            var5_13 += this.timeStep;
        }
        if (var9_6 > this.start && var10_7 > this.width) {
            this.xSel = var1_1.x;
        }
        if (!var14_11 && var1_1.x + this.start > var10_7) {
            this.navigationIndex = -2;
        }
        if (var14_11 && this.navigationIndex >= 0 && var11_8[this.navigationIndex].getData() == null) {
            this.blankIndex = this.navigationIndex;
            this.navigationIndex = -2;
        } else if (!var13_10) {
            this.navigationIndex = -2;
            this.blankIndex = -1;
            this.thread = var1_1.thread;
        }
        this.thread = var1_1.thread;
        this.isSmall = false;
        if (this.navigationIndex == -1) {
            this.time = var11_8[0].getTimestamp();
            this.timeAt = 0L;
            ((AnalyzerTimelineEvent)var2_2).event = var11_8[0];
        } else if (this.navigationIndex != -2 && var11_8.length > this.navigationIndex) {
            this.timeAt = var11_8[this.navigationIndex].getTimestamp();
        } else if (this.blankIndex >= var11_8.length) {
            this.navigationIndex = -2;
            this.blankIndex = var11_8.length - 1;
        }
        if (this.xSel <= (var14_11 != false ? 1 : 1)) {
            this.xSel = -1;
        }
        if (var3_3 != this.start) {
            this.start = var3_3;
        }
    }

    private void render() {
        this.doCalculations();
        int n = 0;
        while (n < this.numThreads) {
            if (this.data[n].length != 0) {
                int n2 = this.findFirstIndex(n);
                if (this.data[n].length > 0) {
                    this.render(this.data[n], n, n2);
                }
            }
            ++n;
        }
        this.lastStart = this.start;
    }

    public void doCalculations() {
        if (this.width == 0) {
            return;
        }
        if (this.zoom <= 0.0f) {
            this.zoom = 1.0f;
        }
        this.timeStep = (float)this.width * this.zoom > (float)this.maxTime ? 1L : (long)((float)this.maxTime / this.zoom / (float)this.width);
    }

    /*
     * Unable to fully structure code
     */
    protected void render(Event[] var1_1, int var2_2, int var3_3) {
        var4_4 = this.start;
        var5_5 = 0;
        var12_6 = var1_1.length;
        var13_7 = var1_1[0] instanceof DurationEvent;
        var6_8 = var3_3 + 1;
        this.lastIndex[var2_2] = -1;
        var7_9 = null;
        var9_10 = this.start;
        var8_11 = false;
        var10_12 = this.timeStep * (long)this.start;
        var18_13 = this.start + this.width;
        var19_14 = false;
        if (var2_2 == this.thread) {
            var19_14 = true;
            this.xSel = -1;
            this.xWidth = 1;
            this.isSmall = false;
        }
        while (var4_4 < var18_13) {
            block16: {
                block15: {
                    if (var6_8 > var12_6 || var10_12 < var1_1[var6_8].getTimestamp()) break block16;
                    this.eventData[var2_2][var5_5] = var7_9;
                    this.subData[var2_2][var5_5] = var4_4 - var9_10;
                    ++var5_5;
                    if (var19_14 && this.xSel == -1 && var3_3 == this.navigationIndex) {
                        this.xSel = var9_10 - this.start;
                        this.xWidth = var4_4 - var9_10;
                    } else if (var19_14 && this.xSel == -1 && var3_3 > this.navigationIndex) {
                        this.xSel = var9_10 - this.start;
                        this.isSmall = true;
                    }
                    try {
                        if (var13_7) ** GOTO lbl-1000
                        while (var10_12 > var1_1[var6_8].getTimestamp()) {
                            ++var6_8;
                        }
                        break block15;
                        while (var1_1[++var6_8].getData() != null || var7_9 == null || var7_9.getData() != null) lbl-1000:
                        // 2 sources

                        {
                            if (var10_12 > var1_1[var6_8].getTimestamp()) continue;
                            break;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException var20_15) {
                        break;
                    }
                }
                var3_3 = var6_8 - 1;
                if (this.lastIndex[var2_2] == -1) {
                    this.lastIndex[var2_2] = var3_3;
                }
                var9_10 = var4_4;
                var7_9 = var1_1[var3_3];
            }
            ++var4_4;
            var10_12 += this.timeStep;
        }
        if (var4_4 == var18_13) {
            this.eventData[var2_2][var5_5] = var7_9;
            this.subData[var2_2][var5_5] = var4_4 - var9_10;
            ++var5_5;
        }
        if (var19_14 && this.xSel == -1 && var3_3 == this.navigationIndex) {
            this.xSel = var9_10 - this.start;
            this.xWidth = var4_4 - var9_10;
        } else if (var19_14 && this.xSel == -1 && (var3_3 > this.navigationIndex || var6_8 > this.navigationIndex)) {
            this.xSel = var9_10 - this.start;
            this.isSmall = true;
        }
        this.subData[var2_2][var5_5++] = -1L;
        this.eventData[var2_2][0] = null;
        if (this.xSel + this.xWidth <= (var13_7 != false ? 1 : 1)) {
            this.xSel = -1;
        }
    }

    private int findFirstIndex(int n) {
        int n2 = this.lastIndex[n];
        long l = this.timeStep * (long)this.start;
        if (this.out.windowWidth != -1) {
            return -1;
        }
        try {
            if (this.lastStart > (long)this.start) {
                ++n2;
                while (l < this.data[n][n2].getTimestamp()) {
                    --n2;
                }
            }
            long l2 = this.data[n][--n2].getTimestamp();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    public String getVersion() {
        return "ThreadViewRenderer 1.26 03/07/02";
    }
}

