/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.timeline.Data;
import com.sun.forte.st.mpmt.timeline.Entity;
import com.sun.forte.st.mpmt.timeline.Event;
import com.sun.forte.st.mpmt.timeline.Experiment;
import com.sun.forte.st.mpmt.timeline.ats.PhatThread;
import javax.swing.ImageIcon;

public class AnalyzerThread
extends PhatThread {
    protected Event[] data;
    protected Data kind;
    protected Entity entity;
    protected Experiment experiment;
    protected boolean visible;

    public AnalyzerThread(Event[] eventArray, Entity entity, Data data, Experiment experiment) {
        this.data = eventArray;
        this.entity = entity;
        this.kind = data;
        this.experiment = experiment;
        this.visible = true;
        this.number = entity.getID();
    }

    public int getNumber() {
        return this.entity.getID();
    }

    public int getExpNum() {
        return this.experiment.getID() + 1;
    }

    public long getStartTime() {
        if (this.data.length > 0) {
            return this.data[0].timestamp;
        }
        return 0L;
    }

    public long getEndTime() {
        if (this.data.length > 0) {
            return this.data[this.data.length - 1].timestamp;
        }
        return 0L;
    }

    public int getKind() {
        return this.kind.getKind();
    }

    public String getDataDescription() {
        return this.kind.getDescription();
    }

    public ImageIcon getIcon() {
        return this.kind.getIcon();
    }

    public Event[] getData() {
        return this.data;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void adjustTime(long l) {
        int n = 0;
        while (n < this.data.length) {
            this.data[n].adjustTime(l);
            ++n;
        }
    }
}

