/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnInteger;
import com.sun.forte.st.mpmt.AnList;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.AnWindow;
import com.sun.forte.st.mpmt.Analyzer;
import com.sun.forte.st.mpmt.timeline.AnalyzerRenderer;
import com.sun.forte.st.mpmt.timeline.AnalyzerThread;
import com.sun.forte.st.mpmt.timeline.AnalyzerThreadDraw;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimelineEvent;
import com.sun.forte.st.mpmt.timeline.AnalyzerZoom;
import com.sun.forte.st.mpmt.timeline.Event;
import com.sun.forte.st.mpmt.timeline.Experiment;
import com.sun.forte.st.mpmt.timeline.ExtendedEvent;
import com.sun.forte.st.mpmt.timeline.HWCEvent;
import com.sun.forte.st.mpmt.timeline.OptionsWindow;
import com.sun.forte.st.mpmt.timeline.Sample;
import com.sun.forte.st.mpmt.timeline.StackView;
import com.sun.forte.st.mpmt.timeline.TimelineColorChooser;
import com.sun.forte.st.mpmt.timeline.TimelineDisp;
import com.sun.forte.st.mpmt.timeline.TimelineFunctionList;
import com.sun.forte.st.mpmt.timeline.TimelineMetaExperiment;
import com.sun.forte.st.mpmt.timeline.ats.NavigationListener;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import com.sun.forte.st.mpmt.timeline.ats.ZoomHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AnalyzerTimeline
extends Timeline
implements ListSelectionListener {
    public static final int SUMMARY_PANE = 0;
    public static final int EVENT_PANE = 1;
    public static final int LEGEND_PANE = 2;
    public static final NumberFormat TIMESTAMP_FMT = new DecimalFormat();
    public static final double TIMESTAMP_MULT = 1.0E-9;
    protected static final int BIG_HEIGHT = 5000;
    public static final int[][] MSTATE_REMAP;
    public static final String[] MSTATE_REMAP_DESC;
    public static final String[] MSTATE_DESC;
    public static final Color[] MSTATE_COLORS;
    protected static final int COLUMNS = 0;
    protected static final int NUM_EVT_SPC_LBL = 15;
    protected TimelineDisp display;
    protected AnalyzerTimeline timeline;
    protected Experiment experiment;
    protected int last_selected;
    protected boolean only_event;
    protected JMenu menu;
    protected JTabbedPane info_tab;
    protected JComponent eventPane;
    protected JComponent stackViewPane;
    protected StackView stackView;
    protected AnList anList;
    protected Vector allFields;
    protected Vector extendedFields;
    protected Vector extendedLabels;
    protected boolean extendedShowing = true;
    protected JTextField typeTxt;
    protected JTextField expTxt;
    protected JTextField functionTxt;
    protected JTextField lwpTxt;
    protected JTextField thrTxt;
    protected JTextField cpuTxt;
    protected JTextField timeTxt;
    protected JTextField[] eventSpecText;
    protected JLabel[] eventSpecLabels;
    protected Event lastEvent;
    protected long lastSelectedFunc;
    protected String[] oldLabels;
    protected boolean[] samplesThreads;
    protected String expName;
    protected TimelineFunctionList func_list;
    protected TimelineColorChooser chooser;
    protected OptionsWindow optionsWindow;

    public AnalyzerTimeline(int n, TimelineDisp timelineDisp) {
        this.display = timelineDisp;
        this.timeline = this;
        this.experiment = null;
        this.last_selected = 1;
        this.only_event = true;
        this.initComponents(n);
    }

    protected void initComponents(int n) {
        AnWindow anWindow = AnWindow.get_win(n);
        this.info_tab = anWindow.getInfoTabPane();
        this.initMenu();
        this.initBar();
        this.initTab();
        this.chooser = new TimelineColorChooser(n, this.func_list);
        this.optionsWindow = new OptionsWindow(n, anWindow, this);
        anWindow.getJMenuBar().add(this.menu);
    }

    private void initMenu() {
        this.menu = new JMenu(AnLocale.getString("Timeline"));
        this.menu.setMnemonic('T');
        JMenuItem jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Back One Event"), AnUtility.leftIcon, -3));
        jMenuItem.setMnemonic('B');
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Forward One Event"), AnUtility.rightIcon, -2));
        jMenuItem.setMnemonic('F');
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Up One Bar"), AnUtility.upIcon, -4));
        jMenuItem.setMnemonic('U');
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Down One Bar"), AnUtility.downIcon, -5));
        jMenuItem.setMnemonic('D');
        this.menu.addSeparator();
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Reset Display"), AnUtility.resetIcon));
        jMenuItem.setMnemonic('R');
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Zoom In x2"), AnUtility.zoomInIcon));
        jMenuItem.setMnemonic('I');
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Zoom Out x2"), AnUtility.zoomOutIcon));
        jMenuItem.setMnemonic('O');
        this.menu.addSeparator();
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Show Color Chooser"), AnUtility.spaceIcon));
        jMenuItem.setMnemonic('C');
        jMenuItem = this.menu.add(new MenuAction(AnLocale.getString("Options..."), AnUtility.spaceIcon));
        jMenuItem.setMnemonic('P');
        this.enableMenu(false);
    }

    private void initBar() {
        this.navigationBar.removeLabels();
        this.navigationBar.addSeparator(new Dimension(20, 0));
        String string = AnLocale.getString("Reset Display");
        JButton jButton = this.navigationBar.add(new MenuAction(string, AnUtility.resetIcon));
        jButton.setActionCommand(string);
        jButton.setToolTipText(string);
        jButton.setMargin(AnVariable.buttonMargin);
        this.navigationBar.addSeparator(new Dimension(20, 0));
        string = AnLocale.getString("Zoom In x2");
        jButton = this.navigationBar.add(new MenuAction(string, AnUtility.zoomInIcon));
        jButton.setActionCommand(string);
        jButton.setToolTipText(string);
        jButton.setMargin(AnVariable.buttonMargin);
        string = AnLocale.getString("Zoom Out x2");
        jButton = this.navigationBar.add(new MenuAction(string, AnUtility.zoomOutIcon));
        jButton.setActionCommand(string);
        jButton.setToolTipText(string);
        jButton.setMargin(AnVariable.buttonMargin);
        this.display.registerKeyboardAction(new MenuAction(AnLocale.getString("Reset Display")), AnLocale.getString("Reset Display"), KeyStroke.getKeyStroke(27, 0), 1);
        this.display.registerKeyboardAction(new MenuAction(AnLocale.getString("Zoom In x2")), AnLocale.getString("Zoom In x2"), KeyStroke.getKeyStroke(107, 2), 1);
        this.display.registerKeyboardAction(new MenuAction(AnLocale.getString("Zoom Out x2")), AnLocale.getString("Zoom Out x2"), KeyStroke.getKeyStroke(109, 2), 1);
        this.display.registerKeyboardAction(new NavigationListener(-3, this), "Back One Event", KeyStroke.getKeyStroke(37, 0), 1);
        this.display.registerKeyboardAction(new NavigationListener(-2, this), "Forward One Event", KeyStroke.getKeyStroke(39, 0), 1);
        this.display.registerKeyboardAction(new NavigationListener(-4, this), "Up One Bar", KeyStroke.getKeyStroke(38, 0), 1);
        this.display.registerKeyboardAction(new NavigationListener(-5, this), "Down One Bar", KeyStroke.getKeyStroke(40, 0), 1);
        ((JComponent)this.navigationBar.getComponent(0)).setToolTipText(AnLocale.getString("Back One Event"));
        ((JComponent)this.navigationBar.getComponent(1)).setToolTipText(AnLocale.getString("Forward One Event"));
        ((JComponent)this.navigationBar.getComponent(2)).setToolTipText(AnLocale.getString("Up One Bar"));
        ((JComponent)this.navigationBar.getComponent(3)).setToolTipText(AnLocale.getString("Down One Bar"));
        this.navigationBar.add(Box.createHorizontalGlue());
        this.zoomHandler = new AnalyzerZoom(this);
        this.zoomHandler.setEventHolder(this.eventHolder);
    }

    private void initTab() {
        this.eventPane = new JPanel();
        this.eventPane.setLayout(new BoxLayout(this.eventPane, 1));
        this.eventPane.setBorder(BorderFactory.createEtchedBorder());
        this.eventPane.add((JLabel)AnUtility.getHeader(AnLocale.getString("Data for Current Timeline Selection")));
        this.allFields = new Vector();
        this.extendedFields = new Vector();
        this.extendedLabels = new Vector();
        this.anList = new AnList(true);
        this.anList.setAlignmentY();
        this.anList.setBorder(AnVariable.boxBorder);
        this.expTxt = this.createField(AnLocale.getString("Experiment Name:"), 'E', this.anList);
        this.typeTxt = this.createField(AnLocale.getString("Event Type:"), 'p', this.anList);
        this.functionTxt = this.createField(AnLocale.getString("Leaf Function:"), 'n', this.anList);
        this.timeTxt = this.createField(AnLocale.getString("Timestamp (sec.):"), 'i', this.anList);
        this.lwpTxt = this.createField(AnLocale.getString("LWP:"), 'L', this.anList);
        this.thrTxt = this.createField(AnLocale.getString("Thread:"), 'h', this.anList);
        this.cpuTxt = this.createField(AnLocale.getString("CPU:"), 'c', this.anList);
        this.eventSpecLabels = new JLabel[15];
        this.eventSpecText = new JTextField[15];
        int n = 0;
        while (n < 15) {
            this.eventSpecLabels[n] = new AnUtility.AnLabel(MSTATE_DESC[5], new ImageIcon(PhatState.createIcon(Color.black)), 4);
            this.eventSpecText[n] = (JTextField)AnUtility.getText("", 0);
            this.eventSpecLabels[n].setVisible(false);
            this.eventSpecText[n].setVisible(false);
            this.eventSpecLabels[n].setLabelFor(this.eventSpecText[n]);
            this.anList.add(this.eventSpecLabels[n], this.eventSpecText[n]);
            this.allFields.add(this.eventSpecText[n]);
            ++n;
        }
        this.eventPane.add(this.anList);
        this.stackView = new StackView();
        this.stackView.addListSelectionListener(this);
        JLabel jLabel = (JLabel)AnUtility.getHeader(AnLocale.getString("Call Stack for Selected Event"));
        jLabel.setDisplayedMnemonic('k');
        jLabel.setLabelFor(this.stackView);
        this.stackViewPane = new JPanel();
        this.stackViewPane.setLayout(new BoxLayout(this.stackViewPane, 1));
        this.stackViewPane.setBorder(AnVariable.boxBorder);
        this.stackViewPane.add(jLabel);
        this.stackViewPane.add(new JScrollPane(this.stackView));
        this.eventPane.add(new JSeparator(0));
        this.eventPane.add(this.stackViewPane);
        this.func_list = new TimelineFunctionList();
        this.func_list.addListSelectionListener(this);
        this.func_list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    AnalyzerTimeline.this.chooser.show();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.func_list);
        this.info_tab.addTab(AnLocale.getString("Event"), this.eventPane);
        this.info_tab.addTab(AnLocale.getString("Legend"), jScrollPane);
        this.info_tab.setEnabledAt(this.info_tab.indexOfComponent(this.eventPane), false);
        this.info_tab.setEnabledAt(this.info_tab.indexOfComponent(jScrollPane), false);
        if (Analyzer.help_broker != null) {
            Analyzer.help_broker.enableHelpKey(this.eventPane, "Tabs_Event", null);
            Analyzer.help_broker.enableHelpKey(jScrollPane, "Tabs_Legend", null);
        }
    }

    public JTextField createField(String string, char c, AnList anList) {
        JLabel jLabel = (JLabel)AnUtility.getItem(string);
        JTextField jTextField = (JTextField)AnUtility.getText("", 0);
        jLabel.setDisplayedMnemonic(c);
        jLabel.setLabelFor(jTextField);
        anList.add(jLabel, jTextField);
        this.allFields.add(jTextField);
        this.extendedFields.add(jTextField);
        this.extendedLabels.add(jLabel);
        return jTextField;
    }

    public void setSelected(boolean bl) {
        this.enableMenu(bl);
        this.info_tab.setEnabledAt(1, bl);
        this.info_tab.setEnabledAt(2, bl);
        if (bl) {
            this.setEventEnabledOnly(this.only_event);
            this.info_tab.setSelectedIndex(this.last_selected);
            this.last_selected = -1;
        } else {
            if (this.last_selected == -1) {
                this.last_selected = this.info_tab.getSelectedIndex();
            }
            this.info_tab.setEnabledAt(0, true);
            this.info_tab.setSelectedIndex(0);
        }
    }

    public void setEventEnabledOnly(boolean bl) {
        if (!this.display.isSelected()) {
            return;
        }
        if (bl) {
            this.info_tab.setSelectedIndex(1);
        }
        this.info_tab.setEnabledAt(0, !bl);
        this.info_tab.setEnabledAt(2, !bl);
        this.only_event = bl;
    }

    public void enableMenu(boolean bl) {
        int n = this.menu.getMenuComponentCount();
        int n2 = 0;
        while (n2 < n) {
            this.menu.getMenuComponent(n2).setEnabled(bl);
            ++n2;
        }
    }

    public void setExp() {
        super.setDataSet(this.experiment);
        this.setRenderer(new AnalyzerRenderer(this.experiment, this));
        this.setThreadDraw(new AnalyzerThreadDraw(this, this.rule, this.activeArray, this.colorMap, this.numThreads));
        this.setBarHeightMode(1);
        this.verticalRuler.setSpecialString(AnLocale.getString("Ex "));
        this.rule.setLabelString(AnLocale.getString("sec"));
        this.func_list.setComponents(this.experiment);
        this.stackViewPane.setPreferredSize(new Dimension(this.stackViewPane.getPreferredSize().width, 5000));
        this.computeSampleThreads();
    }

    public void redraw(ThreadViewEvent threadViewEvent) {
        if (threadViewEvent instanceof AnalyzerTimelineEvent) {
            AnalyzerTimelineEvent analyzerTimelineEvent = (AnalyzerTimelineEvent)threadViewEvent;
            if (analyzerTimelineEvent.event != null) {
                AnalyzerThread[] analyzerThreadArray;
                int n;
                int n2;
                Event event = analyzerTimelineEvent.event;
                if (event instanceof Sample || event instanceof HWCEvent) {
                    HWCEvent hWCEvent;
                    Sample sample;
                    if (event instanceof Sample) {
                        sample = (Sample)event;
                        hWCEvent = null;
                    } else {
                        sample = null;
                        hWCEvent = (HWCEvent)event;
                    }
                    n2 = 0;
                    if (threadViewEvent.thread != -1) {
                        n = 0;
                        analyzerThreadArray = this.experiment.getMapping();
                        while (n < threadViewEvent.thread) {
                            if (analyzerThreadArray[n2] != null) {
                                ++n;
                            }
                            ++n2;
                        }
                        if (analyzerThreadArray[n2] == null) {
                            ++n2;
                        }
                        if (sample != null) {
                            sample.setExpName(analyzerThreadArray[n2].experiment.getName());
                        } else if (hWCEvent != null) {
                            hWCEvent.setclock(analyzerThreadArray[n2].experiment.getClock());
                        }
                    }
                }
                String[] stringArray = event.getEventSpecificLabels();
                char[] cArray = event.getEventSpecificMnemonics();
                ImageIcon[] imageIconArray = event.getEventSpecificIcons();
                if (stringArray != this.oldLabels) {
                    n = 0;
                    while (n < stringArray.length) {
                        this.eventSpecLabels[n].setText(stringArray[n]);
                        this.eventSpecLabels[n].setDisplayedMnemonic(n < cArray.length ? cArray[n] : (char)'\u0000');
                        if (n < imageIconArray.length) {
                            this.eventSpecLabels[n].setIcon(imageIconArray[n]);
                            this.eventSpecLabels[n].setHorizontalTextPosition(10);
                        } else {
                            this.eventSpecLabels[n].setIcon(null);
                        }
                        this.eventSpecLabels[n].setVisible(true);
                        ++n;
                    }
                    n = stringArray.length;
                    while (n < 15) {
                        this.eventSpecLabels[n].setVisible(false);
                        ++n;
                    }
                }
                this.oldLabels = stringArray;
                String[] stringArray2 = event.getEventSpecificInfo();
                n = 0;
                while (n < stringArray2.length) {
                    this.eventSpecText[n].setText(stringArray2[n]);
                    this.eventSpecText[n].setVisible(true);
                    ++n;
                }
                n = stringArray2.length;
                while (n < 15) {
                    this.eventSpecText[n].setVisible(false);
                    ++n;
                }
                if (!(event instanceof ExtendedEvent)) {
                    if (this.extendedShowing) {
                        this.setExtendedFields(false);
                    }
                    this.setEventEnabledOnly(true);
                    super.redraw(threadViewEvent);
                    return;
                }
                if (!this.extendedShowing) {
                    this.setExtendedFields(true);
                }
                this.setEventEnabledOnly(false);
                ExtendedEvent extendedEvent = (ExtendedEvent)event;
                int n3 = ((AnalyzerThreadDraw)this.threadDraw).getSelectedLevel();
                if (extendedEvent == this.lastEvent && n3 == this.stackView.getSelectedIndex()) {
                    super.redraw(threadViewEvent);
                    return;
                }
                this.functionTxt.setText(this.experiment.getFunctionName(extendedEvent.getLeafFunction()));
                this.functionTxt.setCaretPosition(0);
                this.lwpTxt.setText(new AnInteger(extendedEvent.getLWP()).toString());
                this.thrTxt.setText(new AnInteger(extendedEvent.getThread()).toString());
                if (extendedEvent.getCPU() == ExtendedEvent.NO_CPU_INFO) {
                    this.cpuTxt.setText(AnLocale.getString("(unknown)"));
                } else {
                    this.cpuTxt.setText(new AnInteger(extendedEvent.getCPU()).toString());
                }
                this.timeTxt.setText(TIMESTAMP_FMT.format((double)extendedEvent.getTimestamp() * 1.0E-9));
                n2 = 0;
                if (threadViewEvent.thread != -1) {
                    n = 0;
                    analyzerThreadArray = this.experiment.getMapping();
                    while (n < threadViewEvent.thread) {
                        if (analyzerThreadArray[n2] != null) {
                            ++n;
                        }
                        ++n2;
                    }
                    if (analyzerThreadArray[n2] == null) {
                        ++n2;
                    }
                    this.typeTxt.setText(analyzerThreadArray[n2].getDataDescription());
                    this.expName = analyzerThreadArray[n2].experiment.getName();
                } else {
                    this.typeTxt.setText(AnLocale.getString("<unknown>"));
                    this.expName = "";
                }
                this.expTxt.setText(this.expName);
                this.lastEvent = extendedEvent;
                if (threadViewEvent.thread != -1 && (extendedEvent.getStack() != this.lastSelectedFunc || n3 != this.stackView.getSelectedIndex())) {
                    this.stackView.setComponents(this.experiment, extendedEvent.getStack(), n3);
                    this.selectionUpdate(((PhatState)this.stackView.getSelectedValue()).getNumber());
                    this.lastSelectedFunc = extendedEvent.getStack();
                }
            } else {
                this.oldLabels = null;
                int n = 0;
                while (n < 15) {
                    this.eventSpecText[n].setVisible(false);
                    this.eventSpecLabels[n].setVisible(false);
                    ++n;
                }
                this.setExtendedFields(true);
                Enumeration enumeration = this.allFields.elements();
                while (enumeration.hasMoreElements()) {
                    ((JTextField)enumeration.nextElement()).setText("");
                }
                this.stackView.clear();
            }
        }
        super.redraw(threadViewEvent);
    }

    protected void setExtendedFields(boolean bl) {
        Enumeration enumeration = this.extendedFields.elements();
        while (enumeration.hasMoreElements()) {
            ((JTextField)enumeration.nextElement()).setVisible(bl);
        }
        enumeration = this.extendedLabels.elements();
        while (enumeration.hasMoreElements()) {
            ((JLabel)enumeration.nextElement()).setVisible(bl);
        }
        this.stackViewPane.setVisible(bl);
        this.anList.setAlignmentX();
        this.extendedShowing = bl;
    }

    public boolean inRecompute() {
        return !this.display.isComputed();
    }

    public void compute() {
        if (AnUtility.getExpEnable() == null) {
            this.clear();
            return;
        }
        if (this.experiment == null) {
            this.experiment = new TimelineMetaExperiment();
            this.experiment.gatherData();
            this.setExp();
        } else if (this.experiment.needReload()) {
            this.clear();
            this.experiment.gatherData();
            ((AnalyzerRenderer)this.renderer).gatherData();
            this.activeArray = new boolean[this.experiment.getAllThreads().numThreads()];
            int n = 0;
            while (n < this.activeArray.length) {
                this.activeArray[n] = true;
                ++n;
            }
            this.threadDraw.setActiveArray(this.activeArray);
            this.computeSampleThreads();
            this.numThreads = this.activeArray.length;
        }
        this.unclear();
        Analyzer.setProgress(0, "");
    }

    public void clear() {
        this.stackView.clear();
        this.func_list.setListData(new Vector());
        this.oldLabels = null;
        int n = 0;
        while (n < 15) {
            this.eventSpecText[n].setVisible(false);
            this.eventSpecLabels[n].setVisible(false);
            ++n;
        }
        this.setExtendedFields(true);
        Enumeration enumeration = this.allFields.elements();
        while (enumeration.hasMoreElements()) {
            ((JTextField)enumeration.nextElement()).setText("");
        }
        this.rule.setVisible(false);
        this.verticalRuler.setVisible(false);
        this.threadDraw.setVisible(false);
        this.hScroll.setVisible(false);
        this.vScroll.setVisible(false);
        this.eventHolder = new AnalyzerTimelineEvent("recompute");
        this.threadDraw.setEventHolder(null);
        ((AnalyzerThreadDraw)this.threadDraw).recomputeColors();
    }

    public void unclear() {
        this.rule.setVisible(true);
        this.verticalRuler.setVisible(true);
        this.threadDraw.setVisible(true);
        this.hScroll.setVisible(true);
        this.vScroll.setVisible(true);
        this.func_list.setComponents(this.experiment);
        this.renderer.computeDrawing(this.eventHolder);
        this.optionsWindow.update();
    }

    public void computeSampleThreads() {
        this.samplesThreads = new boolean[this.experiment.getAllThreads().numThreads()];
        Enumeration enumeration = this.experiment.getAllThreads().elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AnalyzerThread analyzerThread = (AnalyzerThread)enumeration.nextElement();
            boolean bl = this.samplesThreads[n++] = analyzerThread.getKind() == 6;
        }
    }

    public ZoomHandler getZoomHandler() {
        return this.zoomHandler;
    }

    public static String longToAddress(long l) {
        String string = Long.toHexString(l);
        int n = string.length();
        while (n < 8) {
            string = "0" + string;
            ++n;
        }
        return "0x" + string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ((AnalyzerThreadDraw)this.threadDraw).recomputeColors();
        super.propertyChange(propertyChangeEvent);
    }

    public int getBarHeight() {
        if (this.threadDraw instanceof AnalyzerThreadDraw) {
            return Math.max(16, 4 * ((AnalyzerThreadDraw)this.threadDraw).getStackLevels() + 6);
        }
        return 16;
    }

    public int getBarSpace() {
        return 8;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        PhatState phatState = (PhatState)jList.getSelectedValue();
        if (phatState == null) {
            return;
        }
        this.selectionUpdate(phatState.getNumber());
    }

    public void selectionUpdate(long l) {
        this.display.timelineSelect(l);
        this.func_list.setSelectedFunction(this.experiment, l);
    }

    public int getNumThreads() {
        if (this.experiment == null || this.experiment.getMapping() == null) {
            return 0;
        }
        return this.experiment.getMapping().length;
    }

    public String getExpTxtName() {
        return this.expTxt.getText();
    }

    public static native boolean showAllMetrics();

    static {
        TIMESTAMP_FMT.setMaximumFractionDigits(6);
        TIMESTAMP_FMT.setMinimumFractionDigits(6);
        TIMESTAMP_FMT.setGroupingUsed(false);
        MSTATE_DESC = new String[]{AnLocale.getString("User CPU"), AnLocale.getString("System CPU"), AnLocale.getString("Trap CPU"), AnLocale.getString("Text Page Fault"), AnLocale.getString("Data Page Fault"), AnLocale.getString("Kernel Page Fault"), AnLocale.getString("User Lock"), AnLocale.getString("Sleep"), AnLocale.getString("Wait CPU"), AnLocale.getString("Stopped")};
        MSTATE_COLORS = new Color[]{Color.green, Color.cyan, Color.blue, Color.pink, Color.magenta, Color.black, Color.orange, Color.gray, Color.yellow, Color.red};
        if (AnalyzerTimeline.showAllMetrics()) {
            MSTATE_REMAP = new int[][]{{0}, {1}, {2}, {8}, {6}, {3}, {4}, {5}, {7}, {9}};
            MSTATE_REMAP_DESC = new String[]{AnLocale.getString("User CPU"), AnLocale.getString("System CPU"), AnLocale.getString("Trap CPU"), AnLocale.getString("Wait CPU"), AnLocale.getString("User Lock"), AnLocale.getString("Text Page Fault"), AnLocale.getString("Data Page Fault"), AnLocale.getString("Kernel Page Fault"), AnLocale.getString("Sleep"), AnLocale.getString("Stopped")};
        } else {
            MSTATE_REMAP = new int[][]{{0}, {1, 2}, {8}, {6}, {3}, {4}, {7, 5, 9}};
            MSTATE_REMAP_DESC = new String[]{AnLocale.getString("User CPU"), AnLocale.getString("System CPU"), AnLocale.getString("Wait CPU"), AnLocale.getString("User Lock"), AnLocale.getString("Text Page Fault"), AnLocale.getString("Data Page Fault"), AnLocale.getString("Other Wait")};
        }
    }

    public class MenuAction
    extends AbstractAction {
        ThreadViewEvent tv_event = null;

        public MenuAction(String string) {
            super(string);
        }

        public MenuAction(String string, Icon icon) {
            super(string, icon);
        }

        public MenuAction(String string, Icon icon, int n) {
            this(string, icon);
            this.tv_event = new ThreadViewEvent(analyzerTimeline.timeline, "Nav operation");
            this.tv_event.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (this.tv_event != null) {
                AnalyzerTimeline.this.timeline.getRenderer().computeDrawing(this.tv_event);
                return;
            }
            if (string.equals(AnLocale.getString("Reset Display"))) {
                AnalyzerTimeline.this.zoomHandler.setZoom(1.0f);
                AnalyzerTimeline.this.zoomHandler.fitBarsToWindow();
            } else if (string.equals(AnLocale.getString("Zoom In x2"))) {
                AnalyzerTimeline.this.zoomHandler.zoomInBy2();
            } else if (string.equals(AnLocale.getString("Zoom Out x2"))) {
                AnalyzerTimeline.this.zoomHandler.zoomOutBy2();
            } else if (string.equals(AnLocale.getString("Show Color Chooser"))) {
                AnalyzerTimeline.this.chooser.show();
            } else if (string.equals(AnLocale.getString("Options..."))) {
                AnalyzerTimeline.this.optionsWindow.show();
            }
        }
    }
}

