/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.Analyzer;
import com.sun.forte.st.mpmt.timeline.AnalyzerState;
import com.sun.forte.st.mpmt.timeline.AnalyzerThread;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimeline;
import com.sun.forte.st.mpmt.timeline.Data;
import com.sun.forte.st.mpmt.timeline.DurationEvent;
import com.sun.forte.st.mpmt.timeline.Entity;
import com.sun.forte.st.mpmt.timeline.Event;
import com.sun.forte.st.mpmt.timeline.ExtendedEvent;
import com.sun.forte.st.mpmt.timeline.HWCEvent;
import com.sun.forte.st.mpmt.timeline.HeapEvent;
import com.sun.forte.st.mpmt.timeline.MPIEvent;
import com.sun.forte.st.mpmt.timeline.ProfileEvent;
import com.sun.forte.st.mpmt.timeline.Sample;
import com.sun.forte.st.mpmt.timeline.SamplesState;
import com.sun.forte.st.mpmt.timeline.SyncEvent;
import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import java.awt.Color;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class Experiment
extends PhatDataSet {
    public static final int MAX_ENTS = 16384;
    public static final String SAMPLE_NAME = AnLocale.getString("Ex");
    public static final Data SAMPLE_DATA = new Data(AnLocale.getString("Experiment Samples"), 'x', 6, 0);
    public static final int SAMPLES_ENT = -2;
    public static final Entity SAMPLE_ENTITY = new Entity(3, -2);
    public static final Hashtable stackToExp = new Hashtable(1000);
    protected int exp_id;
    protected String exp_name;
    protected long start_time;
    protected long end_time;
    protected int clock_freq;
    protected Data[] data_desc;
    protected Vector functions;
    protected int max_stack_frames;
    protected AnalyzerThread[] mapping;
    protected Entity[] current_ents;
    protected long current_time_adjust;

    public Experiment(int n) {
        this.exp_id = n;
        this.exp_name = this.getName();
        this.start_time = Experiment.getStartTime(n);
        this.end_time = Experiment.getEndTime(n);
        this.clock_freq = Experiment.getClock(n);
        this.data_desc = this.getDataDesc(n);
        this.max_stack_frames = 0;
        this.current_time_adjust = 0L;
    }

    public int getID() {
        return this.exp_id;
    }

    public long getStartTime() {
        return this.start_time;
    }

    public long getEndTime() {
        return this.end_time;
    }

    public int getClock() {
        return this.clock_freq;
    }

    public Data[] getDataDescriptions() {
        return this.data_desc;
    }

    public Vector getAllFunctions() {
        return this.functions;
    }

    public int getMaxStackFrames() {
        return this.max_stack_frames;
    }

    public AnalyzerThread[] getMapping() {
        return this.mapping;
    }

    public long getCurrentTimeAdjust() {
        return this.current_time_adjust;
    }

    public void setCurrentTimeAdjust(long l) {
        this.current_time_adjust = l;
    }

    public int getNumDataTypes() {
        return this.data_desc.length;
    }

    public boolean needReload() {
        Entity[] entityArray = this.getEntities(1);
        if (this.current_ents == null) {
            return entityArray != null;
        }
        if (entityArray == null) {
            return true;
        }
        int n = entityArray.length;
        if (n != this.current_ents.length) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.current_ents[n2].getID() != entityArray[n2].getID()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void gatherData() {
        this.functions = new Vector<E>();
        var1_1 = new Vector<E>();
        var2_2 = this.getEntities(1);
        var3_3 = new Hashtable<Long, long[]>(1000);
        var4_4 = new HashSet<Long>();
        var5_5 = 0;
        while (var5_5 < var2_2.length) {
            Analyzer.setProgress((int)(100.0 * (double)(var5_5 + 1) / (double)var2_2.length), AnLocale.getString("Reading data for LWP ") + var5_5);
            var9_9 = false;
            var11_11 = new Vector<AnalyzerThread>();
            var12_12 = var2_2[var5_5];
            var7_7 = 0;
            while (var7_7 < this.data_desc.length) {
                if (this.current_ents == null || !this.exp_name.equals(this.getName())) ** GOTO lbl-1000
                var10_10 = false;
                var6_6 = 0;
                while (var6_6 < this.current_ents.length) {
                    if (this.current_ents[var6_6].getID() == var12_12.getID() && (var13_13 = this.getThread(var12_12.getID(), this.data_desc[var7_7])) != null) {
                        var11_11.add(var13_13);
                        var10_10 = true;
                    }
                    ++var6_6;
                }
                if (var10_10) {
                    var9_9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var14_14 = this.getEvents(var12_12, this.start_time, this.end_time, this.data_desc[var7_7]);
                    var15_15 = (Event[])var14_14[0];
                    var17_17 = (long[][])var14_14[1];
                    var6_6 = 0;
                    while (var6_6 < var15_15.length) {
                        var16_16 = (ExtendedEvent)var15_15[var6_6];
                        var18_18 = var17_17[var6_6];
                        var20_19 = (Long)var16_16.getData();
                        if (!var3_3.containsKey(var20_19)) {
                            this.max_stack_frames = Math.max(this.max_stack_frames, var18_18.length);
                            var3_3.put(var20_19, var18_18);
                            Experiment.stackToExp.put(var20_19, this);
                            var8_8 = 0;
                            while (var8_8 < var18_18.length) {
                                var4_4.add(new Long(var18_18[var8_8]));
                                ++var8_8;
                            }
                        }
                        if (var6_6 % 64 == 0) {
                            Analyzer.setProgress((int)(100.0 * (double)((var5_5 + 1) * var15_15.length + var6_6 * var2_2.length) / (double)(var2_2.length * var15_15.length)), AnLocale.getString("Reading data for LWP ") + var5_5);
                        }
                        ++var6_6;
                    }
                    if (var15_15.length > 0 && var15_15[0] instanceof DurationEvent) {
                        var15_15 = this.massageDurationData(var15_15);
                    }
                    if (var15_15.length > 0) {
                        var9_9 = true;
                    }
                    var11_11.add(new AnalyzerThread(var15_15, var12_12, this.data_desc[var7_7], this));
                }
                ++var7_7;
            }
            if (var9_9) {
                var6_6 = 0;
                while (var6_6 < var11_11.size()) {
                    var1_1.add(0, var11_11.elementAt(var6_6));
                    ++var6_6;
                }
            }
            ++var5_5;
        }
        var21_20 = new Hashtable<String, Color>();
        var26_21 = var4_4.size();
        var19_22 = new long[var26_21];
        var5_5 = 0;
        var22_23 = var4_4.iterator();
        while (var22_23.hasNext()) {
            var19_22[var5_5] = (Long)var22_23.next();
            ++var5_5;
        }
        var23_24 = this.getFunctionNames(var19_22);
        var5_5 = 0;
        while (var5_5 < var26_21) {
            var24_25 = var23_24[var5_5];
            var25_26 = new AnalyzerState(var24_25, var19_22[var5_5], this);
            this.functions.add(var25_26);
            if (var21_20.containsKey(var24_25)) {
                var25_26.setColor((Color)var21_20.get(var24_25));
            } else {
                var25_26.setColor(new Color(var24_25.hashCode()));
                var21_20.put(var24_25, var25_26.getColor());
            }
            ++var5_5;
        }
        var1_1.add(this.readSamples(this.functions));
        if (this.functions.size() == 0) {
            this.functions.add(new AnalyzerState(AnLocale.getString("<unknown>"), 0L));
        } else if (var1_1.size() == 0) {
            var1_1.add(new AnalyzerThread(new Event[0], new Entity(1, 0), new Data(AnLocale.getString("<unknown>"), 0), this));
        }
        this.setStates(this.functions);
        this.setThreads(var1_1);
        this.mapping = new AnalyzerThread[var1_1.size() + var2_2.length + 1];
        var27_27 = -2;
        var5_5 = 0;
        var6_6 = var1_1.size() - 1;
        while (var6_6 >= 0) {
            var13_13 = (AnalyzerThread)var1_1.elementAt(var6_6);
            if (var13_13.getNumber() != var27_27) {
                var27_27 = var13_13.getNumber();
                this.mapping[var5_5] = null;
                ++var5_5;
            }
            this.mapping[var5_5] = var13_13;
            ++var5_5;
            --var6_6;
        }
        this.current_ents = var2_2;
        this.exp_name = this.getName();
        Analyzer.setProgress(0, "");
    }

    protected AnalyzerThread readSamples(Vector vector) {
        Event[] eventArray;
        int n = 0;
        while (n < AnalyzerTimeline.MSTATE_REMAP_DESC.length) {
            SamplesState samplesState = new SamplesState(AnalyzerTimeline.MSTATE_REMAP_DESC[n], (long)n, this);
            samplesState.setColor(AnalyzerTimeline.MSTATE_COLORS[AnalyzerTimeline.MSTATE_REMAP[n][0]]);
            ++n;
        }
        long[][] lArray = Experiment.getSamples(this.exp_id);
        if (lArray != null) {
            int n2 = lArray.length;
            eventArray = new Event[n2];
            if (n2 > 0) {
                int n3 = lArray[0].length - 3;
                n = 0;
                while (n < n2) {
                    long[] lArray2 = lArray[n];
                    long[] lArray3 = new long[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        lArray3[n4] = lArray2[n4];
                        ++n4;
                    }
                    Sample sample = new Sample(n + 1, lArray2[n3], lArray2[n3 + 1], lArray2[n3 + 2], lArray3);
                    sample.adjustTime(this.start_time);
                    eventArray[n] = sample;
                    ++n;
                }
            }
            eventArray = this.massageDurationData(eventArray);
        } else {
            eventArray = new Event[]{};
        }
        return new AnalyzerThread(eventArray, SAMPLE_ENTITY, SAMPLE_DATA, this);
    }

    protected Event[] massageDurationData(Event[] eventArray) {
        Event[] eventArray2 = new Event[eventArray.length * 2];
        int n = 0;
        while (n < eventArray.length) {
            DurationEvent durationEvent = (DurationEvent)((Object)eventArray[n]);
            eventArray2[n * 2] = eventArray[n];
            if (durationEvent instanceof SyncEvent) {
                eventArray[n].adjustTime(durationEvent.getDuration());
                eventArray2[n * 2 + 1] = new SyncEvent(0, 0, 0, eventArray[n].getTimestamp() + durationEvent.getDuration(), 0L, 0L, 0L, 0L);
            } else if (durationEvent instanceof Sample) {
                eventArray2[n * 2 + 1] = new Sample(-1, eventArray[n].getTimestamp() + durationEvent.getDuration(), 0L, 0L, null);
            } else if (durationEvent instanceof MPIEvent) {
                eventArray[n].adjustTime(durationEvent.getDuration());
                eventArray2[n * 2 + 1] = new MPIEvent(0, 0, 0, eventArray[n].getTimestamp() + durationEvent.getDuration(), 0L, 0L, 0L, 0, 0, 0L);
            }
            eventArray[n] = null;
            ++n;
        }
        return eventArray2;
    }

    public AnalyzerThread getThread(int n, Data data) {
        Enumeration enumeration = this.defaultThreadGroup.allChildThreads();
        while (enumeration.hasMoreElements()) {
            AnalyzerThread analyzerThread = (AnalyzerThread)enumeration.nextElement();
            if (analyzerThread.getNumber() != n || analyzerThread.getKind() != data.getKind()) continue;
            return analyzerThread;
        }
        return null;
    }

    public void adjustTime(long l) {
        this.mapping[0].adjustTime(l - this.start_time);
        int n = 1;
        while (n < this.mapping.length) {
            if (this.mapping[n] != null) {
                this.mapping[n].adjustTime(l);
            }
            ++n;
        }
    }

    public String getName() {
        return Experiment.getName(this.exp_id);
    }

    public Entity[] getEntities(int n) {
        int[] nArray = Experiment.getEntities(this.exp_id, n);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        Entity[] entityArray = new Entity[n2];
        int n3 = 0;
        while (n3 < n2) {
            entityArray[n3] = new Entity(n, nArray[n3]);
            ++n3;
        }
        return entityArray;
    }

    public Data[] getDataDesc(int n) {
        Object[] objectArray = Experiment.getDataDescriptions(n);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return new Data[0];
        }
        int[] nArray = (int[])objectArray[0];
        int[] nArray2 = (int[])objectArray[1];
        String[] stringArray = (String[])objectArray[2];
        int n2 = nArray.length;
        Data[] dataArray = new Data[n2];
        int n3 = 0;
        while (n3 < n2) {
            dataArray[n3] = nArray[n3] == 3 ? new Data(stringArray[n3], nArray[n3], nArray2[n3]) : new Data(stringArray[n3], nArray[n3]);
            ++n3;
        }
        return dataArray;
    }

    public Object[] getEvents(Entity entity, long l, long l2, Data data) {
        Object[] objectArray = Experiment.getEvents(this.exp_id, entity.getID(), entity.getKind(), l, l2, data.getKind(), data.getAux());
        if (objectArray == null) {
            return null;
        }
        long[][] lArray = (long[][])objectArray[0];
        int n = lArray.length;
        Event[] eventArray = new Event[n];
        Object[] objectArray2 = new Object[]{eventArray, objectArray[1]};
        switch (data.getKind()) {
            case 1: {
                int n2 = 0;
                while (n2 < n) {
                    long[] lArray2 = lArray[n2];
                    eventArray[n2] = new ProfileEvent((int)lArray2[0], (int)lArray2[1], (int)lArray2[2], lArray2[3], lArray2[4], lArray2[5], (int)lArray2[6], (int)lArray2[7]);
                    ++n2;
                }
                break;
            }
            case 2: {
                int n3 = 0;
                while (n3 < n) {
                    long[] lArray3 = lArray[n3];
                    eventArray[n3] = new SyncEvent((int)lArray3[0], (int)lArray3[1], (int)lArray3[2], lArray3[3], lArray3[4], lArray3[5], lArray3[6], lArray3[7]);
                    ++n3;
                }
                break;
            }
            case 3: {
                int n4 = 0;
                while (n4 < n) {
                    long[] lArray4 = lArray[n4];
                    eventArray[n4] = new HWCEvent((int)lArray4[0], (int)lArray4[1], (int)lArray4[2], lArray4[3], lArray4[4], lArray4[5], (int)lArray4[6], lArray4[7]);
                    ++n4;
                }
                break;
            }
            case 4: {
                int n5 = 0;
                while (n5 < n) {
                    long[] lArray5 = lArray[n5];
                    eventArray[n5] = new HeapEvent((int)lArray5[0], (int)lArray5[1], (int)lArray5[2], lArray5[3], lArray5[4], lArray5[5], (int)lArray5[6], (int)lArray5[7], lArray5[8], lArray5[9]);
                    ++n5;
                }
                break;
            }
            case 5: {
                int n6 = 0;
                while (n6 < n) {
                    long[] lArray6 = lArray[n6];
                    eventArray[n6] = new MPIEvent((int)lArray6[0], (int)lArray6[1], (int)lArray6[2], lArray6[3], lArray6[4], lArray6[5], lArray6[6], (int)lArray6[7], (int)lArray6[8], lArray6[9]);
                    ++n6;
                }
                break;
            }
        }
        return objectArray2;
    }

    public static native String getName(int var0);

    public static native long getStartTime(int var0);

    public static native long getEndTime(int var0);

    public static native int getClock(int var0);

    public static native int[] getEntities(int var0, int var1);

    public static native Object[] getDataDescriptions(int var0);

    public static native Object[] getEvents(int var0, int var1, int var2, long var3, long var5, int var7, int var8);

    public static native long[] getStackFunctions(long var0);

    public static native long[] getStackPCs(long var0);

    public static native long[][] getSamples(int var0);

    public native String[] getFunctionNames(long[] var1);

    public native String getFunctionName(long var1);
}

