/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnInteger;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimeline;
import com.sun.forte.st.mpmt.timeline.ExtendedEvent;
import com.sun.forte.st.mpmt.timeline.PointEvent;

public class HeapEvent
extends ExtendedEvent
implements PointEvent {
    public int type;
    public int size;
    protected long vaddr;
    protected long ovaddr;
    protected static final int MALLOC = 0;
    protected static final int FREE = 1;
    protected static final int REALLOC = 2;
    protected static String[] TYPES = new String[]{AnLocale.getString("Allocation"), AnLocale.getString("Free"), AnLocale.getString("Reallocation")};
    protected static final String TYPE = AnLocale.getString("Type:");
    protected static final String SIZE = AnLocale.getString("Size (bytes):");
    protected static final String ADDRESS = AnLocale.getString("Address:");
    protected static final String OADDRESS = AnLocale.getString("Old Address:");
    protected final String[] MALLOC_LABELS = new String[]{TYPE, ADDRESS, SIZE};
    protected final String[] FREE_LABELS = new String[]{TYPE, ADDRESS};
    protected final String[] REALLOC_LABELS = new String[]{TYPE, ADDRESS, OADDRESS, SIZE};

    public HeapEvent(int n, int n2, int n3, long l, long l2, long l3, int n4, int n5, long l4, long l5) {
        super(n, n2, n3, l, l2, l3);
        this.type = n4;
        this.size = n5;
        this.vaddr = l4;
        this.ovaddr = l5;
    }

    public String[] getEventSpecificInfo() {
        switch (this.type) {
            case 0: {
                return new String[]{TYPES[this.type], AnalyzerTimeline.longToAddress(this.vaddr), new AnInteger(this.size).toString()};
            }
            case 1: {
                return new String[]{TYPES[this.type], AnalyzerTimeline.longToAddress(this.vaddr)};
            }
            case 2: {
                return new String[]{TYPES[this.type], AnalyzerTimeline.longToAddress(this.vaddr), AnalyzerTimeline.longToAddress(this.ovaddr), new AnInteger(this.size).toString()};
            }
        }
        return null;
    }

    public String[] getEventSpecificLabels() {
        switch (this.type) {
            case 0: {
                return this.MALLOC_LABELS;
            }
            case 1: {
                return this.FREE_LABELS;
            }
            case 2: {
                return this.REALLOC_LABELS;
            }
        }
        return null;
    }
}

