/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnVariable;
import com.sun.forte.st.mpmt.timeline.AnalyzerThread;
import com.sun.forte.st.mpmt.timeline.AnalyzerThreadDraw;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimeline;
import com.sun.forte.st.mpmt.timeline.Data;
import com.sun.forte.st.mpmt.timeline.Experiment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;

public class OptionsWindow
extends AnDialog {
    public static final int MAX_STACK = 10;
    public static final int MIN_STACK = 5;
    private AnalyzerTimeline timeline;
    private Experiment experiment;
    private AnalyzerThread[] mapping;
    private Vector vector;
    private JPanel type_panel;
    private JSlider slider;

    public OptionsWindow(int n, JFrame jFrame, AnalyzerTimeline analyzerTimeline) {
        super(n, jFrame, AnLocale.getString("Timeline Options"), true, null, null, "Data_TimeOpt");
        this.timeline = analyzerTimeline;
        this.vector = new Vector();
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EtchedBorder(1));
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.setBorder(AnVariable.boxBorder);
        JLabel jLabel = new JLabel(AnLocale.getString("Data Types:"));
        jPanel2.add((Component)jLabel, "North");
        this.type_panel = new JPanel();
        this.type_panel.setLayout(new BoxLayout(this.type_panel, 1));
        jPanel2.add((Component)this.type_panel, "Center");
        jPanel.add(jPanel2);
        jPanel.add(new JSeparator(0));
        jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.setBorder(AnVariable.boxBorder);
        jLabel = new JLabel(AnLocale.getString("Stack Frames:"));
        jLabel.setDisplayedMnemonic('S');
        jLabel.setAlignmentX(0.0f);
        jPanel2.add((Component)jLabel, "North");
        this.slider = new JSlider();
        this.slider.setMinimum(1);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing(1);
        jPanel2.add((Component)this.slider, "Center");
        jLabel.setLabelFor(this.slider);
        jPanel.add(jPanel2);
        this.setAccessory(jPanel);
    }

    public void setComponents() {
        this.type_panel.removeAll();
        this.vector.removeAllElements();
        JCheckBox jCheckBox = new JCheckBox(Experiment.SAMPLE_DATA.getDescription(), true);
        jCheckBox.setMnemonic(Experiment.SAMPLE_DATA.getMnemonic());
        this.type_panel.add(jCheckBox);
        this.vector.add(jCheckBox);
        Data[] dataArray = this.experiment.getDataDescriptions();
        int n = dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            jCheckBox = new JCheckBox(dataArray[n2].getDescription(), true);
            this.vector.add(jCheckBox);
            this.type_panel.add(jCheckBox);
            ++n2;
        }
        int n3 = Math.min(this.experiment.getMaxStackFrames(), 10);
        if (n3 < 5) {
            n3 = 5;
        }
        this.slider.setMaximum(n3);
        this.slider.setMajorTickSpacing(n3 / 5);
        this.slider.setValue(Math.min(3, this.experiment.getMaxStackFrames()));
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Enumeration enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            JCheckBox jCheckBox = (JCheckBox)enumeration.nextElement();
            int n = this.mapping.length;
            int n2 = 0;
            while (n2 < n) {
                AnalyzerThread analyzerThread = this.mapping[n2];
                if (analyzerThread != null && analyzerThread.getDataDescription().equals(jCheckBox.getText())) {
                    analyzerThread.setVisible(jCheckBox.isSelected());
                }
                ++n2;
            }
        }
        ((AnalyzerThreadDraw)this.timeline.getThreadDraw()).setStackLevels(this.slider.getValue());
    }

    public void show() {
        Enumeration enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            JCheckBox jCheckBox = (JCheckBox)enumeration.nextElement();
            int n = this.mapping.length;
            int n2 = 0;
            while (n2 < n) {
                AnalyzerThread analyzerThread = this.mapping[n2];
                if (analyzerThread != null && analyzerThread.getDataDescription().equals(jCheckBox.getText())) {
                    jCheckBox.setSelected(analyzerThread.isVisible());
                }
                ++n2;
            }
        }
        this.slider.setValue(((AnalyzerThreadDraw)this.timeline.getThreadDraw()).getStackLevels());
        super.show();
    }

    public void update() {
        this.experiment = (Experiment)this.timeline.getDataSet();
        this.mapping = this.experiment.getMapping();
        this.setComponents();
        this.actionPerformed(null);
    }
}

