/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnDouble;
import com.sun.forte.st.mpmt.AnInteger;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimeline;
import com.sun.forte.st.mpmt.timeline.DurationEvent;
import com.sun.forte.st.mpmt.timeline.Event;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import java.awt.Color;
import javax.swing.ImageIcon;

public class Sample
extends Event
implements DurationEvent {
    protected int number;
    protected long end_time;
    protected long total;
    protected long[] mstates;
    protected static final double DIV = 1.0E9;
    protected static final String[] LABELS = new String[4 + AnalyzerTimeline.MSTATE_REMAP_DESC.length];
    protected static final char[] MNEMONICS = new char[LABELS.length];
    protected static final int EXTRA_LABELS = 4;
    protected static ImageIcon[] ICONS = new ImageIcon[LABELS.length];
    protected String expname = null;

    Sample(int n, long l, long l2, long l3, long[] lArray) {
        super(l);
        this.number = n;
        this.end_time = l + l2;
        this.total = l3;
        this.mstates = lArray;
    }

    void adjustTime(long l) {
        super.adjustTime(l);
        this.end_time -= l;
    }

    public int getNumber() {
        return this.number;
    }

    public long getEndTime() {
        return this.end_time;
    }

    public long getTotalTime() {
        return this.total;
    }

    public long getDuration() {
        return this.end_time - this.timestamp;
    }

    public Object getData() {
        return this.mstates;
    }

    public String[] getEventSpecificLabels() {
        return LABELS;
    }

    public String[] getEventSpecificInfo() {
        String[] stringArray = new String[LABELS.length];
        stringArray[0] = this.expname;
        stringArray[1] = new AnInteger(this.number).toString();
        stringArray[2] = AnalyzerTimeline.TIMESTAMP_FMT.format((double)this.timestamp * 1.0E-9);
        stringArray[3] = AnalyzerTimeline.TIMESTAMP_FMT.format((double)this.end_time * 1.0E-9);
        int n = AnalyzerTimeline.MSTATE_REMAP.length - 1;
        int n2 = 4;
        while (n >= 0) {
            int[] nArray = AnalyzerTimeline.MSTATE_REMAP[n];
            double d = 0.0;
            int n3 = 0;
            while (n3 < nArray.length) {
                d += (double)this.mstates[nArray[n3]];
                ++n3;
            }
            double d2 = d / (double)this.total;
            stringArray[n2] = new AnDouble(d / 1.0E9).toPercentQuote(1.0 / ((double)this.total / 1.0E9) * 100.0);
            --n;
            ++n2;
        }
        return stringArray;
    }

    public static void updateColor(int n, Color color) {
        Sample.ICONS[Sample.LABELS.length - n - 1] = new ImageIcon(PhatState.createIcon(color));
    }

    public void setExpName(String string) {
        this.expname = string;
    }

    public ImageIcon[] getEventSpecificIcons() {
        return ICONS;
    }

    public char[] getEventSpecificMnemonics() {
        return MNEMONICS;
    }

    static {
        Sample.LABELS[0] = AnLocale.getString("Experiment Name:");
        Sample.LABELS[1] = AnLocale.getString("Sample Number:");
        Sample.LABELS[2] = AnLocale.getString("Start Time (sec.):");
        Sample.LABELS[3] = AnLocale.getString("End Time (sec.):");
        Sample.MNEMONICS[0] = 69;
        Sample.MNEMONICS[1] = 109;
        Sample.MNEMONICS[2] = 97;
        Sample.MNEMONICS[3] = 110;
        Sample.ICONS[3] = null;
        Sample.ICONS[2] = null;
        Sample.ICONS[1] = null;
        Sample.ICONS[0] = null;
        int n = LABELS.length - 1;
        int n2 = 4;
        while (n >= 4) {
            Sample.LABELS[n2] = AnalyzerTimeline.MSTATE_REMAP_DESC[n - 4];
            Sample.MNEMONICS[n2] = '\u0000';
            Sample.ICONS[n2] = new ImageIcon(PhatState.createIcon(AnalyzerTimeline.MSTATE_COLORS[AnalyzerTimeline.MSTATE_REMAP[n - 4][0]]));
            --n;
            ++n2;
        }
    }
}

