/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnAddress;
import com.sun.forte.st.mpmt.timeline.Experiment;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class StackView
extends JList {
    protected Hashtable tempStateLookup = new Hashtable();

    public StackView() {
        ListRenderer listRenderer = new ListRenderer();
        this.setCellRenderer(listRenderer);
        this.setBackground(listRenderer.getBackground());
        this.setFixedCellHeight(16);
    }

    public void setComponents(Experiment experiment, long l, int n) {
        Vector<PhatState> vector = new Vector<PhatState>();
        long[] lArray = Experiment.getStackFunctions(l);
        long[] lArray2 = Experiment.getStackPCs(l);
        String[] stringArray = experiment.getFunctionNames(lArray);
        int n2 = lArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            String string2 = string + " (0x" + AnAddress.toHexString((int)lArray2[n3]) + ")";
            PhatState phatState = experiment.getState(lArray[n3]);
            if (phatState != null) {
                Color color = phatState.getColor();
                phatState = new PhatState(string2, lArray[n3], null);
                phatState.setColor(color);
            } else {
                Long l2 = new Long(lArray[n3]);
                if (!this.tempStateLookup.containsKey(l2)) {
                    phatState = new PhatState(string2, lArray[n3], null);
                    this.tempStateLookup.put(l2, phatState);
                    phatState.setColor(new Color(string.hashCode()));
                } else {
                    phatState = (PhatState)this.tempStateLookup.get(l2);
                }
            }
            vector.add(phatState);
            ++n3;
        }
        this.setListData(vector);
        n = Math.min(n, vector.size() - 1);
        this.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
    }

    public void clear() {
        this.setListData(new Vector());
    }

    protected class ListRenderer
    extends DefaultListCellRenderer {
        protected ListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(object.toString());
            this.setIcon(new ImageIcon(PhatState.createContigIcon((PhatState)object)));
            this.setBorder(null);
            return this;
        }
    }
}

