/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnDialog;
import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimeline;
import com.sun.forte.st.mpmt.timeline.Sample;
import com.sun.forte.st.mpmt.timeline.TimelineFunctionList;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimelineColorChooser
extends AnDialog
implements ChangeListener,
ListSelectionListener {
    private TimelineFunctionList list;
    private JColorChooser chooser;

    public TimelineColorChooser(int n, TimelineFunctionList timelineFunctionList) {
        super(n, null, AnLocale.getString("Timeline Color Chooser"), false, null, null, null);
        this.list = timelineFunctionList;
        timelineFunctionList.addListSelectionListener(this);
        this.chooser = new JColorChooser();
        this.chooser.setPreviewPanel(new JPanel());
        this.chooser.getSelectionModel().addChangeListener(this);
        this.setAccessory(this.chooser);
        this.pack();
    }

    public void setComponents() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        PhatState phatState = (PhatState)this.list.getSelectedValue();
        phatState.setColor(this.chooser.getColor());
        if (phatState.getNumber() < (long)AnalyzerTimeline.MSTATE_COLORS.length) {
            Sample.updateColor((int)phatState.getNumber(), this.chooser.getColor());
        }
        this.list.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.list.getSelectedValue() == null) {
            return;
        }
        PhatState phatState = (PhatState)this.list.getSelectedValue();
        this.chooser.setColor(phatState.getColor());
    }
}

